/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.entryexit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.swing.JMenuItem;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SignalMast;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.entryexit.PointDetails;

public class Source
implements PropertyChangeListener {
    JMenuItem clear = null;
    JMenuItem cancel = null;
    JMenuItem editCancel = null;
    JMenuItem editClear = null;
    JMenuItem editOneClick = null;
    JMenuItem oneClick = null;
    public static final String PROPERTY_ACTIVE = "active";
    NamedBean sourceObject = null;
    NamedBean sourceSignal = null;
    transient PointDetails pd = null;
    EntryExitPairs manager = InstanceManager.getDefault(EntryExitPairs.class);
    transient HashMap<PointDetails, DestinationPoints> pointToDest = new HashMap();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public Source(PointDetails point) {
        if (point.getSensor() != null) {
            this.addSourceObject(point.getSensor());
        } else {
            this.addSourceObject(point.getSignal());
        }
        point.setSource(this);
        this.sourceSignal = point.getSignal();
        this.pd = point;
    }

    public boolean isEnabled(Object dest, LayoutEditor panel) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            return this.pointToDest.get(lookingFor).isEnabled();
        }
        return true;
    }

    public void setEnabled(Object dest, LayoutEditor panel, boolean boo) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            this.pointToDest.get(lookingFor).setEnabled(boo);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(PROPERTY_ACTIVE, evt.getOldValue(), evt.getNewValue());
    }

    void cancelClearInterlockFromSource(int cancelClear) {
        for (DestinationPoints dp : this.pointToDest.values()) {
            if (!dp.isActive()) continue;
            dp.cancelClearInterlock(cancelClear);
        }
    }

    void setMenuEnabled(boolean boo) {
        if (this.clear != null) {
            this.clear.setEnabled(boo);
        }
        if (this.cancel != null) {
            this.cancel.setEnabled(boo);
        }
        if (this.editClear != null) {
            this.editClear.setEnabled(boo);
        }
        if (this.editCancel != null) {
            this.editCancel.setEnabled(boo);
        }
        if (this.oneClick != null) {
            this.oneClick.setEnabled(!boo);
        }
        if (this.editOneClick != null) {
            this.editOneClick.setEnabled(!boo);
        }
    }

    public PointDetails getPoint() {
        return this.pd;
    }

    LayoutBlock getStart() {
        return this.pd.getFacing();
    }

    List<LayoutBlock> getSourceProtecting() {
        return this.pd.getProtecting();
    }

    NamedBean getSourceSignal() {
        if (this.sourceSignal == null) {
            this.pd.getSignal();
        }
        return this.sourceSignal;
    }

    public void addDestination(PointDetails dest, String id) {
        if (this.pointToDest.containsKey(dest)) {
            return;
        }
        DestinationPoints dstPoint = new DestinationPoints(dest, id, this);
        dest.setDestination(dstPoint, this);
        this.pointToDest.put(dest, dstPoint);
        dstPoint.addPropertyChangeListener(this);
    }

    public void removeDestination(PointDetails dest) {
        this.pointToDest.get(dest).dispose();
        this.pointToDest.remove(dest);
        dest.removePropertyChangeListener(this);
        if (this.pointToDest.isEmpty()) {
            this.getPoint().removeSource(this);
        }
    }

    private void addSourceObject(NamedBean source) {
        if (this.sourceObject == source) {
            return;
        }
        this.sourceObject = source;
    }

    Object getSourceObject() {
        return this.sourceObject;
    }

    public ArrayList<PointDetails> getDestinationPoints() {
        return new ArrayList<PointDetails>(this.pointToDest.keySet());
    }

    public boolean isDestinationValid(PointDetails destPoint) {
        return this.pointToDest.containsKey(destPoint);
    }

    public boolean getUniDirection(Object dest, LayoutEditor panel) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            return this.pointToDest.get(lookingFor).getUniDirection();
        }
        return true;
    }

    public void setUniDirection(Object dest, LayoutEditor panel, boolean set) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            this.pointToDest.get(lookingFor).setUniDirection(set);
        }
    }

    public boolean canBeBiDirection(Object dest, LayoutEditor panel) {
        if (this.getSourceSignal() == null) {
            return true;
        }
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            return this.pointToDest.get(lookingFor).getSignal() == null;
        }
        return false;
    }

    public boolean isRouteActive(PointDetails endpoint) {
        if (this.pointToDest.containsKey(endpoint)) {
            return this.pointToDest.get(endpoint).isActive();
        }
        return false;
    }

    public void activeBean(DestinationPoints dest, boolean reverseDirection) {
        if (dest != null) {
            dest.activeBean(reverseDirection);
        }
    }

    public DestinationPoints getDestForPoint(PointDetails dp) {
        return this.pointToDest.get(dp);
    }

    public int getNumberOfDestinations() {
        return this.pointToDest.size();
    }

    public void setEntryExitType(Object dest, LayoutEditor panel, int type) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            this.pointToDest.get(lookingFor).setEntryExitType(type);
        }
        if (type == 2 && this.sourceSignal instanceof SignalMast && !this.manager.isAbsSignalMode()) {
            ((SignalMast)this.sourceSignal).setHeld(true);
        }
    }

    public int getEntryExitType(Object dest, LayoutEditor panel) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            return this.pointToDest.get(lookingFor).getEntryExitType();
        }
        return 0;
    }

    public void cancelInterlock(Object dest, LayoutEditor panel) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            this.pointToDest.get(lookingFor).cancelClearInterlock(0);
        }
    }

    @CheckForNull
    public String getUniqueId(Object dest, LayoutEditor panel) {
        PointDetails lookingFor = this.manager.getPointDetails(dest, panel);
        if (this.pointToDest.containsKey(lookingFor)) {
            return this.pointToDest.get(lookingFor).getUniqueId();
        }
        return null;
    }

    public ArrayList<String> getDestinationUniqueId() {
        ArrayList<String> rList = new ArrayList<String>();
        for (DestinationPoints d : this.pointToDest.values()) {
            rList.add(d.getUniqueId());
        }
        return rList;
    }

    @CheckForNull
    public DestinationPoints getByUniqueId(String id) {
        for (DestinationPoints d : this.pointToDest.values()) {
            if (!d.getUniqueId().equals(id)) continue;
            return d;
        }
        return null;
    }

    @CheckForNull
    public DestinationPoints getByUserName(String id) {
        for (DestinationPoints d : this.pointToDest.values()) {
            String uname = d.getUserName();
            if (uname == null || !uname.equals(id)) continue;
            return d;
        }
        return null;
    }
}

