/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs;

import java.util.Date;
import java.util.Random;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Timebase;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public class CabMessage {
    private String message;
    private final Date sentDate;
    private final int intValue;
    private boolean ackRequired;
    private Date confirmedDate = null;
    private final String messageId;
    private static Random random = new Random();
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public CabMessage(String msg, int intValue, boolean ackReqd) {
        this(CabMessage.generatedId(), msg, intValue, ackReqd);
    }

    public CabMessage(@Nonnull String messageId, String msg, int intValue, boolean ackReqd) {
        this.messageId = messageId;
        this.message = msg;
        this.sentDate = InstanceManager.getDefault(Timebase.class).getTime();
        this.intValue = intValue;
        this.ackRequired = ackReqd;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Date getSentTime() {
        return new Date(this.sentDate.getTime());
    }

    @CheckForNull
    public Date getConfirmedTime() {
        return new Date(this.confirmedDate.getTime());
    }

    public void setConfirmed() {
        this.confirmedDate = InstanceManager.getDefault(Timebase.class).getTime();
        this.ackRequired = false;
    }

    public boolean getAckRequired() {
        return this.ackRequired;
    }

    public int getGroup() {
        return this.intValue;
    }

    private static String generatedId() {
        int length = 20;
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt(CHARACTERS.length());
            char randomChar = CHARACTERS.charAt(randomIndex);
            sb.append(randomChar);
        }
        return sb.toString();
    }
}

