/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.jmrit.etcs.TrackSection;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public class MovementAuthority {
    private final List<TrackSection> list;

    public MovementAuthority(List<TrackSection> sectionList) {
        this.list = sectionList;
    }

    public List<TrackSection> getTrackSections() {
        return Collections.unmodifiableList(this.list);
    }

    private void removeTrackSection(TrackSection ts) {
        this.list.remove(ts);
    }

    @Nonnull
    public static List<TrackSection> getTrackSectionList(@Nonnull List<MovementAuthority> completeList, boolean isSpeed) {
        ArrayList<TrackSection> trackSectionList = new ArrayList<TrackSection>();
        TrackSection lastTs = null;
        for (MovementAuthority ma : completeList) {
            List<TrackSection> tempTrackList = ma.getTrackSections();
            for (TrackSection ts : tempTrackList) {
                if (lastTs == null || MovementAuthority.checkAddToList(lastTs, ts, isSpeed)) {
                    trackSectionList.add(new TrackSection(ts.getLength(), ts.getSpeed(), ts.getGradient()));
                    lastTs = (TrackSection)trackSectionList.get(trackSectionList.size() - 1);
                    continue;
                }
                lastTs.setLength(ts.getLength() + lastTs.getLength());
            }
        }
        return trackSectionList;
    }

    private static boolean checkAddToList(@Nonnull TrackSection lastTs, @Nonnull TrackSection ts, boolean isSpeed) {
        if (isSpeed) {
            return lastTs.getSpeed() != ts.getSpeed();
        }
        return lastTs.getGradient() != ts.getGradient();
    }

    @Nonnull
    public static List<MovementAuthority> advanceForward(@Nonnull List<MovementAuthority> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        MovementAuthority ma = list.get(0);
        if (ma.getTrackSections().isEmpty()) {
            list.remove(ma);
            return MovementAuthority.advanceForward(list, distance);
        }
        TrackSection ts = ma.getTrackSections().get(0);
        int newLength = ts.getLength() - distance;
        if (newLength < 0) {
            ma.removeTrackSection(ts);
            return MovementAuthority.advanceForward(list, distance - ts.getLength());
        }
        ts.setLength(newLength);
        ts.advanceAnnouncements(distance);
        return list;
    }
}

