/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jmri.jmrit.Sound;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class ResourceUtil {
    private static final String RESOURCES_DIRECTORY = "resources/icons/etcs/";
    private static final String SOUNDS_DIR = "resources/sounds/";
    private static final Color BACKGROUND_COLOUR = new Color(3, 17, 34);
    private static boolean soundsInitialised = false;
    private static Sound sound1;
    private static Sound sound2;
    private static Sound sound3;
    private static Sound sound4;
    private static final Logger log;

    private ResourceUtil() {
    }

    @Nonnull
    public static File getImageFile(String fileName) {
        return new File(ResourceUtil.getNameAndDirectoryForFile(fileName));
    }

    private static String getNameAndDirectoryForFile(@Nonnull String fileName) {
        return FileUtil.getExternalFilename(RESOURCES_DIRECTORY + fileName);
    }

    @CheckForNull
    public static ImageIcon getImageIcon(String fileName) {
        String externalFileName = ResourceUtil.getNameAndDirectoryForFile(fileName);
        try {
            File imageFile = new File(externalFileName);
            if (!imageFile.exists()) {
                log.error("Image file {} not found!", (Object)externalFileName);
                return null;
            }
            BufferedImage image = ImageIO.read(imageFile);
            return new ImageIcon(image);
        }
        catch (IOException ex) {
            log.error("IO exception: ", (Throwable)ex);
            return null;
        }
    }

    @CheckForNull
    public static BufferedImage getTransparentImage(@Nonnull String str) {
        if (str.isBlank()) {
            return null;
        }
        BufferedImage a = ResourceUtil.readFile(ResourceUtil.getImageFile(str));
        return ResourceUtil.convertColorToTransparent(a);
    }

    @CheckForNull
    public static BufferedImage readFile(File f) {
        BufferedImage a = null;
        try {
            a = ImageIO.read(f);
        }
        catch (IOException ex) {
            log.error("Exception while reading image {}", (Object)f, (Object)ex);
        }
        return a;
    }

    @CheckForNull
    public static BufferedImage convertColorToTransparent(@CheckForNull BufferedImage image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Color targetColor = BACKGROUND_COLOUR;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color pixelColor = new Color(image.getRGB(x, y), true);
                if (pixelColor.equals(targetColor)) {
                    pixelColor = new Color(0, 0, 0, 0);
                }
                newImage.setRGB(x, y, pixelColor.getRGB());
            }
        }
        return newImage;
    }

    public static void playDmiSound(int sound) throws IllegalArgumentException {
        Sound s;
        if (!soundsInitialised) {
            soundsInitialised = true;
            sound1 = new Sound(FileUtil.getExternalFilename("resources/sounds/S1_toofast.wav"));
            sound2 = new Sound(FileUtil.getExternalFilename("resources/sounds/S2_warning.wav"));
            sound3 = new Sound(FileUtil.getExternalFilename("resources/sounds/S_info.wav"));
            sound4 = new Sound(FileUtil.getExternalFilename("resources/sounds/click.wav"));
            sound1.setAutoClose(false);
            sound2.setAutoClose(false);
            sound3.setAutoClose(false);
            sound4.setAutoClose(false);
        }
        switch (sound) {
            case 1: {
                s = sound1;
                break;
            }
            case 2: {
                ResourceUtil.startSound(sound2, true);
                return;
            }
            case 3: {
                s = sound3;
                break;
            }
            case 4: {
                s = sound4;
                break;
            }
            default: {
                throw new IllegalArgumentException("No Sound for slot " + sound);
            }
        }
        ResourceUtil.startSound(s, false);
    }

    private static void startSound(Sound s, boolean loop) {
        Thread t = ThreadingUtil.newThread(loop ? s::loop : s::play, "DMI Sound " + s);
        t.setPriority(10);
        ThreadingUtil.runOnGUI(t::start);
    }

    public static void stopDmiSound(int sound) {
        if (sound == 2) {
            sound2.stop();
        }
    }

    static {
        log = LoggerFactory.getLogger(ResourceUtil.class);
    }
}

