/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs;

import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.swing.ImageIcon;
import jmri.jmrit.etcs.Bundle;
import jmri.jmrit.etcs.ResourceUtil;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class TrackCondition {
    private final boolean isOrder;
    private int distanceFromStart;
    private final BufferedImage smallImage;
    private final String largeImageOrder;
    private final String largeImageNotOrder;
    protected final String descript;
    private int slotNum = 0;
    private final String actionCommand;
    private static final Logger log = LoggerFactory.getLogger(TrackCondition.class);

    protected TrackCondition(int distance, boolean order, String ordSmlPath, String notOrdSmlPath, String ordLrgPath, String notOrdLrgPath, String description, String command) {
        Object smlIconPath;
        this.distanceFromStart = distance;
        this.isOrder = order;
        this.descript = description;
        this.largeImageOrder = ordLrgPath;
        this.largeImageNotOrder = notOrdLrgPath;
        Object object = smlIconPath = order ? ordSmlPath : notOrdSmlPath;
        if (!((String)smlIconPath).isBlank()) {
            smlIconPath = (String)smlIconPath + ".bmp";
        }
        this.actionCommand = command;
        this.smallImage = ResourceUtil.getTransparentImage((String)smlIconPath);
    }

    public boolean getIsOrder() {
        return this.isOrder;
    }

    public int getDistanceFromStart() {
        return this.distanceFromStart;
    }

    protected void setDistanceFromStart(int distance) {
        this.distanceFromStart = distance;
    }

    public BufferedImage getSmlImage() {
        return this.smallImage;
    }

    @CheckForNull
    public ImageIcon getLargeIcon(boolean isOrder) {
        BufferedImage tst = this.getLargeImage(isOrder);
        if (tst == null) {
            return null;
        }
        return new ImageIcon(tst);
    }

    @CheckForNull
    private BufferedImage getLargeImage(boolean isOrder) {
        Object lrgIconPath;
        Object object = lrgIconPath = isOrder ? this.largeImageOrder : this.largeImageNotOrder;
        if (!((String)lrgIconPath).isEmpty()) {
            lrgIconPath = (String)lrgIconPath + ".bmp";
        }
        log.debug("getting image for {}", lrgIconPath);
        return ResourceUtil.getTransparentImage((String)lrgIconPath);
    }

    public String getDescription() {
        return Bundle.getMessage(this.getIsOrder() ? "DriverAction" : "DriverInfo", this.descript);
    }

    public String getAckString() {
        return this.actionCommand;
    }

    public int getColumnNum() {
        return this.slotNum;
    }

    public void setColumnNum(int newCol) {
        this.slotNum = newCol;
    }

    public boolean equals(Object o) {
        return o instanceof TrackCondition && ((TrackCondition)o).descript.equals(this.descript);
    }

    public int hashCode() {
        return 29 + Objects.hashCode(this.descript);
    }

    public String toString() {
        return this.getDescription();
    }

    public static TrackCondition levelCrossing(int distance) {
        return new TrackCondition(distance, false, "", "", "", "LX_01", "Level Crossing, not protected", "");
    }

    public static TrackCondition radioHole(int distance) {
        return new TrackCondition(distance, false, "", "PL_10", "", "TC_12", "Radio hole", "");
    }

    public static TrackCondition soundHorn(int distance) {
        return new TrackCondition(distance, true, "PL_24", "", "TC_35", "", "Sound Horn", "SoundHornAcknowledged");
    }

    public static TrackCondition pantographIsLowered() {
        return new TrackCondition(0, false, "", "", "", "TC_01", "Pantograph Lowered", "");
    }

    public static TrackCondition pantographLower(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_02", "PL_01", "TC_03", "TC_02", "Lower Pantograph", "LowerPantographAcknowledged");
    }

    public static TrackCondition pantographRaise(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_04", "PL_03", "TC_05", "TC_04", "Raise Pantograph", "RaisePantographAcknowledged");
    }

    public static TrackCondition airConClose(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_19", "PL_17", "TC_21", "TC_19", "Close air conditioning intake", "AirConCloseAcknowledged");
    }

    public static TrackCondition airConOpen(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_20", "PL_18", "TC_22", "TC_20", "Open air conditioning intake", "AirConOpenAcknowledged");
    }

    public static TrackCondition neutralSection(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_06", "PL_05", "TC_07", "TC_06", "Neutral Section", "NeutralSectionStartAcknowledged");
    }

    public static TrackCondition neutralSectionEnd(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_08", "PL_07", "TC_09", "TC_08", "End of Neutral Section", "NeutralSectionEndAcknowledged");
    }

    public static TrackCondition nonStoppingArea(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_09", "PL_09", "TC_11", "TC_10", "Non stopping area", "NonStoppingAreaAcknowledged");
    }

    public static TrackCondition inhibitMagShoeBrake(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_12", "PL_11", "TC_14", "TC_13", "Inhibition of Magnetic Shoe Brake", "InhibitMagShoeBrakeAcknowledged");
    }

    public static TrackCondition inhibitEddyCurrentBrake(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_14", "PL_13", "TC_16", "TC_15", "Inhibition of eddy current Brake", "InhibitEddyCurrentBrakeAcknowledged");
    }

    public static TrackCondition inhibitRegenerativeBrake(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_16", "PL_15", "TC_18", "TC_17", "Inhibition of regenerative Brake", "InhibitRegenerativeBrakeAcknowledged");
    }

    public static TrackCondition tractionChange0(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_26", "PL_25", "TC_24", "TC_23", "No traction system", "NoTractionAcknowledge");
    }

    public static TrackCondition tractionChange25000(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_28", "PL_27", "TC_26", "TC_25", "Traction System : AC 25 kV 50 Hz", "TractionSystemAC25kVAcknowledge");
    }

    public static TrackCondition tractionChange15000(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_30", "PL_29", "TC_28", "TC_27", "Traction System : AC 15 kV 16.7 Hz", "TractionSystemAC15kVAcknowledge");
    }

    public static TrackCondition tractionChange3000(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_32", "PL_31", "TC_30", "TC_29", "Traction System : DC 3 kV", "TractionSystemDC3kVAcknowledge");
    }

    public static TrackCondition tractionChange1500(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_34", "PL_33", "TC_32", "TC_31", "Traction System : DC 1.5 kV", "TractionSystemDC1.5kVAcknowledge");
    }

    public static TrackCondition tractionChange750(int distance, boolean order) {
        return new TrackCondition(distance, order, "PL_36", "PL_35", "TC_34", "TC_33", "Traction System : DC 600/750 V", "TractionSystemDC600750VAcknowledge");
    }
}

