/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import jmri.jmrit.etcs.TrackCondition;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public class TrackSection {
    private final CopyOnWriteArrayList<TrackCondition> accouncements;
    private int length;
    private final int speed;
    private final int gradient;

    public TrackSection(int sectionLength, int sectionSpeed, int sectionGradient) {
        this.length = sectionLength;
        this.speed = sectionSpeed;
        this.gradient = sectionGradient;
        this.accouncements = new CopyOnWriteArrayList();
    }

    public int getLength() {
        return this.length;
    }

    protected void setLength(int newLength) {
        this.length = newLength;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getGradient() {
        return this.gradient;
    }

    public void addAnnouncement(@Nonnull TrackCondition ac) {
        if (ac.getDistanceFromStart() >= this.getLength()) {
            throw new IllegalArgumentException("Announcement " + ac.toString() + " does not fit into track section");
        }
        this.accouncements.add(ac);
    }

    public List<TrackCondition> getAnnouncements() {
        return new ArrayList<TrackCondition>(this.accouncements);
    }

    protected void advanceAnnouncements(int distance) {
        for (TrackCondition ac : this.accouncements) {
            ac.setDistanceFromStart(ac.getDistanceFromStart() - distance);
            if (ac.getDistanceFromStart() >= 0) continue;
            this.accouncements.remove(ac);
        }
    }

    public String toString() {
        return "TrackSection Length:" + this.getLength() + " Speed:" + this.getSpeed() + " Gradient:" + this.getGradient();
    }
}

