/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jmri.jmrit.etcs.CabMessage;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class DmiCabMessage
extends CabMessage {
    private final String[] msgArray;
    private static final Logger log = LoggerFactory.getLogger(DmiCabMessage.class);

    protected DmiCabMessage(CabMessage msg, Font font) {
        super(msg.getMessageId(), msg.getMessage(), msg.getGroup(), msg.getAckRequired());
        this.msgArray = this.msgs(font);
    }

    protected String[] getMessageArray() {
        return Arrays.copyOf(this.msgArray, this.msgArray.length);
    }

    private String[] msgs(Font font) {
        int maxWidth = 170;
        String[] result = DmiCabMessage.splitString(this.getMessage(), maxWidth, font);
        log.debug("{} lines in message", (Object)result.length);
        return result;
    }

    private static String[] splitString(String input, int maxWidth, Font font) {
        String[] words;
        ArrayList<String> substrings = new ArrayList<String>();
        StringBuilder currentSubstring = new StringBuilder();
        for (String word : words = input.split(" ")) {
            if (currentSubstring.length() == 0) {
                currentSubstring.append(word);
                continue;
            }
            String potentialSubstring = currentSubstring.toString() + " " + word;
            if (DmiCabMessage.getStringWidthInPx(potentialSubstring, font) <= maxWidth) {
                currentSubstring.append(" ").append(word);
                continue;
            }
            substrings.add(currentSubstring.toString());
            currentSubstring = new StringBuilder(word);
        }
        if (currentSubstring.length() > 0) {
            substrings.add(currentSubstring.toString());
        }
        return (String[])substrings.toArray(String[]::new);
    }

    private static int getStringWidthInPx(String input, Font font) {
        JFrame frame = new JFrame();
        JLabel label = new JLabel(input);
        label.setFont(font);
        frame.add(label);
        frame.pack();
        frame.setVisible(false);
        FontMetrics fontMetrics = label.getFontMetrics(font);
        int dd = fontMetrics.stringWidth(input);
        frame.dispose();
        return dd;
    }
}

