/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import jmri.jmrit.etcs.CabMessage;
import jmri.jmrit.etcs.MovementAuthority;
import jmri.jmrit.etcs.StationTrackCondition;
import jmri.jmrit.etcs.TrackCondition;
import jmri.jmrit.etcs.TrackSection;
import jmri.jmrit.etcs.dmi.swing.DmiCircularSpeedGuideSection;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import jmri.util.ThreadingUtil;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class DmiDemo {
    final DmiPanel dmiPanel;
    private static final int DELAY_STEP = 11;
    private static int delayMultiplier = 1;
    private static final Logger log = LoggerFactory.getLogger(DmiDemo.class);

    public DmiDemo(DmiPanel mainPanel) {
        this.dmiPanel = mainPanel;
    }

    public void runDemo() {
        ThreadingUtil.newThread(this::doDemo, "DMI Demo").start();
    }

    private void doDemo() {
        this.dmiPanel.messageDriver(new CabMessage("Starting DMI GUI Demo", 1, false));
        DmiDemo.waitFor(1000);
        this.pt1();
    }

    private void pt1() {
        int i;
        CabMessage ackMsg = new CabMessage("Message which needs Acknowledge", 1, true);
        this.dmiPanel.messageDriver(ackMsg);
        DmiDemo.waitFor(3000);
        this.dmiPanel.removeMessage(ackMsg.getMessageId());
        this.dmiPanel.messageDriver(new CabMessage("Ack Message removed, this is a normal CabMessage.", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Ramp speed, setSpeedHookSpeed 0 to 140", 1, false));
        for (i = 0; i < 141; ++i) {
            DmiDemo.waitFor(50);
            this.dmiPanel.setActualSpeed(i);
            DmiDemo.setSpeedHookSpeed(i, this.dmiPanel);
        }
        this.dmiPanel.messageDriver(new CabMessage("Ramp speed, setSpeedHookSpeed 140 to 0", 1, false));
        for (i = 140; i > -1; --i) {
            DmiDemo.waitFor(50);
            this.dmiPanel.setActualSpeed(i);
            DmiDemo.setSpeedHookSpeed(i, this.dmiPanel);
        }
        this.dmiPanel.messageDriver(new CabMessage("Max Speed to 180", 1, false));
        this.dmiPanel.setMaxDialSpeed(180);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("RampActualSpeed setSpeedHookSpeed 0 - 20", 1, false));
        for (i = 0; i < 21; ++i) {
            DmiDemo.waitFor(150);
            this.dmiPanel.setActualSpeed(i);
            DmiDemo.setSpeedHookSpeed(i, this.dmiPanel);
        }
        this.dmiPanel.messageDriver(new CabMessage("RampActualSpeed setSpeedHookSpeed 20 - 0", 1, false));
        for (i = 20; i > -1; --i) {
            DmiDemo.waitFor(150);
            this.dmiPanel.setActualSpeed(i);
            DmiDemo.setSpeedHookSpeed(i, this.dmiPanel);
        }
        this.dmiPanel.messageDriver(new CabMessage("Ramp speed and hook to 20", 1, false));
        for (i = 0; i < 21; ++i) {
            DmiDemo.waitFor(150);
            this.dmiPanel.setActualSpeed(i);
            DmiDemo.setSpeedHookSpeed(i, this.dmiPanel);
        }
        this.dmiPanel.messageDriver(new CabMessage("Max Speed to 250", 1, false));
        this.dmiPanel.setMaxDialSpeed(250);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Max Speed to 400", 1, false));
        this.dmiPanel.setMaxDialSpeed(400);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Ramp speed and Target Advice Speed 0-400", 1, false));
        for (i = 0; i < 401; ++i) {
            DmiDemo.waitFor(20);
            this.dmiPanel.setActualSpeed(i);
            this.dmiPanel.setTargetAdviceSpeed(i);
        }
        this.dmiPanel.messageDriver(new CabMessage("speed 70 , hook 80", 1, false));
        this.dmiPanel.setActualSpeed(70.0f);
        DmiDemo.setSpeedHookSpeed(80, this.dmiPanel);
        this.dmiPanel.setTargetAdviceSpeed(-1);
        this.dmiPanel.messageDriver(new CabMessage("Limited Supervision Speed 10", 1, false));
        this.dmiPanel.setLimitedSupervisionSpeed(10.0f);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Limited Supervision Speed 0-400", 1, false));
        for (i = 0; i < 401; ++i) {
            DmiDemo.waitFor(30);
            this.dmiPanel.setLimitedSupervisionSpeed(i);
        }
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Limited Supervision Speed", 1, false));
        this.dmiPanel.setLimitedSupervisionSpeed(-1.0f);
        this.dmiPanel.messageDriver(new CabMessage("Distance to Target 1500m to 0m", 1, false));
        for (i = 1500; i > -100; --i) {
            this.dmiPanel.setDistanceToTarget(i);
            DmiDemo.waitFor(5);
        }
        this.dmiPanel.setActualSpeed(96.0f);
        DmiDemo.setSpeedHookSpeed(100, this.dmiPanel);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Speed Unit to MPH", 1, false));
        this.dmiPanel.setDisplaySpeedUnit("MPH");
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Speed Unit Empty", 1, false));
        this.dmiPanel.setDisplaySpeedUnit("");
        this.dmiPanel.setCoasting(false);
        DmiDemo.waitFor(1000);
        this.pt2();
    }

    private void pt2() {
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Track Ahead Free Question Visible", 1, false));
        this.dmiPanel.setTrackAheadFreeQuestionVisible(true);
        DmiDemo.waitFor(2000);
        this.dmiPanel.messageDriver(new CabMessage("Track Ahead Free Question Hidden", 1, false));
        this.dmiPanel.setTrackAheadFreeQuestionVisible(false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Tunnel Stopping Icon Visible Ack", 1, false));
        this.dmiPanel.setTunnelStoppingIconVisible(true, true);
        DmiDemo.waitFor(2000);
        this.dmiPanel.messageDriver(new CabMessage("Tunnel Stopping Icon No Ack", 1, false));
        this.dmiPanel.setTunnelStoppingIconVisible(true, false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Tunnel Stopping Distance 400 to 0", 1, false));
        for (int i = 401; i > -2; --i) {
            DmiDemo.waitFor(50);
            this.dmiPanel.setTunnelStoppingDistance(i);
        }
        this.dmiPanel.messageDriver(new CabMessage("Tunnel Stopping Icon hidden", 1, false));
        this.dmiPanel.setTunnelStoppingIconVisible(false, false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Notification Level transition to NTC", 1, false));
        this.dmiPanel.setLevelTransition(-1, true);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Notification Level transition to 0", 1, false));
        this.dmiPanel.setLevelTransition(0, false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Level to 0", 1, false));
        this.dmiPanel.setLevel(0);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Notification Level transition to 1", 1, false));
        this.dmiPanel.setLevelTransition(1, false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Level 1", 1, false));
        this.dmiPanel.setLevel(1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Level 2", 1, false));
        this.dmiPanel.setLevel(2);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Notification Level transition", 1, false));
        this.dmiPanel.setLevelTransition(-2, false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Safe Radio Connection Lost", 1, false));
        this.dmiPanel.setSafeRadioConnection(0);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Safe Radio Connection Hidden", 1, false));
        this.dmiPanel.setSafeRadioConnection(-1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Safe Radio Connection", 1, false));
        this.dmiPanel.setSafeRadioConnection(1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Adhesion Factor On", 1, false));
        this.dmiPanel.setAdhesionFactorOn(true);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Adhesion Factor Off", 1, false));
        this.dmiPanel.setAdhesionFactorOn(false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Display Intervetion Symbol", 1, false));
        this.dmiPanel.setIntervetionSymbol(true);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Intervetion Symbol", 1, false));
        this.dmiPanel.setIntervetionSymbol(false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Reversing Permitted", 1, false));
        this.dmiPanel.setReversingPermittedSymbol(true);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Reversing Permitted hidden", 1, false));
        this.dmiPanel.setReversingPermittedSymbol(false);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Shunting Mode", 1, false));
        this.dmiPanel.setMode(1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode set to Trip", 1, false));
        this.dmiPanel.setMode(4);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode set to Post Trip", 1, false));
        this.dmiPanel.setMode(6);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode set to On Sight", 1, false));
        this.dmiPanel.setMode(7);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode set to Staff Responsible", 1, false));
        this.dmiPanel.setMode(9);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode set to Full Supervision", 1, false));
        this.dmiPanel.setMode(11);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode set to Non-Leading", 1, false));
        this.dmiPanel.setMode(12);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode to Reversing", 1, false));
        this.dmiPanel.setMode(14);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode to Unfitted", 1, false));
        this.dmiPanel.setMode(16);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode to System Failure", 1, false));
        this.dmiPanel.setMode(18);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Release speed to 50", 1, false));
        this.dmiPanel.setReleaseSpeed(50);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Mode to Limited Supervision", 1, false));
        this.dmiPanel.setMode(21);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Release speed", 1, false));
        this.dmiPanel.setReleaseSpeed(-1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Mode to Automatic Train Operation", 1, false));
        this.dmiPanel.setMode(23);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Display Coasting", 1, false));
        this.dmiPanel.setCoasting(true);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Speed Unit while coasting", 1, false));
        this.dmiPanel.setCoasting(true);
        this.dmiPanel.setDisplaySpeedUnit("mph");
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Coasting", 1, false));
        this.dmiPanel.setCoasting(false);
        this.dmiPanel.setDisplaySpeedUnit("");
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Mode to Supervised Manoeuvre", 1, false));
        this.dmiPanel.setMode(24);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Supervised Direction Forwards", 1, false));
        this.dmiPanel.setSupervisedDirection(1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Supervised Direction Reverse", 1, false));
        this.dmiPanel.setSupervisedDirection(-1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Supervised Direction", 1, false));
        this.dmiPanel.setSupervisedDirection(0);
        DmiDemo.waitFor(1000);
        this.checkModeAcknowledge("ModeShuntingAcknowledged", 1, this.dmiPanel);
        this.checkModeAcknowledge("ModeTripAcknowledged", 4, this.dmiPanel);
        this.checkModeAcknowledge("ModeOnSightAcknowledged", 7, this.dmiPanel);
        this.checkModeAcknowledge("ModeStaffResponsibleAcknowledged", 9, this.dmiPanel);
        this.checkModeAcknowledge("ModeReversingAcknowledged", 14, this.dmiPanel);
        this.checkModeAcknowledge("ModeUnfittedAcknowledged", 16, this.dmiPanel);
        this.checkModeAcknowledge("ModeNationalSystemAcknowledged", 20, this.dmiPanel);
        this.checkModeAcknowledge("ModeLimitedSupervisionAcknowledged", 21, this.dmiPanel);
        this.pt3();
    }

    private void checkModeAcknowledge(String str, int mode, DmiPanel main) {
        main.setModeAcknowledge(mode);
        main.messageDriver(new CabMessage(DmiDemo.addSpaceBeforeCapital(str), 1, false));
        DmiDemo.waitFor(1000);
        main.setModeAcknowledge(0);
        DmiDemo.waitFor(500);
    }

    private void pt3() {
        this.dmiPanel.setLevel(2);
        this.dmiPanel.setMode(23);
        this.dmiPanel.setSafeRadioConnection(1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.setAtoMode(1);
        this.dmiPanel.messageDriver(new CabMessage("ATO Selected", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setAtoMode(2);
        this.dmiPanel.messageDriver(new CabMessage("ATO ready for engagement", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setAtoMode(3);
        this.dmiPanel.messageDriver(new CabMessage("ATO Engaged", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setAtoMode(4);
        this.dmiPanel.messageDriver(new CabMessage("ATO Disengaging", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setAtoMode(5);
        this.dmiPanel.messageDriver(new CabMessage("ATO Failure", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setAtoMode(0);
        this.dmiPanel.messageDriver(new CabMessage("ATO Off", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setAtoMode(3);
        this.dmiPanel.messageDriver(new CabMessage("Undershot stopping window", 1, false));
        this.dmiPanel.setStoppingAccuracy(-1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Accurate stopping window", 1, false));
        this.dmiPanel.setStoppingAccuracy(0);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Overshotshot stopping window", 1, false));
        this.dmiPanel.setStoppingAccuracy(1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide stopping window", 1, false));
        this.dmiPanel.setStoppingAccuracy(-2);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Stopping Point", 1, false));
        this.dmiPanel.setStoppingPointLabel("Welwyn North", "17:36:48");
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Skip Stopping Point Active", 1, false));
        this.dmiPanel.setSkipStoppingPoint(17);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Skip Stopping Point requested by ATO-TS", 1, false));
        this.dmiPanel.setSkipStoppingPoint(18);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Skip Stopping Point requested by driver", 1, false));
        this.dmiPanel.setSkipStoppingPoint(19);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Skip Stopping Point", 1, false));
        this.dmiPanel.setSkipStoppingPoint(0);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Set Stopping Point Hidden", 1, false));
        this.dmiPanel.setStoppingPointLabel("", "");
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Request driver to open both sides doors", 1, false));
        this.dmiPanel.setDoorIcon(10);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Request driver to open left doors", 1, false));
        this.dmiPanel.setDoorIcon(11);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Request driver to open right doors", 1, false));
        this.dmiPanel.setDoorIcon(12);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Doors are open", 1, false));
        this.dmiPanel.setDoorIcon(13);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Request driver to close doors", 1, false));
        this.dmiPanel.setDoorIcon(14);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Doors are being closed by ATO", 1, false));
        this.dmiPanel.setDoorIcon(15);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Doors are closed", 1, false));
        this.dmiPanel.setDoorIcon(16);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Dwell Time set to 1min 9secs", 1, false));
        this.dmiPanel.setDwellTime(1, 9);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Dwell Time set to 1min 8secs", 1, false));
        this.dmiPanel.setDwellTime(1, 8);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Hide Dwell Time", 1, false));
        this.dmiPanel.setDwellTime(-1, -1);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Doors are closed", 1, false));
        this.dmiPanel.setDoorIcon(16);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Doors icon hidden", 1, false));
        this.dmiPanel.setDoorIcon(0);
        DmiDemo.waitFor(1000);
        this.pt4();
    }

    private void pt4() {
        this.dmiPanel.messageDriver(new CabMessage("Add Movement Authority", 1, false));
        ArrayList<TrackSection> trackSectionList = new ArrayList<TrackSection>();
        TrackSection s1 = new TrackSection(75, 100, -4);
        TrackSection s2 = new TrackSection(50, 140, -2);
        TrackSection s3 = new TrackSection(125, 100, 1);
        TrackSection s4 = new TrackSection(250, 80, 2);
        TrackSection s5 = new TrackSection(250, 40, 4);
        TrackSection s6 = new TrackSection(250, 100, 8);
        trackSectionList.add(s1);
        trackSectionList.add(s2);
        trackSectionList.add(s3);
        trackSectionList.add(s4);
        trackSectionList.add(s5);
        trackSectionList.add(s6);
        this.dmiPanel.extendMovementAuthorities(new MovementAuthority(trackSectionList));
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Advance Movement Authority", 1, false));
        for (int i = 0; i < 1100; ++i) {
            this.dmiPanel.advance(1);
            DmiDemo.waitFor(20);
        }
        s1 = new TrackSection(7700, 100, 1);
        int pos = 0;
        s1.addAnnouncement(TrackCondition.levelCrossing(pos += 200));
        s1.addAnnouncement(TrackCondition.radioHole(pos += 200));
        s1.addAnnouncement(TrackCondition.soundHorn(pos += 200));
        s1.addAnnouncement(TrackCondition.pantographLower(pos += 200, true));
        s1.addAnnouncement(TrackCondition.pantographLower(pos += 200, false));
        s1.addAnnouncement(TrackCondition.pantographRaise(pos += 200, true));
        s1.addAnnouncement(TrackCondition.pantographRaise(pos += 200, false));
        s1.addAnnouncement(TrackCondition.airConClose(pos += 200, true));
        s1.addAnnouncement(TrackCondition.airConClose(pos += 200, false));
        s1.addAnnouncement(TrackCondition.airConOpen(pos += 200, true));
        s1.addAnnouncement(TrackCondition.airConOpen(pos += 200, false));
        s1.addAnnouncement(TrackCondition.neutralSection(pos += 200, true));
        s1.addAnnouncement(TrackCondition.neutralSection(pos += 200, false));
        s1.addAnnouncement(TrackCondition.neutralSectionEnd(pos += 200, true));
        s1.addAnnouncement(TrackCondition.neutralSectionEnd(pos += 200, false));
        s1.addAnnouncement(TrackCondition.nonStoppingArea(pos += 200, true));
        s1.addAnnouncement(TrackCondition.inhibitMagShoeBrake(pos += 200, true));
        s1.addAnnouncement(TrackCondition.inhibitMagShoeBrake(pos += 200, false));
        s1.addAnnouncement(TrackCondition.inhibitEddyCurrentBrake(pos += 200, true));
        s1.addAnnouncement(TrackCondition.inhibitEddyCurrentBrake(pos += 200, false));
        s1.addAnnouncement(TrackCondition.inhibitRegenerativeBrake(pos += 200, true));
        s1.addAnnouncement(TrackCondition.inhibitRegenerativeBrake(pos += 200, false));
        s1.addAnnouncement(TrackCondition.tractionChange0(pos += 200, true));
        s1.addAnnouncement(TrackCondition.tractionChange0(pos += 200, false));
        s1.addAnnouncement(TrackCondition.tractionChange25000(pos += 200, true));
        s1.addAnnouncement(TrackCondition.tractionChange25000(pos += 200, false));
        s1.addAnnouncement(TrackCondition.tractionChange15000(pos += 200, true));
        s1.addAnnouncement(TrackCondition.tractionChange15000(pos += 200, false));
        s1.addAnnouncement(TrackCondition.tractionChange3000(pos += 200, true));
        s1.addAnnouncement(TrackCondition.tractionChange3000(pos += 200, false));
        s1.addAnnouncement(TrackCondition.tractionChange1500(pos += 200, true));
        s1.addAnnouncement(TrackCondition.tractionChange1500(pos += 200, false));
        s1.addAnnouncement(TrackCondition.tractionChange750(pos += 200, true));
        s1.addAnnouncement(TrackCondition.tractionChange750(pos += 200, false));
        s1.addAnnouncement(new StationTrackCondition(pos += 200, "Welwyn North"));
        trackSectionList = new ArrayList();
        trackSectionList.add(s1);
        this.dmiPanel.extendMovementAuthorities(new MovementAuthority(trackSectionList));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setScale(5);
        this.dmiPanel.messageDriver(new CabMessage("Set Planning Scale 0-3200", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setScale(4);
        this.dmiPanel.messageDriver(new CabMessage("Set Planning Scale 0-1600", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setScale(3);
        this.dmiPanel.messageDriver(new CabMessage("Set Planning Scale 0-8000", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setScale(2);
        this.dmiPanel.messageDriver(new CabMessage("Set Planning Scale 0-4000", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setScale(1);
        this.dmiPanel.messageDriver(new CabMessage("Set Planning Scale 0-2000", 1, false));
        DmiDemo.waitFor(1000);
        this.dmiPanel.setScale(0);
        this.dmiPanel.messageDriver(new CabMessage("Set Planning Scale 0-1000", 1, false));
        DmiDemo.waitFor(1000);
        String tcString = "";
        for (int i = 0; i < 7300; ++i) {
            String newString;
            this.dmiPanel.advance(1);
            TrackCondition nextTc = this.dmiPanel.getNextAnnouncement(false);
            if (nextTc != null && !tcString.equals(newString = nextTc.getDescription())) {
                tcString = newString;
                this.dmiPanel.messageDriver(new CabMessage(tcString, 1, false));
            }
            DmiDemo.waitFor(10);
        }
        this.dmiPanel.setMode(24);
        this.dmiPanel.messageDriver(new CabMessage("Indication Marker", 1, false));
        this.dmiPanel.setIndicationMarker(100, 0);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Indication Marker in ATO", 1, false));
        this.dmiPanel.setMode(23);
        DmiDemo.waitFor(1000);
        this.pt5();
    }

    private void pt5() {
        this.dmiPanel.messageDriver(new CabMessage("Play Sound Too Fast", 1, false));
        this.dmiPanel.playDmiSound(1);
        DmiDemo.waitFor(3000);
        this.dmiPanel.messageDriver(new CabMessage("Play Sound Info", 1, false));
        this.dmiPanel.playDmiSound(3);
        DmiDemo.waitFor(3000);
        this.dmiPanel.messageDriver(new CabMessage("Play Sound Click", 1, false));
        this.dmiPanel.playDmiSound(4);
        DmiDemo.waitFor(3000);
        this.dmiPanel.messageDriver(new CabMessage("Play Sound Warning", 1, false));
        this.dmiPanel.playDmiSound(2);
        DmiDemo.waitFor(3000);
        this.dmiPanel.messageDriver(new CabMessage("Stop Sound Warning", 1, false));
        this.dmiPanel.stopDmiSound(2);
        DmiDemo.waitFor(1000);
        this.dmiPanel.messageDriver(new CabMessage("Demo Complete", 1, false));
    }

    private static void setSpeedHookSpeed(int speedHookSpeed, DmiPanel p) {
        ArrayList<DmiCircularSpeedGuideSection> csgSectionList = new ArrayList<DmiCircularSpeedGuideSection>();
        csgSectionList.add(new DmiCircularSpeedGuideSection(0, DmiPanel.DARK_GREY, -2.0f, 1.0f, false));
        p.setCentreCircleAndDialColor(DmiPanel.YELLOW);
        if (speedHookSpeed > 110) {
            csgSectionList.add(new DmiCircularSpeedGuideSection(1, DmiPanel.ORANGE, 110.0f, speedHookSpeed, true));
            p.setCentreCircleAndDialColor(DmiPanel.ORANGE);
        }
        if (speedHookSpeed > 200) {
            csgSectionList.add(new DmiCircularSpeedGuideSection(1, DmiPanel.RED, 200.0f, speedHookSpeed, true));
            p.setCentreCircleAndDialColor(DmiPanel.RED);
        }
        if (speedHookSpeed <= 50) {
            csgSectionList.add(new DmiCircularSpeedGuideSection(0, DmiPanel.GREY, 0.0f, Math.min(speedHookSpeed, 110), false));
            csgSectionList.add(new DmiCircularSpeedGuideSection(2, DmiPanel.YELLOW, 0.0f, 50.0f, false));
        } else {
            csgSectionList.add(new DmiCircularSpeedGuideSection(0, DmiPanel.YELLOW, 0.0f, Math.min(speedHookSpeed, 110), true));
            csgSectionList.add(new DmiCircularSpeedGuideSection(3, DmiPanel.YELLOW, 0.0f, 50.0f, false));
        }
        p.setCsgSections(csgSectionList);
    }

    private static String addSpaceBeforeCapital(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                result.append(' ');
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    protected static void setDelayMultiplier(int newVal) {
        delayMultiplier = newVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitFor(int msec) {
        if (SwingUtilities.isEventDispatchThread()) {
            log.error("Cannot use waitFor on Swing thread", (Throwable)new Exception());
            return;
        }
        int delay = 0;
        while (delay < msec * delayMultiplier) {
            int priority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(1);
                Thread.sleep(11L);
                delay += 11;
            }
            catch (InterruptedException e) {
                log.error("Interrupted");
                Thread.currentThread().interrupt();
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }
    }
}

