/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.beans.PropertyChangeListener;
import java.util.TimerTask;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import jmri.util.TimerUtil;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class DmiFlashTimer {
    private final DmiPanel panel;
    private static final String PROP_CHANGE_SLOW_FLASH = "SlowFlash";
    private static final String PROP_CHANGE_FAST_FLASH = "FastFlash";
    private boolean fastFlashOn = false;
    private boolean slowFlashOn = false;
    private boolean disposed = false;
    private TimerTask flashTimer;
    private static final Logger log = LoggerFactory.getLogger(DmiFlashTimer.class);

    protected DmiFlashTimer(DmiPanel mainPanel) {
        this.panel = mainPanel;
    }

    protected void addFlashListener(PropertyChangeListener pcl, boolean fast) {
        log.debug("add pcl {}", (Object)pcl);
        this.panel.addPropertyChangeListener(fast ? PROP_CHANGE_FAST_FLASH : PROP_CHANGE_SLOW_FLASH, pcl);
        this.ensureRunning();
    }

    protected void removeFlashListener(PropertyChangeListener pcl, boolean fast) {
        log.debug("remove pcl {} num listeners {}", (Object)pcl, (Object)(this.panel.getPropertyChangeListeners(PROP_CHANGE_FAST_FLASH).length + this.panel.getPropertyChangeListeners(PROP_CHANGE_SLOW_FLASH).length));
        this.panel.removePropertyChangeListener(fast ? PROP_CHANGE_FAST_FLASH : PROP_CHANGE_SLOW_FLASH, pcl);
        log.debug("remove pcl {} num listeners {}", (Object)pcl, (Object)(this.panel.getPropertyChangeListeners(PROP_CHANGE_FAST_FLASH).length + this.panel.getPropertyChangeListeners(PROP_CHANGE_SLOW_FLASH).length));
        if (this.panel.getPropertyChangeListeners(PROP_CHANGE_FAST_FLASH).length + this.panel.getPropertyChangeListeners(PROP_CHANGE_SLOW_FLASH).length == 0) {
            this.dispose();
        }
    }

    private void ensureRunning() {
        log.debug("ensureRunning");
        this.disposed = false;
        if (this.flashTimer == null) {
            this.flashTimer = new TimerTask(){

                @Override
                public void run() {
                    if (!DmiFlashTimer.this.disposed) {
                        DmiFlashTimer.this.triggerFastFlash();
                        TimerUtil.scheduleOnGUIThread(DmiFlashTimer.this.flashTimer, 250L);
                    }
                }
            };
            TimerUtil.scheduleOnGUIThread(this.flashTimer, 250L);
        }
    }

    private void triggerFastFlash() {
        this.fastFlashOn = !this.fastFlashOn;
        log.debug("fast flash {}", (Object)this.fastFlashOn);
        this.panel.firePropertyChange(PROP_CHANGE_FAST_FLASH, !this.fastFlashOn, this.fastFlashOn);
        if (!this.fastFlashOn) {
            this.triggerSlowFlash();
        }
    }

    private void triggerSlowFlash() {
        this.slowFlashOn = !this.slowFlashOn;
        log.debug("slow flash {}", (Object)this.slowFlashOn);
        this.panel.firePropertyChange(PROP_CHANGE_SLOW_FLASH, !this.slowFlashOn, this.slowFlashOn);
    }

    protected void dispose() {
        log.debug("dispose");
        this.disposed = true;
        if (this.flashTimer != null) {
            this.flashTimer.cancel();
            this.flashTimer = null;
        }
    }
}

