/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jmri.Version;
import jmri.jmrit.etcs.CabMessage;
import jmri.jmrit.etcs.MovementAuthority;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.StationTrackCondition;
import jmri.jmrit.etcs.TrackCondition;
import jmri.jmrit.etcs.TrackSection;
import jmri.jmrit.etcs.dmi.swing.DmiCircularSpeedGuideSection;
import jmri.jmrit.etcs.dmi.swing.DmiFlashTimer;
import jmri.jmrit.etcs.dmi.swing.DmiPanelA;
import jmri.jmrit.etcs.dmi.swing.DmiPanelB;
import jmri.jmrit.etcs.dmi.swing.DmiPanelC;
import jmri.jmrit.etcs.dmi.swing.DmiPanelD;
import jmri.jmrit.etcs.dmi.swing.DmiPanelE;
import jmri.jmrit.etcs.dmi.swing.DmiPanelF;
import jmri.jmrit.etcs.dmi.swing.DmiPanelG;
import jmri.util.ThreadingUtil;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public class DmiPanel
extends JPanel {
    public static final Color WHITE = Color.WHITE;
    public static final Color BLACK = Color.BLACK;
    public static final Color GREY = new Color(195, 195, 195);
    public static final Color DARK_GREY = new Color(85, 85, 85);
    public static final Color MEDIUM_GREY = new Color(150, 150, 150);
    public static final Color DARK_BLUE = new Color(3, 17, 34);
    public static final Color ORANGE = new Color(234, 145, 0);
    public static final Color RED = new Color(191, 0, 2);
    public static final Color YELLOW = new Color(223, 223, 0);
    protected static final Color BACKGROUND_COLOUR = DARK_BLUE;
    protected static final Border BORDER_ACK = BorderFactory.createLineBorder(YELLOW, 2);
    protected static final Border BORDER_NORMAL = BorderFactory.createLineBorder(BACKGROUND_COLOUR, 2);
    protected static final String FONT_NAME = "Helvetica";
    public static final String PROP_CHANGE_CABMESSAGE_ACK = "MessageAcknowledged";
    public static final String PROP_CHANGE_LEVEL_NTC_TRANSITION_ACK = "LevelNTCAcknowledged";
    public static final String PROP_CHANGE_LEVEL_0_TRANSITION_ACK = "Level0Acknowledged";
    public static final String PROP_CHANGE_LEVEL_1_TRANSITION_ACK = "Level1Acknowledged";
    public static final String PROP_CHANGE_LEVEL_2_TRANSITION_ACK = "Level2Acknowledged";
    public static final String PROP_CHANGE_LEVEL_3_TRANSITION_ACK = "Level3Acknowledged";
    public static final int MODE_NONE = 0;
    public static final int MODE_SHUNTING = 1;
    public static final int MODE_TRIP = 4;
    public static final int MODE_POST_TRIP = 6;
    public static final int MODE_ON_SIGHT = 7;
    public static final int MODE_STAFF_RESPONSIBLE = 9;
    public static final int MODE_FULL_SUPERVISION = 11;
    public static final int MODE_NON_LEADING = 12;
    public static final int MODE_STANDBY = 13;
    public static final int MODE_REVERSING = 14;
    public static final int MODE_UNFITTED = 16;
    public static final int MODE_SYSTEM_FAILURE = 18;
    public static final int MODE_NATIONAL_SYSTEM = 20;
    public static final int MODE_LIMITED_SUPERVISION = 21;
    public static final int MODE_AUTOMATIC_DRIVING = 23;
    public static final int MODE_SUPERVISED_MANOEUVRE = 24;
    public static final String PROP_CHANGE_MODE_SHUNTING_ACK = "ModeShuntingAcknowledged";
    public static final String PROP_CHANGE_MODE_TRIP_ACK = "ModeTripAcknowledged";
    public static final String PROP_CHANGE_MODE_ON_SIGHT_ACK = "ModeOnSightAcknowledged";
    public static final String PROP_CHANGE_MODE_STAFF_RESPONSIBLE_ACK = "ModeStaffResponsibleAcknowledged";
    public static final String PROP_CHANGE_MODE_REVERSING_ACK = "ModeReversingAcknowledged";
    public static final String PROP_CHANGE_MODE_UNFITTED_ACK = "ModeUnfittedAcknowledged";
    public static final String PROP_CHANGE_MODE_NATIONAL_SYSTEM_ACK = "ModeNationalSystemAcknowledged";
    public static final String PROP_CHANGE_MODE_LIMITED_SUPERVISION_ACK = "ModeLimitedSupervisionAcknowledged";
    public static final String PROP_CHANGE_TRACK_AHEAD_FREE_TRUE = "DriverAdvisesTrackAheadFree";
    public static final String PROP_CHANGE_ATO_DRIVER_REQUEST_START = "AtoDriverStart";
    public static final String PROP_CHANGE_ATO_DRIVER_REQUEST_STOP = "AtoDriverStop";
    public static final String PROP_CHANGE_SKIP_STOPPING_POINT_INACTIVE_DRIVER = "SkipStoppingPointInactive";
    public static final String PROP_CHANGE_SKIP_STOPPING_POINT_REQUEST_DRIVER = "SkipStoppingPointRequestByDriver";
    public static final String PROP_CHANGE_TUNNEL_STOP_AREA_ACK = "TunnelStopAreaAcknowledged";
    public static final String PROP_CHANGE_SOUND_HORN_ACK = "SoundHornAcknowledged";
    public static final String PROP_CHANGE_LOWER_PANT_ACK = "LowerPantographAcknowledged";
    public static final String PROP_CHANGE_RAISE_PANT_ACK = "RaisePantographAcknowledged";
    public static final String PROP_CHANGE_AIRCON_OPEN_ACK = "AirConOpenAcknowledged";
    public static final String PROP_CHANGE_AIRCON_CLOSE_ACK = "AirConCloseAcknowledged";
    public static final String PROP_CHANGE_NEUTRAL_START_ACK = "NeutralSectionStartAcknowledged";
    public static final String PROP_CHANGE_NEUTRAL_END_ACK = "NeutralSectionEndAcknowledged";
    public static final String PROP_CHANGE_NONSTOP_ACK = "NonStoppingAreaAcknowledged";
    public static final String PROP_CHANGE_INHIBIT_MAG_BRAKE_ACK = "InhibitMagShoeBrakeAcknowledged";
    public static final String PROP_CHANGE_INHIBIT_EDDY_BRAKE_ACK = "InhibitEddyCurrentBrakeAcknowledged";
    public static final String PROP_CHANGE_INHIBIT_REGEN_BRAKE_ACK = "InhibitRegenerativeBrakeAcknowledged";
    public static final String PROP_CHANGE_TRACTION_0_ACK = "NoTractionAcknowledge";
    public static final String PROP_CHANGE_TRACTION_25KV_ACK = "TractionSystemAC25kVAcknowledge";
    public static final String PROP_CHANGE_TRACTION_15KV_ACK = "TractionSystemAC15kVAcknowledge";
    public static final String PROP_CHANGE_TRACTION_3KV_ACK = "TractionSystemDC3kVAcknowledge";
    public static final String PROP_CHANGE_TRACTION_1_5KV_ACK = "TractionSystemDC1.5kVAcknowledge";
    public static final String PROP_CHANGE_TRACTION_750V_ACK = "TractionSystemDC600750VAcknowledge";
    protected static final String PROPERTY_CENTRE_TEXT = DmiPanel.class.getName() + "centreText";
    private final DmiPanelA panelA;
    private final DmiPanelB panelB;
    private final DmiPanelC panelC;
    private final DmiPanelD panelD;
    private final DmiPanelE panelE;
    private final DmiPanelG panelG;
    private final DmiFlashTimer flashTimer;
    private int mode = 0;

    public DmiPanel() {
        this.setPreferredSize(new Dimension(640, 480));
        this.setLayout(null);
        this.flashTimer = new DmiFlashTimer(this);
        this.panelA = this.getPanelA();
        this.panelB = this.getPanelB();
        this.panelC = this.getPanelC();
        this.panelD = this.getPanelD();
        this.panelE = this.getPanelE();
        this.panelG = this.getPanelG();
        this.add(this.panelA);
        this.add(this.panelB);
        this.add(this.panelC);
        this.add(this.panelD);
        this.add(this.panelE);
        this.add(this.getPanelF());
        this.add(this.panelG);
        this.add(this.getPanelY());
        this.add(this.getPanelZ());
    }

    private DmiPanelA getPanelA() {
        return new DmiPanelA(this);
    }

    private DmiPanelB getPanelB() {
        return new DmiPanelB(this);
    }

    private DmiPanelC getPanelC() {
        return new DmiPanelC(this);
    }

    private DmiPanelD getPanelD() {
        return new DmiPanelD(this);
    }

    private DmiPanelE getPanelE() {
        return new DmiPanelE(this);
    }

    private DmiPanelF getPanelF() {
        return new DmiPanelF(this);
    }

    private DmiPanelG getPanelG() {
        return new DmiPanelG(this);
    }

    private JPanel getPanelY() {
        JPanel p = new JPanel();
        p.setBackground(BACKGROUND_COLOUR);
        p.setBounds(0, 0, 640, 15);
        return p;
    }

    private JPanel getPanelZ() {
        JPanel p = new JPanel();
        p.setBackground(BACKGROUND_COLOUR);
        p.setLayout(null);
        p.setBounds(0, 465, 640, 15);
        JLabel jmriLabel = new JLabel("JMRI " + Version.getCanonicalVersion());
        jmriLabel.setFont(new Font(FONT_NAME, 0, 9));
        jmriLabel.setForeground(BLACK);
        jmriLabel.setLayout(null);
        jmriLabel.setBounds(590, 2, 110, 15);
        p.add(jmriLabel);
        return p;
    }

    public void setMaxDialSpeed(int speed) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setMaxDialSpeed(speed));
    }

    public void setActualSpeed(float speed) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setActualSpeed(speed));
    }

    public void setCentreCircleAndDialColor(Color colour) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setCentreCircleAndDialColor(colour));
    }

    public void setCsgSections(List<DmiCircularSpeedGuideSection> list) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setCsgSections(list));
    }

    public void setDisplaySpeedUnit(String newVal) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setDisplaySpeedUnit(newVal));
    }

    public void setTargetAdviceSpeed(int newVal) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setTargetAdviceSpeed(newVal));
    }

    public void setNextAdviceChange(int distance) {
        ThreadingUtil.runOnGUI(() -> this.panelD.setNextAdviceChange(distance));
    }

    public void setReleaseSpeed(int speed) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setReleaseSpeed(speed));
    }

    public void setReleaseSpeedColour(Color newColour) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setReleaseSpeedColour(newColour));
    }

    public void setLevelTransition(int newLevel, boolean ackRequired) {
        ThreadingUtil.runOnGUI(() -> this.panelC.setLevelTransition(newLevel, ackRequired));
    }

    public void setLevel(int level) {
        ThreadingUtil.runOnGUI(() -> this.panelC.setLevel(level));
    }

    public void setMode(int newMode) {
        this.mode = newMode;
        ThreadingUtil.runOnGUI(() -> {
            this.panelB.setMode(newMode);
            this.panelD.repaint();
        });
    }

    public void setModeAcknowledge(int newMode) {
        ThreadingUtil.runOnGUI(() -> this.panelC.setModeAcknowledge(newMode));
    }

    protected int getMode() {
        return this.mode;
    }

    public void addAnnouncement(TrackCondition tc) {
        ThreadingUtil.runOnGUI(() -> this.panelB.addAnnouncement(tc));
    }

    public void removeAnnouncement(TrackCondition tc) {
        ThreadingUtil.runOnGUI(() -> this.panelB.removeAnnouncement(tc));
    }

    public void setLimitedSupervisionSpeed(float spd) {
        ThreadingUtil.runOnGUI(() -> this.panelA.setLimitedSupervisionSpeed(spd));
    }

    public void setDistanceToTarget(float distance) {
        ThreadingUtil.runOnGUI(() -> this.panelA.setDistanceToTarget(distance));
    }

    public void setAdhesionFactorOn(boolean newVal) {
        ThreadingUtil.runOnGUI(() -> this.panelA.setAdhesionFactorOn(newVal));
    }

    public void setIntervetionSymbol(boolean newVal) {
        ThreadingUtil.runOnGUI(() -> this.panelC.setIntervetionSymbol(newVal));
    }

    public void setReversingPermittedSymbol(boolean newVal) {
        ThreadingUtil.runOnGUI(() -> this.panelC.setReversingPermittedSymbol(newVal));
    }

    public void setIndicationMarker(int distance, int whichSpeedChange) {
        ThreadingUtil.runOnGUI(() -> this.panelD.setIndicationMarkerLine(distance, whichSpeedChange));
    }

    protected void setAtoMode(int mode) {
        ThreadingUtil.runOnGUI(() -> this.panelG.setAtoMode(mode));
    }

    public void setCoasting(boolean visible) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setCoasting(visible));
    }

    public void setStoppingAccuracy(int acc) {
        ThreadingUtil.runOnGUI(() -> this.panelG.setStoppingAccuracy(acc));
    }

    public void setStoppingPointLabel(String station, String eta) {
        ThreadingUtil.runOnGUI(() -> this.panelG.setStoppingPointLabel(station, eta));
    }

    public void setDwellTime(int mins, int secs) {
        ThreadingUtil.runOnGUI(() -> this.panelG.setDwellTime(mins, secs));
    }

    public void setDoorIcon(int mode) {
        ThreadingUtil.runOnGUI(() -> this.panelG.setDoorIcon(mode));
    }

    public void setSkipStoppingPoint(int mode) {
        ThreadingUtil.runOnGUI(() -> this.panelG.setSkipStoppingPoint(mode));
    }

    public void setSupervisedDirection(int newDirection) {
        ThreadingUtil.runOnGUI(() -> this.panelB.setSupervisedDirection(newDirection));
    }

    public void setTunnelStoppingDistance(int distance) {
        ThreadingUtil.runOnGUI(() -> this.panelC.setTunnelStoppingDistance(distance));
    }

    public void setTunnelStoppingIconVisible(boolean visible, boolean ack) {
        ThreadingUtil.runOnGUI(() -> this.panelC.setTunnelStoppingIconVisible(visible, ack));
    }

    public void setSafeRadioConnection(int newVal) {
        ThreadingUtil.runOnGUI(() -> this.panelE.setSafeRadioConnection(newVal));
    }

    public void setTrackAheadFreeQuestionVisible(boolean newVal) {
        ThreadingUtil.runOnGUI(() -> this.panelD.setTrackAheadFreeQuestionVisible(newVal));
    }

    public void setScale(int scale) {
        ThreadingUtil.runOnGUI(() -> this.panelD.setScale(scale));
    }

    public void resetMovementAuthorities(@Nonnull List<MovementAuthority> a) {
        ThreadingUtil.runOnGUI(() -> this.panelD.resetMovementAuthorities(a));
    }

    public List<MovementAuthority> getMovementAuthorities() {
        return this.panelD.getMovementAuthorities();
    }

    public void extendMovementAuthorities(@Nonnull MovementAuthority dma) {
        ThreadingUtil.runOnGUI(() -> this.panelD.extendMovementAuthorities(dma));
    }

    @CheckForNull
    public TrackCondition getNextAnnouncement(boolean mustBeStation) {
        List<MovementAuthority> mas = this.panelD.getMovementAuthorities();
        for (MovementAuthority ma : mas) {
            List<TrackSection> tsList = ma.getTrackSections();
            for (TrackSection ts : tsList) {
                List<TrackCondition> anList = ts.getAnnouncements();
                for (TrackCondition tc : anList) {
                    if (mustBeStation && !(tc instanceof StationTrackCondition)) continue;
                    return tc;
                }
            }
        }
        return null;
    }

    public void advance(int distance) {
        ThreadingUtil.runOnGUI(() -> {
            this.panelD.advance(distance);
            this.panelA.advance(distance);
        });
    }

    public void messageDriver(CabMessage msg) {
        ThreadingUtil.runOnGUI(() -> this.panelE.addMessage(msg));
    }

    public void removeMessage(String messageId) {
        ThreadingUtil.runOnGUI(() -> this.panelE.removeMessage(messageId));
    }

    public void playDmiSound(int sound) throws IllegalArgumentException {
        ResourceUtil.playDmiSound(sound);
    }

    public void stopDmiSound(int sound) {
        ResourceUtil.stopDmiSound(sound);
    }

    protected void addFlashListener(PropertyChangeListener pcl, boolean fast) {
        this.flashTimer.addFlashListener(pcl, fast);
    }

    protected void removeFlashListener(PropertyChangeListener pcl, boolean fast) {
        this.flashTimer.removeFlashListener(pcl, fast);
    }

    protected void firePropertyChange(String property, String newVal) {
        this.firePropertyChange(property, "", newVal);
    }

    @Override
    public void setVisible(boolean newVal) {
        ThreadingUtil.runOnGUI(() -> super.setVisible(newVal));
    }

    public void dispose() {
        this.panelG.dispose();
        this.panelC.dispose();
        this.flashTimer.dispose();
    }
}

