/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.dmi.swing.Bundle;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmiPanelA
extends JPanel {
    private final JLabel a2Label;
    private final JLabel a4Label;
    private String speedString = "";
    private int distanceToTarget = -10;
    private static final BufferedImage supervisionImage = ResourceUtil.readFile(ResourceUtil.getImageFile("LS_01.bmp"));
    private static final ImageIcon adhesionIcon = ResourceUtil.getImageIcon("ST_02.bmp");
    private static final double LINEAR_SCALE_MAX_DISTANCE = 100.0;
    private static final double LOG_SCALE_MIN_DISTANCE = 100.0;
    private static final double LOG_SCALE_MAX_DISTANCE = 1000.0;
    private static final int TOTAL_PIXELS = 188;
    private static final int FIRST_100M_PIXELS = 33;
    private static final int LOG_SCALE_WIDTH_PIXELS = 155;
    private static final Logger log = LoggerFactory.getLogger(DmiPanelA.class);

    public DmiPanelA(@Nonnull DmiPanel mainPanel) {
        this.setLayout(null);
        this.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.setBounds(0, 15, 54, 300);
        JPanel a1 = this.getSupervisionImagePanel();
        this.a2Label = new JLabel();
        JPanel a3 = this.getDistanceToTargetBarPanel();
        JPanel a4 = new JPanel();
        a1.setBounds(0, 0, 54, 54);
        this.a2Label.setBounds(0, 54, 54, 30);
        a3.setBounds(0, 84, 54, 191);
        a4.setBounds(0, 275, 54, 25);
        a1.setLayout(null);
        a1.setOpaque(true);
        this.a2Label.setForeground(DmiPanel.GREY);
        this.a2Label.setFont(new Font("Helvetica", 0, 14));
        this.a2Label.setHorizontalAlignment(4);
        this.a4Label = new JLabel();
        a4.add(this.a4Label);
        this.setBg(a3);
        this.setBg(a4);
        this.add(a1);
        this.add(this.a2Label);
        this.add(a3);
        this.add(a4);
        this.setAdhesionFactorOn(false);
        this.setLimitedSupervisionSpeed(-1.0f);
    }

    private JPanel getDistanceToTargetBarPanel() {
        return new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (DmiPanelA.this.distanceToTarget < 0) {
                    return;
                }
                if (!(g instanceof Graphics2D)) {
                    throw new IllegalArgumentException("Graphics object passed is not the correct type");
                }
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHints(hints);
                g2.setColor(DmiPanel.GREY);
                DmiPanelA.this.drawScale(g2);
                int rectHeight = (int)DmiPanelA.calculatePositionOnScale(DmiPanelA.this.distanceToTarget);
                g2.fillRect(29, 188 - rectHeight, 10, rectHeight);
            }
        };
    }

    private static double calculatePositionOnScale(double lengthInMeters) {
        double position;
        if (lengthInMeters <= 100.0) {
            position = lengthInMeters / 100.0 * 33.0;
        } else {
            double logScaleFactor = 155.0 / (Math.log(1000.0) - Math.log(100.0));
            position = 33.0 + (Math.log(lengthInMeters) - Math.log(100.0)) * logScaleFactor;
        }
        log.debug("at distance {} px: {}", (Object)lengthInMeters, (Object)position);
        return position;
    }

    private void drawScale(Graphics2D g2) {
        g2.drawLine(12, 1, 25, 1);
        g2.drawLine(12, 2, 25, 2);
        g2.drawLine(16, 8, 25, 8);
        g2.drawLine(16, 15, 25, 15);
        g2.drawLine(16, 24, 25, 24);
        g2.drawLine(16, 34, 25, 34);
        g2.drawLine(12, 47, 25, 47);
        g2.drawLine(12, 48, 25, 48);
        g2.drawLine(16, 61, 25, 61);
        g2.drawLine(16, 81, 25, 81);
        g2.drawLine(16, 107, 25, 107);
        g2.drawLine(16, 154, 25, 154);
        g2.drawLine(12, 187, 25, 187);
        g2.drawLine(12, 188, 25, 188);
    }

    private JPanel getSupervisionImagePanel() {
        return new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (DmiPanelA.this.speedString.isEmpty()) {
                    return;
                }
                if (!(g instanceof Graphics2D)) {
                    throw new IllegalArgumentException("Graphics object passed is not the correct type");
                }
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHints(hints);
                Font font = new Font("Helvetica", 0, 18);
                g2.setFont(font);
                g2.setColor(DmiPanel.GREY);
                FontMetrics fm = g2.getFontMetrics();
                int textWidth = fm.stringWidth(DmiPanelA.this.speedString);
                int centerX = (this.getWidth() - textWidth) / 2;
                g2.drawImage(supervisionImage, 2, 2, 50, 50, this);
                g2.drawString(DmiPanelA.this.speedString, centerX, 33);
            }
        };
    }

    protected void setLimitedSupervisionSpeed(float spd) {
        this.speedString = spd < 0.0f ? "" : String.valueOf(Math.round(spd));
        this.repaint();
    }

    protected void setAdhesionFactorOn(boolean newVal) {
        this.a4Label.setIcon(newVal ? adhesionIcon : null);
        this.a4Label.setToolTipText(newVal ? Bundle.getMessage("AdhesionFactorOn") : null);
    }

    protected void setDistanceToTarget(float distance) {
        this.distanceToTarget = Math.round(distance);
        this.a2Label.setVisible(this.distanceToTarget >= 0);
        int nearestTen = (this.distanceToTarget + 5) / 10 * 10;
        this.a2Label.setText(String.valueOf(nearestTen));
        this.repaint();
    }

    private void setBg(JPanel p) {
        p.setBackground(DmiPanel.BACKGROUND_COLOUR);
        p.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    protected void advance(int distance) {
        this.setDistanceToTarget(this.distanceToTarget - distance);
    }
}

