/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.TrackCondition;
import jmri.jmrit.etcs.dmi.swing.Bundle;
import jmri.jmrit.etcs.dmi.swing.DmiCircularSpeedGuideSection;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import jmri.jmrit.etcs.dmi.swing.DmiSpeedoDialPanel;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class DmiPanelB
extends JPanel {
    private final JLabel b6Label;
    private final JLabel b7Label;
    private final JLabel b8Label;
    private final DmiSpeedoDialPanel p;
    private final UnderDialButton b3;
    private final UnderDialButton b4;
    private final UnderDialButton b5;
    private final List<TrackCondition> requireAllocationOrderAccouncements;
    private final List<UnderDialButton> underDialButtonList;
    private static final Logger log = LoggerFactory.getLogger(DmiPanelB.class);

    public DmiPanelB(@Nonnull DmiPanel main) {
        this.setLayout(null);
        this.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.setBounds(54, 15, 280, 300);
        this.setOpaque(true);
        this.p = new DmiSpeedoDialPanel();
        this.requireAllocationOrderAccouncements = new ArrayList<TrackCondition>();
        this.underDialButtonList = new ArrayList<UnderDialButton>();
        this.b3 = new UnderDialButton(main);
        this.b4 = new UnderDialButton(main);
        this.b5 = new UnderDialButton(main);
        this.underDialButtonList.add(this.b3);
        this.underDialButtonList.add(this.b4);
        this.underDialButtonList.add(this.b5);
        JPanel b6 = new JPanel();
        JPanel b7 = new JPanel();
        JPanel b8 = new JPanel();
        this.p.setBounds(0, 0, 280, 300);
        this.b3.setBounds(86, 256, 36, 36);
        this.b4.setBounds(122, 256, 36, 36);
        this.b5.setBounds(158, 256, 36, 36);
        b6.setBounds(10, 256, 36, 36);
        b7.setBounds(236, 256, 36, 36);
        b8.setBounds(122, 198, 36, 36);
        this.setBg(b6);
        this.setBg(b7);
        this.setBg(b8);
        b6.setToolTipText("Release Speed");
        this.b6Label = new JLabel();
        this.b6Label.setForeground(DmiPanel.MEDIUM_GREY);
        this.b6Label.setFont(new Font("Helvetica", 1, 22));
        this.b6Label.setBounds(0, 0, 36, 36);
        this.b6Label.setVerticalAlignment(0);
        b6.add(this.b6Label);
        this.b7Label = new JLabel();
        b7.add(this.b7Label);
        this.add(this.p);
        this.add(this.b3);
        this.add(this.b4);
        this.add(this.b5);
        this.add(b6);
        this.add(b7);
        this.b8Label = new JLabel();
        b8.add(this.b8Label);
        this.add(b8);
        this.setMode(13);
    }

    protected void addAnnouncement(TrackCondition tc) {
        log.debug("adding announcement {}", (Object)tc);
        this.requireAllocationOrderAccouncements.add(tc);
        this.updateDisplayOrderAccouncements();
    }

    protected void removeAnnouncement(TrackCondition tc) {
        log.debug("b4 remove {}", (Object)this.requireAllocationOrderAccouncements.size());
        this.requireAllocationOrderAccouncements.remove(tc);
        this.removeFromButton(tc);
        this.updateDisplayOrderAccouncements();
        log.debug("after remove {}", (Object)this.requireAllocationOrderAccouncements.size());
    }

    private void removeFromButton(TrackCondition tc) {
        this.underDialButtonList.forEach(udb -> {
            if (tc.equals(udb.getTrackCondition())) {
                log.debug("removing track condition {}", (Object)tc);
                udb.setTrackCondition(null);
            }
        });
    }

    private void updateDisplayOrderAccouncements() {
        if (!this.requireAllocationOrderAccouncements.isEmpty()) {
            for (UnderDialButton udb : this.underDialButtonList) {
                log.debug("updateDisplayOrderAccouncements for {}", (Object)udb.getTrackCondition());
                if (udb.getTrackCondition() != null) continue;
                log.debug("setting tc to {}", (Object)this.requireAllocationOrderAccouncements.get(0));
                udb.setTrackCondition(this.requireAllocationOrderAccouncements.remove(0));
                return;
            }
        }
    }

    private void setBg(JPanel p) {
        p.setBackground(DmiPanel.BACKGROUND_COLOUR);
        p.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    protected void setMaxDialSpeed(int speed) {
        this.p.setMaxDialSpeed(speed);
    }

    protected void setCentreCircleAndDialColor(Color color) {
        this.p.setCentreCircleAndDialColor(color);
    }

    protected void setActualSpeed(float speed) {
        this.p.update(speed);
    }

    protected void setTargetAdviceSpeed(int newVal) {
        this.p.setTargetAdviceSpeed(newVal);
    }

    protected void setCsgSections(List<DmiCircularSpeedGuideSection> list) {
        this.p.setCsgSections(list);
    }

    protected void setDisplaySpeedUnit(String newVal) {
        this.p.setDisplaySpeedUnit(newVal);
    }

    protected void setReleaseSpeed(int spd) {
        this.b6Label.setText(spd < 0 ? "" : String.valueOf(spd));
    }

    protected void setReleaseSpeedColour(Color newColour) {
        this.b6Label.setForeground(newColour);
    }

    protected void setMode(int newMode) {
        this.b7Label.setVisible(newMode != 0);
        this.setCoasting(false);
        this.setSupervisedDirection(0);
        switch (newMode) {
            case 0: {
                break;
            }
            case 1: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_01.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("Shunting"));
                break;
            }
            case 4: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_04.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("Trip"));
                break;
            }
            case 6: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_06.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("PostTrip"));
                break;
            }
            case 7: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_07.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("OnSight"));
                break;
            }
            case 9: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_09.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("StaffResponsible"));
                break;
            }
            case 11: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_11.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("FullSupervision"));
                break;
            }
            case 12: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_12.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("NonLeading"));
                break;
            }
            case 13: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_13.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("StandBy"));
                break;
            }
            case 14: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_14.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("Reversing"));
                break;
            }
            case 16: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_16.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("Unfitted"));
                break;
            }
            case 18: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_18.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("SystemFailure"));
                break;
            }
            case 21: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_21.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("LimitedSupervision"));
                break;
            }
            case 23: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_23.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("AutomaticDriving"));
                break;
            }
            case 24: {
                this.b7Label.setIcon(ResourceUtil.getImageIcon("MO_24.bmp"));
                this.b7Label.setToolTipText(Bundle.getMessage("SupervisedManoeuvre"));
                break;
            }
            default: {
                log.error("Could not set Mode {}", (Object)newMode);
            }
        }
    }

    protected void setCoasting(boolean visible) {
        this.b8Label.setVisible(visible);
        if (visible) {
            this.b8Label.setIcon(ResourceUtil.getImageIcon("ATO_20.bmp"));
            this.b8Label.setToolTipText(Bundle.getMessage("Coasting"));
        } else {
            this.b8Label.setIcon(null);
            this.b8Label.setToolTipText(null);
        }
        this.b8Label.repaint();
    }

    protected void setSupervisedDirection(int newDirection) {
        switch (newDirection) {
            case -1: {
                this.b8Label.setIcon(ResourceUtil.getImageIcon("SM02.bmp"));
                this.b8Label.setToolTipText(Bundle.getMessage("Reverse"));
                break;
            }
            case 1: {
                this.b8Label.setIcon(ResourceUtil.getImageIcon("SM01.bmp"));
                this.b8Label.setToolTipText(Bundle.getMessage("Forward"));
                break;
            }
            default: {
                this.b8Label.setIcon(null);
                this.b8Label.setToolTipText(null);
            }
        }
        this.b8Label.setVisible(newDirection != 0);
    }

    private static class UnderDialButton
    extends JButton {
        private final transient PropertyChangeListener pcl = evt -> this.changeBorder();
        private boolean nextFlashState = true;
        private final DmiPanel mainPanel;
        private TrackCondition tc = null;

        UnderDialButton(DmiPanel main) {
            this.mainPanel = main;
            this.setBorder(DmiPanel.BORDER_NORMAL);
            this.setFocusable(false);
            this.setBackground(DmiPanel.BACKGROUND_COLOUR);
            this.addActionListener(this::buttonClicked);
        }

        void buttonClicked(ActionEvent e) {
            this.setEnabled(false);
            this.mainPanel.removeFlashListener(this.pcl, false);
            log.debug("button clicked: {}", (Object)e.getActionCommand());
            this.mainPanel.firePropertyChange(e.getActionCommand(), false, true);
            this.setBorder(DmiPanel.BORDER_NORMAL);
        }

        void setTrackCondition(@CheckForNull TrackCondition newTc) {
            log.debug("button set track condition to {}", (Object)this.tc);
            this.tc = newTc;
            this.setEnabled(this.tc != null && this.tc.getIsOrder());
            this.resetImage();
            this.setActionCommand(newTc == null ? "" : newTc.getAckString());
            log.debug("set {} actionCommand to {}", (Object)this.tc, (Object)this.getActionCommand());
        }

        void resetImage() {
            if (this.tc == null) {
                this.setIcon(null);
                this.setBorder(DmiPanel.BORDER_NORMAL);
                this.mainPanel.removeFlashListener(this.pcl, false);
            } else {
                this.setIcon(this.tc.getLargeIcon(this.isEnabled()));
                if (this.isEnabled()) {
                    this.mainPanel.addFlashListener(this.pcl, false);
                    this.nextFlashState = true;
                    this.changeBorder();
                }
            }
            this.repaint();
        }

        TrackCondition getTrackCondition() {
            return this.tc;
        }

        private void changeBorder() {
            this.setBorder(this.nextFlashState ? DmiPanel.BORDER_ACK : DmiPanel.BORDER_NORMAL);
            this.nextFlashState = !this.nextFlashState;
        }
    }
}

