/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmiPanelC
extends JPanel {
    private final JButton c1Button;
    private final JButton c2Button;
    private final JLabel c3Label;
    private final JPanel c1Panel;
    private final JLabel c6Label;
    private final JLabel c8Label;
    private final JLabel c9Label;
    private final DmiPanel mainPanel;
    private final transient PropertyChangeListener pclC1 = evt -> this.changeC1Border();
    private final transient PropertyChangeListener pclC2 = evt -> this.changeC2Border();
    private boolean nextc1FlashState = true;
    private boolean nextc2FlashState = true;
    private static final Logger log = LoggerFactory.getLogger(DmiPanelC.class);

    public DmiPanelC(@Nonnull DmiPanel panel) {
        this.setLayout(null);
        this.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.setBounds(0, 315, 334, 50);
        this.mainPanel = panel;
        this.c1Panel = new JPanel();
        this.c1Panel.setLayout(new GridLayout(1, 1));
        JPanel c2Panel = new JPanel();
        JPanel c3Panel = new JPanel();
        JPanel c4Panel = new JPanel();
        JPanel c5Panel = new JPanel();
        JPanel c6Panel = new JPanel();
        JPanel c7Panel = new JPanel();
        JPanel c8Panel = new JPanel();
        JPanel c9Panel = new JPanel();
        c8Panel.setBounds(0, 0, 54, 25);
        c9Panel.setBounds(0, 25, 54, 25);
        c2Panel.setBounds(54, 0, 37, 50);
        c3Panel.setBounds(91, 0, 37, 50);
        c4Panel.setBounds(128, 0, 37, 50);
        this.c1Panel.setBounds(165, 0, 58, 50);
        c5Panel.setBounds(223, 0, 37, 50);
        c6Panel.setBounds(260, 0, 37, 50);
        c7Panel.setBounds(297, 0, 37, 50);
        this.c6Label = new JLabel();
        this.c8Label = new JLabel();
        this.c9Label = new JLabel();
        c6Panel.add(this.c6Label);
        c8Panel.add(this.c8Label);
        c9Panel.add(this.c9Label);
        this.setBg(this.c1Panel);
        this.setBg(c2Panel);
        this.setBg(c3Panel);
        this.setBg(c4Panel);
        this.setBg(c5Panel);
        this.setBg(c6Panel);
        this.setBg(c7Panel);
        this.setBg(c8Panel);
        this.setBg(c9Panel);
        this.c1Panel.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.c1Button = new JButton();
        this.c1Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.c1Button.setFocusable(false);
        this.c1Button.setVisible(false);
        this.c1Button.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.c1Button.setContentAreaFilled(false);
        this.c1Button.addActionListener(this::acknowledgeLevelPressed);
        this.c1Button.setName("levelTransitionNotificationButton");
        this.c2Button = new JButton();
        this.c2Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.c2Button.setFocusable(false);
        this.c2Button.setVisible(false);
        this.c2Button.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.c2Button.setContentAreaFilled(false);
        this.c2Button.addActionListener(this::acknowledgeTunnelStopPressed);
        this.c2Button.setName("TunnelStopNotificationButton");
        this.c2Button.setIcon(ResourceUtil.getImageIcon("TC_37.bmp"));
        this.c2Button.setDisabledIcon(ResourceUtil.getImageIcon("TC_36.bmp"));
        this.c3Label = new JLabel();
        this.c3Label.setBounds(91, 0, 74, 50);
        this.c3Label.setForeground(DmiPanel.GREY);
        this.c3Label.setVerticalAlignment(0);
        this.c3Label.setHorizontalAlignment(0);
        this.c3Label.setFont(new Font("Helvetica", 1, 18));
        this.add(this.c3Label);
        this.c1Panel.add(this.c1Button);
        c2Panel.add(this.c2Button);
        this.add(c8Panel);
        this.add(c9Panel);
        this.add(c2Panel);
        this.add(c3Panel);
        this.add(c4Panel);
        this.add(this.c1Panel);
        this.add(c5Panel);
        this.add(c6Panel);
        this.add(c7Panel);
        this.setLevel(-2);
        this.setTunnelStoppingDistance(0);
        this.setLevelTransition(-2, false);
    }

    protected void setLevelTransition(int newLevel, boolean ackRequired) {
        this.mainPanel.removeFlashListener(this.pclC1, false);
        this.c1Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.setC1LevelTransitionIcon(newLevel, ackRequired);
        if (ackRequired) {
            this.startC1Flash();
        }
    }

    protected void setModeAcknowledge(int newMode) {
        this.c1Button.setVisible(newMode != 0);
        this.mainPanel.removeFlashListener(this.pclC1, false);
        if (newMode == 0) {
            return;
        }
        this.startC1Flash();
        this.c1Button.setEnabled(true);
        this.c1Button.setIcon(DmiPanelC.getC1ModeAcknowledgeIcon(newMode));
        this.c1Button.setSelectedIcon(DmiPanelC.getC1ModeAcknowledgeIcon(newMode));
        this.c1Button.setActionCommand(this.getC1ActionEventText(newMode));
    }

    private static Icon getC1ModeAcknowledgeIcon(int newMode) {
        switch (newMode) {
            case 1: {
                return ResourceUtil.getImageIcon("MO_02.bmp");
            }
            case 4: {
                return ResourceUtil.getImageIcon("MO_05.bmp");
            }
            case 7: {
                return ResourceUtil.getImageIcon("MO_08.bmp");
            }
            case 9: {
                return ResourceUtil.getImageIcon("MO_10.bmp");
            }
            case 14: {
                return ResourceUtil.getImageIcon("MO_15.bmp");
            }
            case 16: {
                return ResourceUtil.getImageIcon("MO_17.bmp");
            }
            case 20: {
                return ResourceUtil.getImageIcon("MO_20.bmp");
            }
            case 21: {
                return ResourceUtil.getImageIcon("MO_22.bmp");
            }
        }
        log.warn("No Icon for C1 SetLevel with Confirmation {}", (Object)newMode);
        return null;
    }

    private String getC1ActionEventText(int mode) {
        switch (mode) {
            case 1: {
                return "ModeShuntingAcknowledged";
            }
            case 4: {
                return "ModeTripAcknowledged";
            }
            case 7: {
                return "ModeOnSightAcknowledged";
            }
            case 9: {
                return "ModeStaffResponsibleAcknowledged";
            }
            case 14: {
                return "ModeReversingAcknowledged";
            }
            case 16: {
                return "ModeUnfittedAcknowledged";
            }
            case 20: {
                return "ModeNationalSystemAcknowledged";
            }
            case 21: {
                return "ModeLimitedSupervisionAcknowledged";
            }
        }
        log.warn("No ActionText for C1 SetLevel with Confirmation {}", (Object)mode);
        return null;
    }

    private void startC1Flash() {
        this.nextc1FlashState = true;
        this.changeC1Border();
        this.mainPanel.addFlashListener(this.pclC1, false);
    }

    private void setC1LevelTransitionIcon(int newLevel, boolean ackRequired) {
        if (ackRequired) {
            switch (newLevel) {
                case -1: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_09.bmp"));
                    this.c1Button.setActionCommand("LevelNTCAcknowledged");
                    break;
                }
                case 0: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_07.bmp"));
                    this.c1Button.setActionCommand("Level0Acknowledged");
                    break;
                }
                case 1: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_11.bmp"));
                    this.c1Button.setActionCommand("Level1Acknowledged");
                    break;
                }
                case 2: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_13.bmp"));
                    this.c1Button.setActionCommand("Level2Acknowledged");
                    break;
                }
                case 3: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_15.bmp"));
                    this.c1Button.setActionCommand("Level3Acknowledged");
                    break;
                }
                default: {
                    this.c1Button.setIcon(null);
                    break;
                }
            }
        } else {
            switch (newLevel) {
                case -1: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_08.bmp"));
                    this.c1Button.setDisabledIcon(ResourceUtil.getImageIcon("LE_08.bmp"));
                    break;
                }
                case 0: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_06.bmp"));
                    this.c1Button.setDisabledIcon(ResourceUtil.getImageIcon("LE_06.bmp"));
                    break;
                }
                case 1: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_10.bmp"));
                    this.c1Button.setDisabledIcon(ResourceUtil.getImageIcon("LE_10.bmp"));
                    break;
                }
                case 2: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_12.bmp"));
                    this.c1Button.setDisabledIcon(ResourceUtil.getImageIcon("LE_12.bmp"));
                    break;
                }
                case 3: {
                    this.c1Button.setIcon(ResourceUtil.getImageIcon("LE_14.bmp"));
                    this.c1Button.setDisabledIcon(ResourceUtil.getImageIcon("LE_14.bmp"));
                    break;
                }
                default: {
                    this.c1Button.setIcon(null);
                    this.c1Button.setDisabledIcon(null);
                }
            }
        }
        this.c1Button.setEnabled(ackRequired);
        this.c1Button.setVisible(newLevel > -2);
    }

    protected void setTunnelStoppingIconVisible(boolean visible, boolean ackReqd) {
        this.c2Button.setEnabled(ackReqd);
        this.c2Button.setBorder(ackReqd ? DmiPanel.BORDER_ACK : DmiPanel.BORDER_NORMAL);
        this.c2Button.setVisible(visible);
        if (visible && ackReqd) {
            this.mainPanel.addFlashListener(this.pclC2, false);
        } else {
            this.mainPanel.removeFlashListener(this.pclC2, false);
        }
    }

    protected void setTunnelStoppingDistance(int distance) {
        this.c3Label.setVisible(distance > 0);
        this.c3Label.setText(String.valueOf(distance));
    }

    private void setBg(JComponent p) {
        p.setBackground(DmiPanel.BACKGROUND_COLOUR);
        p.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    protected void setC8Label(Icon ico) {
        this.c8Label.setIcon(ico);
    }

    protected void setLevel(int level) {
        switch (level) {
            case -1: {
                this.setC8Label(ResourceUtil.getImageIcon("LE_02.bmp"));
                break;
            }
            case 0: {
                this.setC8Label(ResourceUtil.getImageIcon("LE_01.bmp"));
                break;
            }
            case 1: {
                this.setC8Label(ResourceUtil.getImageIcon("LE_03.bmp"));
                break;
            }
            case 2: {
                this.setC8Label(ResourceUtil.getImageIcon("LE_04.bmp"));
                break;
            }
            case 3: {
                this.setC8Label(ResourceUtil.getImageIcon("LE_05.bmp"));
                break;
            }
            default: {
                this.setC8Label(null);
            }
        }
    }

    protected void setIntervetionSymbol(boolean newVal) {
        this.c9Label.setIcon(newVal ? ResourceUtil.getImageIcon("ST_01.bmp") : null);
    }

    protected void setReversingPermittedSymbol(boolean newVal) {
        this.c6Label.setIcon(newVal ? ResourceUtil.getImageIcon("ST_06.bmp") : null);
    }

    private void changeC1Border() {
        this.c1Button.setBorder(this.nextc1FlashState ? DmiPanel.BORDER_ACK : DmiPanel.BORDER_NORMAL);
        this.nextc1FlashState = !this.nextc1FlashState;
    }

    private void changeC2Border() {
        this.c2Button.setBorder(this.nextc2FlashState ? DmiPanel.BORDER_ACK : DmiPanel.BORDER_NORMAL);
        this.nextc2FlashState = !this.nextc2FlashState;
    }

    private void acknowledgeLevelPressed(ActionEvent e) {
        log.debug("confirmation of level change {}", (Object)e);
        this.mainPanel.removeFlashListener(this.pclC1, false);
        this.nextc1FlashState = true;
        this.c1Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.setModeAcknowledge(0);
        if (e.getActionCommand().startsWith("Level")) {
            int newLevel = StringUtil.getFirstIntFromString(e.getActionCommand());
            this.setC1LevelTransitionIcon(newLevel, false);
        }
        this.mainPanel.firePropertyChange(e.getActionCommand(), false, true);
    }

    private void acknowledgeTunnelStopPressed(ActionEvent e) {
        log.debug("confirmation of tunnel stopping area pressed {}", (Object)e);
        this.mainPanel.removeFlashListener(this.pclC2, false);
        this.c2Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.nextc1FlashState = true;
        this.c2Button.setEnabled(false);
        this.mainPanel.firePropertyChange("TunnelStopAreaAcknowledged", false, true);
    }

    protected void dispose() {
        this.mainPanel.removeFlashListener(this.pclC1, false);
        this.mainPanel.removeFlashListener(this.pclC2, false);
    }
}

