/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.etcs.MovementAuthority;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.TrackCondition;
import jmri.jmrit.etcs.TrackSection;
import jmri.jmrit.etcs.dmi.swing.Bundle;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmiPanelD
extends JPanel {
    private static final Color PASP_DARK = new Color(33, 49, 74);
    private static final Color PASP_LIGHT = new Color(41, 74, 107);
    private final DmiPanel dmiPanel;
    private final JPanel trackAheadFreeQuestion;
    private final JPanel planningPanel;
    private final JButton plusButton;
    private final JButton minusButton;
    private static final int[] scaleLineYPx = new int[]{284, 283, 250, 206, 182, 164, 150, 149, 107, 64, 21, 20};
    private static final boolean[] scaleLineLight = new boolean[]{true, true, false, false, false, false, true, true, false, false, true, true};
    private static final int[] scaleDistanceBase = new int[]{0, 125, 250, 500, 1000};
    private static final int[] scaleycords = new int[]{287, 155, 111, 68, 25};
    private static final int[] scales = new int[]{1, 2, 4, 8, 16, 32};
    private final List<MovementAuthority> maList = new ArrayList<MovementAuthority>();
    private boolean loopGradientLimitReached = false;
    private int nextAdviceChange = -1;
    private int indicationDistance = -1;
    private int indicationSpeedChange = -1;
    private static final BufferedImage speedDownImage = ResourceUtil.getTransparentImage("PL_22.bmp");
    private static final BufferedImage speedDownImageTargetIndication = ResourceUtil.getTransparentImage("PL_23.bmp");
    private static final BufferedImage speedDownImageTargetIndicationAto = ResourceUtil.getTransparentImage("PL_37.bmp");
    private static final BufferedImage speedUpImage = ResourceUtil.getTransparentImage("PL_21.bmp");
    private int currentScale = 0;
    private static final Logger log = LoggerFactory.getLogger(DmiPanelD.class);

    public DmiPanelD(@Nonnull DmiPanel mainPanel) {
        this.setLayout(null);
        this.dmiPanel = mainPanel;
        this.trackAheadFreeQuestion = this.trackAheadFreeQuestionPanel();
        this.plusButton = new TransparentButton(true);
        this.minusButton = new TransparentButton(false);
        this.setButtonsToState();
        this.planningPanel = this.getPlanningPanel();
        this.planningPanel.setLayout(null);
        this.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.setBounds(334, 15, 246, 300);
        this.add(this.trackAheadFreeQuestion);
        this.add(this.planningPanel);
        this.setTrackAheadFreeQuestionVisible(false);
    }

    private JPanel getPlanningPanel() {
        JPanel p = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (DmiPanelD.this.trackAheadFreeQuestion.isVisible() || DmiPanelD.this.maList.isEmpty()) {
                    DmiPanelD.this.plusButton.setVisible(false);
                    DmiPanelD.this.minusButton.setVisible(false);
                    return;
                }
                if (!(g instanceof Graphics2D)) {
                    throw new IllegalArgumentException("Graphics object passed is not the correct type");
                }
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHints(hints);
                DmiPanelD.this.drawBackground(g2);
                DmiPanelD.this.drawScale(g2);
                DmiPanelD.this.loopGradientLimitReached = false;
                DmiPanelD.this.drawGradientBar(g2);
                DmiPanelD.this.drawSpeedChanges(g2);
                DmiPanelD.this.drawAnnouncementsAndOrders(g2);
                DmiPanelD.this.drawNextAdviceChange(g2);
                DmiPanelD.this.drawIndicationMarkerLine(g2);
            }
        };
        p.setLayout(null);
        p.setBounds(0, 0, 246, 300);
        p.setOpaque(false);
        p.add(this.plusButton);
        p.add(this.minusButton);
        return p;
    }

    private void drawAnnouncementsAndOrders(Graphics2D g2) {
        int metresInPreviousSections = 0;
        int nextColumn = 2;
        Comparator<TrackCondition> lengthComparator = Comparator.comparingInt(TrackCondition::getDistanceFromStart);
        for (MovementAuthority ma : this.maList) {
            for (TrackSection section : ma.getTrackSections()) {
                List<TrackCondition> l = section.getAnnouncements();
                Collections.sort(l, lengthComparator);
                for (TrackCondition da : l) {
                    log.debug("found trackCondition {}", (Object)da);
                    int distance = metresInPreviousSections + da.getDistanceFromStart();
                    if (!((double)distance <= (double)(scaleDistanceBase[4] * scales[this.currentScale]) * 1.5)) continue;
                    nextColumn = DmiPanelD.ensureSlotNumber(da, nextColumn);
                    int startPx = this.calculatePositionOnScale(distance);
                    log.debug("marker dist:{} px:{}", (Object)distance, (Object)startPx);
                    log.debug("drawing image {} at x:{} y:{} ", new Object[]{da.getSmlImage(), DmiPanelD.getAnnouncementColumnPx(da.getColumnNum()), 265 - startPx});
                    g2.drawImage((Image)da.getSmlImage(), DmiPanelD.getAnnouncementColumnPx(da.getColumnNum()), 265 - startPx, this);
                }
                metresInPreviousSections += section.getLength();
            }
        }
    }

    private static int getAnnouncementColumnPx(int column) {
        switch (column) {
            case 1: {
                return 42;
            }
            case 2: {
                return 67;
            }
            case 3: {
                return 92;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int ensureSlotNumber(TrackCondition da, int nextColumn) {
        int tempCol = nextColumn;
        if (da.getColumnNum() == 0) {
            da.setColumnNum(tempCol);
        } else {
            tempCol = da.getColumnNum();
        }
        if (++tempCol == 4) {
            tempCol = 1;
        }
        return tempCol;
    }

    private void drawSpeedChanges(Graphics2D g2) {
        List<TrackSection> speedChangeList = MovementAuthority.getTrackSectionList(this.maList, true);
        speedChangeList.forEach(ts -> log.debug("track section speed {} length {}", (Object)ts.getSpeed(), (Object)ts.getLength()));
        Font unitsSizedFont = new Font("Helvetica", 0, 14);
        g2.setFont(unitsSizedFont);
        g2.setColor(DmiPanel.GREY);
        int loopMetres = 0;
        int stopPx = 0;
        boolean increaseDisplayed = false;
        int reductionsDisplayed = 0;
        for (int i = 0; i < speedChangeList.size(); ++i) {
            int startPx = this.calculatePositionOnScale(loopMetres);
            stopPx = this.calculatePositionOnScale(loopMetres += speedChangeList.get(i).getLength());
            if (i == 0) continue;
            int speed = speedChangeList.get(i).getSpeed();
            int change = speed - speedChangeList.get(i - 1).getSpeed();
            if (change < 0) {
                g2.setColor(this.getIndicationColor(i));
                if (increaseDisplayed || reductionsDisplayed >= 4) continue;
                g2.drawImage((Image)this.getIndicationImg(i), 136, 280 - startPx, this);
                g2.drawString(String.valueOf(speed), 155, 295 - startPx);
                ++reductionsDisplayed;
                continue;
            }
            g2.setColor(DmiPanel.GREY);
            g2.drawImage((Image)speedUpImage, 136, 266 - startPx, this);
            g2.drawString(String.valueOf(speed), 155, 281 - startPx);
        }
        g2.setColor(this.getIndicationColor(0));
        g2.drawImage((Image)this.getIndicationImg(0), 136, 281 - stopPx, this);
        g2.drawString(String.valueOf("0"), 155, 295 - stopPx);
    }

    private BufferedImage getIndicationImg(int order) {
        if (this.indicationSpeedChange != order) {
            return speedDownImage;
        }
        if (this.dmiPanel.getMode() == 23) {
            return speedDownImageTargetIndicationAto;
        }
        return speedDownImageTargetIndication;
    }

    private Color getIndicationColor(int order) {
        if (this.indicationSpeedChange != order) {
            return DmiPanel.GREY;
        }
        if (this.dmiPanel.getMode() == 23) {
            return DmiPanel.WHITE;
        }
        return DmiPanel.YELLOW;
    }

    private void drawBackground(Graphics2D g2) {
        g2.setColor(PASP_DARK);
        g2.fillRect(147, 0, 99, 285);
        List<TrackSection> speedChangeList = MovementAuthority.getTrackSectionList(this.maList, true);
        speedChangeList.forEach(ts -> log.debug("track section speed {} length {}", (Object)ts.getSpeed(), (Object)ts.getLength()));
        int loopSpeedPlanningMetresFromStart = 0;
        int loopWidth = 4;
        for (int i = 0; i < speedChangeList.size(); ++i) {
            int startPx = this.calculatePositionOnScale(loopSpeedPlanningMetresFromStart);
            int stopPx = this.calculatePositionOnScale(loopSpeedPlanningMetresFromStart += speedChangeList.get(i).getLength());
            if (speedChangeList.get(i) != speedChangeList.get(0)) {
                double percentageOfFirstSection = (double)speedChangeList.get(i).getSpeed() / (double)speedChangeList.get(0).getSpeed() * 100.0;
                if (percentageOfFirstSection < 50.0) {
                    loopWidth = Math.min(loopWidth, 1);
                } else if (percentageOfFirstSection < 75.0) {
                    loopWidth = Math.min(loopWidth, 2);
                } else if (percentageOfFirstSection < 100.0) {
                    loopWidth = Math.min(loopWidth, 3);
                }
            }
            int w = 94 * loopWidth / 4;
            log.debug("draw rect y:{} width:{} height:{}", new Object[]{282 - stopPx, w, stopPx - startPx});
            g2.setColor(PASP_LIGHT);
            g2.fillRect(147, 282 - stopPx, w, stopPx - startPx);
        }
    }

    private void drawScale(Graphics2D g2) {
        for (int i = 0; i < scaleLineYPx.length; ++i) {
            g2.setColor(scaleLineLight[i] ? DmiPanel.MEDIUM_GREY : DmiPanel.DARK_GREY);
            g2.drawLine(40, scaleLineYPx[i], 240, scaleLineYPx[i]);
        }
        Font unitsSizedFont = new Font("Helvetica", 0, 12);
        g2.setFont(unitsSizedFont);
        FontMetrics unitsFontM = g2.getFontMetrics(unitsSizedFont);
        g2.setColor(DmiPanel.MEDIUM_GREY);
        for (int i = 0; i < scaleDistanceBase.length; ++i) {
            String s = String.valueOf(scaleDistanceBase[i] * scales[this.currentScale]);
            int width = 38 - unitsFontM.stringWidth(s);
            g2.drawString(s, width, scaleycords[i]);
        }
        this.plusButton.setVisible(true);
        this.minusButton.setVisible(true);
    }

    private void drawNextAdviceChange(Graphics2D g2) {
        if (this.nextAdviceChange < 0) {
            return;
        }
        g2.setColor(DmiPanel.GREY);
        int startPx = 282 - this.calculatePositionOnScale(this.nextAdviceChange);
        g2.fillRect(147, startPx, 10, 2);
        g2.fillRect(167, startPx, 10, 2);
        g2.fillRect(187, startPx, 10, 2);
        g2.fillRect(207, startPx, 10, 2);
        g2.fillRect(227, startPx, 10, 2);
    }

    private void drawIndicationMarkerLine(Graphics2D g2) {
        if (this.indicationDistance < 0) {
            return;
        }
        g2.setColor(this.dmiPanel.getMode() == 23 ? DmiPanel.WHITE : DmiPanel.YELLOW);
        int startPx = 282 - this.calculatePositionOnScale(this.indicationDistance);
        g2.fillRect(147, startPx, 93, 2);
    }

    private int calculatePositionOnScale(int lengthInMeters) {
        int position;
        int linearScaleMaxDistance = scaleDistanceBase[1] * scales[this.currentScale] / 5;
        double logScaleMaxDistance = scaleDistanceBase[4] * scales[this.currentScale];
        int TOTAL_PIXELS = 262;
        long FIRST_LINEAR_SCALE_PIXELS = 33L;
        long logScaleWidthInPixels = 229L;
        if (lengthInMeters <= linearScaleMaxDistance) {
            position = (int)((float)lengthInMeters / (float)linearScaleMaxDistance * 33.0f);
        } else {
            double logScaleFactor = (double)logScaleWidthInPixels / (Math.log(logScaleMaxDistance) - Math.log(linearScaleMaxDistance));
            position = (int)(33.0 + (Math.log(lengthInMeters) - Math.log(linearScaleMaxDistance)) * logScaleFactor);
        }
        log.debug("at distance {} px: {}", (Object)lengthInMeters, (Object)position);
        return position;
    }

    protected void extendMovementAuthorities(MovementAuthority a) {
        this.maList.add(a);
        this.repaint();
    }

    protected void resetMovementAuthorities(List<MovementAuthority> a) {
        this.maList.clear();
        this.maList.addAll(a);
        this.repaint();
    }

    protected List<MovementAuthority> getMovementAuthorities() {
        return Collections.unmodifiableList(this.maList);
    }

    protected void advance(int distance) {
        MovementAuthority.advanceForward(this.maList, distance);
        this.nextAdviceChange -= distance;
        this.repaint();
    }

    private void drawGradientBar(Graphics2D g2) {
        List<TrackSection> gradientList = MovementAuthority.getTrackSectionList(this.maList, false);
        int drawingMetresFromStart = 0;
        for (TrackSection gradientTs : gradientList) {
            int startMetres = drawingMetresFromStart;
            int endMetres = drawingMetresFromStart + gradientTs.getLength();
            int startPx = this.calculatePositionOnScale(startMetres);
            int stopPx = this.calculatePositionOnScale(endMetres);
            g2.setColor(gradientTs.getGradient() < 0 ? DmiPanel.DARK_GREY : DmiPanel.GREY);
            g2.fillRect(116, 283 - stopPx, 17, stopPx - startPx - 2);
            g2.setColor(gradientTs.getGradient() < 0 ? DmiPanel.GREY : DmiPanel.WHITE);
            g2.drawLine(116, 283 - stopPx, 131, 283 - stopPx);
            g2.drawLine(115, 283 - startPx, 115, 283 - stopPx);
            g2.setColor(DmiPanel.BLACK);
            g2.drawLine(115, 283 - startPx - 1, 132, 283 - startPx - 1);
            this.drawIconsOnGradient(g2, gradientTs, startPx, stopPx);
            drawingMetresFromStart = endMetres;
        }
    }

    private void drawIconsOnGradient(Graphics2D g2, TrackSection gradientTs, int startPx, int stopPx) {
        int usableHeight;
        if (this.loopGradientLimitReached) {
            return;
        }
        int stopHeight = 283 - stopPx + 12;
        if (stopHeight < 0) {
            stopHeight = 12;
            this.loopGradientLimitReached = true;
        }
        if ((usableHeight = stopPx - startPx - 4) > 14) {
            Font unitsSizedFont = new Font("Helvetica", 0, 13);
            g2.setFont(unitsSizedFont);
            FontMetrics unitsFontM = g2.getFontMetrics(unitsSizedFont);
            g2.setColor(gradientTs.getGradient() < 0 ? DmiPanel.WHITE : DmiPanel.BLACK);
            String toDraw = gradientTs.getGradient() < 0 ? "   -   " : "   +   ";
            int width = 124 - unitsFontM.stringWidth(toDraw) / 2;
            log.debug("stopHeight:{}", (Object)stopHeight);
            g2.drawString(toDraw, width, stopHeight);
            if (usableHeight > 20) {
                g2.drawString(toDraw, width, 283 - startPx - 2);
            }
            if (usableHeight > 30) {
                unitsSizedFont = new Font("Helvetica", 0, 12);
                g2.setFont(unitsSizedFont);
                unitsFontM = g2.getFontMetrics(unitsSizedFont);
                toDraw = String.valueOf(gradientTs.getGradient()).replace(String.valueOf("-"), "");
                width = 124 - unitsFontM.stringWidth(toDraw) / 2;
                int centre = (startPx + stopPx) / 2;
                int drawHeight = 283 - centre + 4;
                g2.drawString(toDraw, width, drawHeight);
            }
        }
    }

    private void setButtonsToState() {
        this.plusButton.setEnabled(this.currentScale != 0);
        this.minusButton.setEnabled(this.currentScale != 5);
    }

    protected void setScale(int scale) {
        this.currentScale = scale;
        this.setButtonsToState();
        this.repaint();
    }

    protected void setTrackAheadFreeQuestionVisible(boolean newVal) {
        this.trackAheadFreeQuestion.setVisible(newVal);
    }

    protected void setNextAdviceChange(int distance) {
        this.nextAdviceChange = distance;
        this.repaint();
    }

    protected void setIndicationMarkerLine(int distance, int whichSpeedChange) {
        this.indicationDistance = distance;
        this.indicationSpeedChange = whichSpeedChange;
        this.repaint();
    }

    private JPanel trackAheadFreeQuestionPanel() {
        JPanel p = new JPanel();
        p.setLayout(null);
        p.setBounds(0, 50, 246, 50);
        p.setBackground(DmiPanel.DARK_GREY);
        JLabel trackAheadFreeQuestionLogo = new JLabel(ResourceUtil.getImageIcon("DR_02.bmp"));
        trackAheadFreeQuestionLogo.setBounds(0, 0, 162, 50);
        trackAheadFreeQuestionLogo.setBackground(DmiPanel.DARK_GREY);
        trackAheadFreeQuestionLogo.setBorder(BorderFactory.createLineBorder(DmiPanel.MEDIUM_GREY, 1));
        p.add(trackAheadFreeQuestionLogo);
        JButton trackAheadFreeButton = new JButton(Bundle.getMessage("ButtonYes"));
        trackAheadFreeButton.setFocusable(false);
        trackAheadFreeButton.setBounds(162, 0, 84, 50);
        trackAheadFreeButton.setBackground(DmiPanel.MEDIUM_GREY);
        trackAheadFreeButton.setForeground(DmiPanel.BLACK);
        trackAheadFreeButton.setActionCommand("DriverAdvisesTrackAheadFree");
        trackAheadFreeButton.addActionListener(this::buttonClicked);
        p.add(trackAheadFreeButton);
        return p;
    }

    void buttonClicked(ActionEvent e) {
        this.dmiPanel.firePropertyChange(e.getActionCommand(), false, true);
        this.setTrackAheadFreeQuestionVisible(false);
    }

    private class TransparentButton
    extends JButton {
        private final boolean plus;

        private TransparentButton(boolean plusIcon) {
            this.setOpaque(false);
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.plus = plusIcon;
            if (this.plus) {
                this.setIcon(ResourceUtil.getImageIcon("NA_03.bmp"));
                this.setDisabledIcon(ResourceUtil.getImageIcon("NA_05.bmp"));
            } else {
                this.setIcon(ResourceUtil.getImageIcon("NA_04.bmp"));
                this.setDisabledIcon(ResourceUtil.getImageIcon("NA_06.bmp"));
            }
            this.setBounds(0, this.plus ? 246 : 0, 50, 50);
            this.addActionListener(this::changeScale);
        }

        private void changeScale(ActionEvent e) {
            log.debug("scale changed {}", (Object)e.paramString());
            DmiPanelD.this.currentScale = DmiPanelD.this.currentScale + (this.plus ? -1 : 1);
            DmiPanelD.this.setButtonsToState();
            DmiPanelD.this.planningPanel.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Icon i;
            Icon icon = i = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
            if (i != null) {
                i.paintIcon(this, g, 15, this.plus ? 36 : 0);
            }
        }
    }
}

