/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.etcs.CabMessage;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.dmi.swing.Bundle;
import jmri.jmrit.etcs.dmi.swing.DmiCabMessage;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmiPanelE
extends JPanel {
    private final JButton e10upArrow;
    private final JButton e11downArrow;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
    private final JLabel labele1;
    private final DmiPanel mainPane;
    private final JPanel messagePanel;
    private final JButton messageButton;
    private int msgScroll = 0;
    private final List<DmiCabMessage> messageList = new ArrayList<DmiCabMessage>();
    private final JLabel[] messageLabels;
    private final JLabel[] timeLabels;
    private final Font timeFont = new Font("Helvetica", 0, 12);
    private final Font messageFont = new Font("Helvetica", 0, 16);
    private CabMessage cabMessageBeingConfirmed;
    private final JLabel msglabel1 = new JLabel();
    private final JLabel msglabel2 = new JLabel();
    private final JLabel msglabel3 = new JLabel();
    private final JLabel msglabel4 = new JLabel();
    private final JLabel msglabel5 = new JLabel();
    private final JLabel timeLabel1 = new JLabel();
    private final JLabel timeLabel2 = new JLabel();
    private final JLabel timeLabel3 = new JLabel();
    private final JLabel timeLabel4 = new JLabel();
    private final JLabel timeLabel5 = new JLabel();
    private static final Logger log = LoggerFactory.getLogger(DmiPanelE.class);

    public DmiPanelE(@Nonnull DmiPanel mainPanel) {
        this.mainPane = mainPanel;
        this.messageButton = new JButton();
        this.setLayout(null);
        this.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.setBounds(0, 365, 334, 100);
        JPanel e1 = new JPanel();
        JPanel e2 = new JPanel();
        JPanel e3 = new JPanel();
        JPanel e4 = new JPanel();
        this.messagePanel = this.initMsgPanel();
        this.e10upArrow = new JButton();
        this.e11downArrow = new JButton();
        this.e10upArrow.setFocusable(false);
        this.e11downArrow.setFocusable(false);
        e1.setBounds(0, 0, 54, 25);
        e1.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        e1.setBackground(DmiPanel.BACKGROUND_COLOUR);
        e2.setBounds(0, 25, 54, 25);
        e2.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        e2.setBackground(DmiPanel.BACKGROUND_COLOUR);
        e3.setBounds(0, 50, 54, 25);
        e3.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        e3.setBackground(DmiPanel.BACKGROUND_COLOUR);
        e4.setBounds(0, 75, 54, 25);
        e4.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        e4.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.messagePanel.setBounds(0, 0, 234, 100);
        this.messagePanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.messagePanel.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.messageButton.setBounds(54, 0, 234, 100);
        this.messageButton.setLayout(null);
        this.messageButton.setContentAreaFilled(false);
        this.messageButton.setBorderPainted(false);
        this.messageButton.setName("messageAcknowledgeButton");
        this.messageButton.add(this.messagePanel);
        this.messageButton.addActionListener(this::acknowledgeButtonPressed);
        this.e10upArrow.setBounds(288, 0, 46, 50);
        this.e10upArrow.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.e10upArrow.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.e11downArrow.setBounds(288, 50, 46, 50);
        this.e11downArrow.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.e11downArrow.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.e10upArrow.setIcon(ResourceUtil.getImageIcon("NA_13.bmp"));
        this.e11downArrow.setIcon(ResourceUtil.getImageIcon("NA_14.bmp"));
        this.e10upArrow.setDisabledIcon(ResourceUtil.getImageIcon("NA_15.bmp"));
        this.e11downArrow.setDisabledIcon(ResourceUtil.getImageIcon("NA_16.bmp"));
        this.e10upArrow.setName("e10upArrow");
        this.e11downArrow.setName("e11downArrow");
        this.e10upArrow.addActionListener(e -> {
            --this.msgScroll;
            this.updateMsgPanel();
        });
        this.e11downArrow.addActionListener(e -> {
            ++this.msgScroll;
            this.updateMsgPanel();
        });
        this.add(e1);
        this.add(e2);
        this.add(e3);
        this.add(e4);
        this.add(this.messageButton);
        this.add(this.e10upArrow);
        this.add(this.e11downArrow);
        this.labele1 = new JLabel();
        e1.add(this.labele1);
        this.timeLabels = new JLabel[]{this.timeLabel1, this.timeLabel2, this.timeLabel3, this.timeLabel4, this.timeLabel5};
        this.messageLabels = new JLabel[]{this.msglabel1, this.msglabel2, this.msglabel3, this.msglabel4, this.msglabel5};
        this.e10upArrow.setEnabled(false);
        this.e11downArrow.setEnabled(false);
    }

    private void acknowledgeButtonPressed(ActionEvent e) {
        this.setMessageButtonEnabled(false);
        this.cabMessageBeingConfirmed.setConfirmed();
        this.mainPane.firePropertyChange("MessageAcknowledged", this.cabMessageBeingConfirmed.getMessageId());
        this.updateMsgPanel();
    }

    private JPanel initMsgPanel() {
        JPanel p = new JPanel();
        p.setLayout(null);
        this.timeLabel1.setBounds(5, 0, 35, 20);
        this.timeLabel2.setBounds(5, 20, 35, 20);
        this.timeLabel3.setBounds(5, 40, 35, 20);
        this.timeLabel4.setBounds(5, 60, 35, 20);
        this.timeLabel5.setBounds(5, 80, 35, 20);
        this.msglabel1.setBounds(50, 0, 204, 20);
        this.msglabel2.setBounds(50, 20, 204, 20);
        this.msglabel3.setBounds(50, 40, 204, 20);
        this.msglabel4.setBounds(50, 60, 204, 20);
        this.msglabel5.setBounds(50, 80, 204, 20);
        this.timeLabel1.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.timeLabel2.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.timeLabel3.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.timeLabel4.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.timeLabel5.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.msglabel1.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.msglabel2.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.msglabel3.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.msglabel4.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.msglabel5.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.timeLabel1.setForeground(Color.WHITE);
        this.timeLabel2.setForeground(Color.WHITE);
        this.timeLabel3.setForeground(Color.WHITE);
        this.timeLabel4.setForeground(Color.WHITE);
        this.timeLabel5.setForeground(Color.WHITE);
        this.msglabel1.setForeground(Color.WHITE);
        this.msglabel2.setForeground(Color.WHITE);
        this.msglabel3.setForeground(Color.WHITE);
        this.msglabel4.setForeground(Color.WHITE);
        this.msglabel5.setForeground(Color.WHITE);
        this.timeLabel1.setFont(this.timeFont);
        this.timeLabel2.setFont(this.timeFont);
        this.timeLabel3.setFont(this.timeFont);
        this.timeLabel4.setFont(this.timeFont);
        this.timeLabel5.setFont(this.timeFont);
        this.msglabel1.setFont(this.messageFont);
        this.msglabel2.setFont(this.messageFont);
        this.msglabel3.setFont(this.messageFont);
        this.msglabel4.setFont(this.messageFont);
        this.msglabel5.setFont(this.messageFont);
        this.msglabel1.setName("msglabel1");
        this.msglabel5.setName("msglabel5");
        this.timeLabel1.setName("timeLabel1");
        p.add(this.timeLabel1);
        p.add(this.timeLabel2);
        p.add(this.timeLabel3);
        p.add(this.timeLabel4);
        p.add(this.timeLabel5);
        p.add(this.msglabel1);
        p.add(this.msglabel2);
        p.add(this.msglabel3);
        p.add(this.msglabel4);
        p.add(this.msglabel5);
        return p;
    }

    protected void addMessage(@Nonnull CabMessage msg) {
        this.removeMessage(msg.getMessageId());
        this.messageList.add(new DmiCabMessage(msg, this.messageFont));
        this.msgScroll = 0;
        this.updateMsgPanel();
    }

    protected void removeMessage(String messageId) {
        Iterator<DmiCabMessage> iterator = this.messageList.iterator();
        while (iterator.hasNext()) {
            DmiCabMessage obj = iterator.next();
            if (!obj.getMessageId().equals(messageId)) continue;
            iterator.remove();
        }
        this.updateMsgPanel();
    }

    private void updateMsgPanel() {
        DmiCabMessage msg;
        Comparator<CabMessage> customComparator = Comparator.comparing(CabMessage::getAckRequired, Comparator.reverseOrder()).thenComparingInt(CabMessage::getGroup).thenComparing(CabMessage::getSentTime, Comparator.reverseOrder());
        Collections.sort(this.messageList, customComparator);
        for (int i = 0; i < 5; ++i) {
            this.messageLabels[i].setText("");
            this.timeLabels[i].setText("");
        }
        if (!this.messageList.isEmpty() && (msg = this.messageList.get(0)).getAckRequired()) {
            this.setAckReqdMessage(msg);
            return;
        }
        this.displayMessages();
    }

    private void displayMessages() {
        this.setMessageButtonEnabled(false);
        ArrayList<String> tempTimes = new ArrayList<String>();
        ArrayList<String> tempMessages = new ArrayList<String>();
        for (DmiCabMessage msg : this.messageList) {
            log.debug("CabM: {}", (Object)msg);
            String[] msgText = msg.getMessageArray();
            for (int i = 0; i < msgText.length; ++i) {
                tempTimes.add(i == 0 ? this.dateFormat.format(msg.getSentTime().getTime()) : "");
                tempMessages.add(msgText[i]);
            }
        }
        this.msgScroll = Math.min(this.msgScroll, Math.max(tempMessages.size() - 5, 0));
        for (int i = 0; i < 5; ++i) {
            int position = i + this.msgScroll;
            if (position >= tempMessages.size()) continue;
            this.timeLabels[i].setText((String)tempTimes.get(position));
            this.messageLabels[i].setText((String)tempMessages.get(position));
        }
        this.e10upArrow.setEnabled(this.msgScroll > 0);
        this.e11downArrow.setEnabled(this.msgScroll < tempMessages.size() - 5);
    }

    private void setAckReqdMessage(DmiCabMessage msg) {
        log.debug("ack reqd, display single message");
        this.setMessageButtonEnabled(true);
        this.timeLabels[0].setText(this.dateFormat.format(msg.getSentTime().getTime()));
        this.cabMessageBeingConfirmed = msg;
        String[] msgText = msg.getMessageArray();
        log.debug("formatted msg has {} lines", (Object)msgText.length);
        for (int i = 0; i < 5; ++i) {
            if (i >= msgText.length) continue;
            log.debug("msgText {} {}", (Object)i, (Object)msgText[i]);
            this.messageLabels[i].setText(msgText[i]);
        }
        this.e10upArrow.setEnabled(false);
        this.e11downArrow.setEnabled(false);
    }

    private void setMessageButtonEnabled(boolean newVal) {
        this.messageButton.setEnabled(newVal);
        this.messagePanel.setBorder(BorderFactory.createLineBorder(newVal ? DmiPanel.YELLOW : DmiPanel.BACKGROUND_COLOUR, 2));
    }

    protected void setSafeRadioConnection(int newVal) {
        switch (newVal) {
            case 1: {
                this.labele1.setIcon(ResourceUtil.getImageIcon("ST_03.bmp"));
                this.labele1.setToolTipText(Bundle.getMessage("RadioConnectionOK"));
                break;
            }
            case 0: {
                this.labele1.setIcon(ResourceUtil.getImageIcon("ST_04.bmp"));
                this.labele1.setToolTipText(Bundle.getMessage("RadioConnectionLost"));
                break;
            }
            default: {
                this.labele1.setIcon(null);
                this.labele1.setToolTipText(null);
            }
        }
    }
}

