/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.annotation.CheckForNull;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.dmi.swing.Bundle;
import jmri.jmrit.etcs.dmi.swing.DmiDemo;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmiPanelF
extends JPanel {
    private final JButton f1;
    private final JButton f2;
    private final JButton f3;
    private final JButton f4;
    private final JButton f5;
    private final DmiPanel main;
    private static final Logger log = LoggerFactory.getLogger(DmiPanelF.class);

    public DmiPanelF(@CheckForNull DmiPanel mainPane) {
        this.setLayout(null);
        this.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.setBounds(580, 15, 60, 450);
        this.main = mainPane;
        this.f1 = new JButton(Bundle.getMessage("ButtonMain"));
        this.f2 = new JButton(Bundle.getMessage("ButtonOverRide"));
        this.f3 = new JButton(Bundle.getMessage("ButtonDataView"));
        this.f4 = new JButton("Spec");
        this.f5 = new JButton();
        this.f1.setBounds(0, 0, 60, 50);
        this.f2.setBounds(0, 50, 60, 50);
        this.f3.setBounds(0, 100, 60, 50);
        this.f4.setBounds(0, 150, 60, 50);
        this.f5.setBounds(0, 200, 60, 50);
        this.f1.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.f2.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.f3.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.f4.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.f5.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.f1.setForeground(DmiPanel.GREY);
        this.f2.setForeground(DmiPanel.GREY);
        this.f3.setForeground(DmiPanel.GREY);
        this.f4.setForeground(DmiPanel.GREY);
        this.f1.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.f2.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.f3.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.f4.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.f5.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.f1.setFocusable(false);
        this.f2.setFocusable(false);
        this.f3.setFocusable(false);
        this.f4.setFocusable(false);
        this.f5.setFocusable(false);
        this.f1.setHorizontalAlignment(0);
        this.f2.setHorizontalAlignment(0);
        this.f3.setHorizontalAlignment(0);
        this.f4.setHorizontalAlignment(0);
        this.f5.setHorizontalAlignment(0);
        this.f1.setFont(new Font("Helvetica", 0, 17));
        this.f2.setFont(new Font("Helvetica", 0, 17));
        this.f3.setFont(new Font("Helvetica", 0, 17));
        this.f4.setFont(new Font("Helvetica", 0, 17));
        this.f5.setIcon(ResourceUtil.getImageIcon("SE_04.bmp"));
        this.add(this.f1);
        this.add(this.f2);
        this.add(this.f3);
        this.add(this.f4);
        this.add(this.f5);
        this.f5.addMouseListener(JmriMouseListener.adapt(new PopupListener()));
    }

    private class PopupListener
    extends JmriMouseAdapter {
        private final UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
        private JCheckBoxMenuItem jcmi;

        private PopupListener() {
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        private void showPopup(JmriMouseEvent e) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem mi = new JMenuItem(Bundle.getMessage("RunDemo"));
            mi.addActionListener(this::runDemo);
            popupMenu.add(mi);
            this.jcmi = new JCheckBoxMenuItem(Bundle.getMessage("CentreSpeedText"));
            this.jcmi.setToolTipText(Bundle.getMessage("GlobalPreference"));
            this.jcmi.setSelected(this.p.getSimplePreferenceState(DmiPanel.PROPERTY_CENTRE_TEXT));
            this.jcmi.addActionListener(this::setCentreSpeedText);
            popupMenu.add(this.jcmi);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        private void runDemo(ActionEvent e) {
            log.debug("running demo from {}", (Object)e.getActionCommand());
            new DmiDemo(DmiPanelF.this.main).runDemo();
        }

        private void setCentreSpeedText(ActionEvent e) {
            log.debug("set centre speed pref from {}", (Object)e.getActionCommand());
            this.p.setSimplePreferenceState(DmiPanel.PROPERTY_CENTRE_TEXT, this.jcmi.isSelected());
            DmiPanelF.this.main.repaint();
        }
    }
}

