/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.jmrit.etcs.ResourceUtil;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;

public class DmiPanelG
extends JPanel {
    private final DmiPanel main;
    private final JLabel timeLabel = new JLabel();
    private final JLabel g2g3g4LabelTop;
    private final JLabel g2g3g4LabelBottom;
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final Timebase clock = InstanceManager.getDefault(Timebase.class);
    private final transient PropertyChangeListener clockTickListener = e -> this.updateClock();
    private transient TimerTask secondTimer;
    private final transient PropertyChangeListener clockPauseFlashListener = e -> this.timeLabel.setVisible(!this.timeLabel.isVisible());
    private final transient PropertyChangeListener clockRunStateChangedListener = e -> this.clockRunStateChanged();
    private boolean disposed = false;
    private final JButton g1Button;
    private final JButton g2Button;
    private final JButton g3Button;
    private final JLabel g4Label;
    private final JLabel g3LabelMins;
    private final JLabel g3LabelSecs;
    private final JButton g5Button;

    public DmiPanelG(@Nonnull DmiPanel mainPanel) {
        this.setLayout(null);
        this.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.setBounds(334, 315, 246, 150);
        this.main = mainPanel;
        JToggleButton g12PositionButton = new JToggleButton();
        g12PositionButton.setBounds(63, 100, 120, 50);
        g12PositionButton.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        g12PositionButton.setBackground(DmiPanel.BACKGROUND_COLOUR);
        g12PositionButton.setIcon(ResourceUtil.getImageIcon("DR_03.bmp"));
        this.add(g12PositionButton);
        g12PositionButton.setFocusable(false);
        this.timeLabel.setBounds(183, 100, 63, 50);
        this.timeLabel.setForeground(DmiPanel.GREY);
        this.timeLabel.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.timeLabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.timeLabel.setFont(new Font("Helvetica", 0, 13));
        this.timeLabel.setHorizontalAlignment(0);
        this.add(this.timeLabel);
        this.clock.addMinuteChangeListener(this.clockTickListener);
        this.clock.addPropertyChangeListener("rate", this.clockTickListener);
        this.clock.addPropertyChangeListener("run", this.clockRunStateChangedListener);
        ThreadingUtil.runOnGUIEventually(() -> {
            this.clockRunStateChanged();
            this.updateClock();
        });
        this.g2g3g4LabelTop = new JLabel();
        this.g2g3g4LabelTop.setBounds(49, 4, 147, 25);
        this.g2g3g4LabelTop.setForeground(DmiPanel.GREY);
        this.g2g3g4LabelTop.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g2g3g4LabelTop.setFont(new Font("Helvetica", 0, 13));
        this.g2g3g4LabelTop.setHorizontalAlignment(0);
        this.add(this.g2g3g4LabelTop);
        this.g2g3g4LabelBottom = new JLabel();
        this.g2g3g4LabelBottom.setBounds(49, 21, 147, 24);
        this.g2g3g4LabelBottom.setForeground(DmiPanel.GREY);
        this.g2g3g4LabelBottom.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g2g3g4LabelBottom.setFont(new Font("Helvetica", 0, 13));
        this.g2g3g4LabelBottom.setHorizontalAlignment(0);
        this.add(this.g2g3g4LabelBottom);
        this.g1Button = new JButton();
        this.g1Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.g1Button.setFocusable(false);
        this.g1Button.setVisible(false);
        this.g1Button.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g1Button.setContentAreaFilled(false);
        this.g1Button.addActionListener(this::gButtonPressed);
        this.g1Button.setName("g1Button");
        this.g2Button = new JButton();
        this.g2Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.g2Button.setFocusable(false);
        this.g2Button.setVisible(false);
        this.g2Button.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g2Button.setContentAreaFilled(false);
        this.g2Button.addActionListener(this::gButtonPressed);
        this.g2Button.setName("g2Button");
        this.g3Button = new JButton();
        this.g3Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.g3Button.setFocusable(false);
        this.g3Button.setVisible(false);
        this.g3Button.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g3Button.setContentAreaFilled(false);
        this.g3Button.addActionListener(this::gButtonPressed);
        this.g3Button.setName("g3Button");
        this.g3LabelMins = new JLabel();
        this.g3LabelMins.setBounds(98, 12, 24, 24);
        this.g3LabelMins.setForeground(DmiPanel.GREY);
        this.g3LabelMins.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g3LabelMins.setFont(new Font("Helvetica", 0, 17));
        this.g3LabelMins.setHorizontalAlignment(4);
        this.add(this.g3LabelMins);
        this.g3LabelSecs = new JLabel();
        this.g3LabelSecs.setBounds(122, 14, 24, 24);
        this.g3LabelSecs.setForeground(DmiPanel.GREY);
        this.g3LabelSecs.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g3LabelSecs.setFont(new Font("Helvetica", 0, 13));
        this.g3LabelSecs.setHorizontalAlignment(2);
        this.add(this.g3LabelSecs);
        this.g4Label = new JLabel();
        this.g4Label.setVisible(false);
        this.g4Label.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g5Button = new JButton();
        this.g5Button.setBorder(DmiPanel.BORDER_NORMAL);
        this.g5Button.setFocusable(false);
        this.g5Button.setVisible(false);
        this.g5Button.setBackground(DmiPanel.BACKGROUND_COLOUR);
        this.g5Button.setContentAreaFilled(false);
        this.g5Button.addActionListener(this::gButtonPressed);
        this.g5Button.setName("g5Button");
        this.g1Button.setBounds(0, 0, 49, 50);
        this.g2Button.setBounds(49, 0, 49, 50);
        this.g3Button.setBounds(98, 0, 49, 50);
        this.g4Label.setBounds(147, 0, 49, 50);
        this.g5Button.setBounds(196, 0, 49, 50);
        this.add(this.g1Button);
        this.add(this.g2Button);
        this.add(this.g3Button);
        this.add(this.g4Label);
        this.add(this.g5Button);
    }

    protected void setAtoMode(int mode) {
        switch (mode) {
            case 1: {
                this.g1Button.setIcon(ResourceUtil.getImageIcon("ATO_01.bmp"));
                this.g1Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_01.bmp"));
                break;
            }
            case 2: {
                this.g1Button.setIcon(ResourceUtil.getImageIcon("ATO_02.bmp"));
                this.g1Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_02.bmp"));
                this.g1Button.setActionCommand("AtoDriverStart");
                break;
            }
            case 3: {
                this.g1Button.setIcon(ResourceUtil.getImageIcon("ATO_03.bmp"));
                this.g1Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_03.bmp"));
                this.g1Button.setActionCommand("AtoDriverStop");
                break;
            }
            case 4: {
                this.g1Button.setIcon(ResourceUtil.getImageIcon("ATO_04.bmp"));
                this.g1Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_04.bmp"));
                this.g1Button.setActionCommand("AtoDriverStop");
                break;
            }
            case 5: {
                this.g1Button.setIcon(ResourceUtil.getImageIcon("ATO_05.bmp"));
                this.g1Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_05.bmp"));
                break;
            }
            default: {
                this.g1Button.setIcon(null);
                this.g1Button.setDisabledIcon(null);
            }
        }
        this.g1Button.setEnabled(mode > 1 && mode < 5);
        this.g1Button.setVisible(mode != 0);
    }

    protected void setStoppingAccuracy(int acc) {
        switch (acc) {
            case -1: {
                this.g2Button.setIcon(ResourceUtil.getImageIcon("ATO_07.bmp"));
                break;
            }
            case 0: {
                this.g2Button.setIcon(ResourceUtil.getImageIcon("ATO_08.bmp"));
                break;
            }
            case 1: {
                this.g2Button.setIcon(ResourceUtil.getImageIcon("ATO_06.bmp"));
                break;
            }
        }
        this.g2Button.setVisible(acc != -2);
    }

    protected void setStoppingPointLabel(String station, String eta) {
        this.g2g3g4LabelTop.setText(station);
        this.g2g3g4LabelBottom.setText(eta);
        this.g2g3g4LabelTop.setVisible(!station.isBlank());
        this.g2g3g4LabelBottom.setVisible(!eta.isBlank());
    }

    protected void setDwellTime(int mins, int secs) {
        this.g3LabelMins.setVisible(mins > 0);
        this.g3LabelSecs.setVisible(secs > -1);
        this.g3LabelMins.setText(String.valueOf(mins));
        this.g3LabelSecs.setText((mins > 0 ? ":" : "") + (secs < 10 ? "0" : "") + secs);
    }

    protected void setDoorIcon(int mode) {
        switch (mode) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.g4Label.setIcon(ResourceUtil.getImageIcon("ATO_" + mode + ".bmp"));
                break;
            }
            default: {
                this.g4Label.setIcon(null);
            }
        }
        this.g4Label.setVisible(mode != 0);
    }

    protected void setSkipStoppingPoint(int mode) {
        this.g5Button.setEnabled(false);
        switch (mode) {
            case 17: {
                this.g5Button.setActionCommand("SkipStoppingPointInactive");
                this.g5Button.setIcon(ResourceUtil.getImageIcon("ATO_17.bmp"));
                this.g5Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_" + mode + ".bmp"));
                this.g5Button.setEnabled(true);
                break;
            }
            case 18: {
                this.g5Button.setIcon(ResourceUtil.getImageIcon("ATO_18.bmp"));
                this.g5Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_" + mode + ".bmp"));
                break;
            }
            case 19: {
                this.g5Button.setActionCommand("SkipStoppingPointRequestByDriver");
                this.g5Button.setIcon(ResourceUtil.getImageIcon("ATO_19.bmp"));
                this.g5Button.setDisabledIcon(ResourceUtil.getImageIcon("ATO_" + mode + ".bmp"));
                this.g5Button.setEnabled(true);
                break;
            }
            default: {
                this.g5Button.setIcon(null);
                this.g5Button.setDisabledIcon(null);
            }
        }
        this.g5Button.setVisible(mode != 0);
    }

    private void gButtonPressed(ActionEvent e) {
        this.main.firePropertyChange(e.getActionCommand(), false, true);
    }

    private void clockRunStateChanged() {
        this.timeLabel.setVisible(this.clock.getRun());
        if (this.clock.getRun()) {
            this.main.removeFlashListener(this.clockPauseFlashListener, false);
        } else {
            this.main.addFlashListener(this.clockPauseFlashListener, false);
        }
    }

    private void updateClock() {
        this.restartSecondTimer();
        this.updateLabel();
    }

    private void updateLabel() {
        LocalTime now = this.clock.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        this.timeLabel.setText(now.format(TIME_FORMAT));
    }

    private void restartSecondTimer() {
        if (this.secondTimer != null) {
            this.secondTimer.cancel();
            this.secondTimer = null;
        }
        final long period = (long)(1000.0 / this.clock.userGetRate());
        this.secondTimer = new TimerTask(){

            @Override
            public void run() {
                if (!DmiPanelG.this.disposed) {
                    DmiPanelG.this.updateLabel();
                    TimerUtil.scheduleOnGUIThread(DmiPanelG.this.secondTimer, period);
                }
            }
        };
        TimerUtil.scheduleOnGUIThread(this.secondTimer, period);
    }

    public void dispose() {
        this.clock.removeMinuteChangeListener(this.clockTickListener);
        this.clock.removePropertyChangeListener("run", this.clockRunStateChangedListener);
        this.clock.removePropertyChangeListener("rate", this.clockTickListener);
        this.main.removeFlashListener(this.clockPauseFlashListener, false);
        this.disposed = true;
    }
}

