/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.etcs.dmi.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.etcs.dmi.swing.DmiCircularSpeedGuideSection;
import jmri.jmrit.etcs.dmi.swing.DmiPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmiSpeedoDialPanel
extends JPanel {
    private float speed = 0.0f;
    private float targetAdviceSpeed = -1.0f;
    private int maxSpeed = 140;
    private int majorSpeedGap = 20;
    private Color centreCircleAndDialColor = DmiPanel.GREY;
    private String displaySpeedUnit = "";
    private static final int DIAL_CENTRE_X = 140;
    private static final int DIAL_CENTRE_Y = 150;
    private static final float DEGREES_SPEED0_CLOCKWISE = 126.0f;
    private static final int HOOK_DEPTH = 20;
    private static final int OUTER_CSG_RADIUS = 137;
    private final int[] pointerX = new int[]{-20, -20, -7, -7, 7, 7, 20, 20};
    private final int[] pointerY = new int[]{-31, -266, -314, -381, -381, -314, -266, -31};
    private final int[] scaledPointerX = new int[this.pointerX.length];
    private final int[] scaledPointerY = new int[this.pointerY.length];
    private final int[] rotatedPointerX = new int[this.pointerX.length];
    private final int[] rotatedPointerY = new int[this.pointerY.length];
    private Polygon scaledPointerHand;
    private final int pointerHeight;
    private final CopyOnWriteArrayList<DmiCircularSpeedGuideSection> csgSectionList;
    private final UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
    private static final Logger log = LoggerFactory.getLogger(DmiSpeedoDialPanel.class);

    public DmiSpeedoDialPanel() {
        this.setLayout(null);
        this.setOpaque(false);
        this.csgSectionList = new CopyOnWriteArrayList();
        Polygon pointerHand = new Polygon(this.pointerX, this.pointerY, this.pointerY.length);
        this.pointerHeight = pointerHand.getBounds().getSize().height;
        float scaleRatio = 96.15385f / (float)this.pointerHeight;
        for (int i = 0; i < this.pointerX.length; ++i) {
            this.scaledPointerX[i] = (int)((float)this.pointerX[i] * scaleRatio);
            this.scaledPointerY[i] = (int)((float)this.pointerY[i] * scaleRatio);
        }
        this.scaledPointerHand = new Polygon(this.scaledPointerX, this.scaledPointerY, this.scaledPointerX.length);
        this.setMaxDialSpeed(140);
        this.update(0.0f);
    }

    @Override
    public void paint(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            throw new IllegalArgumentException("Graphics object passed is not the correct type");
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(140, 150);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(hints);
        this.drawTicksAndDigits(g2, 125.0f);
        this.csgSectionList.forEach(s -> this.drawACsgSection(g2, (DmiCircularSpeedGuideSection)s));
        this.drawTargetAdviceSpeed(g2);
        this.drawPointer(g2);
        this.drawCentreCircle(g2);
        this.drawSpeedUnit(g2);
    }

    private void drawHook(Graphics2D g2, DmiCircularSpeedGuideSection section) {
        int hookWidth = 4;
        boolean miniMook = section.type == 2;
        float hookWidthAngle = 126.0f - (float)hookWidth;
        float angle = this.getSpeedAngle(section.stop);
        int hookOuterRadius = 137 - (miniMook ? 6 : 0);
        int hookInnerRadius = 117;
        g2.setColor(miniMook ? DmiPanel.YELLOW : section.col);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(this.dotX(hookOuterRadius, angle + 126.0f), this.dotY(hookOuterRadius, angle + 126.0f));
        polygon2.addPoint(this.dotX(hookInnerRadius, angle + 126.0f), this.dotY(hookInnerRadius, angle + 126.0f));
        polygon2.addPoint(this.dotX(hookInnerRadius, angle + hookWidthAngle), this.dotY(hookInnerRadius, angle + hookWidthAngle));
        polygon2.addPoint(this.dotX(hookOuterRadius, angle + hookWidthAngle), this.dotY(hookOuterRadius, angle + hookWidthAngle));
        g2.fillPolygon(polygon2);
    }

    private void drawACsgSection(Graphics2D g, DmiCircularSpeedGuideSection section) {
        float startAngle = this.getSpeedAngle(section.start) + 126.0f;
        float endAngle = this.getSpeedAngle(section.stop) - this.getSpeedAngle(section.start);
        if (section.includeNegative) {
            startAngle -= 5.0f;
            endAngle += 5.0f;
        }
        log.debug("endAngle: {}", (Object)Float.valueOf(endAngle));
        int innerRadius = 9;
        int outerRadius = 137;
        if (section.type == 2) {
            outerRadius = 132;
        }
        if (section.type == 0) {
            innerRadius = 9;
        } else if (section.type == 1) {
            innerRadius = 20;
        }
        if (section.type == 3) {
            innerRadius = 5;
        }
        if (section.type == 2) {
            innerRadius = 5;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHints(hints);
        g2d.translate(140, 150);
        if (section.type == 0 || section.type == 1) {
            this.drawAnArc(g2d, false, section.col, outerRadius, (int)startAngle, (int)endAngle);
            this.drawAnArc(g2d, true, section.col, outerRadius - innerRadius, (int)startAngle, (int)endAngle);
        }
        if (section.type == 3) {
            this.drawAnArc(g2d, false, DmiPanel.GREY, outerRadius, (int)startAngle, (int)endAngle);
            this.drawAnArc(g2d, false, DmiPanel.BACKGROUND_COLOUR, outerRadius - innerRadius + 1, (int)startAngle, (int)endAngle);
            this.drawAnArc(g2d, true, section.col, outerRadius - innerRadius, (int)startAngle, (int)endAngle);
        }
        if (section.type == 2) {
            this.drawAnArc(g2d, false, DmiPanel.BACKGROUND_COLOUR, outerRadius, (int)startAngle, (int)endAngle);
            this.drawAnArc(g2d, false, DmiPanel.YELLOW, outerRadius - 1, (int)startAngle, (int)endAngle);
            this.drawAnArc(g2d, true, section.col, outerRadius - innerRadius, (int)startAngle, (int)endAngle);
            this.drawHook(g, section);
        }
        g.drawImage((Image)image, -140, -150, null);
        g2d.dispose();
        if (section.includeHook) {
            this.drawHook(g, section);
        }
    }

    private void drawAnArc(Graphics2D g2, boolean transparent, Color color, int radius, int startAngle, int endAngle) {
        if (transparent) {
            g2.setComposite(AlphaComposite.getInstance(11, 0.0f));
        } else {
            g2.setColor(color);
        }
        g2.fillArc(-radius, -radius, 2 * radius, 2 * radius, -startAngle + (transparent ? 2 : 0), -endAngle - (transparent ? 4 : 0));
    }

    private void drawTicksAndDigits(Graphics2D g2, float halfFaceSize) {
        Font sizedFont = new Font("Helvetica", 1, 18);
        g2.setFont(sizedFont);
        FontMetrics fontM = g2.getFontMetrics(sizedFont);
        g2.setColor(Color.WHITE);
        for (int j = 0; j <= this.maxSpeed; j += 10) {
            float i = this.getSpeedAngle(j) + 126.0f;
            log.debug("angle is {}", (Object)Float.valueOf(i));
            if (j >= 0 && j % this.majorSpeedGap != 0) {
                g2.drawLine(this.dotX(halfFaceSize, i), this.dotY(halfFaceSize, i), this.dotX(halfFaceSize - 15.0f, i), this.dotY(halfFaceSize - 15.0f, i));
                continue;
            }
            g2.drawLine(this.dotX(halfFaceSize, i), this.dotY(halfFaceSize, i), this.dotX(halfFaceSize - 25.0f, i), this.dotY(halfFaceSize - 25.0f, i));
            if (this.majorSpeedGap > 20 && j > 201 && j % 100 != 0) continue;
            String dashSpeed = Integer.toString(j);
            int xOffset = fontM.stringWidth(dashSpeed);
            int yOffset = fontM.getHeight();
            g2.drawString(dashSpeed, this.dotX(halfFaceSize - 40.0f, i) - xOffset / 2, this.dotY(halfFaceSize - 40.0f, i) + yOffset / 4);
        }
    }

    private void drawCentreCircle(Graphics2D g2) {
        g2.setColor(this.centreCircleAndDialColor);
        int dotSize = 20;
        g2.fillOval(-dotSize, -dotSize, dotSize * 2, dotSize * 2);
        String speedString = this.getSpeedString(this.speed);
        Font digitsSizedFont = new Font("Helvetica", 1, 22);
        g2.setFont(digitsSizedFont);
        g2.setColor(this.centreCircleAndDialColor == DmiPanel.RED ? Color.WHITE : Color.BLACK);
        FontMetrics digitsFontM = g2.getFontMetrics(digitsSizedFont);
        if (this.p.getSimplePreferenceState(DmiPanel.PROPERTY_CENTRE_TEXT)) {
            g2.drawString(speedString, -digitsFontM.stringWidth(speedString) / 2, 7);
        } else {
            g2.drawString(speedString, 18 - digitsFontM.stringWidth(speedString), 7);
        }
    }

    private String getSpeedString(float speed) {
        if (speed > 0.0f) {
            return String.valueOf(Math.max(1, Math.round(speed)));
        }
        return "0";
    }

    private void drawPointer(Graphics2D g2) {
        float speedAngle = this.getSpeedAngle(this.speed);
        double speedAngleRadians = Math.toRadians(speedAngle - 144.0f);
        for (int i = 0; i < this.scaledPointerX.length; ++i) {
            this.rotatedPointerX[i] = (int)((double)this.scaledPointerX[i] * Math.cos(speedAngleRadians) - (double)this.scaledPointerY[i] * Math.sin(speedAngleRadians));
            this.rotatedPointerY[i] = (int)((double)this.scaledPointerX[i] * Math.sin(speedAngleRadians) + (double)this.scaledPointerY[i] * Math.cos(speedAngleRadians));
        }
        this.scaledPointerHand = new Polygon(this.rotatedPointerX, this.rotatedPointerY, this.rotatedPointerX.length);
        g2.setColor(this.centreCircleAndDialColor);
        g2.fillPolygon(this.scaledPointerHand);
    }

    private void drawSpeedUnit(Graphics2D g2) {
        if (this.displaySpeedUnit.isBlank()) {
            return;
        }
        Font unitsSizedFont = new Font("Helvetica", 1, 16);
        g2.setFont(unitsSizedFont);
        g2.setColor(DmiPanel.GREY);
        FontMetrics unitsFontM = g2.getFontMetrics(unitsSizedFont);
        g2.drawString(this.displaySpeedUnit, -unitsFontM.stringWidth(this.displaySpeedUnit) / 2, 50);
    }

    private void drawTargetAdviceSpeed(Graphics2D g2) {
        log.debug("targetAS {}", (Object)Float.valueOf(this.targetAdviceSpeed));
        if (this.targetAdviceSpeed < 0.0f) {
            return;
        }
        g2.setColor(DmiPanel.MEDIUM_GREY);
        float i = this.getSpeedAngle(this.targetAdviceSpeed) + 126.0f;
        g2.fillOval(this.dotX(111.0f, i) - 5, this.dotY(111.0f, i) - 5, 10, 10);
    }

    private float getSpeedAngle(float speed) {
        float angleForSpeed1 = 288.0f / (float)this.maxSpeed;
        if (this.maxSpeed > 299) {
            angleForSpeed1 *= (float)this.maxSpeed / (200.0f + ((float)this.maxSpeed - 200.0f) / 2.0f);
            if (speed >= 200.0f) {
                return angleForSpeed1 * 200.0f + angleForSpeed1 * (speed - 200.0f) / 2.0f;
            }
        }
        return angleForSpeed1 * speed;
    }

    private int dotX(float radius, float angle) {
        return (int)Math.round((double)radius * Math.cos(Math.toRadians(angle)));
    }

    private int dotY(float radius, float angle) {
        return (int)Math.round((double)radius * Math.sin(Math.toRadians(angle)));
    }

    protected void update(float speed) {
        if (speed > (float)this.maxSpeed) {
            log.debug("add code here to move scale up");
        }
        this.speed = speed;
        this.repaint();
    }

    protected void setDisplaySpeedUnit(String newVal) {
        this.displaySpeedUnit = newVal;
        this.repaint();
    }

    protected void setMaxDialSpeed(int newSpd) {
        this.maxSpeed = newSpd;
        this.majorSpeedGap = newSpd > 251 ? 50 : 20;
        this.repaint();
    }

    protected void setCentreCircleAndDialColor(Color newColor) {
        this.centreCircleAndDialColor = newColor;
    }

    protected void setCsgSections(List<DmiCircularSpeedGuideSection> list) {
        this.csgSectionList.clear();
        this.csgSectionList.addAll(list);
        this.repaint();
    }

    protected void setTargetAdviceSpeed(int newVal) {
        this.targetAdviceSpeed = newVal;
        this.repaint();
    }
}

