/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.jython;

import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jynstrument
extends JPanel {
    private Object mContext;
    private String jythonFile;
    private String jynstrumentFolder;
    private String className;
    private JPopupMenu myPopUpMenu;
    private static final Logger log = LoggerFactory.getLogger(Jynstrument.class);

    public Object getContext() {
        return this.mContext;
    }

    public void setContext(Object context) {
        this.mContext = context;
    }

    public String getJythonFile() {
        return this.jythonFile;
    }

    public void setJythonFile(String jythonFile) {
        this.jythonFile = jythonFile;
    }

    public String getFolder() {
        return this.jynstrumentFolder;
    }

    public void setFolder(String jynstrumentFolder) {
        this.jynstrumentFolder = jynstrumentFolder;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void exit() {
        Container cnt = this.getParent();
        log.debug("getParent() is {}", (Object)cnt);
        if (cnt != null) {
            cnt.remove(this);
            cnt.repaint();
        }
        this.quit();
        this.setPopUpMenu(null);
    }

    public boolean validateContext() {
        if (this.getExpectedContextClassName() == null || this.mContext == null) {
            return false;
        }
        try {
            return Class.forName(this.getExpectedContextClassName()).isAssignableFrom(this.mContext.getClass());
        }
        catch (ClassNotFoundException e) {
            log.error("Class {} not found.", (Object)this.getExpectedContextClassName(), (Object)e);
            return false;
        }
    }

    public abstract String getExpectedContextClassName();

    public abstract void init();

    protected abstract void quit();

    public JPopupMenu getPopUpMenu() {
        return this.myPopUpMenu;
    }

    public void setPopUpMenu(JPopupMenu myPopUpMenu) {
        this.myPopUpMenu = myPopUpMenu;
    }

    public void setXml(Element e) {
    }

    public Element getXml() {
        return null;
    }
}

