/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.jython;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jmri.jmrit.jython.Jynstrument;
import jmri.jmrit.jython.JynstrumentPopupMenu;
import jmri.script.JmriScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JynstrumentFactory {
    private static final String instanceName = "jynstrumentObjectInstance";
    private static final Logger log = LoggerFactory.getLogger(JynstrumentFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Should crash if missing ScriptEngine dependencies are not present")
    public static Jynstrument createInstrument(String path, Object context) {
        Jynstrument jyns;
        String className = JynstrumentFactory.validate(path);
        if (className == null) {
            File f = new File(path);
            String parentPath = f.getParent();
            className = JynstrumentFactory.validate(parentPath);
            if (className == null) {
                log.error("Invalid Jynstrument, neither {} or {} are usable", (Object)path, (Object)parentPath);
                return null;
            }
            path = parentPath;
        }
        String jyFile = path + File.separator + className + ".py";
        ScriptEngine engine = JmriScriptEngineManager.getDefault().getEngine("jython");
        try (FileReader fr = new FileReader(jyFile);){
            engine.eval(fr);
            engine.eval("jynstrumentObjectInstance = " + className + "()");
            jyns = (Jynstrument)engine.get(instanceName);
            engine.eval("del jynstrumentObjectInstance");
        }
        catch (IOException | ScriptException ex) {
            log.error("Exception while creating Jynstrument", (Throwable)ex);
            return null;
        }
        jyns.setClassName(className);
        jyns.setContext(context);
        if (!jyns.validateContext()) {
            log.error("Invalid context for Jynstrument, host is {} and {} kind of host is expected", context.getClass(), (Object)jyns.getExpectedContextClassName());
            return null;
        }
        jyns.setJythonFile(jyFile);
        jyns.setFolder(path);
        jyns.setPopUpMenu(new JynstrumentPopupMenu(jyns));
        jyns.init();
        return jyns;
    }

    private static String validate(String path) {
        File f;
        if (path == null) {
            log.error("Path is null");
            return null;
        }
        if (path.length() - 4 < 0) {
            log.error("File name too short (should at least end with .jyn) (got {})", (Object)path);
            return null;
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - File.separator.length());
        }
        if (!(f = new File(path)).isDirectory()) {
            log.debug("Not a directory, trying parent");
            return null;
        }
        if (!path.toLowerCase().endsWith(".jyn")) {
            log.debug("Not an instrument (folder name not ending with .jyn) (got {})", (Object)path);
            return null;
        }
        String[] children = f.list();
        String className = null;
        if (children == null) {
            log.error("Didn't find any files in {}", (Object)f);
            return className;
        }
        String assumedClassName = f.getName().substring(0, f.getName().length() - 4);
        for (String c : children) {
            if (c.compareToIgnoreCase(assumedClassName + ".py") != 0) continue;
            return assumedClassName;
        }
        log.warn("Coulnd't find best candidate ({}), reverting to first one", (Object)(assumedClassName + ".py"));
        for (String c : children) {
            if (c.substring(c.length() - 3).compareToIgnoreCase(".py") != 0) continue;
            className = c.substring(0, c.length() - 3);
        }
        log.warn("Using {}", className);
        return className;
    }
}

