/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.jython;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jmri.jmrit.jython.Jynstrument;
import jmri.jmrit.jython.JythonWindow;

public class JynstrumentPopupMenu
extends JPopupMenu {
    private static final ResourceBundle jythonBundle = ResourceBundle.getBundle("jmri/jmrit/jython/Bundle");
    Jynstrument jynstrument;

    public JynstrumentPopupMenu(Jynstrument it) {
        super(it.getName());
        this.jynstrument = it;
        this.initMenu();
        it.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                Component cmp;
                for (cmp = e.getComponent(); cmp != null && !(cmp instanceof Jynstrument); cmp = cmp.getParent()) {
                }
                if (cmp == null) {
                    return;
                }
                Jynstrument it = (Jynstrument)cmp;
                if (e.isPopupTrigger()) {
                    it.getPopUpMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private void initMenu() {
        JMenuItem quitMenuItem = new JMenuItem(jythonBundle.getString("JynstrumentPopupMenuQuit"));
        quitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JynstrumentPopupMenu.this.jynstrument.exit();
                JynstrumentPopupMenu.this.jynstrument = null;
            }
        });
        this.add(quitMenuItem);
        this.add(new JythonWindow(jythonBundle.getString("JynstrumentPopupMenuDebug")));
        this.addSeparator();
    }
}

