/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.jython;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.jython.Bundle;
import jmri.script.swing.ScriptOutput;
import jmri.util.JmriJFrame;

public class JythonWindow
extends AbstractAction {
    private JTextArea area;
    private JFrame f;
    private JCheckBox autoScroll;
    private UserPreferencesManager pref;
    private JButton clearButton;
    public static final String alwaysOnTopCheck = JythonWindow.class.getName() + ".alwaysOnTop";
    public static final String alwaysScrollCheck = JythonWindow.class.getName() + ".alwaysScroll";
    protected JCheckBox alwaysOnTopCheckBox = new JCheckBox();

    public JythonWindow(String name) {
        super(name);
    }

    public JythonWindow() {
        super("Script Output Window");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        this.f = new JmriJFrame(Bundle.getMessage("TitleOutputFrame"));
        this.area = new JTextArea(ScriptOutput.getDefault().getOutputArea().getDocument(), null, 12, 50);
        this.f.getContentPane().add((Component)new JScrollPane(this.area, 22, 30), "Center");
        JPanel p = new JPanel();
        this.clearButton = new JButton(Bundle.getMessage("ButtonClear"));
        p.add(this.clearButton);
        this.autoScroll = new JCheckBox(Bundle.getMessage("CheckBoxAutoScroll"), true);
        p.add(this.autoScroll);
        this.autoScroll.setSelected(this.pref.getSimplePreferenceState(alwaysScrollCheck));
        this.alwaysOnTopCheckBox.setText(Bundle.getMessage("WindowAlwaysOnTop"));
        this.alwaysOnTopCheckBox.setVisible(true);
        this.alwaysOnTopCheckBox.setToolTipText(Bundle.getMessage("WindowAlwaysOnTopToolTip"));
        this.alwaysOnTopCheckBox.setSelected(this.pref.getSimplePreferenceState(alwaysOnTopCheck));
        p.add(this.alwaysOnTopCheckBox);
        this.f.setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
        this.autoScroll.addItemListener(new ItemListener(){
            JTextArea ta;
            {
                this.ta = JythonWindow.this.area;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JythonWindow.this.doAutoScroll(this.ta, true);
                    JythonWindow.this.pref.setSimplePreferenceState(alwaysScrollCheck, JythonWindow.this.autoScroll.isSelected());
                }
            }
        });
        this.alwaysOnTopCheckBox.addActionListener(ae -> {
            this.f.setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
            this.pref.setSimplePreferenceState(alwaysOnTopCheck, this.alwaysOnTopCheckBox.isSelected());
        });
        this.clearButton.addActionListener(ae -> this.area.setText(""));
        this.f.getContentPane().add((Component)p, "Last");
        int size = this.area.getFont().getSize();
        this.area.setFont(new Font("Monospaced", 0, size));
        this.area.getDocument().addDocumentListener(new DocumentListener(){
            JTextArea ta;
            JCheckBox chk;
            {
                this.ta = JythonWindow.this.area;
                this.chk = JythonWindow.this.autoScroll;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                JythonWindow.this.doAutoScroll(this.ta, this.chk.isSelected());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JythonWindow.this.doAutoScroll(this.ta, this.chk.isSelected());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JythonWindow.this.doAutoScroll(this.ta, this.chk.isSelected());
            }
        });
        this.doAutoScroll(this.area, true);
        this.f.pack();
        this.f.setVisible(true);
    }

    private void doAutoScroll(JTextArea ta, boolean scroll) {
        if (scroll) {
            ta.setCaretPosition(ta.getText().length());
        }
    }

    public JFrame getFrame() {
        return this.f;
    }
}

