/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.BeanSetting;
import jmri.NamedBean;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.TrainOrder;
import jmri.jmrit.logix.Warrant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOrder {
    private int _index;
    private OBlock _block;
    private String _pathName;
    private String _entryName;
    private String _exitName;
    private float _pathLength;
    private static final Logger log = LoggerFactory.getLogger(BlockOrder.class);

    public BlockOrder(@Nonnull OBlock block) {
        this._block = block;
    }

    public BlockOrder(@Nonnull OBlock block, String path, String entry, String exit) {
        this(block);
        this._pathName = path;
        this._entryName = entry;
        this._exitName = exit;
    }

    protected BlockOrder(@Nonnull BlockOrder bo) {
        this._index = bo.getIndex();
        this._block = bo.getBlock();
        this._pathName = bo.getPathName();
        this._entryName = bo.getEntryName();
        this._exitName = bo.getExitName();
    }

    public void setIndex(int idx) {
        this._index = idx;
    }

    public int getIndex() {
        return this._index;
    }

    protected void setEntryName(String name) {
        this._entryName = name;
    }

    public String getEntryName() {
        return this._entryName;
    }

    protected void setExitName(String name) {
        this._exitName = name;
    }

    public String getExitName() {
        return this._exitName;
    }

    protected void setPathName(String path) {
        this._pathName = path;
    }

    public String getPathName() {
        return this._pathName;
    }

    protected OPath getPath() {
        return this._block.getPathByName(this._pathName);
    }

    protected String setPath(Warrant warrant) {
        Portal p;
        String msg = this._block.setPath(this.getPathName(), warrant);
        if (msg == null && (p = this.getEntryPortal()) != null) {
            p.setEntryState(this._block);
        }
        return msg;
    }

    @Nonnull
    protected TrainOrder allocatePaths(@Nonnull Warrant warrant, boolean allocate) {
        if (this._pathName == null) {
            log.error("setPaths({}) - {}", (Object)warrant.getDisplayName(), (Object)Bundle.getMessage("NoPaths", this._block.getDisplayName()));
            return new TrainOrder(Warrant.Stop, TrainOrder.Cause.ERROR, this._index, this._index, Bundle.getMessage("NoPaths", this._block.getDisplayName()));
        }
        log.debug("{}: calls allocatePaths() in block \"{}\" for path \"{}\". _index={}", new Object[]{warrant.getDisplayName(), this._block.getDisplayName(), this._pathName, this._index});
        TrainOrder to = this.findStopCondition(this, warrant);
        if (to != null && Warrant.Stop.equals(to._speedType)) {
            return to;
        }
        String msg = this._block.allocate(warrant);
        if (msg != null) {
            return new TrainOrder(Warrant.Stop, TrainOrder.Cause.ERROR, this._index, this._index, msg);
        }
        BlockOrder bo1 = warrant.getBlockOrderAt(this._index + 1);
        if (bo1 != null) {
            OBlock nextBlock = bo1.getBlock();
            TrainOrder to1 = this.findStopCondition(bo1, warrant);
            if (to1 == null || !Warrant.Stop.equals(to1._speedType)) {
                if (allocate) {
                    nextBlock.allocate(warrant);
                    nextBlock.showAllocated(warrant, bo1.getPathName());
                }
            } else {
                OPath path1 = this.getPath();
                Portal exit = this.getExitPortal();
                msg = this.pathsConnect(path1, exit, bo1.getBlock());
            }
            if (msg != null) {
                return new TrainOrder(Warrant.Stop, to1 != null ? to1._cause : TrainOrder.Cause.WARRANT, bo1.getIndex(), this._index, msg);
            }
        }
        if (allocate && (msg = this.setPath(warrant)) != null) {
            return new TrainOrder(Warrant.Stop, TrainOrder.Cause.ERROR, this._index, this._index, msg);
        }
        if (to != null) {
            return to;
        }
        return new TrainOrder(null, TrainOrder.Cause.NONE, this._index, this._index, null);
    }

    @CheckForNull
    private TrainOrder findStopCondition(@Nonnull BlockOrder bo, @Nonnull Warrant warrant) {
        String speedType;
        OBlock block = bo.getBlock();
        Warrant w = block.getWarrant();
        if (w != null && !warrant.equals(w)) {
            return new TrainOrder(Warrant.Stop, TrainOrder.Cause.WARRANT, bo.getIndex(), bo.getIndex(), Bundle.getMessage("AllocatedToWarrant", w.getDisplayName(), block.getDisplayName(), w.getTrainName()));
        }
        if (block.isOccupied()) {
            String rogue = (String)block.getValue();
            if (rogue == null) {
                rogue = Bundle.getMessage("unknownTrain");
            }
            if (!rogue.equals(warrant.getTrainName())) {
                return new TrainOrder(Warrant.Stop, TrainOrder.Cause.OCCUPY, bo.getIndex(), bo.getIndex(), Bundle.getMessage("blockInUse", rogue, block.getDisplayName()));
            }
        }
        if ((speedType = BlockOrder.getPermissibleSpeedAt(bo)) != null) {
            String msg = Warrant.Stop.equals(speedType) ? Bundle.getMessage("BlockStopAspect", block.getDisplayName(), speedType) : Bundle.getMessage("BlockSpeedAspect", block.getDisplayName(), speedType);
            return new TrainOrder(speedType, TrainOrder.Cause.SIGNAL, bo.getIndex(), bo.getIndex(), msg);
        }
        return null;
    }

    @CheckForNull
    protected String pathsConnect(@Nonnull OPath path1, @CheckForNull Portal exit, @CheckForNull OBlock block) {
        if (exit == null || block == null) {
            return null;
        }
        OPath path2 = block.getPath();
        if (path2 == null) {
            return null;
        }
        for (BeanSetting bs1 : path1.getSettings()) {
            for (BeanSetting bs2 : path2.getSettings()) {
                if (!bs1.getBean().equals(bs2.getBean())) continue;
                if (log.isDebugEnabled()) {
                    if (bs1.equals(bs2)) {
                        log.debug("Path \"{}\" in block \"{}\" and \"{}\" in block \"{}\" agree on setting of shared turnout \"{}\"", new Object[]{path1.getName(), this._block.getDisplayName(), path2.getName(), block.getDisplayName(), bs1.getBean().getDisplayName()});
                    } else {
                        log.debug("Path \"{}\" in block \"{}\" and \"{}\" in block \"{}\" have opposed settings of shared turnout \"{}\"", new Object[]{path1.getName(), this._block.getDisplayName(), path2.getName(), block.getDisplayName(), bs1.getBean().getDisplayName()});
                    }
                }
                return Bundle.getMessage("SharedTurnout", bs1.getBean().getDisplayName(), this._block.getDisplayName(), block.getDisplayName());
            }
        }
        return null;
    }

    protected static String getPermissibleSpeedAt(BlockOrder bo) {
        String speedType = bo.getPermissibleEntranceSpeed();
        if (speedType != null) {
            log.debug("getPermissibleSpeedAt(): \"{}\" Signal speed= {}", (Object)bo.getBlock().getDisplayName(), (Object)speedType);
        } else {
            speedType = bo.getBlock().getBlockSpeed();
            if (speedType.equals("")) {
                speedType = null;
            }
            if (speedType != null) {
                log.debug("getPermissibleSpeedAt(): \"{}\" Block speed= {}", (Object)bo.getBlock().getDisplayName(), (Object)speedType);
            }
        }
        return speedType;
    }

    protected void setPathLength(float len) {
        this._pathLength = len;
    }

    protected float getPathLength() {
        if (this._pathLength <= 0.0f) {
            OPath p = this.getPath();
            this._pathLength = p != null ? p.getLengthMm() : 0.0f;
        }
        return this._pathLength;
    }

    protected void setBlock(@Nonnull OBlock block) {
        this._block = block;
    }

    @Nonnull
    public OBlock getBlock() {
        return this._block;
    }

    @CheckForNull
    protected Portal getEntryPortal() {
        if (this._entryName == null) {
            return null;
        }
        return this._block.getPortalByName(this._entryName);
    }

    @CheckForNull
    protected Portal getExitPortal() {
        if (this._exitName == null) {
            return null;
        }
        return this._block.getPortalByName(this._exitName);
    }

    protected String getPermissibleEntranceSpeed() {
        Portal portal = this._block.getPortalByName(this.getEntryName());
        if (portal != null) {
            return portal.getPermissibleSpeed(this._block, true);
        }
        return null;
    }

    protected float getEntranceSpace() {
        Portal portal = this._block.getPortalByName(this.getEntryName());
        if (portal != null) {
            return portal.getEntranceSpaceForBlock(this._block);
        }
        return 0.0f;
    }

    @CheckForNull
    protected NamedBean getSignal() {
        Portal portal = this.getEntryPortal();
        if (portal != null) {
            return portal.getSignalProtectingBlock(this._block);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BlockOrder: Block \"");
        sb.append(this._block.getDisplayName());
        sb.append("\" has Path \"");
        sb.append(this._pathName);
        sb.append("\" with Portals, entry= \"");
        sb.append(this._entryName);
        sb.append("\" and exit= \"");
        sb.append(this._exitName);
        sb.append("\"");
        return sb.toString();
    }
}

