/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import jmri.DccThrottle;
import jmri.JmriException;
import jmri.Memory;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.jmrit.logix.WarrantTableModel;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Engineer
extends Thread
implements PropertyChangeListener {
    private int _idxCurrentCommand;
    private ThrottleSetting _currentCommand;
    private long _commandTime = 0L;
    private int _idxSkipToSpeedCommand;
    private float _normalSpeed = 0.0f;
    private String _speedType = "Normal";
    private float _timeRatio = 1.0f;
    private boolean _abort = false;
    private boolean _halt = false;
    private boolean _stopPending = false;
    private boolean _waitForClear = false;
    private boolean _waitForSensor = false;
    private boolean _runOnET = false;
    private boolean _setRunOnET = false;
    protected DccThrottle _throttle;
    private final Warrant _warrant;
    private final List<ThrottleSetting> _commands;
    private Sensor _waitSensor;
    private int _sensorWaitState;
    private final Object _rampLockObject = new Object();
    private final Object _synchLockObject = new Object();
    private final Object _clearLockObject = new Object();
    private boolean _atHalt = false;
    private boolean _atClear = false;
    private final SpeedUtil _speedUtil;
    private OBlock _synchBlock = null;
    private Thread _checker = null;
    private ThrottleRamp _ramp;
    private boolean _holdRamp = false;
    private boolean _isRamping = false;
    private static final Logger log = LoggerFactory.getLogger(Engineer.class);

    Engineer(Warrant warrant, DccThrottle throttle) {
        this._warrant = warrant;
        this._throttle = throttle;
        this._speedUtil = warrant.getSpeedUtil();
        this._commands = this._warrant.getThrottleCommands();
        this._idxCurrentCommand = 0;
        this._currentCommand = this._commands.get(this._idxCurrentCommand);
        this._idxSkipToSpeedCommand = 0;
        this._waitForSensor = false;
        this.setName("Engineer(" + this._warrant.getTrainName() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="waits may be indefinite until satisfied or thread aborted")
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Engineer started warrant {} _throttle= {}", (Object)this._warrant.getDisplayName(), (Object)this._throttle.getClass().getName());
        }
        int cmdBlockIdx = 0;
        while (this._idxCurrentCommand < this._commands.size()) {
            int idx;
            while (this._idxSkipToSpeedCommand > this._idxCurrentCommand) {
                if (log.isDebugEnabled()) {
                    ThrottleSetting ts = this._commands.get(this._idxCurrentCommand);
                    log.debug("{}: Skip Cmd #{}: {} Warrant", new Object[]{this._warrant.getDisplayName(), this._idxCurrentCommand + 1, ts});
                }
                ++this._idxCurrentCommand;
            }
            if (this._idxCurrentCommand == this._commands.size()) break;
            this._currentCommand = this._commands.get(this._idxCurrentCommand);
            long cmdWaitTime = this._currentCommand.getTime();
            ThrottleSetting.Command command = this._currentCommand.getCommand();
            this._runOnET = this._setRunOnET;
            if (command.hasBlockName() && (idx = this._warrant.getIndexOfBlockAfter((OBlock)this._currentCommand.getBean(), cmdBlockIdx)) >= 0) {
                cmdBlockIdx = idx;
            }
            if (cmdBlockIdx < this._warrant.getCurrentOrderIndex() || command.equals((Object)ThrottleSetting.Command.NOOP) && cmdBlockIdx <= this._warrant.getCurrentOrderIndex()) {
                cmdWaitTime = Math.min(cmdWaitTime, 200L);
                if (log.isDebugEnabled()) {
                    log.debug("{}: Train reached block \"{}\" before script et={}ms", new Object[]{this._warrant.getDisplayName(), this._warrant.getCurrentBlockName(), this._currentCommand.getTime()});
                }
            }
            if (this._abort) break;
            long cmdStart = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("{}: Start Cmd #{} for block \"{}\" currently in \"{}\". wait {}ms to do cmd {}", new Object[]{this._warrant.getDisplayName(), this._idxCurrentCommand + 1, this._currentCommand.getBeanDisplayName(), this._warrant.getCurrentBlockName(), cmdWaitTime, command});
            }
            Object object = this;
            synchronized (object) {
                if (!"Normal".equals(this._speedType)) {
                    cmdWaitTime = (long)((float)cmdWaitTime * this._timeRatio);
                }
                try {
                    if (cmdWaitTime > 0L) {
                        this.wait(cmdWaitTime);
                    }
                }
                catch (InterruptedException ie) {
                    log.debug("InterruptedException during time wait", (Throwable)ie);
                    this._warrant.debugInfo();
                    Thread.currentThread().interrupt();
                    this._abort = true;
                }
                catch (IllegalArgumentException iae) {
                    log.error("At time wait", (Throwable)iae);
                }
            }
            if (this._abort) break;
            if (!this._runOnET && cmdBlockIdx > this._warrant.getCurrentOrderIndex()) {
                object = this._synchLockObject;
                synchronized (object) {
                    this._synchBlock = this._warrant.getBlockAt(cmdBlockIdx);
                    this._warrant.fireRunStatus("WaitForSync", this._idxCurrentCommand - 1, this._idxCurrentCommand);
                    if (log.isDebugEnabled()) {
                        log.debug("{}: Wait for train to enter \"{}\".", (Object)this._warrant.getDisplayName(), (Object)this._synchBlock.getDisplayName());
                    }
                    try {
                        this._synchLockObject.wait();
                        this._synchBlock = null;
                    }
                    catch (InterruptedException ie) {
                        log.debug("InterruptedException during _waitForSync", (Throwable)ie);
                        this._warrant.debugInfo();
                        Thread.currentThread().interrupt();
                        this._abort = true;
                    }
                }
                if (this._abort) break;
            }
            object = this._clearLockObject;
            synchronized (object) {
                if (this._waitForClear) {
                    try {
                        this._atClear = true;
                        if (log.isDebugEnabled()) {
                            log.debug("{}: Waiting for clearance. _waitForClear= {} _halt= {} at block \"{}\" Cmd#{}.", new Object[]{this._warrant.getDisplayName(), this._waitForClear, this._halt, this._warrant.getBlockAt(cmdBlockIdx).getDisplayName(), this._idxCurrentCommand + 1});
                        }
                        this._clearLockObject.wait();
                        this._waitForClear = false;
                        this._atClear = false;
                    }
                    catch (InterruptedException ie) {
                        log.debug("InterruptedException during _atClear", (Throwable)ie);
                        this._warrant.debugInfo();
                        Thread.currentThread().interrupt();
                        this._abort = true;
                    }
                }
            }
            if (this._abort) break;
            object = this;
            synchronized (object) {
                if (this._halt) {
                    try {
                        this._atHalt = true;
                        if (log.isDebugEnabled()) {
                            log.debug("{}: Waiting to Resume. _halt= {}, _waitForClear= {}, Block \"{}\".", new Object[]{this._warrant.getDisplayName(), this._halt, this._waitForClear, this._warrant.getBlockAt(cmdBlockIdx).getDisplayName()});
                        }
                        this.wait();
                        this._halt = false;
                        this._atHalt = false;
                    }
                    catch (InterruptedException ie) {
                        log.debug("InterruptedException during _atHalt", (Throwable)ie);
                        this._warrant.debugInfo();
                        Thread.currentThread().interrupt();
                        this._abort = true;
                    }
                }
            }
            if (this._abort) break;
            object = this;
            synchronized (object) {
                while (this._isRamping || this._holdRamp) {
                    int idx2 = this._idxCurrentCommand;
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("{}: Waiting for ramp to finish at Cmd #{}.", (Object)this._warrant.getDisplayName(), (Object)(this._idxCurrentCommand + 1));
                        }
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        this._warrant.debugInfo();
                        Thread.currentThread().interrupt();
                        this._abort = true;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("{}: Cmd #{} held for {}ms. {}", new Object[]{this._warrant.getDisplayName(), idx2 + 1, System.currentTimeMillis() - cmdStart, this._currentCommand});
                }
                if (this._idxSkipToSpeedCommand <= this._idxCurrentCommand) {
                    this.executeComand(this._currentCommand, System.currentTimeMillis() - cmdStart);
                    ++this._idxCurrentCommand;
                }
            }
        }
        this.setSpeed(0.0f);
        this._warrant.stopWarrant(this._abort, true);
    }

    private void executeComand(ThrottleSetting ts, long et) {
        ThrottleSetting.Command command = ts.getCommand();
        ThrottleSetting.CommandValue cmdVal = ts.getValue();
        switch (command) {
            case SPEED: {
                this._normalSpeed = cmdVal.getFloat();
                float speedMod = this._speedUtil.modifySpeed(this._normalSpeed, this._speedType);
                if (this._normalSpeed > speedMod) {
                    float trackSpeed = this._speedUtil.getTrackSpeed(speedMod);
                    this._timeRatio = this._speedUtil.getTrackSpeed(this._normalSpeed) / trackSpeed;
                    this._speedUtil.speedChange(speedMod);
                    this.setSpeed(speedMod);
                    break;
                }
                this._timeRatio = 1.0f;
                this._speedUtil.speedChange(this._normalSpeed);
                this.setSpeed(this._normalSpeed);
                break;
            }
            case NOOP: {
                break;
            }
            case SET_SENSOR: {
                ThreadingUtil.runOnGUIEventually(() -> this.setSensor(ts.getNamedBeanHandle(), cmdVal));
                break;
            }
            case FKEY: {
                this.setFunction(ts.getKeyNum(), cmdVal.getType());
                break;
            }
            case FORWARD: {
                this.setForward(cmdVal.getType());
                break;
            }
            case LATCHF: {
                this.setFunctionMomentary(ts.getKeyNum(), cmdVal.getType());
                break;
            }
            case WAIT_SENSOR: {
                this.waitForSensor(ts.getNamedBeanHandle(), cmdVal);
                break;
            }
            case RUN_WARRANT: {
                ThreadingUtil.runOnGUIEventually(() -> this.runWarrant(ts.getNamedBeanHandle(), cmdVal));
                break;
            }
            case SPEEDSTEP: {
                break;
            }
            case SET_MEMORY: {
                ThreadingUtil.runOnGUIEventually(() -> this.setMemory(ts.getNamedBeanHandle(), cmdVal));
                break;
            }
        }
        this._commandTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("{}: Cmd #{} done. et={}. {}", new Object[]{this._warrant.getDisplayName(), this._idxCurrentCommand + 1, et, ts});
        }
    }

    protected int getCurrentCommandIndex() {
        return this._idxCurrentCommand;
    }

    private void advanceToCommandIndex(int idx) {
        this._idxSkipToSpeedCommand = idx;
        if (log.isTraceEnabled()) {
            log.debug("advanceToCommandIndex to {} - {}", (Object)(this._idxSkipToSpeedCommand + 1), (Object)this._commands.get(idx));
        }
    }

    protected void setRunOnET(boolean set) {
        if (log.isDebugEnabled() && this._setRunOnET != set) {
            log.debug("{}: setRunOnET {} command #{}", new Object[]{this._warrant.getDisplayName(), set, this._idxCurrentCommand + 1});
        }
        this._setRunOnET = set;
        if (!set) {
            this._runOnET = false;
        }
    }

    protected boolean getRunOnET() {
        return this._setRunOnET;
    }

    protected OBlock getSynchBlock() {
        return this._synchBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearWaitForSync(OBlock block) {
        if (this._synchBlock != null) {
            Object object = this._synchLockObject;
            synchronized (object) {
                if (block.equals(this._synchBlock)) {
                    this._synchLockObject.notifyAll();
                    if (log.isDebugEnabled()) {
                        log.debug("{}: clearWaitForSync from block \"{}\". notifyAll() called.  isRamping()={}", new Object[]{this._warrant.getDisplayName(), block.getDisplayName(), this.isRamping()});
                    }
                    return;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: clearWaitForSync from block \"{}\". _synchBlock= {} SpeedState={} _atClear={} _atHalt={}", new Object[]{this._warrant.getDisplayName(), block.getDisplayName(), this._synchBlock == null ? "null" : this._synchBlock.getDisplayName(), this.getSpeedState(), this._atClear, this._atHalt});
        }
    }

    private static void setFrameStatusText(String m, Color c) {
        ThreadingUtil.runOnGUIEventually(() -> WarrantTableFrame.getDefault().setStatusText(m, c, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    protected synchronized void rampSpeedTo(@Nonnull String endSpeedType, int endBlockIdx) {
        float speed = this._speedUtil.modifySpeed(this._normalSpeed, endSpeedType);
        if (log.isDebugEnabled()) {
            log.debug("{}: rampSpeedTo: type= {}, throttle from {} to {}.", new Object[]{this._warrant.getDisplayName(), endSpeedType, Float.valueOf(this.getSpeedSetting()), Float.valueOf(speed)});
        }
        this._speedUtil.speedChange(-1.0f);
        if (endSpeedType.equals(Warrant.EStop)) {
            this.setStop(true);
            return;
        }
        if (endSpeedType.equals(Warrant.Stop) && this.getSpeedSetting() <= 0.0f) {
            this.setStop(false);
            return;
        }
        if (this._isRamping) {
            if (endSpeedType.equals(this._ramp._endSpeedType)) {
                return;
            }
        } else if (speed == this.getSpeedSetting()) {
            this.rampDone(false, endSpeedType, endBlockIdx);
            return;
        }
        if (this._ramp == null) {
            this._ramp = new ThrottleRamp();
            this._ramp.start();
        } else if (this._isRamping) {
            if (this._ramp.duplicate(endSpeedType, endBlockIdx)) {
                return;
            }
            this._holdRamp = true;
            this._ramp.quit(false);
        }
        long time = 0L;
        int pause = 2 * this._speedUtil.getRampTimeIncrement();
        do {
            try {
                this.wait(40L);
                time += 40L;
                this._ramp.quit(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (time <= (long)pause && this._isRamping);
        if (!this._isRamping) {
            if (Warrant._trace || log.isDebugEnabled()) {
                log.info(Bundle.getMessage("RampStart", this._warrant.getTrainName(), endSpeedType, this._warrant.getCurrentBlockName()));
            }
            this._ramp.setParameters(endSpeedType, endBlockIdx);
            Object object = this._rampLockObject;
            synchronized (object) {
                this._ramp._rampDown = endBlockIdx >= 0 || endSpeedType.equals(Warrant.Stop);
                this._holdRamp = false;
                this.setWaitforClear(true);
                this._rampLockObject.notifyAll();
                log.debug("{}: rampSpeedTo calls notify _rampLockObject", (Object)this._warrant.getDisplayName());
            }
        } else {
            log.error("Can't launch ramp for speed {}! _ramp Thread.State= {}. Waited {}ms", new Object[]{endSpeedType, this._ramp.getState(), time});
            this._warrant.debugInfo();
            this.setSpeedToType(endSpeedType);
            this._ramp.quit(true);
            this._ramp.interrupt();
            this._ramp = null;
        }
    }

    protected boolean isRamping() {
        return this._isRamping;
    }

    private void setIsRamping(boolean set) {
        this._isRamping = set;
    }

    protected String getSpeedType(boolean absolute) {
        if (absolute) {
            if (this.isRamping()) {
                return this._ramp._endSpeedType;
            }
            if (this._waitForClear || this._halt) {
                return Warrant.Stop;
            }
        }
        return this._speedType;
    }

    protected synchronized boolean cancelRamp(boolean die) {
        if (this._ramp != null) {
            if (die) {
                this._ramp.quit(true);
                this._ramp.interrupt();
            } else if (this._isRamping) {
                this._ramp.quit(false);
                return true;
            }
        }
        return false;
    }

    protected void setSpeed(float speed) {
        this._throttle.setSpeedSetting(speed);
        if (!this._abort) {
            this._warrant.fireRunStatus("SpeedChange", null, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: _throttle.setSpeedSetting({}) called, ({}).", new Object[]{this._warrant.getDisplayName(), Float.valueOf(speed), this._speedType});
        }
    }

    protected float getSpeedSetting() {
        float speed = this._throttle.getSpeedSetting();
        if (speed < 0.0f) {
            this._throttle.setSpeedSetting(0.0f);
            speed = this._throttle.getSpeedSetting();
        }
        return speed;
    }

    protected float getScriptSpeed() {
        return this._normalSpeed;
    }

    private void setSpeedRatio(String speedType) {
        if (speedType.equals("Normal")) {
            this._timeRatio = 1.0f;
        } else if (this._normalSpeed > 0.0f) {
            float speedMod = this._speedUtil.modifySpeed(this._normalSpeed, this._speedType);
            if (this._normalSpeed > speedMod) {
                float trackSpeed = this._speedUtil.getTrackSpeed(speedMod);
                this._timeRatio = this._speedUtil.getTrackSpeed(this._normalSpeed) / trackSpeed;
            } else {
                this._timeRatio = 1.0f;
            }
        } else {
            this._timeRatio = 1.0f;
        }
    }

    protected synchronized void setSpeedToType(String speedType) {
        float speed = this.getSpeedSetting();
        if (log.isDebugEnabled()) {
            log.debug("{}: setSpeedToType({}) speed={} scriptSpeed={}", new Object[]{this._warrant.getDisplayName(), speedType, Float.valueOf(speed), Float.valueOf(this._normalSpeed)});
        }
        if (speedType.equals(Warrant.Stop)) {
            this.setStop(false);
            this.advanceToCommandIndex(this._idxCurrentCommand + 1);
        } else if (speedType.equals(Warrant.EStop)) {
            this.setStop(true);
            this.advanceToCommandIndex(this._idxCurrentCommand + 1);
        } else {
            if (speedType.equals(this.getSpeedType(true))) {
                return;
            }
            this._speedType = speedType;
            this.setSpeedRatio(speedType);
            float speedMod = this._speedUtil.modifySpeed(this._normalSpeed, this._speedType);
            this._speedUtil.speedChange(speedMod);
            this.setSpeed(speedMod);
        }
    }

    protected synchronized void setHalt(boolean halt) {
        if (log.isDebugEnabled()) {
            log.debug("{}: setHalt({}): _atHalt= {}, _waitForClear= {}", new Object[]{this._warrant.getDisplayName(), halt, this._atHalt, this._waitForClear});
        }
        if (!halt) {
            this._halt = false;
            if (!this._atClear) {
                log.debug("setHalt calls notify()");
                this.notifyAll();
            }
        } else {
            this._halt = true;
        }
    }

    private long getTimeToNextCommand() {
        if (this._commandTime > 0L) {
            long elapsedTime = System.currentTimeMillis() - this._commandTime;
            return Math.max(0L, this._currentCommand.getTime() - elapsedTime);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWaitforClear(boolean wait) {
        if (log.isDebugEnabled()) {
            log.debug("{}: setWaitforClear({}): _atClear= {}, throttle speed= {}, _halt= {}", new Object[]{this._warrant.getDisplayName(), wait, this._atClear, Float.valueOf(this.getSpeedSetting()), this._halt});
        }
        if (!wait) {
            Object object = this._clearLockObject;
            synchronized (object) {
                log.debug("setWaitforClear calls notify");
                this._waitForClear = false;
                this._clearLockObject.notifyAll();
            }
        } else {
            this._waitForClear = true;
        }
    }

    String debugInfo() {
        StringBuilder info = new StringBuilder("\n");
        info.append(this.getName());
        info.append(" on warrant= ");
        info.append(this._warrant.getDisplayName());
        info.append("\nThread.State= ");
        info.append((Object)this.getState());
        info.append(", isAlive= ");
        info.append(this.isAlive());
        info.append(", isInterrupted= ");
        info.append(this.isInterrupted());
        info.append("\n\tThrottle setting= ");
        info.append(this.getSpeedSetting());
        info.append(", scriptSpeed= ");
        info.append(this.getScriptSpeed());
        info.append(". runstate= ");
        info.append(Warrant.RUN_STATE[this.getRunState()]);
        int cmdIdx = this.getCurrentCommandIndex();
        if (cmdIdx < this._commands.size()) {
            info.append("\n\tCommand #");
            info.append(cmdIdx + 1);
            info.append(": ");
            info.append(this._commands.get(cmdIdx).toString());
        } else {
            info.append("\n\t\tAt last command.");
        }
        info.append("\n\tEngineer flags: _waitForClear= ");
        info.append(this._waitForClear);
        info.append(", _atclear= ");
        info.append(this._atClear);
        info.append(", _halt= ");
        info.append(this._halt);
        info.append(", _atHalt= ");
        info.append(this._atHalt);
        if (this._synchBlock != null) {
            info.append("\n\t\tWaiting for Sync at \"");
            info.append(this._synchBlock.getDisplayName());
        }
        info.append("\"\n\t\t_setRunOnET= ");
        info.append(this._setRunOnET);
        info.append(", _runOnET= ");
        info.append(this._runOnET);
        info.append("\n\t\t_stopPending= ");
        info.append(this._stopPending);
        info.append(", _abort= ");
        info.append(this._abort);
        info.append("\n\t_speedType= \"");
        info.append(this._speedType);
        info.append("\" SpeedState= ");
        info.append(this.getSpeedState().toString());
        info.append("\n\tStack trace:");
        for (StackTraceElement elem : this.getStackTrace()) {
            info.append("\n\t\t");
            info.append(elem.getClassName());
            info.append(".");
            info.append(elem.getMethodName());
            info.append(", line ");
            info.append(elem.getLineNumber());
        }
        if (this._ramp != null) {
            info.append("\n\tRamp Thread.State= ");
            info.append((Object)this._ramp.getState());
            info.append(", isAlive= ");
            info.append(this._ramp.isAlive());
            info.append(", isInterrupted= ");
            info.append(this._ramp.isInterrupted());
            info.append("\n\tRamp flags: _isRamping= ");
            info.append(this._isRamping);
            info.append(", stop= ");
            info.append(this._ramp.stop);
            info.append(", _die= ");
            info.append(this._ramp._die);
            info.append("\n\tRamp Type: ");
            info.append(this._ramp._rampDown ? "DOWN" : "UP");
            info.append(" ramp");
            info.append("\n\t\tEndSpeedType= \"");
            info.append(this._ramp._endSpeedType);
            int endIdx = this._ramp.getEndBlockIndex();
            info.append("\"\n\t\tEndBlockIdx= ");
            info.append(endIdx);
            if (endIdx >= 0) {
                info.append(" EndBlock= \"");
                info.append(this._warrant.getBlockAt(endIdx).getDisplayName());
            }
            info.append("\"");
            info.append("\n\tStack trace:");
            for (StackTraceElement elem : this._ramp.getStackTrace()) {
                info.append("\n\t\t");
                info.append(elem.getClassName());
                info.append(".");
                info.append(elem.getMethodName());
                info.append(", line ");
                info.append(elem.getLineNumber());
            }
        } else {
            info.append("\n\tNo ramp.");
        }
        return info.toString();
    }

    private synchronized void setStop(boolean eStop) {
        float speed = this._throttle.getSpeedSetting();
        if (speed <= 0.0f && (this._waitForClear || this._halt)) {
            return;
        }
        this.cancelRamp(false);
        if (eStop) {
            this.setHalt(true);
            this.setSpeed(-0.1f);
            this.setSpeed(0.0f);
        } else {
            this.setSpeed(0.0f);
            this.setWaitforClear(true);
        }
        log.debug("{}: setStop({}) from speed={} scriptSpeed={}", new Object[]{this._warrant.getDisplayName(), eStop, Float.valueOf(speed), Float.valueOf(this._normalSpeed)});
    }

    protected Warrant.SpeedState getSpeedState() {
        if (this.isRamping()) {
            if (this._ramp._rampDown) {
                return Warrant.SpeedState.RAMPING_DOWN;
            }
            return Warrant.SpeedState.RAMPING_UP;
        }
        return Warrant.SpeedState.STEADY_SPEED;
    }

    protected int getRunState() {
        if (this._stopPending) {
            if (this._halt) {
                return 6;
            }
            return 14;
        }
        if (this._halt) {
            return 1;
        }
        if (this._waitForClear) {
            return 9;
        }
        if (this._waitForSensor) {
            return 10;
        }
        if (this._abort) {
            return 3;
        }
        if (this._synchBlock != null) {
            return 11;
        }
        if (this.isRamping()) {
            return 8;
        }
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="quit is called another thread to clear all ramp waits")
    public void stopRun(boolean abort, boolean turnOffFunctions) {
        if (abort) {
            this._abort = true;
        }
        Object object = this._synchLockObject;
        synchronized (object) {
            this._synchLockObject.notifyAll();
        }
        object = this._clearLockObject;
        synchronized (object) {
            this._clearLockObject.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        this.cancelRamp(true);
        if (this._waitSensor != null) {
            this._waitSensor.removePropertyChangeListener(this);
        }
        if (this._throttle != null) {
            if (this._throttle.getSpeedSetting() > 0.0f) {
                if (abort) {
                    this._throttle.setSpeedSetting(-1.0f);
                }
                this.setSpeed(0.0f);
                if (turnOffFunctions) {
                    this._throttle.setFunction(0, false);
                    this._throttle.setFunction(1, false);
                    this._throttle.setFunction(2, false);
                    this._throttle.setFunction(3, false);
                }
            }
            this._warrant.releaseThrottle(this._throttle);
        }
    }

    private void setForward(ThrottleSetting.ValueType type) {
        if (type == ThrottleSetting.ValueType.VAL_TRUE) {
            this._throttle.setIsForward(true);
        } else if (type == ThrottleSetting.ValueType.VAL_FALSE) {
            this._throttle.setIsForward(false);
        } else {
            throw new IllegalArgumentException("setForward type " + type + " wrong");
        }
    }

    private void setFunction(int cmdNum, ThrottleSetting.ValueType type) {
        if (cmdNum < 0 || cmdNum > 28) {
            throw new IllegalArgumentException("setFunction " + cmdNum + " out of range");
        }
        if (type == ThrottleSetting.ValueType.VAL_ON) {
            this._throttle.setFunction(cmdNum, true);
        } else if (type == ThrottleSetting.ValueType.VAL_OFF) {
            this._throttle.setFunction(cmdNum, false);
        } else {
            throw new IllegalArgumentException("setFunction type " + type + " wrong");
        }
    }

    private void setFunctionMomentary(int cmdNum, ThrottleSetting.ValueType type) {
        if (cmdNum < 0 || cmdNum > 28) {
            log.error("Function value {} out of range", (Object)cmdNum);
            throw new IllegalArgumentException("setFunctionMomentary " + cmdNum + " out of range");
        }
        if (type == ThrottleSetting.ValueType.VAL_ON) {
            this._throttle.setFunctionMomentary(cmdNum, true);
        } else if (type == ThrottleSetting.ValueType.VAL_OFF) {
            this._throttle.setFunctionMomentary(cmdNum, false);
        } else {
            throw new IllegalArgumentException("setFunctionMomentary type " + type + " wrong");
        }
    }

    private void setMemory(NamedBeanHandle<?> handle, ThrottleSetting.CommandValue cmdVal) {
        Object bean = handle.getBean();
        if (!(bean instanceof Memory)) {
            log.error("setMemory: {} not a Memory!", bean);
            return;
        }
        Memory m = (Memory)bean;
        ThrottleSetting.ValueType type = cmdVal.getType();
        if (Warrant._trace || log.isDebugEnabled()) {
            log.info("{} : Set memory", (Object)Bundle.getMessage("setMemory", this._warrant.getTrainName(), m.getDisplayName(), cmdVal.getText()));
        }
        this._warrant.fireRunStatus("MemorySetCommand", type.toString(), m.getDisplayName());
        m.setValue(cmdVal.getText());
    }

    private void setSensor(NamedBeanHandle<?> handle, ThrottleSetting.CommandValue cmdVal) {
        block6: {
            Object bean = handle.getBean();
            if (!(bean instanceof Sensor)) {
                log.error("setSensor: {} not a Sensor!", bean);
                return;
            }
            Sensor s = (Sensor)bean;
            ThrottleSetting.ValueType type = cmdVal.getType();
            try {
                if (Warrant._trace || log.isDebugEnabled()) {
                    log.info("{} : Set Sensor", (Object)Bundle.getMessage("setSensor", this._warrant.getTrainName(), s.getDisplayName(), type.toString()));
                }
                this._warrant.fireRunStatus("SensorSetCommand", type.toString(), s.getDisplayName());
                if (type == ThrottleSetting.ValueType.VAL_ACTIVE) {
                    s.setKnownState(2);
                    break block6;
                }
                if (type == ThrottleSetting.ValueType.VAL_INACTIVE) {
                    s.setKnownState(4);
                    break block6;
                }
                throw new IllegalArgumentException("setSensor type " + type + " wrong");
            }
            catch (JmriException e) {
                log.warn("Exception setting sensor {} in action", (Object)handle.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSensor(NamedBeanHandle<?> handle, ThrottleSetting.CommandValue cmdVal) {
        Object bean;
        if (this._waitSensor != null) {
            this._waitSensor.removePropertyChangeListener(this);
        }
        if (!((bean = handle.getBean()) instanceof Sensor)) {
            log.error("setSensor: {} not a Sensor!", bean);
            return;
        }
        this._waitSensor = (Sensor)bean;
        ThrottleSetting.ValueType type = cmdVal.getType();
        if (type == ThrottleSetting.ValueType.VAL_ACTIVE) {
            this._sensorWaitState = 2;
        } else if (type == ThrottleSetting.ValueType.VAL_INACTIVE) {
            this._sensorWaitState = 4;
        } else {
            throw new IllegalArgumentException("waitForSensor type " + type + " wrong");
        }
        int state = this._waitSensor.getKnownState();
        if (state == this._sensorWaitState) {
            log.info("Engineer: state of event sensor {} already at state {}", (Object)this._waitSensor.getDisplayName(), (Object)type.toString());
            return;
        }
        this._waitSensor.addPropertyChangeListener(this);
        if (log.isDebugEnabled()) {
            log.debug("Listen for propertyChange of {}, wait for State= {}", (Object)this._waitSensor.getDisplayName(), (Object)this._sensorWaitState);
        }
        Engineer engineer = this;
        synchronized (engineer) {
            this._waitForSensor = true;
            while (this._waitForSensor) {
                try {
                    if (Warrant._trace || log.isDebugEnabled()) {
                        log.info("{} : waitSensor", (Object)Bundle.getMessage("waitSensor", this._warrant.getTrainName(), this._waitSensor.getDisplayName(), type.toString()));
                    }
                    this._warrant.fireRunStatus("SensorWaitCommand", type.toString(), this._waitSensor.getDisplayName());
                    this.wait();
                    if (this._abort) continue;
                    String name = this._waitSensor.getDisplayName();
                    if (Warrant._trace || log.isDebugEnabled()) {
                        log.info("{} : wait Sensor Change", (Object)Bundle.getMessage("waitSensorChange", this._warrant.getTrainName(), name));
                    }
                    this._warrant.fireRunStatus("SensorWaitCommand", null, name);
                }
                catch (InterruptedException ie) {
                    log.error("Engineer interrupted at waitForSensor \"{}\"", (Object)this._waitSensor.getDisplayName(), (Object)ie);
                    this._warrant.debugInfo();
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.clearSensor();
                }
            }
        }
    }

    private void clearSensor() {
        if (this._waitSensor != null) {
            this._waitSensor.removePropertyChangeListener(this);
        }
        this._sensorWaitState = 0;
        this._waitForSensor = false;
        this._waitSensor = null;
    }

    protected Sensor getWaitSensor() {
        return this._waitSensor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="Sensor change on another thread is expected even when Engineer (this) has not done any modifing")
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("propertyChange {} new value= {}", (Object)evt.getPropertyName(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("KnownState") && ((Number)evt.getNewValue()).intValue() == this._sensorWaitState) {
            Engineer engineer = this;
            synchronized (engineer) {
                this.notifyAll();
            }
        }
    }

    private void runWarrant(NamedBeanHandle<?> handle, ThrottleSetting.CommandValue cmdVal) {
        Object bean = handle.getBean();
        if (!(bean instanceof Warrant)) {
            log.error("runWarrant: {} not a warrant!", bean);
            return;
        }
        Warrant warrant = (Warrant)bean;
        int num = Math.round(cmdVal.getFloat());
        if (num == 0) {
            return;
        }
        if (num > 0) {
            cmdVal.setFloat(--num);
        }
        if (this._warrant.getSpeedUtil().getDccAddress().equals(warrant.getSpeedUtil().getDccAddress())) {
            if (log.isDebugEnabled()) {
                log.debug("Loco address {} finishes warrant {} and starts warrant {}", new Object[]{warrant.getSpeedUtil().getDccAddress(), this._warrant.getDisplayName(), warrant.getDisplayName()});
            }
            long time = 0L;
            for (int i = this._idxCurrentCommand + 1; i < this._commands.size(); ++i) {
                ThrottleSetting cmd = this._commands.get(i);
                time += cmd.getTime();
            }
            this._checker = new CheckForTermination(this._warrant, warrant, num, time);
            this._checker.start();
            log.debug("Exit runWarrant");
        } else {
            Color color = Color.red;
            String msg = WarrantTableFrame.getDefault().runTrain(warrant, 2);
            if (msg == null) {
                msg = Bundle.getMessage("linkedLaunch", warrant.getDisplayName(), this._warrant.getDisplayName(), warrant.getfirstOrder().getBlock().getDisplayName(), this._warrant.getfirstOrder().getBlock().getDisplayName());
                color = WarrantTableModel.myGreen;
            }
            if (Warrant._trace || log.isDebugEnabled()) {
                log.info("{} : Warrant Status", (Object)msg);
            }
            Engineer.setFrameStatusText(msg, color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="rampDone is called by ramp thread to clear Engineer waiting for it to finish")
    private void rampDone(boolean stop, String speedType, int endBlockIdx) {
        this.setIsRamping(false);
        if (!stop && !speedType.equals(Warrant.Stop)) {
            this._speedType = speedType;
            this.setSpeedRatio(speedType);
            this.setWaitforClear(false);
            this.setHalt(false);
        }
        this._stopPending = false;
        if (!(this._waitForClear || this._atHalt || this._atClear || this._holdRamp)) {
            Engineer engineer = this;
            synchronized (engineer) {
                this.notifyAll();
            }
            log.debug("{}: rampDone called notify.", (Object)this._warrant.getDisplayName());
            if (this._currentCommand != null && this._currentCommand.getCommand().equals((Object)ThrottleSetting.Command.NOOP)) {
                --this._idxCurrentCommand;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: ThrottleRamp {} for speedType \"{}\". Thread.State= {}}", new Object[]{this._warrant.getDisplayName(), stop ? "stopped" : "completed", speedType, this._ramp != null ? this._ramp.getState() : "_ramp is null!"});
        }
    }

    class ThrottleRamp
    extends Thread {
        private String _endSpeedType;
        private int _endBlockIdx = -1;
        private boolean stop = false;
        private boolean _rampDown = true;
        private boolean _die = false;
        RampData rampData;

        ThrottleRamp() {
            this.setName("Ramp(" + Engineer.this._warrant.getTrainName() + ")");
            this._endBlockIdx = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="quit is called by another thread to clear all ramp waits")
        void quit(boolean die) {
            this.stop = true;
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            if (die) {
                this._die = die;
                object = Engineer.this._rampLockObject;
                synchronized (object) {
                    Engineer.this._rampLockObject.notifyAll();
                }
            }
            log.debug("{}: ThrottleRamp clears _ramp waits", (Object)Engineer.this._warrant.getDisplayName());
        }

        void setParameters(String endSpeedType, int endBlockIdx) {
            this._endSpeedType = endSpeedType;
            this._endBlockIdx = endBlockIdx;
            Engineer.this._stopPending = endSpeedType.equals(Warrant.Stop);
        }

        boolean duplicate(String endSpeedType, int endBlockIdx) {
            return endBlockIdx == this._endBlockIdx && endSpeedType.equals(this._endSpeedType);
        }

        int getEndBlockIndex() {
            return this._endBlockIdx;
        }

        int getCommandIndexLimit(int blockIdx, int cmdIdx) {
            ThrottleSetting ts;
            int cmd;
            String endBlkName;
            int limit = Engineer.this._commands.size();
            String curBlkName = Engineer.this._warrant.getCurrentBlockName();
            if (!curBlkName.contentEquals(endBlkName = Engineer.this._warrant.getBlockAt(blockIdx).getDisplayName())) {
                for (cmd = cmdIdx; cmd < Engineer.this._commands.size(); ++cmd) {
                    ts = Engineer.this._commands.get(cmd);
                    if (!ts.getBeanDisplayName().equals(endBlkName)) continue;
                    cmdIdx = cmd;
                    break;
                }
            }
            endBlkName = Engineer.this._warrant.getBlockAt(blockIdx + 1).getDisplayName();
            for (cmd = cmdIdx; cmd < Engineer.this._commands.size(); ++cmd) {
                ts = Engineer.this._commands.get(cmd);
                if (!ts.getBeanDisplayName().equals(endBlkName) || !ts.getValue().getType().equals((Object)ThrottleSetting.ValueType.VAL_NOOP)) continue;
                limit = cmd;
                break;
            }
            log.debug("getCommandIndexLimit: in end block {}, limitIdx = {} in block {}", new Object[]{curBlkName, limit + 1, Engineer.this._warrant.getBlockAt(blockIdx).getDisplayName()});
            return limit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="waits may be indefinite until satisfied or thread aborted")
        public void run() {
            while (!this._die) {
                Engineer.this.setIsRamping(false);
                Object object = Engineer.this._rampLockObject;
                synchronized (object) {
                    try {
                        Engineer.this._rampLockObject.wait();
                        Engineer.this.setIsRamping(true);
                    }
                    catch (InterruptedException ie) {
                        log.debug("As expected", (Throwable)ie);
                    }
                }
                if (this._die) break;
                this.stop = false;
                this.doRamp();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
        public void doRamp() {
            float endSpeed;
            int commandIndexLimit;
            float speed = Engineer.this.getSpeedSetting();
            if (this._endBlockIdx >= 0) {
                commandIndexLimit = this.getCommandIndexLimit(this._endBlockIdx, Engineer.this._idxCurrentCommand);
                endSpeed = Engineer.this._speedUtil.getBlockSpeedInfo(this._endBlockIdx).getExitSpeed();
                endSpeed = Engineer.this._speedUtil.modifySpeed(endSpeed, this._endSpeedType);
            } else {
                commandIndexLimit = Engineer.this._commands.size();
                endSpeed = Engineer.this._speedUtil.modifySpeed(Engineer.this._normalSpeed, this._endSpeedType);
            }
            ThrottleSetting.CommandValue cmdVal = Engineer.this._currentCommand.getValue();
            long timeToSpeedCmd = Engineer.this.getTimeToNextCommand();
            boolean bl = this._rampDown = endSpeed <= speed;
            if (log.isDebugEnabled()) {
                log.debug("RAMP {} \"{}\" speed from {}, to {}, at block \"{}\" at Cmd#{} to Cmd#{}. timeToNextCmd= {}", new Object[]{this._rampDown ? "DOWN" : "UP", this._endSpeedType, Float.valueOf(speed), Float.valueOf(endSpeed), this._endBlockIdx >= 0 ? Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName() : "ahead", Engineer.this._idxCurrentCommand + 1, commandIndexLimit, timeToSpeedCmd});
            }
            float scriptTrackSpeed = Engineer.this._speedUtil.getTrackSpeed(Engineer.this._normalSpeed);
            int warBlockIdx = Engineer.this._warrant.getCurrentOrderIndex();
            int cmdBlockIdx = -1;
            int cmdIdx = Engineer.this._idxCurrentCommand;
            while (cmdIdx >= 0) {
                ThrottleSetting cmd;
                if (!(cmd = Engineer.this._commands.get(--cmdIdx)).getCommand().hasBlockName()) continue;
                OBlock blk = (OBlock)cmd.getBean();
                int idx = Engineer.this._warrant.getIndexOfBlockBefore(warBlockIdx, blk);
                if (idx >= 0) {
                    cmdBlockIdx = idx;
                    break;
                }
                cmdBlockIdx = Engineer.this._warrant.getIndexOfBlockAfter(blk, warBlockIdx);
                break;
            }
            if (cmdBlockIdx < 0) {
                cmdBlockIdx = warBlockIdx;
            }
            ThrottleRamp throttleRamp = this;
            synchronized (throttleRamp) {
                block57: {
                    try {
                        NamedBean bean;
                        if (!this._rampDown) {
                            this.rampData = Engineer.this._speedUtil.getRampForSpeedChange(speed, 1.0f);
                            int timeIncrement = this.rampData.getRampTimeIncrement();
                            ListIterator<Float> iter = this.rampData.speedIterator(true);
                            speed = iter.next().floatValue();
                            float rampDist = 0.0f;
                            float cmdDist = (float)timeToSpeedCmd * scriptTrackSpeed;
                            while (!this.stop && iter.hasNext()) {
                                float s;
                                speed = iter.next().floatValue();
                                if (speed > (s = Engineer.this._speedUtil.modifySpeed(Engineer.this._normalSpeed, this._endSpeedType))) {
                                    Engineer.this.setSpeed(s);
                                    break block57;
                                }
                                Engineer.this.setSpeed(speed);
                                if (!this.stop && rampDist >= cmdDist && Engineer.this._idxCurrentCommand < commandIndexLimit) {
                                    int idx;
                                    warBlockIdx = Engineer.this._warrant.getCurrentOrderIndex();
                                    if (Engineer.this._currentCommand.getCommand().hasBlockName() && (idx = Engineer.this._warrant.getIndexOfBlockBefore(warBlockIdx, (OBlock)Engineer.this._currentCommand.getBean())) >= 0) {
                                        cmdBlockIdx = idx;
                                    }
                                    if (cmdBlockIdx <= warBlockIdx) {
                                        ThrottleSetting.Command cmd = Engineer.this._currentCommand.getCommand();
                                        if (cmd.equals((Object)ThrottleSetting.Command.SPEED)) {
                                            cmdVal = Engineer.this._currentCommand.getValue();
                                            Engineer.this._normalSpeed = cmdVal.getFloat();
                                            scriptTrackSpeed = Engineer.this._speedUtil.getTrackSpeed(Engineer.this._normalSpeed);
                                            if (log.isDebugEnabled()) {
                                                log.debug("Cmd #{} for speed= {} skipped.", (Object)(Engineer.this._idxCurrentCommand + 1), (Object)Float.valueOf(Engineer.this._normalSpeed));
                                            }
                                            cmdDist = 0.0f;
                                        } else {
                                            Engineer.this.executeComand(Engineer.this._currentCommand, timeIncrement);
                                        }
                                        if (Engineer.this._idxCurrentCommand < Engineer.this._commands.size() - 1) {
                                            Engineer.this._currentCommand = Engineer.this._commands.get(++Engineer.this._idxCurrentCommand);
                                            cmdDist = scriptTrackSpeed * (float)Engineer.this._currentCommand.getTime();
                                        } else {
                                            cmdDist = 0.0f;
                                        }
                                        rampDist = 0.0f;
                                        Engineer.this.advanceToCommandIndex(Engineer.this._idxCurrentCommand);
                                    }
                                }
                                try {
                                    this.wait(timeIncrement);
                                }
                                catch (InterruptedException ie) {
                                    this.stop = true;
                                }
                                rampDist += Engineer.this._speedUtil.getDistanceTraveled(speed, Engineer.this._speedType, timeIncrement);
                            }
                            break block57;
                        }
                        Engineer.this._warrant.downRampBegun(this._endBlockIdx);
                        this.rampData = Engineer.this._speedUtil.getRampForSpeedChange(speed, endSpeed);
                        int timeIncrement = this.rampData.getRampTimeIncrement();
                        ListIterator<Float> iter = this.rampData.speedIterator(false);
                        speed = iter.previous().floatValue();
                        float rampDist = 0.0f;
                        float cmdDist = (float)timeToSpeedCmd * scriptTrackSpeed;
                        while (!this.stop && iter.hasPrevious()) {
                            speed = iter.previous().floatValue();
                            Engineer.this.setSpeed(speed);
                            if (this._endBlockIdx >= 0) {
                                int curIdx = Engineer.this._warrant.getCurrentOrderIndex();
                                if (curIdx > this._endBlockIdx) {
                                    Engineer.this.setSpeed(endSpeed);
                                    this.stop = true;
                                    log.warn("\"{}\" Ramp to speed \"{}\" ended due to overrun into block \"{}\". throttle {} set to {}.\"{}\"", new Object[]{Engineer.this._warrant.getTrainName(), this._endSpeedType, Engineer.this._warrant.getBlockAt(curIdx).getDisplayName(), Float.valueOf(speed), Float.valueOf(endSpeed), Engineer.this._warrant.getDisplayName()});
                                } else if (curIdx < this._endBlockIdx && this._endSpeedType.equals(Warrant.Stop) && Math.abs(speed - endSpeed) < 0.001f) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Extending ramp to reach block {}. speed= {}", (Object)Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName(), (Object)Float.valueOf(speed));
                                    }
                                    int waittime = 0;
                                    float throttleIncrement = Engineer.this._speedUtil.getRampThrottleIncrement();
                                    while (this._endBlockIdx > Engineer.this._warrant.getCurrentOrderIndex() && waittime <= 60 * timeIncrement && Engineer.this.getSpeedSetting() > 0.0f) {
                                        if (waittime == 5 * timeIncrement || waittime == 10 * timeIncrement || waittime == 15 * timeIncrement || waittime == 20 * timeIncrement) {
                                            Engineer.this.setSpeed(Engineer.this.getSpeedSetting() + throttleIncrement);
                                        }
                                        try {
                                            this.wait(timeIncrement);
                                            waittime += timeIncrement;
                                        }
                                        catch (InterruptedException ie) {
                                            this.stop = true;
                                        }
                                    }
                                    try {
                                        this.wait(timeIncrement);
                                    }
                                    catch (InterruptedException ie) {
                                        this.stop = true;
                                    }
                                }
                            }
                            if (!this.stop && rampDist >= cmdDist && Engineer.this._idxCurrentCommand < commandIndexLimit) {
                                int idx;
                                warBlockIdx = Engineer.this._warrant.getCurrentOrderIndex();
                                if (Engineer.this._currentCommand.getCommand().hasBlockName() && (idx = Engineer.this._warrant.getIndexOfBlockBefore(warBlockIdx, (OBlock)Engineer.this._currentCommand.getBean())) >= 0) {
                                    cmdBlockIdx = idx;
                                }
                                if (cmdBlockIdx <= warBlockIdx) {
                                    ThrottleSetting.Command cmd = Engineer.this._currentCommand.getCommand();
                                    if (cmd.equals((Object)ThrottleSetting.Command.SPEED)) {
                                        cmdVal = Engineer.this._currentCommand.getValue();
                                        Engineer.this._normalSpeed = cmdVal.getFloat();
                                        scriptTrackSpeed = Engineer.this._speedUtil.getTrackSpeed(Engineer.this._normalSpeed);
                                        if (log.isDebugEnabled()) {
                                            log.debug("Cmd #{} for speed= {} skipped.", (Object)(Engineer.this._idxCurrentCommand + 1), (Object)Float.valueOf(Engineer.this._normalSpeed));
                                        }
                                        cmdDist = 0.0f;
                                    } else {
                                        Engineer.this.executeComand(Engineer.this._currentCommand, timeIncrement);
                                    }
                                    if (Engineer.this._idxCurrentCommand < Engineer.this._commands.size() - 1) {
                                        Engineer.this._currentCommand = Engineer.this._commands.get(++Engineer.this._idxCurrentCommand);
                                        cmdDist = scriptTrackSpeed * (float)Engineer.this._currentCommand.getTime();
                                    } else {
                                        cmdDist = 0.0f;
                                    }
                                    rampDist = 0.0f;
                                    Engineer.this.advanceToCommandIndex(Engineer.this._idxCurrentCommand);
                                }
                            }
                            try {
                                this.wait(timeIncrement);
                            }
                            catch (InterruptedException ie) {
                                this.stop = true;
                            }
                            rampDist += Engineer.this._speedUtil.getDistanceTraveled(speed, Engineer.this._speedType, timeIncrement);
                        }
                        if (this._endBlockIdx < 0 || commandIndexLimit >= Engineer.this._commands.size()) break block57;
                        long cmdStart = System.currentTimeMillis();
                        while (!(Engineer.this._idxCurrentCommand >= commandIndexLimit || (bean = Engineer.this._currentCommand.getBean()) instanceof OBlock && this._endBlockIdx < Engineer.this._warrant.getIndexOfBlockAfter((OBlock)bean, this._endBlockIdx))) {
                            ThrottleSetting.Command cmd = Engineer.this._currentCommand.getCommand();
                            if (cmd.equals((Object)ThrottleSetting.Command.SPEED)) {
                                cmdVal = Engineer.this._currentCommand.getValue();
                                Engineer.this._normalSpeed = cmdVal.getFloat();
                                if (log.isDebugEnabled()) {
                                    log.debug("Cmd #{} for speed {} skipped. warrant {}", new Object[]{Engineer.this._idxCurrentCommand + 1, Float.valueOf(Engineer.this._normalSpeed), Engineer.this._warrant.getDisplayName()});
                                }
                            } else {
                                Engineer.this.executeComand(Engineer.this._currentCommand, System.currentTimeMillis() - cmdStart);
                            }
                            Engineer.this._currentCommand = Engineer.this._commands.get(++Engineer.this._idxCurrentCommand);
                            Engineer.this.advanceToCommandIndex(Engineer.this._idxCurrentCommand);
                        }
                    }
                    catch (Throwable throwable) {
                        if (log.isDebugEnabled()) {
                            log.debug("Ramp Done. End Blk= {}, _idxCurrentCommand={} resumeIdx={}, commandIndexLimit={}. warrant {}", new Object[]{this._endBlockIdx >= 0 ? Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName() : "not required", Engineer.this._idxCurrentCommand + 1, Engineer.this._idxSkipToSpeedCommand, commandIndexLimit, Engineer.this._warrant.getDisplayName()});
                        }
                        throw throwable;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Ramp Done. End Blk= {}, _idxCurrentCommand={} resumeIdx={}, commandIndexLimit={}. warrant {}", new Object[]{this._endBlockIdx >= 0 ? Engineer.this._warrant.getBlockAt(this._endBlockIdx).getDisplayName() : "not required", Engineer.this._idxCurrentCommand + 1, Engineer.this._idxSkipToSpeedCommand, commandIndexLimit, Engineer.this._warrant.getDisplayName()});
                }
            }
            Engineer.this.rampDone(this.stop, this._endSpeedType, this._endBlockIdx);
            if (!this.stop) {
                Engineer.this._warrant.fireRunStatus("RampDone", Engineer.this._halt, this._endSpeedType);
                if (Warrant._trace || log.isDebugEnabled()) {
                    log.info(Bundle.getMessage("RampSpeed", Engineer.this._warrant.getTrainName(), this._endSpeedType, Engineer.this._warrant.getCurrentBlockName()));
                }
            } else if (Warrant._trace || log.isDebugEnabled()) {
                log.info(Bundle.getMessage("RampSpeed", Engineer.this._warrant.getTrainName(), this._endSpeedType, Engineer.this._warrant.getCurrentBlockName()) + "-Interrupted!");
            }
            this.stop = false;
            if (this._rampDown) {
                Engineer.this._warrant.downRampDone(this.stop, Engineer.this._halt, this._endSpeedType, this._endBlockIdx);
            }
        }
    }

    private class CheckForTermination
    extends Thread {
        Warrant oldWarrant;
        Warrant newWarrant;
        long waitTime;

        CheckForTermination(Warrant oldWar, Warrant newWar, int num, long limit) {
            this.oldWarrant = oldWar;
            this.newWarrant = newWar;
            this.waitTime = limit;
            if (log.isDebugEnabled()) {
                log.debug("checkForTermination of \"{}\", before launching \"{}\". waitTime= {})", new Object[]{this.oldWarrant.getDisplayName(), this.newWarrant.getDisplayName(), this.waitTime});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            long time = 0L;
            CheckForTermination checkForTermination = this;
            // MONITORENTER : checkForTermination
            while (time <= this.waitTime || this.oldWarrant.getRunMode() != 0) {
                try {
                    this.wait(100L);
                    time += 100L;
                }
                catch (InterruptedException ie) {
                    log.error("Engineer interrupted at CheckForTermination of \"{}\"", (Object)this.oldWarrant.getDisplayName(), (Object)ie);
                    Engineer.this._warrant.debugInfo();
                    Thread.currentThread().interrupt();
                    time = this.waitTime;
                }
            }
            // MONITOREXIT : checkForTermination
            if (time > this.waitTime || log.isDebugEnabled()) {
                log.info("Waited {}ms for warrant \"{}\" to terminate. runMode={}", new Object[]{time, this.oldWarrant.getDisplayName(), this.oldWarrant.getRunMode()});
            }
            this.checkerDone(this.oldWarrant, this.newWarrant);
        }

        private void checkerDone(Warrant oldWarrant, Warrant newWarrant) {
            OBlock endBlock = oldWarrant.getLastOrder().getBlock();
            if (oldWarrant.getRunMode() != 0) {
                log.error("{} : Cannot Launch", (Object)Bundle.getMessage("cannotLaunch", newWarrant.getDisplayName(), oldWarrant.getDisplayName(), endBlock.getDisplayName()));
                return;
            }
            String msg = WarrantTableFrame.getDefault().runTrain(newWarrant, 2);
            Color color = Color.red;
            if (msg == null) {
                ThrottleSetting.CommandValue cmdVal = Engineer.this._currentCommand.getValue();
                int num = Math.round(cmdVal.getFloat());
                msg = oldWarrant.equals(newWarrant) ? Bundle.getMessage("reLaunch", oldWarrant.getDisplayName(), num < 0 ? "unlimited" : Integer.valueOf(num)) : Bundle.getMessage("linkedLaunch", newWarrant.getDisplayName(), oldWarrant.getDisplayName(), newWarrant.getfirstOrder().getBlock().getDisplayName(), endBlock.getDisplayName());
                color = WarrantTableModel.myGreen;
            }
            if (Warrant._trace || log.isDebugEnabled()) {
                log.info("{} : Launch", (Object)msg);
            }
            Engineer.setFrameStatusText(msg, color);
            Engineer.this._checker = null;
        }
    }
}

