/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnSpeedPanel
extends JInternalFrame
implements PropertyChangeListener {
    private final Warrant _warrant;
    private JLabel _scaleSpeed;
    private JLabel _direction;
    private static final Logger log = LoggerFactory.getLogger(LearnSpeedPanel.class);

    LearnSpeedPanel(Warrant w) {
        this._warrant = w;
        this.initGUI();
    }

    private void initGUI() {
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        this.setDefaultCloseOperation(0);
        JPanel panel = new JPanel();
        panel.setFont(new Font("", 0, 32));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setOpaque(false);
        OBlock blk = this._warrant.getBlockAt(0);
        String name = blk != null ? blk.getDisplayName() : this._warrant.getDisplayName();
        this._direction = new JLabel(Bundle.getMessage("forward"));
        panel.add(this._direction);
        panel.add(Box.createHorizontalStrut(WarrantRoute.STRUT_SIZE));
        this._scaleSpeed = new JLabel(Bundle.getMessage("TrainReady", this._warrant.getTrainName(), name));
        panel.add(this._scaleSpeed);
        mainPanel.add(panel);
    }

    public void notifyAddressThrottleFound(DccThrottle throttle) {
        this._warrant.getSpeedUtil().setThrottle(throttle);
        throttle.addPropertyChangeListener(this);
        this._scaleSpeed.setText(this.setSpeed(throttle.getSpeedSetting()));
        if (log.isDebugEnabled()) {
            DccLocoAddress address = (DccLocoAddress)throttle.getLocoAddress();
            log.debug("new address is {}", (Object)address);
        }
        this.setSpeed(0.0f);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("SpeedSetting")) {
            this._scaleSpeed.setText(this.setSpeed(((Float)e.getNewValue()).floatValue()));
        } else if (e.getPropertyName().equals("IsForward")) {
            String direction = Boolean.TRUE.equals(e.getNewValue()) ? Bundle.getMessage("forward") : Bundle.getMessage("reverse");
            this._direction.setText(direction);
        }
        if (log.isDebugEnabled()) {
            log.debug("Property change event received {} / {}", (Object)e.getPropertyName(), e.getNewValue());
        }
    }

    private String setSpeed(float throttleValue) {
        String units;
        float trackSpeed = this._warrant.getSpeedUtil().getTrackSpeed(throttleValue);
        float speed = 0.0f;
        SignalSpeedMap speedMap = InstanceManager.getDefault(SignalSpeedMap.class);
        switch (speedMap.getInterpretation()) {
            case 1: 
            case 2: {
                units = Bundle.getMessage("percentThrottle");
                speed = throttleValue * 100.0f;
                break;
            }
            case 3: {
                units = Bundle.getMessage("speedMph");
                speed = trackSpeed * speedMap.getLayoutScale() * 2.2369363f;
                break;
            }
            case 4: {
                units = Bundle.getMessage("speedKmph");
                speed = trackSpeed * speedMap.getLayoutScale() * 3.6f;
                break;
            }
            default: {
                units = "Error";
                log.error("Unknown speed interpretation {}", (Object)speedMap.getInterpretation());
            }
        }
        return Bundle.getMessage("atSpeed", Bundle.getMessage("speedmm", Math.round(trackSpeed * 1000.0f)), Math.round(speed), units);
    }

    public void destroy() {
        DccThrottle throttle = this._warrant.getSpeedUtil().getThrottle();
        if (throttle != null) {
            throttle.removePropertyChangeListener(this);
            if (log.isDebugEnabled()) {
                DccLocoAddress address = (DccLocoAddress)throttle.getLocoAddress();
                log.debug("Address {} destroyed", (Object)address);
            }
        }
    }
}

