/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jmri.InstanceManager;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.SpeedProfilePanel;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import jmri.util.table.ButtonEditor;

public class MergePrompt
extends JDialog {
    private final Map<String, Boolean> _candidates;
    private final Map<String, Map<Integer, Boolean>> _anomalyMap;
    private JPanel _viewPanel;
    private static final int STRUT = 20;

    MergePrompt(String name, Map<String, Boolean> cand, Map<String, Map<Integer, Boolean>> anomalies) {
        this._candidates = cand;
        this._anomalyMap = anomalies;
        this.setTitle(name);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MergePrompt.this.noMerge();
                MergePrompt.this.dispose();
            }
        });
        MergeTableModel model = new MergeTableModel(cand);
        JTable table = new JTable(model);
        table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
        table.getColumnModel().getColumn(2).setCellEditor(new ButtonEditor(new JButton()));
        table.getColumnModel().getColumn(2).setCellRenderer(new ButtonCellRenderer());
        int tablewidth = 0;
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
            tablewidth += width;
        }
        int rowHeight = new JButton((String)"VIEW").getPreferredSize().height;
        table.setRowHeight(rowHeight);
        JPanel description = new JPanel();
        JLabel label = new JLabel(Bundle.getMessage("MergePrompt"));
        label.setHorizontalAlignment(0);
        description.add(label);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        JButton button = new JButton(Bundle.getMessage("ButtonNoMerge"));
        button.addActionListener(evt -> {
            this.noMerge();
            this.dispose();
        });
        panel.add(button);
        panel.add(Box.createHorizontalStrut(20));
        button = new JButton(Bundle.getMessage("ButtonMerge"));
        button.addActionListener(evt -> this.dispose());
        panel.add(button);
        panel.add(Box.createHorizontalStrut(20));
        button = new JButton(Bundle.getMessage("ButtonCloseView"));
        button.addActionListener(evt -> {
            if (this._viewPanel != null) {
                this.getContentPane().remove(this._viewPanel);
            }
            this.pack();
        });
        panel.add(button);
        JScrollPane pane = new JScrollPane(table);
        pane.setPreferredSize(new Dimension(tablewidth, tablewidth));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.add(description);
        mainPanel.add(pane);
        if (this._anomalyMap != null && !this._anomalyMap.isEmpty()) {
            mainPanel.add(MergePrompt.makeAnomalyPanel());
        }
        mainPanel.add(panel);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.add(Box.createHorizontalStrut(20));
        p.add(Box.createHorizontalGlue());
        p.add(mainPanel);
        p.add(Box.createHorizontalGlue());
        p.add(Box.createHorizontalStrut(20));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        contentPane.add(p);
        this.setContentPane(contentPane);
        this.pack();
        Dimension screen = this.getToolkit().getScreenSize();
        this.setLocation(screen.width / 3, screen.height / 4);
        this.setAlwaysOnTop(true);
    }

    private void noMerge() {
        for (Map.Entry<String, Boolean> ent : this._candidates.entrySet()) {
            this._candidates.put(ent.getKey(), false);
        }
    }

    static JPanel makeEditInfoPanel(RosterEntry entry) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JLabel label = new JLabel(Bundle.getMessage("viewTitle", entry.getId()));
        label.setAlignmentX(0.5f);
        panel.add(label);
        label = new JLabel(Bundle.getMessage("deletePrompt1"));
        label.setFont(new Font("SansSerif", 0, 12));
        label.setForeground(Color.RED);
        label.setAlignmentX(0.5f);
        panel.add(label);
        label = new JLabel(Bundle.getMessage("deletePrompt2"));
        label.setFont(new Font("SansSerif", 0, 12));
        label.setAlignmentX(0.5f);
        panel.add(label);
        label = new JLabel(Bundle.getMessage("deletePrompt3"));
        label.setFont(new Font("SansSerif", 0, 12));
        label.setAlignmentX(0.5f);
        panel.add(label);
        return panel;
    }

    static JPanel makeAnomalyPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JLabel l = new JLabel(Bundle.getMessage("anomalyPrompt"));
        l.setForeground(Color.RED);
        l.setAlignmentX(0.5f);
        panel.add(l);
        return panel;
    }

    static JPanel makeSpeedProfilePanel(String title, RosterSpeedProfile profile, boolean edit, Map<Integer, Boolean> anomalies) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(new JLabel(Bundle.getMessage(title)));
        SpeedProfilePanel speedPanel = new SpeedProfilePanel(profile, edit, anomalies);
        panel.add(speedPanel);
        return panel;
    }

    @Nonnull
    public static Map<Integer, Boolean> validateSpeedProfile(@CheckForNull RosterSpeedProfile speedProfile) {
        HashMap<Integer, Boolean> anomalies = new HashMap<Integer, Boolean>();
        if (speedProfile == null) {
            return anomalies;
        }
        TreeMap<Integer, RosterSpeedProfile.SpeedStep> rosterTree = speedProfile.getProfileSpeeds();
        float lastForward = 0.0f;
        Integer lastKey = 0;
        Iterator<Map.Entry<Integer, RosterSpeedProfile.SpeedStep>> iter = rosterTree.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = iter.next();
            float forward = entry.getValue().getForwardSpeed();
            Integer key = entry.getKey();
            if (!(forward > 0.0f)) continue;
            if (forward < lastForward) {
                while (iter.hasNext()) {
                    Map.Entry<Integer, RosterSpeedProfile.SpeedStep> nextEntry = iter.next();
                    float nextForward = nextEntry.getValue().getForwardSpeed();
                    if (!(nextForward > 0.0f)) continue;
                    if (nextForward > lastForward) {
                        anomalies.put(key, true);
                        forward = nextForward;
                        key = nextEntry.getKey();
                        break;
                    }
                    anomalies.put(lastKey, true);
                    break;
                }
            }
            lastForward = forward;
            lastKey = key;
        }
        rosterTree = speedProfile.getProfileSpeeds();
        float lastReverse = 0.0f;
        lastKey = 0;
        iter = rosterTree.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = iter.next();
            float reverse = entry.getValue().getReverseSpeed();
            Integer key = entry.getKey();
            if (!(reverse > 0.0f)) continue;
            if (reverse < lastReverse) {
                while (iter.hasNext()) {
                    Map.Entry<Integer, RosterSpeedProfile.SpeedStep> nextEntry = iter.next();
                    float nextreverse = nextEntry.getValue().getReverseSpeed();
                    if (!(nextreverse > 0.0f)) continue;
                    if (nextreverse > lastReverse) {
                        anomalies.put(key, false);
                        reverse = nextreverse;
                        key = nextEntry.getKey();
                        break;
                    }
                    anomalies.put(lastKey, false);
                    break;
                }
            }
            lastReverse = reverse;
            lastKey = key;
        }
        return anomalies;
    }

    private static class ButtonCellRenderer
    extends DefaultTableCellRenderer {
        private ButtonCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component b = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            JLabel l = (JLabel)b;
            l.setHorizontalAlignment(0);
            MergeTableModel tableModel = (MergeTableModel)table.getModel();
            if (tableModel.hasAnomaly(row)) {
                l.setBackground(Color.RED);
            } else {
                l.setBackground(table.getBackground());
            }
            return b;
        }
    }

    private class MergeTableModel
    extends AbstractTableModel {
        static final int MERGE_COL = 0;
        static final int ID_COL = 1;
        static final int VIEW_COL = 2;
        static final int NUMCOLS = 3;
        final ArrayList<Map.Entry<String, Boolean>> candidateArray = new ArrayList();

        MergeTableModel(Map<String, Boolean> map) {
            Iterator<Map.Entry<String, Boolean>> iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                this.candidateArray.add(iter.next());
            }
        }

        boolean hasAnomaly(int row) {
            Map.Entry<String, Boolean> entry = this.candidateArray.get(row);
            Map<Integer, Boolean> anomaly = MergePrompt.this._anomalyMap.get(entry.getKey());
            return anomaly != null && !anomaly.isEmpty();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.candidateArray.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("Merge");
                }
                case 1: {
                    return Bundle.getMessage("TrainId");
                }
                case 2: {
                    return Bundle.getMessage("SpeedProfiles");
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)3).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)16).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)7).getPreferredSize().width;
                }
            }
            return new JTextField((int)12).getPreferredSize().width;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map.Entry<String, Boolean> entry = this.candidateArray.get(row);
            switch (col) {
                case 0: {
                    return entry.getValue();
                }
                case 1: {
                    String id = entry.getKey();
                    if (id == null || id.isEmpty() || id.charAt(0) == '$' && id.charAt(id.length() - 1) == '$') {
                        id = Bundle.getMessage("noSuchAddress");
                    }
                    return id;
                }
                case 2: {
                    return Bundle.getMessage("View");
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Map.Entry<String, Boolean> entry = this.candidateArray.get(row);
            switch (col) {
                case 0: {
                    String id = entry.getKey();
                    if (Roster.getDefault().getEntryForId(id) == null) {
                        MergePrompt.this._candidates.put(entry.getKey(), false);
                        break;
                    }
                    MergePrompt.this._candidates.put(entry.getKey(), (Boolean)value);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.showProfiles(entry.getKey());
                    break;
                }
            }
        }

        private void showProfiles(String id) {
            if (MergePrompt.this._viewPanel != null) {
                MergePrompt.this.getContentPane().remove(MergePrompt.this._viewPanel);
            }
            MergePrompt.this.invalidate();
            MergePrompt.this._viewPanel = this.makeViewPanel(id);
            if (MergePrompt.this._viewPanel == null) {
                return;
            }
            MergePrompt.this.getContentPane().add(MergePrompt.this._viewPanel);
            MergePrompt.this.pack();
            MergePrompt.this.setVisible(true);
        }

        @CheckForNull
        private JPanel makeViewPanel(String id) {
            RosterEntry entry = Roster.getDefault().getEntryForId(id);
            if (entry == null) {
                return null;
            }
            JPanel viewPanel = new JPanel();
            viewPanel.setLayout(new BoxLayout(viewPanel, 3));
            viewPanel.add(Box.createGlue());
            JPanel panel = new JPanel();
            panel.add(MergePrompt.makeEditInfoPanel(entry));
            viewPanel.add(panel);
            JPanel spPanel = new JPanel();
            spPanel.setLayout(new BoxLayout(spPanel, 2));
            spPanel.add(Box.createGlue());
            RosterSpeedProfile speedProfile = entry.getSpeedProfile();
            if (speedProfile != null) {
                spPanel.add(MergePrompt.makeSpeedProfilePanel("rosterSpeedProfile", speedProfile, false, null));
                spPanel.add(Box.createGlue());
            }
            WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
            RosterSpeedProfile mergeProfile = manager.getMergeProfile(id);
            Map<Integer, Boolean> anomaly = MergePrompt.validateSpeedProfile(mergeProfile);
            spPanel.add(MergePrompt.makeSpeedProfilePanel("mergedSpeedProfile", mergeProfile, true, anomaly));
            spPanel.add(Box.createGlue());
            viewPanel.add(spPanel);
            return viewPanel;
        }
    }
}

