/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.JmriException;
import jmri.SpeedStepMode;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantPreferencesPanel;
import jmri.jmrit.logix.WarrantRoute;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NXFrame
extends WarrantRoute {
    private float _maxThrottle = 0.0f;
    private float _startDist;
    private float _stopDist;
    private final JTextField _maxThrottleBox = new JTextField(6);
    private final JTextField _maxSpeedBox = new JTextField(6);
    private final JLabel _maxSpeedBoxLabel = new JLabel(Bundle.getMessage("scaleSpeed"));
    private final JTextField _originDist = new JTextField(6);
    private WarrantRoute.DisplayButton _originUnits;
    private final JTextField _destDist = new JTextField(6);
    private WarrantRoute.DisplayButton _destUnits;
    private final JSpinner _timeIncre = new JSpinner(new SpinnerNumberModel(750, 200, 9000, 1));
    private final JTextField _rampIncre = new JTextField(6);
    private final JRadioButton _forward = new JRadioButton();
    private final JRadioButton _reverse = new JRadioButton();
    private final JCheckBox _noRamp = new JCheckBox();
    private final JCheckBox _noSound = new JCheckBox();
    private final JCheckBox _stageEStop = new JCheckBox();
    private final JCheckBox _shareRouteBox = new JCheckBox();
    private final JCheckBox _haltStartBox = new JCheckBox();
    private final JCheckBox _addTracker = new JCheckBox();
    private final JRadioButton _runAuto = new JRadioButton(Bundle.getMessage("RunAuto"));
    private final JRadioButton _runManual = new JRadioButton(Bundle.getMessage("RunManual"));
    private JPanel _routePanel = new JPanel();
    private JPanel _autoRunPanel;
    private final JPanel __trainHolder = new JPanel();
    private JPanel _switchPanel;
    private JPanel _trainPanel;
    private static final Logger log = LoggerFactory.getLogger(NXFrame.class);

    protected NXFrame() {
        this.init();
    }

    private void init() {
        log.debug("newInstance");
        this.makeMenus();
        this._routePanel = new JPanel();
        this._routePanel.setLayout(new BoxLayout(this._routePanel, 3));
        this._routePanel.add(Box.createVerticalGlue());
        this._routePanel.add(this.makeBlockPanels(true));
        this._forward.setSelected(true);
        this._speedUtil.setIsForward(true);
        this._stageEStop.setSelected(false);
        this._haltStartBox.setSelected(false);
        this._runAuto.setSelected(true);
        this._autoRunPanel = this.makeAutoRunPanel();
        this._switchPanel = this.makeSwitchPanel();
        this._maxSpeedBox.setEnabled(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.add(this._routePanel);
        this.getContentPane().add(mainPanel);
        if (this._maxThrottle <= 0.1f) {
            this._maxThrottle = WarrantPreferences.getDefault().getThrottleScale() * 100.0f;
        }
        this._maxThrottleBox.setText(NumberFormat.getNumberInstance().format(this._maxThrottle));
        this.maxThrottleEventAction();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WarrantTableAction.getDefault().closeNXFrame();
            }
        });
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.pack();
    }

    protected boolean isRouteSeaching() {
        return this._routePanel.isVisible();
    }

    private void setPanel() {
        this.__trainHolder.add(this._trainPanel);
    }

    private void setPanel(JPanel p) {
        JPanel con = (JPanel)this.getContentPane().getComponent(0);
        con.removeAll();
        con.add(p);
        con.add(this._switchPanel);
        this.pack();
    }

    private JPanel makeSwitchPanel() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._runAuto);
        bg.add(this._runManual);
        this._runAuto.addActionListener(event -> {
            this.setPanel();
            this.setPanel(this._autoRunPanel);
        });
        this._runManual.addActionListener(event -> {
            this.setPanel(this._trainPanel);
            this._stageEStop.setSelected(false);
            this._shareRouteBox.setSelected(false);
            this._haltStartBox.setSelected(false);
            this._addTracker.setSelected(false);
        });
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 2));
        pp.add(Box.createHorizontalGlue());
        pp.add(this._runAuto);
        pp.add(Box.createHorizontalStrut(STRUT_SIZE));
        pp.add(this._runManual);
        pp.add(Box.createHorizontalGlue());
        JPanel p = new JPanel();
        p.add(Box.createGlue());
        JButton button = new JButton(Bundle.getMessage("ButtonRoute"));
        button.addActionListener(e -> {
            this.clearTempWarrant();
            JPanel con = (JPanel)this.getContentPane().getComponent(0);
            con.removeAll();
            con.add(this._routePanel);
            this.pack();
        });
        p.add(button);
        p.add(Box.createHorizontalStrut(2 * STRUT_SIZE));
        button = new JButton(Bundle.getMessage("ButtonRunNX"));
        button.addActionListener(e -> {
            this.clearTempWarrant();
            this.makeAndRunWarrant();
        });
        p.add(button);
        p.add(Box.createHorizontalStrut(2 * STRUT_SIZE));
        button = new JButton(Bundle.getMessage("ButtonCancel"));
        button.addActionListener(e -> WarrantTableAction.getDefault().closeNXFrame());
        p.add(button);
        p.add(Box.createGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(pp);
        panel.add(p);
        return panel;
    }

    @Override
    protected void maxThrottleEventAction() {
        float num;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        try {
            num = formatter.parse(this._maxThrottleBox.getText()).floatValue();
            num = Math.min(100.0f, Math.max(num, 0.0f));
            this._maxThrottleBox.setText(formatter.format(num));
        }
        catch (ParseException pe) {
            this._maxThrottleBox.setText(null);
            this._maxSpeedBox.setText(null);
            return;
        }
        float speed = this._speedUtil.getTrackSpeed(num / 100.0f);
        switch (this._displayPref) {
            case MPH: {
                this._maxSpeedBox.setText(formatter.format(speed * this._scale * 2.2369363f));
                break;
            }
            case KPH: {
                this._maxSpeedBox.setText(formatter.format(speed * this._scale * 3.6f));
                break;
            }
            case MMPS: {
                this._maxSpeedBox.setText(formatter.format(speed * 1000.0f));
                break;
            }
            default: {
                this._maxSpeedBox.setText(formatter.format(speed * 39.37f));
            }
        }
    }

    private void unitsEventAction(@Nonnull JButton button, JTextField field) {
        try {
            this.getDistance(this._originDist, (BlockOrder)this._orders.get(0));
            this.getDistance(this._destDist, (BlockOrder)this._orders.get(this._orders.size() - 1));
        }
        catch (JmriException je) {
            JmriJOptionPane.showMessageDialog(this, je.getMessage(), Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        this._units = button.getText().equals(WarrantRoute.Display.IN.toString()) ? WarrantRoute.Display.CM : WarrantRoute.Display.IN;
        this.setFieldText(this._originUnits, this._originDist);
        this.setFieldText(this._destUnits, this._destDist);
    }

    private void setFieldText(@Nonnull JButton button, @Nonnull JTextField field) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMaximumFractionDigits(2);
        float num = 0.0f;
        try {
            num = formatter.parse(field.getText()).floatValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        num = this._units.equals((Object)WarrantRoute.Display.IN) ? (num *= 0.393701f) : (num *= 2.54f);
        button.setText(this._units.toString());
        field.setText(formatter.format(num));
    }

    private JPanel makeAutoRunPanel() {
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 3));
        WarrantRoute.DisplayButton speedUnitsButton = new WarrantRoute.DisplayButton(this._displayPref);
        this._originUnits = new WarrantRoute.DisplayButton(this._units);
        this._destUnits = new WarrantRoute.DisplayButton(this._units);
        this._maxThrottleBox.addActionListener(evt -> this.maxThrottleEventAction());
        this._maxSpeedBox.addActionListener(evt -> {
            float maxNum;
            float num;
            NumberFormat formatter = NumberFormat.getNumberInstance();
            formatter.setMaximumFractionDigits(2);
            try {
                num = formatter.parse(this._maxSpeedBox.getText()).floatValue();
            }
            catch (ParseException pe) {
                this._maxSpeedBox.setText("");
                return;
            }
            if (num < 0.0f) {
                this._maxSpeedBox.setText(formatter.format(0L));
                this._maxThrottleBox.setText(formatter.format(0L));
                return;
            }
            float maxSpeed = this._speedUtil.getTrackSpeed(1.0f);
            switch (this._displayPref) {
                case MPH: {
                    maxNum = maxSpeed * 2.2369363f * this._scale;
                    break;
                }
                case KPH: {
                    maxNum = maxSpeed * 3.6f * this._scale;
                    break;
                }
                case MMPS: {
                    maxNum = maxSpeed * 1000.0f;
                    break;
                }
                default: {
                    maxNum = maxSpeed * 39.37f;
                }
            }
            if (num > maxNum) {
                String name = this._speedUtil.getRosterId();
                if (!(name != null && name.charAt(0) != '$' || (name = this.getTrainName()) != null && !name.isEmpty())) {
                    name = Bundle.getMessage("Unknown");
                }
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("maxSpeedLimit", name, formatter.format(maxNum), speedUnitsButton.getText()), Bundle.getMessage("MessageTitle"), 1);
                this._maxSpeedBox.setText(formatter.format(maxNum));
                this._maxThrottleBox.setText(formatter.format(100L));
                return;
            }
            switch (this._displayPref) {
                case MPH: {
                    num = num * 0.44704f / this._scale;
                    break;
                }
                case KPH: {
                    num = num * 0.277778f / this._scale;
                    break;
                }
                case MMPS: {
                    num /= 1000.0f;
                    break;
                }
                default: {
                    num /= 39.37f;
                }
            }
            float throttle = this._speedUtil.getThrottleSettingForSpeed(num) * 100.0f;
            this._maxThrottleBox.setText(formatter.format(throttle));
        });
        speedUnitsButton.addActionListener(evt -> {
            float num;
            NumberFormat formatter = NumberFormat.getNumberInstance();
            try {
                num = formatter.parse(this._maxSpeedBox.getText()).floatValue();
            }
            catch (ParseException pe) {
                this._maxSpeedBox.setText(null);
                return;
            }
            switch (this._displayPref) {
                case MPH: {
                    this._displayPref = WarrantRoute.Display.KPH;
                    this._maxSpeedBox.setText(formatter.format(num * 1.60934f));
                    break;
                }
                case KPH: {
                    this._displayPref = WarrantRoute.Display.MMPS;
                    this._maxSpeedBox.setText(formatter.format(num * 277.778f / this._scale));
                    this._maxSpeedBoxLabel.setText(Bundle.getMessage("trackSpeed"));
                    break;
                }
                case MMPS: {
                    this._displayPref = WarrantRoute.Display.INPS;
                    this._maxSpeedBox.setText(formatter.format(num * 0.03937f));
                    break;
                }
                default: {
                    this._displayPref = WarrantRoute.Display.MPH;
                    this._maxSpeedBox.setText(formatter.format(num * 0.056818f * this._scale));
                    this._maxSpeedBoxLabel.setText(Bundle.getMessage("scaleSpeed"));
                }
            }
            speedUnitsButton.setDisplayPref(this._displayPref);
        });
        p1.add(NXFrame.makeTextAndButtonPanel(this._maxThrottleBox, new JLabel(Bundle.getMessage("percent")), new JLabel(Bundle.getMessage("MaxSpeed")), "ToolTipPercentThrottle"));
        p1.add(NXFrame.makeTextAndButtonPanel(this._maxSpeedBox, speedUnitsButton, this._maxSpeedBoxLabel, "ToolTipScaleSpeed"));
        this._originUnits.addActionListener(evt -> this.unitsEventAction(this._originUnits, this._originDist));
        this._destUnits.addActionListener(evt -> this.unitsEventAction(this._destUnits, this._destDist));
        p1.add(NXFrame.makeTextAndButtonPanel(this._originDist, this._originUnits, new JLabel(Bundle.getMessage("startDistance")), "ToolTipStartDistance"));
        p1.add(NXFrame.makeTextAndButtonPanel(this._destDist, this._destUnits, new JLabel(Bundle.getMessage("stopDistance")), "ToolTipStopDistance"));
        p1.add(WarrantPreferencesPanel.timeIncrementPanel(false, this._timeIncre));
        p1.add(WarrantPreferencesPanel.throttleIncrementPanel(false, this._rampIncre));
        this._rampIncre.addActionListener(e -> {
            boolean showdialog;
            String text = this._rampIncre.getText();
            try {
                float incr = NumberFormat.getNumberInstance().parse(text).floatValue();
                showdialog = incr < 0.5f || incr > 25.0f;
            }
            catch (ParseException pe) {
                showdialog = true;
            }
            if (showdialog) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("rampIncrWarning", text), Bundle.getMessage("WarningTitle"), 2);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._forward);
        bg.add(this._reverse);
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 2));
        pp.add(Box.createHorizontalGlue());
        pp.add(NXFrame.makeTextBoxPanel(false, this._forward, "forward", null));
        pp.add(NXFrame.makeTextBoxPanel(false, this._reverse, "reverse", null));
        pp.add(Box.createHorizontalGlue());
        p1.add(pp);
        this.__trainHolder.setLayout(new BoxLayout(this.__trainHolder, 3));
        this._trainPanel = this.makeTrainIdPanel(null);
        this.__trainHolder.add(this._trainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 3));
        p2.add(this.__trainHolder);
        p2.add(NXFrame.makeTextBoxPanel(this._noRamp, "NoRamping", "ToolTipNoRamping"));
        p2.add(NXFrame.makeTextBoxPanel(this._noSound, "NoSound", "ToolTipNoSound"));
        p2.add(NXFrame.makeTextBoxPanel(this._stageEStop, "StageEStop", null));
        p2.add(NXFrame.makeTextBoxPanel(this._haltStartBox, "HaltAtStart", null));
        p2.add(NXFrame.makeTextBoxPanel(this._shareRouteBox, "ShareRoute", "ToolTipShareRoute"));
        p2.add(NXFrame.makeTextBoxPanel(this._addTracker, "AddTracker", "ToolTipAddTracker"));
        JPanel autoRunPanel = new JPanel();
        autoRunPanel.setLayout(new BoxLayout(autoRunPanel, 3));
        JPanel ppp = new JPanel();
        ppp.setLayout(new BoxLayout(ppp, 2));
        ppp.add(Box.createHorizontalStrut(STRUT_SIZE));
        ppp.add(p1);
        ppp.add(Box.createHorizontalGlue());
        ppp.add(p2);
        ppp.add(Box.createHorizontalStrut(STRUT_SIZE));
        autoRunPanel.add(ppp);
        this._forward.addActionListener(evt -> this.maxThrottleEventAction());
        this._reverse.addActionListener(evt -> this.maxThrottleEventAction());
        return autoRunPanel;
    }

    private void updateAutoRunPanel() {
        this._startDist = this.getPathLength((BlockOrder)this._orders.get(0)) * 0.4f;
        this._stopDist = this.getPathLength((BlockOrder)this._orders.get(this._orders.size() - 1)) * 0.6f;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        if (this._units.equals((Object)WarrantRoute.Display.IN)) {
            this._originDist.setText(formatter.format((double)this._startDist * 0.0393701));
            this._destDist.setText(formatter.format((double)this._stopDist * 0.0393701));
        } else {
            this._originDist.setText(formatter.format(this._startDist / 10.0f));
            this._destDist.setText(formatter.format(this._stopDist / 10.0f));
        }
        this._autoRunPanel.repaint();
    }

    private void makeMenus() {
        this.setTitle(Bundle.getMessage("AutoWarrant"));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.logix.NXWarrant", true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        log.trace("propertyChange \"{}\" old= {} new= {} source= {}", new Object[]{property, e.getOldValue(), e.getNewValue(), e.getSource().getClass().getName()});
        if (property.equals("DnDrop")) {
            this.doAction(e.getSource());
        }
    }

    @Override
    protected void selectedRoute(ArrayList<BlockOrder> orders) {
        JPanel con = (JPanel)this.getContentPane().getComponent(0);
        con.removeAll();
        if (this._runAuto.isSelected()) {
            con.add(this._autoRunPanel);
        } else {
            con.add(this._trainPanel);
        }
        con.add(this._switchPanel);
        this.updateAutoRunPanel();
        this.pack();
    }

    private void makeAndRunWarrant() {
        int mode;
        String msg = this.getBoxData();
        if (msg == null) {
            msg = this.checkLocoAddress();
        }
        if (msg != null) {
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        String s = ("" + Math.random()).substring(2);
        Warrant warrant = new Warrant("IW" + s, "NX(" + this.getAddress() + ")");
        warrant.setBlockOrders(this._orders);
        warrant.setTrainName(this.getTrainName());
        warrant.setNoRamp(this._noRamp.isSelected());
        this._speedUtil.setIsForward(this._forward.isSelected());
        warrant.setSpeedUtil(this._speedUtil);
        log.debug("Warrant {}. Route and loco set.", (Object)warrant.getDisplayName());
        if (!this._runManual.isSelected()) {
            mode = 2;
            warrant.setShareRoute(this._shareRouteBox.isSelected());
            warrant.setAddTracker(this._addTracker.isSelected());
            warrant.setHaltStart(this._haltStartBox.isSelected());
            msg = this.makeCommands(warrant);
        } else {
            mode = 3;
        }
        if (msg == null) {
            WarrantTableFrame tableFrame = WarrantTableFrame.getDefault();
            tableFrame.setVisible(true);
            warrant.setNXWarrant(true);
            tableFrame.getModel().addNXWarrant(warrant);
            log.debug("NXWarrant added to table");
            msg = tableFrame.runTrain(warrant, mode);
            if (msg != null) {
                log.debug("WarrantTableFrame run warrant. msg= {} Remove warrant {}", (Object)msg, (Object)warrant.getDisplayName());
                tableFrame.getModel().removeWarrant(warrant, false);
            }
        }
        if (msg != null) {
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
        } else {
            WarrantTableAction.getDefault().closeNXFrame();
        }
    }

    protected void setMaxSpeed(float s) {
        this._maxThrottle = s;
        this._maxThrottleBox.setText(NumberFormat.getNumberInstance().format(s));
    }

    private String getBoxData() {
        float maxSpeed;
        String text = null;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        try {
            text = this._maxThrottleBox.getText();
            maxSpeed = formatter.parse(text).floatValue();
        }
        catch (ParseException pe) {
            if (text == null) {
                text = "\"\"";
            }
            return Bundle.getMessage("badSpeed100", text);
        }
        try {
            this._startDist = this.getDistance(this._originDist, (BlockOrder)this._orders.get(0));
            if (this._startDist < 2.0f) {
                this._startDist = 2.0f;
            }
        }
        catch (JmriException je) {
            return je.getMessage();
        }
        try {
            this._stopDist = this.getDistance(this._destDist, (BlockOrder)this._orders.get(this._orders.size() - 1));
            if (this._stopDist < 2.0f) {
                this._stopDist = 2.0f;
            }
        }
        catch (JmriException je) {
            return je.getMessage();
        }
        if (maxSpeed > 100.0f || maxSpeed < 0.001f) {
            return Bundle.getMessage("badSpeed100", Float.valueOf(maxSpeed));
        }
        this._maxThrottle = maxSpeed / 100.0f;
        String msg = this.setAddress();
        if (msg != null) {
            return msg;
        }
        int time = (Integer)this._timeIncre.getValue();
        this._speedUtil.setRampTimeIncrement(time);
        try {
            text = this._rampIncre.getText();
            float incre = NumberFormat.getNumberInstance().parse(text).floatValue();
            if (incre < 0.5f || incre > 25.0f) {
                return Bundle.getMessage("rampIncrWarning", text);
            }
            this._speedUtil.setRampThrottleIncrement(incre / 100.0f);
        }
        catch (ParseException pe) {
            return Bundle.getMessage("MustBeFloat", text);
        }
        return null;
    }

    private float getDistance(@Nonnull JTextField field, @Nonnull BlockOrder bo) throws JmriException {
        float distance;
        NumberFormat formatter = NumberFormat.getNumberInstance();
        String text = field.getText();
        try {
            distance = formatter.parse(text).floatValue();
        }
        catch (ParseException pe) {
            throw new JmriException(Bundle.getMessage("MustBeFloat", text));
        }
        float pathLen = this.getPathLength(bo);
        if (pathLen <= 0.0f) {
            throw new JmriException(Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName()));
        }
        if (this._units.equals((Object)WarrantRoute.Display.IN)) {
            if ((distance *= 25.4f) > pathLen) {
                field.setText(formatter.format(pathLen * 0.03937008f));
                throw new JmriException(Bundle.getMessage("BadLengthIn", bo.getPathName(), bo.getBlock().getDisplayName(), Float.valueOf(pathLen * 0.03937008f), text));
            }
            if (distance < 0.0f) {
                field.setText("0");
                throw new JmriException(Bundle.getMessage("BadLengthIn", bo.getPathName(), bo.getBlock().getDisplayName(), Float.valueOf(pathLen * 0.03937008f), text));
            }
        } else {
            if ((distance *= 10.0f) > pathLen) {
                field.setText(formatter.format(pathLen * 0.1f));
                throw new JmriException(Bundle.getMessage("BadLengthCm", bo.getPathName(), bo.getBlock().getDisplayName(), Float.valueOf(pathLen * 0.1f), text));
            }
            if (distance < 0.0f) {
                field.setText("0");
                throw new JmriException(Bundle.getMessage("BadLengthCm", bo.getPathName(), bo.getBlock().getDisplayName(), Float.valueOf(pathLen * 0.1f), text));
            }
        }
        return distance;
    }

    private float getPathLength(@Nonnull BlockOrder bo) {
        float len = bo.getPathLength();
        if (len <= 0.0f && (len = bo.getPathLength()) <= 0.0f) {
            String sLen = JmriJOptionPane.showInputDialog(this, Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName()) + Bundle.getMessage("getPathLength", bo.getPathName(), bo.getBlock().getDisplayName()), Bundle.getMessage("WarningTitle"), 2);
            try {
                len = NumberFormat.getNumberInstance().parse(sLen).floatValue();
            }
            catch (NullPointerException | ParseException pe) {
                len = 0.0f;
            }
            bo.setPathLength(len);
        }
        return len;
    }

    private float getTotalLength() throws JmriException {
        List<BlockOrder> orders = this.getOrders();
        float totalLen = this._startDist;
        for (int i = 1; i < orders.size() - 1; ++i) {
            BlockOrder bo = orders.get(i);
            float pathLen = this.getPathLength(bo);
            if (pathLen <= 0.0f) {
                throw new JmriException(Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName()));
            }
            totalLen += pathLen;
        }
        return totalLen += this._stopDist;
    }

    @CheckForNull
    private String makeCommands(@Nonnull Warrant w) {
        float totalLen;
        int cmdNum;
        int nextIdx = 0;
        List<BlockOrder> orders = this.getOrders();
        BlockOrder bo = orders.get(nextIdx++);
        String blockName = bo.getBlock().getDisplayName();
        w.addThrottleCommand(new ThrottleSetting(0L, ThrottleSetting.Command.FKEY, 0, ThrottleSetting.ValueType.VAL_ON, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
        if (this._forward.isSelected()) {
            w.addThrottleCommand(new ThrottleSetting(100L, ThrottleSetting.Command.FORWARD, -1, ThrottleSetting.ValueType.VAL_TRUE, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
            if (!this._noSound.isSelected()) {
                w.addThrottleCommand(new ThrottleSetting(1000L, ThrottleSetting.Command.FKEY, 2, ThrottleSetting.ValueType.VAL_ON, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                w.addThrottleCommand(new ThrottleSetting(2500L, ThrottleSetting.Command.FKEY, 2, ThrottleSetting.ValueType.VAL_OFF, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                w.addThrottleCommand(new ThrottleSetting(1000L, ThrottleSetting.Command.FKEY, 2, ThrottleSetting.ValueType.VAL_ON, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                w.addThrottleCommand(new ThrottleSetting(2500L, ThrottleSetting.Command.FKEY, 2, ThrottleSetting.ValueType.VAL_OFF, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                cmdNum = 7;
            } else {
                cmdNum = 3;
            }
        } else {
            w.addThrottleCommand(new ThrottleSetting(100L, ThrottleSetting.Command.FORWARD, -1, ThrottleSetting.ValueType.VAL_FALSE, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
            if (!this._noSound.isSelected()) {
                w.addThrottleCommand(new ThrottleSetting(1000L, ThrottleSetting.Command.FKEY, 3, ThrottleSetting.ValueType.VAL_ON, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                w.addThrottleCommand(new ThrottleSetting(500L, ThrottleSetting.Command.FKEY, 3, ThrottleSetting.ValueType.VAL_OFF, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                w.addThrottleCommand(new ThrottleSetting(500L, ThrottleSetting.Command.FKEY, 3, ThrottleSetting.ValueType.VAL_ON, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                w.addThrottleCommand(new ThrottleSetting(500L, ThrottleSetting.Command.FKEY, 3, ThrottleSetting.ValueType.VAL_OFF, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
                cmdNum = 6;
            } else {
                cmdNum = 2;
            }
        }
        try {
            totalLen = this.getTotalLength();
        }
        catch (JmriException je) {
            return je.getMessage();
        }
        RampData upRamp = this._speedUtil.getRampForSpeedChange(0.0f, this._maxThrottle);
        RampData downRamp = this._speedUtil.getRampForSpeedChange(this._maxThrottle, 0.0f);
        float upRampLength = upRamp.getRampLength();
        float dnRampLength = downRamp.getRampLength();
        int timeInterval = downRamp.getRampTimeIncrement();
        float intervalDist = totalLen - (upRampLength + dnRampLength);
        while (intervalDist < 0.0f) {
            log.debug("Route length= {}, upRampLength= {}, dnRampLength= {}, intervalDist= {}, _maxThrottle= {}", new Object[]{Float.valueOf(totalLen), Float.valueOf(upRampLength), Float.valueOf(dnRampLength), Float.valueOf(intervalDist), Float.valueOf(this._maxThrottle)});
            ListIterator<Float> downIter = downRamp.speedIterator(false);
            float prevSetting = downIter.previous().floatValue();
            this._maxThrottle = downIter.hasPrevious() ? (prevSetting = downIter.previous().floatValue()) : this._speedUtil.getThrottleSettingForSpeed(totalLen / (float)(timeInterval * 2));
            upRamp = this._speedUtil.getRampForSpeedChange(0.0f, this._maxThrottle);
            downRamp = this._speedUtil.getRampForSpeedChange(this._maxThrottle, 0.0f);
            upRampLength = upRamp.getRampLength();
            dnRampLength = downRamp.getRampLength();
            intervalDist = totalLen - (upRampLength + dnRampLength);
        }
        if (upRampLength < 1.0f) {
            upRamp = this._speedUtil.getRampForSpeedChange(0.0f, this._speedUtil.getRampThrottleIncrement());
        }
        if (dnRampLength < 1.0f) {
            downRamp = this._speedUtil.getRampForSpeedChange(0.0f, this._speedUtil.getRampThrottleIncrement());
        }
        log.debug("Route length= {}, upRampLength= {}, dnRampLength= {}, intervalDist= {}, _maxThrottle= {}", new Object[]{Float.valueOf(totalLen), Float.valueOf(upRampLength), Float.valueOf(dnRampLength), Float.valueOf(intervalDist), Float.valueOf(this._maxThrottle)});
        float blockLen = this._startDist;
        float sumBlkLen = 0.0f;
        int speedTime = 0;
        int noopTime = 0;
        ListIterator<Float> iter = upRamp.speedIterator(true);
        float curThrottle = 0.0f;
        float prevThrottle = 0.0f;
        float curDistance = 0.0f;
        float blkDistance = 0.0f;
        float dist = 0.0f;
        log.debug("Start in block \"{}\" startDist= {} stopDist= {}", new Object[]{blockName, Float.valueOf(this._startDist), Float.valueOf(this._stopDist)});
        while (iter.hasNext()) {
            while (iter.hasNext() && !(blkDistance + (dist = this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, speedTime)) >= blockLen)) {
                blkDistance += dist;
                curDistance += dist;
                float nextThrottle = iter.next().floatValue();
                w.addThrottleCommand(new ThrottleSetting(speedTime, ThrottleSetting.Command.SPEED, -1, ThrottleSetting.ValueType.VAL_FLOAT, SpeedStepMode.UNKNOWN, nextThrottle, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
                if (log.isDebugEnabled()) {
                    log.debug("cmd#{}. UpRamp block \"{}\" set speed {} after {}ms dist= {} from {} to {}, blkDist= {} curDist= {}", new Object[]{cmdNum++, blockName, Float.valueOf(nextThrottle), speedTime, Float.valueOf(dist), Float.valueOf(prevThrottle), Float.valueOf(curThrottle), Float.valueOf(blkDistance), Float.valueOf(curDistance)});
                }
                prevThrottle = curThrottle;
                curThrottle = nextThrottle;
                speedTime = timeInterval;
            }
            if (blkDistance >= blockLen) {
                noopTime = this._speedUtil.getTimeForDistance(curThrottle, blockLen);
                speedTime = this._speedUtil.getTimeForDistance(curThrottle, blkDistance - blockLen);
            } else {
                noopTime = this._speedUtil.getTimeForDistance(curThrottle, blockLen - blkDistance);
                speedTime = timeInterval - noopTime;
            }
            if (log.isDebugEnabled()) {
                log.debug("Leave block \"{}\"  curThrottle= {}, blockLen= {} blkDist= {}, noopTime= {} 'speedTime'= {}, curDist= {}", new Object[]{blockName, Float.valueOf(curThrottle), Float.valueOf(blockLen), Float.valueOf(blkDistance), noopTime, speedTime, Float.valueOf(curDistance)});
            }
            if (!iter.hasNext()) break;
            if (nextIdx >= orders.size()) continue;
            speedTime = noopTime > timeInterval ? 0 : timeInterval - noopTime;
            dist = this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, noopTime);
            blkDistance += dist;
            curDistance += dist;
            sumBlkLen += blockLen;
            if ((blockLen = this.getPathLength(bo = orders.get(nextIdx++))) <= 0.0f) {
                return Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName());
            }
            blockName = bo.getBlock().getDisplayName();
            w.addThrottleCommand(new ThrottleSetting(noopTime, ThrottleSetting.Command.NOOP, -1, ThrottleSetting.ValueType.VAL_NOOP, SpeedStepMode.UNKNOWN, 0.0f, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
            if (log.isDebugEnabled()) {
                log.debug("cmd#{}. Enter RampUp block \"{}\" noopTime= {}, dist= {} blockLen= {}, blkDist= {}, sumBlkLen= {}, curDist= {}", new Object[]{cmdNum++, blockName, noopTime, Float.valueOf(dist), Float.valueOf(blockLen), Float.valueOf(blkDistance), Float.valueOf(sumBlkLen), Float.valueOf(curDistance)});
            }
            blkDistance = 0.0f;
            curDistance = sumBlkLen;
        }
        if ((double)blkDistance < 0.01) {
            dist = this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, speedTime);
            log.debug("No speed increase in block \"{}\" speedTime= {} dist= {}, blkDist= {}, curDist= {} upRampLength={}", new Object[]{blockName, speedTime, Float.valueOf(dist), Float.valueOf(blkDistance), Float.valueOf(curDistance), Float.valueOf(upRampLength)});
            blkDistance += dist;
            curDistance += dist;
        }
        log.debug("Ramp Up done in block \"{}\" speedTime= {} dist= {}, blkDist= {}, curDist= {} upRampLength= {} diff= {}", new Object[]{blockName, speedTime, Float.valueOf(dist), Float.valueOf(blkDistance), Float.valueOf(curDistance), Float.valueOf(upRampLength), Float.valueOf(upRampLength - curDistance)});
        blkDistance += upRampLength - curDistance;
        curDistance = upRampLength;
        if (log.isDebugEnabled()) {
            log.debug("Ramp Up done in block \"{}\" timeInterval= {} dist= {}, blkDist= {}, curDist= {} upRampLength= {}", new Object[]{blockName, noopTime, Float.valueOf(dist), Float.valueOf(blkDistance), Float.valueOf(curDistance), Float.valueOf(upRampLength)});
        }
        prevThrottle = curThrottle;
        if (log.isDebugEnabled() && (double)Math.abs(curThrottle - this._maxThrottle) > 0.001) {
            log.error("curThrottle = {} _maxThrottle = {} prevThrottle= {}", new Object[]{Float.valueOf(curThrottle), Float.valueOf(this._maxThrottle), Float.valueOf(prevThrottle)});
        }
        if (totalLen - sumBlkLen - blockLen > dnRampLength) {
            if (!iter.hasNext()) {
                if (nextIdx < orders.size()) {
                    dist = this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, noopTime);
                    blkDistance += dist;
                    curDistance += dist;
                    sumBlkLen += blockLen;
                    int n = nextIdx++;
                    bo = orders.get(n);
                    blockLen = this.getPathLength(bo);
                    if (blockLen <= 0.0f) {
                        return Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName());
                    }
                    blockName = bo.getBlock().getDisplayName();
                    w.addThrottleCommand(new ThrottleSetting(noopTime, ThrottleSetting.Command.NOOP, -1, ThrottleSetting.ValueType.VAL_NOOP, SpeedStepMode.UNKNOWN, 0.0f, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
                    if (log.isDebugEnabled()) {
                        log.debug("cmd#{}. Enter RampUp block \"{}\" noopTime= {}, dist= {} blockLen= {}, blkDist= {}, sumBlkLen= {}, curDist= {}", new Object[]{cmdNum++, blockName, noopTime, Float.valueOf(dist), Float.valueOf(blockLen), Float.valueOf(blkDistance), Float.valueOf(sumBlkLen), Float.valueOf(curDistance)});
                    }
                    curDistance = sumBlkLen;
                    blkDistance = 0.0f;
                } else if (log.isDebugEnabled()) {
                    log.debug("Ramp Up done at last block \"{}\" curThrottle={}, blkDist={}, curDist={}", new Object[]{blockName, Float.valueOf(curThrottle), Float.valueOf(blkDistance), Float.valueOf(curDistance)});
                }
                while (nextIdx < orders.size() && totalLen - sumBlkLen - blockLen > dnRampLength) {
                    noopTime = this._speedUtil.getTimeForDistance(curThrottle, blockLen);
                    sumBlkLen += blockLen;
                    curDistance += blockLen;
                    if (log.isDebugEnabled()) {
                        log.debug("Leave MidRoute block \"{}\" noopTime= {} blockLen= {}, sumBlkLen= {}, curDist={}", new Object[]{blockName, noopTime, Float.valueOf(blockLen), Float.valueOf(sumBlkLen), Float.valueOf(curDistance)});
                    }
                    int n = nextIdx++;
                    bo = orders.get(n);
                    blockLen = this.getPathLength(bo);
                    if (blockLen <= 0.0f) {
                        return Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName());
                    }
                    blockName = bo.getBlock().getDisplayName();
                    if (nextIdx == orders.size()) {
                        blockLen = this._stopDist;
                    }
                    w.addThrottleCommand(new ThrottleSetting(noopTime, ThrottleSetting.Command.NOOP, -1, ThrottleSetting.ValueType.VAL_NOOP, SpeedStepMode.UNKNOWN, 0.0f, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
                    if (!log.isDebugEnabled()) continue;
                    log.debug("cmd#{}. Enter MidRoute block \"{}\" noopTime= {},blockLen= {}, sumBlkLen= {}, curDist={}", new Object[]{cmdNum++, blockName, noopTime, Float.valueOf(blockLen), Float.valueOf(sumBlkLen), Float.valueOf(curDistance)});
                }
            }
            blkDistance = 0.0f;
            dist = totalLen - sumBlkLen - dnRampLength;
        } else {
            dist = totalLen - dnRampLength - upRampLength;
        }
        speedTime = this._speedUtil.getTimeForDistance(curThrottle, dist);
        blkDistance += dist;
        float diff = totalLen - dnRampLength - (curDistance += dist);
        if (log.isDebugEnabled()) {
            log.debug("Begin Ramp Down in block \"{}\" speedTime= {} dist= {}, blkDist= {}, curDist= {} dnRampLength= {} diff= {}", new Object[]{blockName, speedTime, Float.valueOf(dist), Float.valueOf(blkDistance), Float.valueOf(curDistance), Float.valueOf(dnRampLength), Float.valueOf(diff)});
        }
        blkDistance += diff;
        curDistance = totalLen - dnRampLength;
        if (log.isDebugEnabled()) {
            log.debug("Begin Ramp Down at block \"{}\" blockLen={}, at blkDistance= {} curDist= {} sumBlkLen= {} curThrottle= {}", new Object[]{blockName, Float.valueOf(blockLen), Float.valueOf(blkDistance), Float.valueOf(curDistance), Float.valueOf(sumBlkLen), Float.valueOf(curThrottle)});
        }
        iter = downRamp.speedIterator(false);
        iter.previous();
        float nextThrottle = iter.previous().floatValue();
        w.addThrottleCommand(new ThrottleSetting(speedTime, ThrottleSetting.Command.SPEED, -1, ThrottleSetting.ValueType.VAL_FLOAT, SpeedStepMode.UNKNOWN, nextThrottle, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
        if (log.isDebugEnabled()) {
            log.debug("cmd#{}. DownRamp block \"{}\" set speed {} after {}ms dist= {} from {} to {}, blkDist= {} curDist={}", new Object[]{cmdNum++, blockName, Float.valueOf(nextThrottle), speedTime, Float.valueOf(dist), Float.valueOf(prevThrottle), Float.valueOf(curThrottle), Float.valueOf(blkDistance), Float.valueOf(curDistance)});
        }
        prevThrottle = curThrottle;
        curThrottle = nextThrottle;
        speedTime = timeInterval;
        while (iter.hasPrevious()) {
            if (nextIdx == orders.size() && this._stageEStop.isSelected()) {
                w.addThrottleCommand(new ThrottleSetting(50L, ThrottleSetting.Command.SPEED, -1, ThrottleSetting.ValueType.VAL_FLOAT, SpeedStepMode.UNKNOWN, -0.5f, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
                log.debug("cmd#{}. At block \"{}\" EStop set speed= {}", new Object[]{cmdNum++, blockName, -0.5});
                break;
            }
            nextThrottle = curThrottle;
            while (iter.hasPrevious() && !(blkDistance + (dist = this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, speedTime)) >= blockLen)) {
                nextThrottle = iter.previous().floatValue();
                if (!iter.hasPrevious() && nextIdx != orders.size()) {
                    log.debug("BEFORE last block! Set speed {} in block \"{}\" after {}ms!dist= {}, blkDist= {} curDist={}, blockLen= {}", new Object[]{Float.valueOf(nextThrottle), blockName, speedTime, Float.valueOf(dist), Float.valueOf(blkDistance), Float.valueOf(curDistance), Float.valueOf(blockLen)});
                    iter.next();
                    noopTime = speedTime;
                    speedTime = -1;
                    break;
                }
                blkDistance += dist;
                curDistance += dist;
                w.addThrottleCommand(new ThrottleSetting(speedTime, ThrottleSetting.Command.SPEED, -1, ThrottleSetting.ValueType.VAL_FLOAT, SpeedStepMode.UNKNOWN, nextThrottle, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
                if (log.isDebugEnabled()) {
                    log.debug("cmd#{}. DownRamp block \"{}\" set speed {} after {}ms dist= {} from {} to {}, blkDist= {} curDist={}", new Object[]{cmdNum++, blockName, Float.valueOf(nextThrottle), speedTime, Float.valueOf(dist), Float.valueOf(prevThrottle), Float.valueOf(curThrottle), Float.valueOf(blkDistance), Float.valueOf(curDistance)});
                }
                prevThrottle = curThrottle;
                curThrottle = nextThrottle;
                speedTime = timeInterval;
            }
            if (!iter.hasPrevious()) break;
            if (speedTime < 0) {
                speedTime = 0;
            } else if (blkDistance >= blockLen) {
                noopTime = this._speedUtil.getTimeForDistance(curThrottle, blockLen);
                speedTime = this._speedUtil.getTimeForDistance(curThrottle, blkDistance - blockLen);
            } else {
                noopTime = this._speedUtil.getTimeForDistance(curThrottle, blockLen - blkDistance);
                speedTime = timeInterval - noopTime;
            }
            if (log.isDebugEnabled()) {
                log.debug("Leave block \"{}\" curThrottle= {}, blockLen= {} BlkDist= {}, noopTime= {} 'speedTime'= {}, curDist= {}", new Object[]{blockName, Float.valueOf(curThrottle), Float.valueOf(blockLen), Float.valueOf(blkDistance), noopTime, speedTime, Float.valueOf(curDistance)});
            }
            if (nextIdx < orders.size()) {
                speedTime = noopTime > timeInterval ? 0 : timeInterval - noopTime;
                dist = this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, noopTime);
                blkDistance += dist;
                curDistance += dist;
                sumBlkLen += blockLen;
                bo = orders.get(nextIdx++);
                blockLen = nextIdx == orders.size() ? this._stopDist : this.getPathLength(bo);
                if (blockLen <= 0.0f) {
                    return Bundle.getMessage("zeroPathLength", bo.getPathName(), bo.getBlock().getDisplayName());
                }
                blockName = bo.getBlock().getDisplayName();
                w.addThrottleCommand(new ThrottleSetting(noopTime, ThrottleSetting.Command.NOOP, -1, ThrottleSetting.ValueType.VAL_NOOP, SpeedStepMode.UNKNOWN, 0.0f, "", blockName, this._speedUtil.getTrackSpeed(curThrottle)));
                if (log.isDebugEnabled()) {
                    log.debug("cmd#{}. Enter RampDown block \"{}\" noopTime= {}, dist= {} blockLen= {}, blkDist= {}, sumBlkLen= {}, curDist= {}", new Object[]{cmdNum++, blockName, noopTime, Float.valueOf(dist), Float.valueOf(blockLen), Float.valueOf(blkDistance), Float.valueOf(sumBlkLen), Float.valueOf(curDistance)});
                }
                blkDistance = 0.0f;
                curDistance = sumBlkLen;
                if (nextIdx != orders.size() || !((dist = this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, speedTime)) > blockLen)) continue;
                speedTime = 0;
                continue;
            }
            if (!iter.hasPrevious()) continue;
            this._stageEStop.setSelected(true);
            log.error("cmd#{}. ERROR speed in block \"{}\" set speed {} after {}ms dist= {} from {} to {}, blkDist= {} curDist={}", new Object[]{cmdNum++, blockName, Float.valueOf(nextThrottle), speedTime, Float.valueOf(dist), Float.valueOf(prevThrottle), Float.valueOf(curThrottle), Float.valueOf(blkDistance), Float.valueOf(curDistance)});
        }
        if (log.isDebugEnabled()) {
            log.debug("Ramp down done at block \"{}\", blockLen= {}, BlkDist= {}, curDist= {}, sumBlkLen= {}, totalLen= {},", new Object[]{blockName, Float.valueOf(blockLen), Float.valueOf(blkDistance), Float.valueOf(curDistance += this._speedUtil.getDistanceOfSpeedChange(prevThrottle, curThrottle, speedTime)), Float.valueOf(sumBlkLen += this._stopDist), Float.valueOf(totalLen)});
        }
        if (!this._noSound.isSelected()) {
            w.addThrottleCommand(new ThrottleSetting(500L, ThrottleSetting.Command.FKEY, 1, ThrottleSetting.ValueType.VAL_OFF, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
            w.addThrottleCommand(new ThrottleSetting(1000L, ThrottleSetting.Command.FKEY, 2, ThrottleSetting.ValueType.VAL_ON, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
            w.addThrottleCommand(new ThrottleSetting(2000L, ThrottleSetting.Command.FKEY, 2, ThrottleSetting.ValueType.VAL_OFF, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
        }
        w.addThrottleCommand(new ThrottleSetting(500L, ThrottleSetting.Command.FKEY, 0, ThrottleSetting.ValueType.VAL_OFF, SpeedStepMode.UNKNOWN, 0.0f, "", blockName));
        return null;
    }
}

