/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Sensor;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBlock
extends Block
implements PropertyChangeListener {
    public static final int ALLOCATED = 16;
    public static final int RUNNING = 32;
    public static final int OUT_OF_SERVICE = 64;
    public static final int TRACK_ERROR = 128;
    private static final Color DEFAULT_FILL_COLOR = new Color(200, 0, 200);
    public static final String PROPERTY_PATH_STATE = "pathState";
    public static final String PROPERTY_PATH_COUNT = "pathCount";
    public static final String PROPERTY_PORTAL_COUNT = "portalCount";
    public static final String PROPERTY_DELETED = "deleted";
    private List<Portal> _portals = new ArrayList<Portal>();
    private Warrant _warrant;
    private String _pathName;
    protected long _entryTime;
    private boolean _metric = false;
    private NamedBeanHandle<Sensor> _errNamedSensor;
    private Color _markerForeground = Color.WHITE;
    private Color _markerBackground = DEFAULT_FILL_COLOR;
    private Font _markerFont;
    private static final Logger log = LoggerFactory.getLogger(OBlock.class);

    public static String getLocalStatusName(String str) {
        return OBlockStatus.getByName(str).getDescr();
    }

    public static String getSystemStatusName(String str) {
        return OBlockStatus.getByDescr(str).getName();
    }

    public OBlock(@Nonnull String systemName) {
        super(systemName);
        this.setState(256);
    }

    public OBlock(@Nonnull String systemName, String userName) {
        super(systemName, userName);
        this.setState(256);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        OBlock b = (OBlock)obj;
        return b.getSystemName().equals(this.getSystemName());
    }

    @Override
    public int hashCode() {
        return this.getSystemName().hashCode();
    }

    @Override
    public boolean setSensor(String pName) {
        Sensor oldSensor = this.getSensor();
        Sensor newSensor = null;
        if (pName != null && pName.trim().length() > 0) {
            newSensor = InstanceManager.sensorManagerInstance().getByUserName(pName);
            if (newSensor == null) {
                newSensor = InstanceManager.sensorManagerInstance().getBySystemName(pName);
            }
            if (newSensor == null) {
                log.error("No sensor named '{}' exists.", (Object)pName);
                return false;
            }
        }
        if (oldSensor != null && oldSensor.equals(newSensor)) {
            return true;
        }
        int saveState = this.getState() & 0xFFFFFEF0;
        if (newSensor == null || pName == null) {
            this.setNamedSensor(null);
        } else {
            this.setNamedSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, newSensor));
        }
        this.setState(this.getState() | saveState);
        this.firePropertyChange("OccupancySensorChange", oldSensor, newSensor);
        return true;
    }

    @Override
    public void setNamedSensor(@CheckForNull NamedBeanHandle<Sensor> namedSensor) {
        super.setNamedSensor(namedSensor);
        Sensor s = this.getSensor();
        if (s != null) {
            this.setState(s.getState() & 0xFFFFFEFF);
        }
    }

    public boolean setErrorSensor(@CheckForNull String pName) {
        NamedBeanHandle<Sensor> newErrSensorHdl = null;
        Sensor newErrSensor = null;
        if (pName != null && pName.trim().length() > 0) {
            newErrSensor = InstanceManager.sensorManagerInstance().getByUserName(pName);
            if (newErrSensor == null) {
                newErrSensor = InstanceManager.sensorManagerInstance().getBySystemName(pName);
            }
            if (newErrSensor != null) {
                newErrSensorHdl = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, newErrSensor);
            }
            if (newErrSensor == null) {
                log.error("No sensor named '{}' exists.", (Object)pName);
                return false;
            }
        }
        if (this._errNamedSensor != null) {
            if (this._errNamedSensor.equals(newErrSensorHdl)) {
                return true;
            }
            this._errNamedSensor.getBean().removePropertyChangeListener(this);
        }
        this._errNamedSensor = newErrSensorHdl;
        this.setState(this.getState() & 0xFFFFFF7F);
        if (newErrSensor != null) {
            newErrSensor.addPropertyChangeListener(this, this._errNamedSensor.getName(), "OBlock Error Sensor " + this.getDisplayName());
            if (newErrSensor.getState() == 2) {
                this.setState(this.getState() | 0x80);
            } else {
                this.setState(this.getState() & 0xFFFFFF7F);
            }
        }
        return true;
    }

    @CheckForNull
    public Sensor getErrorSensor() {
        if (this._errNamedSensor == null) {
            return null;
        }
        return this._errNamedSensor.getBean();
    }

    @CheckForNull
    public NamedBeanHandle<Sensor> getNamedErrorSensor() {
        return this._errNamedSensor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("property change: of \"{}\" property {} is now {} from {}", new Object[]{this.getDisplayName(), evt.getPropertyName(), evt.getNewValue(), evt.getSource().getClass().getName()});
        }
        if (this.getErrorSensor() != null && evt.getSource().equals(this.getErrorSensor()) && "KnownState".equals(evt.getPropertyName())) {
            int errState = (Integer)evt.getNewValue();
            int oldState = this.getState();
            if (errState == 2) {
                this.setState(oldState | 0x80);
            } else {
                this.setState(oldState & 0xFFFFFF7F);
            }
            this.firePropertyChange(PROPERTY_PATH_STATE, oldState, this.getState());
        }
    }

    @CheckForNull
    protected String isPathSet(@Nonnull String path) {
        String msg = null;
        if (this._warrant != null && path.equals(this._pathName)) {
            msg = this._warrant.getDisplayName();
        }
        log.trace("Path \"{}\" in oblock \"{}\" {}", new Object[]{path, this.getDisplayName(), msg == null ? "not set" : " set in warrant " + msg});
        return msg;
    }

    @CheckForNull
    public Warrant getWarrant() {
        return this._warrant;
    }

    public boolean isAllocatedTo(@CheckForNull Warrant warrant) {
        if (warrant == null) {
            return false;
        }
        return warrant.equals(this._warrant);
    }

    public String getAllocatedPathName() {
        return this._pathName;
    }

    public void setMetricUnits(boolean type) {
        this._metric = type;
    }

    public boolean isMetric() {
        return this._metric;
    }

    public void setMarkerForeground(Color c) {
        this._markerForeground = c;
    }

    public Color getMarkerForeground() {
        return this._markerForeground;
    }

    public void setMarkerBackground(Color c) {
        this._markerBackground = c;
    }

    public Color getMarkerBackground() {
        return this._markerBackground;
    }

    public void setMarkerFont(Font f) {
        this._markerFont = f;
    }

    public Font getMarkerFont() {
        return this._markerFont;
    }

    @Override
    public void setState(int v) {
        int old = this.getState();
        super.setState(v);
        log.debug("\"{}\" setState({})", (Object)this.getDisplayName(), (Object)this.getState());
        this.firePropertyChange("state", old, this.getState());
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (o == null) {
            this._markerForeground = Color.WHITE;
            this._markerBackground = DEFAULT_FILL_COLOR;
            this._markerFont = null;
        }
    }

    public boolean statusIs(String statusName) {
        OBlockStatus oblockStatus = OBlockStatus.getByName(statusName);
        if (oblockStatus != null) {
            return (this.getState() & oblockStatus.getStatus()) != 0;
        }
        log.error("\"{}\" type not found.  Update Conditional State Variable testing OBlock \"{}\" status", (Object)this.getDisplayName(), (Object)statusName);
        return false;
    }

    public boolean isDark() {
        return (this.getState() & 0x100) != 0;
    }

    public boolean isOccupied() {
        return (this.getState() & 2) != 0;
    }

    @CheckForNull
    public String occupiedBy() {
        Warrant w = this._warrant;
        if (this.isOccupied()) {
            if (w != null) {
                return w.getTrainName();
            }
            return Bundle.getMessage("unknownTrain");
        }
        return null;
    }

    public boolean isFree() {
        int state = this.getState();
        return (state & 0x10) == 0 && (state & 2) == 0;
    }

    @CheckForNull
    public String allocate(Warrant warrant) {
        if (warrant == null) {
            log.error("allocate(warrant) called with null warrant in block \"{}\"!", (Object)this.getDisplayName());
            return "ERROR! allocate called with null warrant in block \"" + this.getDisplayName() + "\"!";
        }
        if (this._warrant != null) {
            if (!warrant.equals(this._warrant)) {
                return Bundle.getMessage("AllocatedToWarrant", this._warrant.getDisplayName(), this.getDisplayName(), this._warrant.getTrainName());
            }
            return null;
        }
        this._warrant = warrant;
        if (log.isDebugEnabled()) {
            log.debug("Allocate OBlock \"{}\" to warrant \"{}\".", (Object)this.getDisplayName(), (Object)warrant.getDisplayName());
        }
        int old = this.getState();
        int newState = old | 0x10;
        super.setState(newState);
        this.firePropertyChange("state", old, newState);
        return null;
    }

    protected void showAllocated(Warrant warrant, String pathName) {
        if (this._warrant != null && !this._warrant.equals(warrant)) {
            return;
        }
        if (this._pathName == null) {
            this._pathName = pathName;
        }
        this.firePropertyChange(PROPERTY_PATH_STATE, 0, this.getState());
    }

    @CheckForNull
    public String allocatePath(String pathName) {
        log.debug("Allocate OBlock path \"{}\" in block \"{}\", state= {}", new Object[]{pathName, this.getSystemName(), this.getState()});
        if (pathName == null) {
            log.error("allocate called with null pathName in block \"{}\"!", (Object)this.getDisplayName());
            return null;
        }
        if (this._warrant != null) {
            return Bundle.getMessage("AllocatedToWarrant", this._warrant.getDisplayName(), this.getDisplayName(), this._warrant.getTrainName());
        }
        this._pathName = pathName;
        return null;
    }

    public String getAllocatingWarrantName() {
        if (this._warrant == null) {
            return "no warrant";
        }
        return this._warrant.getDisplayName();
    }

    public boolean deAllocate(Warrant warrant) {
        OPath path;
        if (warrant == null) {
            return true;
        }
        if (this._warrant != null) {
            if (!this._warrant.equals(warrant)) {
                log.warn("{} cannot deallocate. {}", (Object)warrant.getDisplayName(), (Object)Bundle.getMessage("AllocatedToWarrant", this._warrant.getDisplayName(), this.getDisplayName(), this._warrant.getTrainName()));
                return false;
            }
            Warrant curWarrant = this._warrant;
            this._warrant = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("deAllocate block \"{}\" from warrant \"{}\"", (Object)this.getDisplayName(), (Object)warrant.getDisplayName());
                }
                this.removePropertyChangeListener(curWarrant);
            }
            catch (Exception ex) {
                log.trace("Warrant {} unregistered.", (Object)curWarrant.getDisplayName(), (Object)ex);
            }
        }
        this._warrant = null;
        if (this._pathName != null && (path = this.getPathByName(this._pathName)) != null) {
            int lockState = 0;
            path.setTurnouts(0, false, lockState, false);
            Portal portal = path.getFromPortal();
            if (portal != null) {
                portal.setState(1);
            }
            if ((portal = path.getToPortal()) != null) {
                portal.setState(1);
            }
        }
        int old = this.getState();
        super.setState(old & 0xFFFFFFCF);
        this.firePropertyChange("state", old, this.getState());
        return true;
    }

    public void setOutOfService(boolean set) {
        if (set) {
            this.setState(this.getState() | 0x40);
        } else {
            this.setState(this.getState() & 0xFFFFFFBF);
        }
    }

    public void setError(boolean set) {
        if (set) {
            this.setState(this.getState() | 0x80);
        } else {
            this.setState(this.getState() & 0xFFFFFF7F);
        }
    }

    public void addPortal(Portal portal) {
        String name = this.getDisplayName();
        if (!name.equals(portal.getFromBlockName()) && !name.equals(portal.getToBlockName())) {
            log.warn("{} not in block {}", (Object)portal.getDescription(), (Object)this.getDisplayName());
            return;
        }
        String pName = portal.getName();
        if (pName != null) {
            for (Portal value : this._portals) {
                if (!pName.equals(value.getName())) continue;
                return;
            }
        }
        int oldSize = this._portals.size();
        this._portals.add(portal);
        log.trace("add portal \"{}\" to Block \"{}\"", (Object)portal.getName(), (Object)this.getDisplayName());
        this.firePropertyChange(PROPERTY_PORTAL_COUNT, oldSize, this._portals.size());
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    protected void removePortal(@CheckForNull Portal portal) {
        if (portal != null) {
            for (OPath oPath : this.getPaths()) {
                if (portal.equals(oPath.getFromPortal())) {
                    oPath.setFromPortal(null);
                    log.trace("removed Portal {} from Path \"{}\" in oblock {}", new Object[]{portal.getName(), oPath.getName(), this.getDisplayName()});
                }
                if (!portal.equals(oPath.getToPortal())) continue;
                oPath.setToPortal(null);
                log.trace("removed Portal {} from Path \"{}\" in oblock {}", new Object[]{portal.getName(), oPath.getName(), this.getDisplayName()});
            }
            for (OPath oPath : this.getPaths()) {
                if (oPath.getFromPortal() != null || oPath.getToPortal() != null) continue;
                this.removeOPath(oPath);
                log.trace("removed Path \"{}\" from oblock {}", (Object)oPath.getName(), (Object)this.getDisplayName());
            }
            int n = this._portals.size();
            this._portals = this._portals.stream().filter(p -> !Objects.equals(p, portal)).collect(Collectors.toList());
            this.firePropertyChange(PROPERTY_PORTAL_COUNT, n, this._portals.size());
        }
    }

    public Portal getPortalByName(String name) {
        for (Portal po : this._portals) {
            if (!po.getName().equals(name)) continue;
            return po;
        }
        return null;
    }

    @Nonnull
    public List<Portal> getPortals() {
        return new ArrayList<Portal>(this._portals);
    }

    public void setPortals(ArrayList<Portal> portals) {
        this._portals = portals;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    public OPath getPathByName(String name) {
        for (Path opa : this.getPaths()) {
            OPath path = (OPath)opa;
            if (!path.getName().equals(name)) continue;
            return path;
        }
        return null;
    }

    @Override
    public void setLength(float len) {
        this.getPaths().stream().forEach(p -> {
            if (p.getLength() > len) {
                p.setLength(len);
            }
        });
        super.setLength(len);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    public boolean addPath(OPath path) {
        String pName = path.getName();
        log.trace("addPath \"{}\" to OBlock {}", (Object)pName, (Object)this.getSystemName());
        List<Path> list = this.getPaths();
        for (Path p : list) {
            if (((OPath)p).equals(path)) {
                log.trace("Path \"{}\" duplicated in OBlock {}", (Object)pName, (Object)this.getSystemName());
                return false;
            }
            if (!pName.equals(((OPath)p).getName())) continue;
            log.trace("Path named \"{}\" already exists in OBlock {}", (Object)pName, (Object)this.getSystemName());
            return false;
        }
        OBlock pathBlock = (OBlock)path.getBlock();
        if (pathBlock != null && !this.equals(pathBlock)) {
            log.warn("Path \"{}\" already in block {}, cannot be added to block {}", new Object[]{pName, pathBlock.getDisplayName(), this.getDisplayName()});
            return false;
        }
        path.setBlock(this);
        Portal portal = path.getFromPortal();
        if (portal != null && !portal.addPath(path)) {
            log.trace("Path \"{}\" rejected by portal  {}", (Object)pName, (Object)portal.getName());
            return false;
        }
        portal = path.getToPortal();
        if (portal != null && !portal.addPath(path)) {
            log.debug("Path \"{}\" rejected by portal  {}", (Object)pName, (Object)portal.getName());
            return false;
        }
        super.addPath(path);
        this.firePropertyChange(PROPERTY_PATH_COUNT, null, this.getPaths().size());
        return true;
    }

    public boolean removeOPath(OPath path) {
        Block block = path.getBlock();
        if (block != null && !this.getSystemName().equals(block.getSystemName())) {
            return false;
        }
        if (!InstanceManager.getDefault(WarrantManager.class).okToRemoveBlockPath(this, path)) {
            return false;
        }
        path.clearSettings();
        super.removePath(path);
        Portal portal = path.getToPortal();
        if (portal != null) {
            portal.removePath(path);
        }
        if ((portal = path.getFromPortal()) != null) {
            portal.removePath(path);
        }
        path.dispose();
        this.firePropertyChange(PROPERTY_PATH_COUNT, path, this.getPaths().size());
        return true;
    }

    protected String setPath(String pathName, Warrant warrant) {
        OPath path = this.getPathByName(pathName);
        if (path == null) {
            return Bundle.getMessage("PathNotFound", pathName, this.getDisplayName());
        }
        if (warrant == null || !warrant.equals(this._warrant)) {
            String name = this._warrant != null ? this._warrant.getDisplayName() : Bundle.getMessage("Warrant");
            return Bundle.getMessage("PathNotSet", pathName, this.getDisplayName(), name);
        }
        this._pathName = pathName;
        int lockState = 0;
        path.setTurnouts(0, true, lockState, true);
        this.firePropertyChange(PROPERTY_PATH_STATE, 0, this.getState());
        if (log.isTraceEnabled()) {
            log.debug("setPath: Path \"{}\" in path \"{}\" {} set for warrant {}", new Object[]{pathName, this.getDisplayName(), this._pathName, warrant.getDisplayName()});
        }
        return null;
    }

    protected OPath getPath() {
        if (this._pathName == null) {
            return null;
        }
        return this.getPathByName(this._pathName);
    }

    public void pseudoPropertyChange(String propName, Object old, Object n) {
        log.trace("pseudoPropertyChange: Block \"{}\" property \"{}\" new value= {}", new Object[]{this.getSystemName(), propName, n});
        this.firePropertyChange(propName, old, n);
    }

    @Override
    public void goingInactive() {
        this.setState(this.getState() & 0xFFFFFFD4 | 4);
        this.setValue(null);
        if (this._warrant != null) {
            ThreadingUtil.runOnLayout(() -> this._warrant.goingInactive(this));
        }
    }

    @Override
    public void goingActive() {
        this.setState(this.getState() & 0xFFFFFFF2 | 2);
        this._entryTime = System.currentTimeMillis();
        if (this._warrant != null) {
            ThreadingUtil.runOnLayout(() -> this._warrant.goingActive(this));
        }
    }

    @Override
    public void goingUnknown() {
        this.setState(this.getState() & 0xFFFFFFF1 | 1);
    }

    @Override
    public void goingInconsistent() {
        this.setState(this.getState() & 0xFFFFFFF8 | 8);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    public void dispose() {
        if (!InstanceManager.getDefault(WarrantManager.class).okToRemoveBlock(this)) {
            return;
        }
        this.firePropertyChange(PROPERTY_DELETED, null, null);
        for (Path pa : this.getPaths()) {
            this.removeOPath((OPath)pa);
        }
        for (Portal portal : this.getPortals()) {
            if (log.isTraceEnabled()) {
                log.debug("this = {}, toBlock = {}, fromblock= {}", new Object[]{this.getDisplayName(), portal.getToBlock().getDisplayName(), portal.getFromBlock().getDisplayName()});
            }
            if (this.equals(portal.getToBlock())) {
                portal.setToBlock(null, false);
            }
            if (!this.equals(portal.getFromBlock())) continue;
            portal.setFromBlock(null, false);
        }
        this._portals.clear();
        for (Iterator<Object> iterator : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)iterator));
        }
        InstanceManager.getDefault(OBlockManager.class).deregister(this);
        super.dispose();
    }

    public String getDescription() {
        return MessageFormat.format(Bundle.getMessage("BlockDescription"), this.getDisplayName());
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        ArrayList duplicateCheck = new ArrayList();
        if (bean != null) {
            if (log.isDebugEnabled()) {
                Sensor s = this.getSensor();
                log.debug("oblock: {}, sensor = {}", (Object)this.getDisplayName(), (Object)(s == null ? "Dark OBlock" : s.getDisplayName()));
            }
            if (bean.equals(this.getSensor())) {
                report.add(new NamedBeanUsageReport("OBlockSensor"));
            }
            if (bean.equals(this.getErrorSensor())) {
                report.add(new NamedBeanUsageReport("OBlockSensorError"));
            }
            if (bean.equals(this.getWarrant())) {
                report.add(new NamedBeanUsageReport("OBlockWarant"));
            }
            this.getPortals().forEach(portal -> {
                if (log.isDebugEnabled()) {
                    log.debug("    portal: {}, fb = {}, tb = {}, fs = {}, ts = {}", new Object[]{portal.getName(), portal.getFromBlockName(), portal.getToBlockName(), portal.getFromSignalName(), portal.getToSignalName()});
                }
                if (bean.equals(portal.getFromBlock()) || bean.equals(portal.getToBlock())) {
                    report.add(new NamedBeanUsageReport("OBlockPortalNeighborOBlock", portal.getName()));
                }
                if (bean.equals(portal.getFromSignal()) || bean.equals(portal.getToSignal())) {
                    report.add(new NamedBeanUsageReport("OBlockPortalSignal", portal.getName()));
                }
                portal.getFromPaths().forEach(path -> {
                    log.debug("        from path = {}", (Object)path.getName());
                    path.getSettings().forEach(setting -> {
                        log.debug("            turnout = {}", (Object)setting.getBean().getDisplayName());
                        if (bean.equals(setting.getBean()) && !duplicateCheck.contains(bean)) {
                            report.add(new NamedBeanUsageReport("OBlockPortalPathTurnout", portal.getName()));
                            duplicateCheck.add(bean);
                        }
                    });
                });
                portal.getToPaths().forEach(path -> {
                    log.debug("        to path   = {}", (Object)path.getName());
                    path.getSettings().forEach(setting -> {
                        log.debug("            turnout = {}", (Object)setting.getBean().getDisplayName());
                        if (bean.equals(setting.getBean()) && !duplicateCheck.contains(bean)) {
                            report.add(new NamedBeanUsageReport("OBlockPortalPathTurnout", portal.getName()));
                            duplicateCheck.add(bean);
                        }
                    });
                });
            });
        }
        return report;
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameOBlock");
    }

    public static enum OBlockStatus {
        Unoccupied(4, "unoccupied", Bundle.getMessage("unoccupied")),
        Occupied(2, "occupied", Bundle.getMessage("occupied")),
        Allocated(16, "allocated", Bundle.getMessage("allocated")),
        Running(32, "running", Bundle.getMessage("running")),
        OutOfService(64, "outOfService", Bundle.getMessage("outOfService")),
        Dark(256, "dark", Bundle.getMessage("dark")),
        TrackError(128, "powerError", Bundle.getMessage("powerError"));

        private final int status;
        private final String name;
        private final String descr;
        private static final Map<String, OBlockStatus> map;
        private static final Map<String, OBlockStatus> reverseMap;

        private OBlockStatus(int status, String name, String descr) {
            this.status = status;
            this.name = name;
            this.descr = descr;
        }

        public int getStatus() {
            return this.status;
        }

        public String getName() {
            return this.name;
        }

        public String getDescr() {
            return this.descr;
        }

        public static OBlockStatus getByName(String name) {
            return map.get(name);
        }

        public static OBlockStatus getByDescr(String descr) {
            return reverseMap.get(descr);
        }

        static {
            map = new HashMap<String, OBlockStatus>();
            reverseMap = new HashMap<String, OBlockStatus>();
            for (OBlockStatus oblockStatus : OBlockStatus.values()) {
                map.put(oblockStatus.getName(), oblockStatus);
                reverseMap.put(oblockStatus.getDescr(), oblockStatus);
            }
        }
    }
}

