/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManagerAutoDefault;
import jmri.ProvidingManager;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrix.CaptiveSystemConnectionMemo;
import jmri.managers.AbstractManager;

public class OBlockManager
extends AbstractManager<OBlock>
implements ProvidingManager<OBlock>,
InstanceManagerAutoDefault {
    public OBlockManager() {
        super(new CaptiveSystemConnectionMemo("O", "OBlocks"));
    }

    @Override
    public int getXMLOrder() {
        return 110;
    }

    @Override
    public char typeLetter() {
        return 'B';
    }

    @CheckForNull
    public OBlock createNewOBlock(@Nonnull String systemName, @CheckForNull String userName) {
        OBlock r;
        if (userName != null && !userName.equals("") && (r = (OBlock)this.getByUserName(userName)) != null) {
            return null;
        }
        if (!this.isValidSystemNameFormat(systemName)) {
            return null;
        }
        r = (OBlock)this.getBySystemName(systemName);
        if (r != null) {
            return null;
        }
        r = new OBlock(systemName, userName);
        this.updateAutoNumber(systemName);
        this.register(r);
        return r;
    }

    @CheckForNull
    public OBlock createNewOBlock(@Nonnull String userName) {
        return this.createNewOBlock(this.getAutoSystemName(), userName);
    }

    @CheckForNull
    public OBlock getOBlock(@Nonnull String name) {
        OBlock r = (OBlock)this.getByUserName(name);
        if (r != null) {
            return r;
        }
        return (OBlock)this.getBySystemName(name);
    }

    @Override
    public OBlock provide(@Nonnull String name) {
        return this.provideOBlock(name);
    }

    @Nonnull
    public OBlock provideOBlock(@Nonnull String name) {
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("No name given for OBlock");
        }
        OBlock ob = (OBlock)this.getByUserName(name);
        if (ob == null) {
            ob = (OBlock)this.getBySystemName(name);
        }
        if (ob == null && (ob = this.createNewOBlock(name, null)) == null) {
            throw new IllegalArgumentException("could not create OBlock \"" + name + "\"");
        }
        return ob;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameOBlocks" : "BeanNameOBlock");
    }

    @Override
    public Class<OBlock> getNamedBeanClass() {
        return OBlock.class;
    }
}

