/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import jmri.jmrit.logix.Bundle;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpSessionLog {
    private static final String OP_SESSION_LOG_ERROR = "Op session log error {}";
    static BufferedWriter _outBuff;
    private static final Logger log;

    private OpSessionLog() {
    }

    public static synchronized boolean makeLogFile(Component parent) {
        JmriJFileChooser fileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
        fileChooser.setDialogTitle(Bundle.getMessage("logSession"));
        fileChooser.setFileFilter(new TextFilter());
        int retVal = fileChooser.showDialog(parent, Bundle.getMessage("logFile"));
        if (retVal != 0) {
            return false;
        }
        File file = fileChooser.getSelectedFile();
        Object fileName = file.getAbsolutePath();
        String fileNameLC = ((String)fileName).toLowerCase();
        if (!fileNameLC.endsWith(".txt")) {
            fileName = (String)fileName + ".txt";
            file = new File((String)fileName);
        }
        if (file.exists() && JmriJOptionPane.showConfirmDialog(parent, Bundle.getMessage("overWritefile", fileName), Bundle.getMessage("QuestionTitle"), 2, 3) != 0) {
            return false;
        }
        try {
            _outBuff = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            OpSessionLog.writeHeader((String)fileName);
        }
        catch (FileNotFoundException fnfe) {
            JmriJOptionPane.showMessageDialog(parent, fnfe.getMessage(), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        return true;
    }

    private static void writeHeader(String fileName) {
        if (_outBuff == null) {
            return;
        }
        try {
            _outBuff.newLine();
            _outBuff.append("\t\t\t");
            _outBuff.append(fileName);
            _outBuff.newLine();
            _outBuff.append("\t\t\t");
            SimpleDateFormat dateFormatter = new SimpleDateFormat("EEEE, MMMM d, yyyy");
            _outBuff.append(dateFormatter.format(new Date()));
            _outBuff.newLine();
            _outBuff.newLine();
            OpSessionLog.writeLn(Bundle.getMessage("startLog"));
        }
        catch (IOException ioe) {
            log.error(OP_SESSION_LOG_ERROR, (Object)ioe.getMessage());
        }
    }

    public static synchronized void writeLn(String text) {
        if (_outBuff == null) {
            return;
        }
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("  hh:mm:ss a   ");
            _outBuff.append(dateFormatter.format(new Date()));
            _outBuff.append(text);
            _outBuff.newLine();
        }
        catch (IOException ioe) {
            log.error(OP_SESSION_LOG_ERROR, (Object)ioe.getMessage());
        }
    }

    public static synchronized void flush() {
        if (_outBuff == null) {
            return;
        }
        try {
            _outBuff.flush();
        }
        catch (IOException ioe) {
            log.error(OP_SESSION_LOG_ERROR, (Object)ioe.getMessage());
        }
    }

    public static synchronized void close() {
        if (_outBuff == null) {
            return;
        }
        try {
            OpSessionLog.writeLn(Bundle.getMessage("stopLog"));
            _outBuff.flush();
            _outBuff.close();
        }
        catch (IOException ioe) {
            log.error(OP_SESSION_LOG_ERROR, (Object)ioe.getMessage());
        }
    }

    static {
        log = LoggerFactory.getLogger(OpSessionLog.class);
    }
}

