/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.logix.Portal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalManager
implements InstanceManagerAutoDefault,
PropertyChangeListener {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ArrayList<Portal> _nameList = new ArrayList();
    private final HashMap<String, Portal> _portalMap = new HashMap();
    public static final String PROPERTY_NUM_PORTALS = "numPortals";
    private static final Logger log = LoggerFactory.getLogger(PortalManager.class);

    public int getPortalCount() {
        return this._nameList.size();
    }

    public Portal getPortal(int idx) {
        return this._nameList.get(idx);
    }

    public int getIndexOf(Portal portal) {
        return this._nameList.indexOf(portal);
    }

    public Portal getPortal(String name) {
        return this._portalMap.get(name);
    }

    public Collection<Portal> getPortalSet() {
        return Collections.unmodifiableCollection(this._nameList);
    }

    public Portal createNewPortal(@Nonnull String userName) {
        Portal portal;
        Objects.requireNonNull(userName, "Name cannot be null");
        if (userName.trim().length() > 0) {
            portal = this._portalMap.get(userName);
            if (portal != null) {
                return null;
            }
        } else {
            return null;
        }
        portal = new Portal(userName);
        this._nameList.add(portal);
        this._portalMap.put(userName, portal);
        this.pcs.firePropertyChange(PROPERTY_NUM_PORTALS, null, (Object)this._nameList.size());
        portal.addPropertyChangeListener(this);
        return portal;
    }

    public Portal providePortal(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Portal portal = this.getPortal(name);
        if (portal == null) {
            portal = this.createNewPortal(name);
        }
        return portal;
    }

    private synchronized void deletePortal(Portal portal) {
        String name = portal.getName();
        this._nameList.remove(portal);
        this._portalMap.remove(name);
        this.pcs.firePropertyChange(PROPERTY_NUM_PORTALS, portal, (Object)this._nameList.size());
    }

    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!(e.getSource() instanceof Portal)) {
            return;
        }
        Portal portal = (Portal)e.getSource();
        String propertyName = e.getPropertyName();
        log.debug("property = {}", (Object)propertyName);
        if ("portalDelete".equals(propertyName)) {
            this.deletePortal(portal);
        }
    }
}

