/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.util.ArrayList;
import java.util.ListIterator;
import jmri.jmrit.logix.SpeedUtil;

public class RampData {
    private final int _timeInterval;
    private final float _throttleInterval;
    private ArrayList<Float> _settings;
    private boolean _upRamp;
    private final SpeedUtil _speedUtil;
    private final float _fromSpeed;
    private final float _toSpeed;
    private static final float INCRE_RATE = 1.085f;

    RampData(SpeedUtil util, float throttleIncre, int timeIncre, float fromSet, float toSet) {
        this._throttleInterval = throttleIncre;
        this._timeInterval = timeIncre;
        this._speedUtil = util;
        this._fromSpeed = fromSet;
        this._toSpeed = toSet;
        this.makeThrottleSettings();
    }

    protected boolean isUpRamp() {
        return this._upRamp;
    }

    private void makeThrottleSettings() {
        float highSetting;
        float lowSetting;
        this._upRamp = this._toSpeed >= this._fromSpeed;
        this._settings = new ArrayList();
        if (this._upRamp) {
            lowSetting = this._fromSpeed;
            highSetting = this._toSpeed;
        } else {
            lowSetting = this._toSpeed;
            highSetting = this._fromSpeed;
        }
        float throttleIncre = this._throttleInterval;
        for (float low = 0.0f; low < lowSetting; low += (throttleIncre *= 1.085f)) {
        }
        this._settings.add(Float.valueOf(lowSetting));
        lowSetting += throttleIncre;
        while (lowSetting < highSetting) {
            this._settings.add(Float.valueOf(lowSetting));
            float momentumTime = this._speedUtil.getMomentumTime(lowSetting, lowSetting + throttleIncre * 1.085f);
            if (momentumTime <= (float)this._timeInterval) {
                throttleIncre *= 1.085f;
            }
            lowSetting += throttleIncre;
        }
        this._settings.add(Float.valueOf(highSetting));
    }

    protected float getRampLength() {
        float nextSetting;
        float rampLength = 0.0f;
        float momentumTime = 0.0f;
        if (this._upRamp) {
            float prevSetting;
            ListIterator<Float> iter = this.speedIterator(true);
            nextSetting = prevSetting = iter.next().floatValue();
            while (iter.hasNext()) {
                nextSetting = iter.next().floatValue();
                float dist = this._speedUtil.getDistanceOfSpeedChange(prevSetting, nextSetting, this._timeInterval);
                rampLength += dist;
                momentumTime = this._speedUtil.getMomentumTime(prevSetting, nextSetting);
                prevSetting = nextSetting;
            }
        } else {
            float prevSetting;
            ListIterator<Float> iter = this.speedIterator(false);
            nextSetting = prevSetting = iter.previous().floatValue();
            while (iter.hasPrevious()) {
                nextSetting = iter.previous().floatValue();
                float dist = this._speedUtil.getDistanceOfSpeedChange(prevSetting, nextSetting, this._timeInterval);
                rampLength += dist;
                momentumTime = this._speedUtil.getMomentumTime(prevSetting, nextSetting);
                prevSetting = nextSetting;
            }
        }
        if ((float)this._timeInterval > momentumTime) {
            rampLength -= this._speedUtil.getTrackSpeed(nextSetting) * ((float)this._timeInterval - momentumTime);
        }
        return rampLength;
    }

    protected int getNumSteps() {
        return this._settings.size() - 1;
    }

    protected int getRamptime() {
        return (this._settings.size() - 1) * this._timeInterval;
    }

    protected float getMaxSpeed() {
        if (this._settings == null) {
            throw new IllegalArgumentException("Null array of throttle settings");
        }
        return this._settings.get(this._settings.size() - 1).floatValue();
    }

    protected ListIterator<Float> speedIterator(boolean up) {
        if (up) {
            return this._settings.listIterator(0);
        }
        return this._settings.listIterator(this._settings.size());
    }

    protected int getRampTimeIncrement() {
        return this._timeInterval;
    }
}

