/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.WarrantRoute;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteFinder
implements Runnable {
    private WarrantRoute _caller;
    private BlockOrder _originBlockOrder;
    private BlockOrder _destBlockOrder;
    private BlockOrder _viaBlockOrder;
    private BlockOrder _avoidBlockOrder;
    private ArrayList<DefaultMutableTreeNode> _destNodes;
    private DefaultTreeModel _tree;
    private OBlock _destBlock;
    private String _dPathName;
    private String _dEntryName;
    private OBlock _viaBlock;
    private String _vPathName;
    private OBlock _avoidBlock;
    private String _aPathName;
    private int _maxBlocks;
    private boolean _quit = false;
    private static final Logger log = LoggerFactory.getLogger(RouteFinder.class);

    protected RouteFinder(WarrantRoute f, BlockOrder origin, BlockOrder dest, BlockOrder via, BlockOrder avoid, int maxB) {
        this._caller = f;
        this._originBlockOrder = origin;
        this._destBlockOrder = dest;
        this._viaBlockOrder = via;
        this._avoidBlockOrder = avoid;
        this._maxBlocks = maxB;
    }

    protected synchronized void quit() {
        log.debug("quit= {}", (Object)this._quit);
        this._quit = true;
    }

    @Override
    public void run() {
        this._destBlock = this._destBlockOrder.getBlock();
        this._dPathName = this._destBlockOrder.getPathName();
        this._dEntryName = this._destBlockOrder.getEntryName();
        this._viaBlock = null;
        this._vPathName = null;
        if (this._viaBlockOrder != null) {
            this._vPathName = this._viaBlockOrder.getPathName();
            this._viaBlock = this._viaBlockOrder.getBlock();
        }
        this._avoidBlock = null;
        this._aPathName = null;
        if (this._avoidBlockOrder != null) {
            this._aPathName = this._avoidBlockOrder.getPathName();
            this._avoidBlock = this._avoidBlockOrder.getBlock();
        }
        this._destNodes = new ArrayList();
        this._quit = false;
        int level = 0;
        if (log.isDebugEnabled()) {
            log.debug("Origin= \"{}\" Path= \"{}\" Exit= \"{}\"", new Object[]{this._originBlockOrder.getBlock().getDisplayName(), this._originBlockOrder.getPathName(), this._originBlockOrder.getExitName()});
            log.debug("Destination= \"{}\" Path= \"{}\" Entry= \"{}\"", new Object[]{this._destBlock.getDisplayName(), this._dPathName, this._dEntryName});
        }
        RouteNode root = new RouteNode(this._originBlockOrder, this._viaBlockOrder != null);
        this._tree = new DefaultTreeModel(root);
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        nodes.add(root);
        while (level < this._maxBlocks && !this._quit) {
            nodes = this.makeLevel(nodes, level);
            log.debug("level {} has {} nodes. quit= {}", new Object[]{level, nodes.size(), this._quit});
            ++level;
        }
        ThreadingUtil.runOnLayout(() -> {
            if (this._destNodes.isEmpty()) {
                this._caller.debugRoute(this._tree, this._originBlockOrder, this._destBlockOrder);
            } else {
                this._caller.pickRoute(this._destNodes, this._tree);
            }
        });
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OBlock extends Block")
    ArrayList<RouteNode> makeLevel(ArrayList<RouteNode> nodes, int level) {
        ArrayList<RouteNode> children = new ArrayList<RouteNode>();
        for (int i = 0; i < nodes.size(); ++i) {
            String pName;
            RouteNode node = nodes.get(i);
            BlockOrder pOrder = (BlockOrder)node.getUserObject();
            OBlock pBlock = pOrder.getBlock();
            Portal exitPortal = pBlock.getPortalByName(pName = pOrder.getExitName());
            if (exitPortal != null) {
                OBlock nextBlock = exitPortal.getOpposingBlock(pBlock);
                List<OPath> paths = exitPortal.getPathsFromOpposingBlock(pBlock);
                if (log.isTraceEnabled()) {
                    log.debug("makeLevel {} block= {}, path= {} meets {} portal paths", new Object[]{level, pBlock.getDisplayName(), pOrder.getPathName(), paths.size()});
                }
                if (paths.isEmpty()) {
                    if (nextBlock == null) {
                        log.error("Portal \"{}\" is malformed! \"{}\" not connected to another block!", (Object)pName, (Object)pBlock.getDisplayName());
                    } else {
                        log.error("Portal \"{}\" does not have any paths from \"{}\" to \"{}\"", new Object[]{pName, pBlock.getDisplayName(), nextBlock.getDisplayName()});
                    }
                }
                for (int k = 0; k < paths.size(); ++k) {
                    OPath path = paths.get(k);
                    if (this._avoidBlock != null && this._avoidBlock.equals(nextBlock) && this._aPathName.equals(path.getName())) continue;
                    String exitName = path.getOppositePortalName(pName);
                    OBlock pathBlock = (OBlock)path.getBlock();
                    BlockOrder nOrder = new BlockOrder(pathBlock, path.getName(), pName, exitName);
                    RouteNode child = new RouteNode(nOrder, node.needsViaAncestor());
                    this._tree.insertNodeInto(child, node, node.getChildCount());
                    if (this._viaBlock != null && this._viaBlock.equals(nextBlock) && this._vPathName.equals(path.getName())) {
                        child.hasViaAncestor(true);
                    }
                    if (!node.needsViaAncestor()) {
                        if (log.isTraceEnabled()) {
                            log.debug("Test= \"{}\" Path= {} Exit= {}", new Object[]{nOrder.getBlock().getDisplayName(), path.getName(), pName});
                        }
                        if (this._destBlock == nOrder.getBlock() && this._dPathName.equals(path.getName()) && this._dEntryName.equals(pName)) {
                            this._destNodes.add(child);
                        }
                    }
                    children.add(child);
                    if (!this._quit) {
                        continue;
                    }
                    break;
                }
            } else {
                log.debug("Dead branch: block= \"{}\" has no exit portal", (Object)pBlock.getDisplayName());
            }
            if (this._quit) break;
        }
        return children;
    }

    static class RouteNode
    extends DefaultMutableTreeNode {
        boolean _needsViaAncestor = false;

        RouteNode(Object userObject) {
            super(userObject);
        }

        RouteNode(Object userObject, boolean needsViaAncestor) {
            super(userObject);
            this._needsViaAncestor = needsViaAncestor;
        }

        void hasViaAncestor(boolean hasViaAncestor) {
            this._needsViaAncestor = !hasViaAncestor;
        }

        boolean needsViaAncestor() {
            return this._needsViaAncestor;
        }
    }
}

