/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.LearnThrottleFrame;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCWarrant
extends Warrant {
    private static final String WAIT_UNEXPECTED_EXCEPTION = "{} wait unexpected exception {}";
    private NamedBean _nextSignal = null;
    public static final float SPEED_STOP = 0.0f;
    public static final float SPEED_TO_PLATFORM = 0.2f;
    public static final float SPEED_UNSIGNALLED = 0.4f;
    private long timeToPlatform = 500L;
    private float speedFactor = 0.8f;
    private boolean forward = true;
    private final boolean _allowShallowAllocation = false;
    private DccThrottle _throttle = null;
    float _maxBlockLength = 0.0f;
    SignalSpeedMap _speedMap = InstanceManager.getDefault(SignalSpeedMap.class);
    static LinkedBlockingQueue<SCWarrant> waitToRunQ = new LinkedBlockingQueue();
    private static final Logger log = LoggerFactory.getLogger(SCWarrant.class);

    public SCWarrant(String sName, String uName, long TTP) {
        super(sName, uName);
        log.debug("new SCWarrant {} TTP={}", (Object)uName, (Object)TTP);
        this.timeToPlatform = TTP;
        this.setNoRamp(true);
    }

    public long getTimeToPlatform() {
        return this.timeToPlatform;
    }

    public void setTimeToPlatform(long TTP) {
        this.timeToPlatform = TTP;
    }

    public void setForward(boolean set) {
        this.forward = set;
    }

    public boolean getForward() {
        return this.forward;
    }

    public void setSpeedFactor(float factor) {
        this.speedFactor = (double)factor > 1.0 ? 1.0f : ((double)factor < 0.1 ? 0.1f : factor);
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    float getMaxBlockLength() {
        return this._maxBlockLength;
    }

    void setMaxBlockLength() {
        for (int i = 0; i <= this.getBlockOrders().size() - 1; ++i) {
            float blockLength = this.getBlockOrderAt(i).getBlock().getLengthCm();
            if (!(blockLength > this._maxBlockLength)) continue;
            this._maxBlockLength = blockLength;
        }
    }

    private String allocateStartBlock() {
        BlockOrder bo = this.getBlockOrderAt(0);
        OBlock block = bo.getBlock();
        String message = block.allocate(this);
        if (message != null) {
            log.info("{} START-block allocation failed {} ", (Object)this._trainName, (Object)message);
            return message;
        }
        message = bo.setPath(this);
        if (message != null) {
            log.info("{} setting path in START-block failed {}", (Object)this._trainName, (Object)message);
            return message;
        }
        return null;
    }

    @Override
    public String setRoute(boolean delay, List<BlockOrder> orders) {
        return this.allocateStartBlock();
    }

    boolean allTurnoutsSet() {
        for (int i = 0; i < this.getBlockOrders().size(); ++i) {
            OBlock block_i = this.getBlockOrderAt(i).getBlock();
            OPath path_i = this.getBlockOrderAt(i).getPath();
            if (path_i.checkPathSet()) continue;
            log.debug("{}: turnouts at block {} are not set yet (in allTurnoutsSet).", (Object)this._trainName, (Object)block_i.getDisplayName());
            return false;
        }
        return true;
    }

    public boolean isRouteFree() {
        for (int i = 0; i < this.getBlockOrders().size(); ++i) {
            OBlock block_i = this.getBlockOrderAt(i).getBlock();
            if ((block_i.getState() & 0x10) == 16) {
                log.debug("{}: block {} is allocated to {} (in isRouteFree).", new Object[]{this._trainName, block_i.getDisplayName(), block_i.getAllocatingWarrantName()});
                if (!block_i.isAllocatedTo(this)) {
                    return false;
                }
            }
            if ((block_i.getState() & 2) != 2 || i <= 0) continue;
            log.debug("{}: block {} is not free (in isRouteFree).", (Object)this._trainName, (Object)block_i.getDisplayName());
            return false;
        }
        return true;
    }

    boolean isRouteAllocated() {
        for (int i = 0; i < this.getBlockOrders().size(); ++i) {
            OBlock block_i = this.getBlockOrderAt(i).getBlock();
            if (block_i.isAllocatedTo(this)) continue;
            log.debug("{}: block {} is not allocated to this warrant (in isRouteAllocated).", (Object)this._trainName, (Object)block_i.getDisplayName());
            return false;
        }
        return true;
    }

    @Override
    public void notifyThrottleFound(DccThrottle throttle) {
        this._throttle = throttle;
        if (throttle == null) {
            this.abortWarrant("notifyThrottleFound: null throttle(?)!");
            this.firePropertyChange("throttleFail", null, Bundle.getMessage("noThrottle"));
            return;
        }
        if (this._runMode == 1) {
            this.abortWarrant("notifyThrottleFound: No LEARN mode for SCWarrant");
            InstanceManager.throttleManagerInstance().releaseThrottle(throttle, this);
            this.firePropertyChange("throttleFail", null, Bundle.getMessage("noThrottle"));
            return;
        }
        log.debug("{} notifyThrottleFound address= {} _runMode= {}", new Object[]{this._trainName, throttle.getLocoAddress(), this._runMode});
        this.startupWarrant();
        this.firePropertyChange("WarrantStart", 0, this._runMode);
        this.runSignalControlledTrain();
    }

    @Override
    protected synchronized String getRunningMessage() {
        if (this._throttle == null) {
            return super.getRunningMessage();
        }
        if (this._runMode != 2) {
            return "Idle";
        }
        if (this.getBlockOrderAt(this.getCurrentOrderIndex()) == null) {
            return "Uninitialized";
        }
        String block = this.getBlockOrderAt(this.getCurrentOrderIndex()).getBlock().getDisplayName();
        String signal = "no signal";
        Object aspect = "none";
        if (this._nextSignal != null) {
            signal = this._nextSignal.getDisplayName();
            if (this._nextSignal instanceof SignalHead) {
                int appearance = ((SignalHead)this._nextSignal).getAppearance();
                aspect = "appearance " + appearance;
            } else {
                aspect = ((SignalMast)this._nextSignal).getAspect();
            }
        }
        return Bundle.getMessage("SCWStatus", block, this.getCurrentOrderIndex(), Float.valueOf(this._throttle.getSpeedSetting()), signal, aspect);
    }

    protected void runSignalControlledTrain() {
        this.allocateBlocksAndSetTurnouts(0);
        this.setTrainDirection();
        SCTrainRunner thread = new SCTrainRunner(this);
        Thread t = ThreadingUtil.newThread(thread);
        t.setName("SCTrainRunner");
        t.start();
    }

    protected boolean isStartBlockOccupied() {
        int blockState = this.getBlockOrderAt(0).getBlock().getState();
        return (blockState & 4) != 4;
    }

    protected synchronized void waitForStartblockToGetOccupied() {
        while (!this.isStartBlockOccupied()) {
            log.debug("{} waiting for start block {} to become occupied", (Object)this._trainName, (Object)this.getBlockOrderAt(0).getBlock().getDisplayName());
            try {
                this.wait(2500L);
            }
            catch (InterruptedException ie) {
                log.debug("{} waitForStartblockToGetOccupied InterruptedException {}", new Object[]{this._trainName, ie, ie});
            }
            catch (Exception e) {
                log.debug("{} waitForStartblockToGetOccupied unexpected exception {}", new Object[]{this._trainName, e, e});
            }
        }
    }

    public void setTrainDirection() {
        this._throttle.setIsForward(this.forward);
    }

    public boolean isNextBlockFreeAndAllocated() {
        BlockOrder bo = this.getBlockOrderAt(this.getCurrentOrderIndex() + 1);
        if (bo == null) {
            return false;
        }
        int blockState = bo.getBlock().getState();
        if (blockState == 20) {
            return this.getBlockOrderAt(this.getCurrentOrderIndex() + 1).getBlock().isAllocatedTo(this);
        }
        return false;
    }

    public void getAndGetNotifiedFromNextSignal() {
        if (this._nextSignal != null) {
            log.debug("{} getAndGetNotifiedFromNextSignal removing property listener for signal {}", (Object)this._trainName, (Object)this._nextSignal.getDisplayName());
            this._nextSignal.removePropertyChangeListener(this);
            this._nextSignal = null;
        }
        for (int i = this.getCurrentOrderIndex() + 1; i <= this.getBlockOrders().size() - 1; ++i) {
            BlockOrder bo = this.getBlockOrderAt(i);
            if (bo == null) {
                log.debug("{} getAndGetNotifiedFromNextSignal could not find a BlockOrder for index {}", (Object)this._trainName, (Object)i);
                continue;
            }
            if (bo.getEntryName().equals("")) {
                log.debug("{} getAndGetNotifiedFromNextSignal could not find an entry to Block for index {}", (Object)this._trainName, (Object)i);
                continue;
            }
            log.debug("{} getAndGetNotifiedFromNextSignal examines block {} with entryname = {}", new Object[]{this._trainName, bo.getBlock().getDisplayName(), bo.getEntryName()});
            this._nextSignal = bo.getSignal();
            if (this._nextSignal == null) continue;
            log.debug("{} getAndGetNotifiedFromNextSignal found a new signal to listen to: {}", (Object)this._trainName, (Object)this._nextSignal.getDisplayName());
            break;
        }
        if (this._nextSignal != null) {
            this._nextSignal.addPropertyChangeListener(this);
        }
    }

    boolean inStartBlock() {
        return this.getCurrentOrderIndex() == 0;
    }

    boolean approchingDestination() {
        float distance = 0.0f;
        if (this.getCurrentOrderIndex() == this.getBlockOrders().size() - 2) {
            return true;
        }
        for (int i = this.getCurrentOrderIndex(); i <= this.getBlockOrders().size() - 2; ++i) {
            float blockLength = this.getBlockOrderAt(i).getBlock().getLengthCm();
            if (blockLength < 1.0f) {
                return false;
            }
            distance += blockLength;
        }
        return (double)distance < 1.5 * (double)this.getMaxBlockLength();
    }

    public void setSpeedFromNextSignal() {
        String speed = null;
        if (this._nextSignal == null) {
            this._throttle.setSpeedSetting(this.speedFactor * 0.4f);
        } else {
            if (this._nextSignal instanceof SignalHead) {
                int appearance = ((SignalHead)this._nextSignal).getAppearance();
                speed = this._speedMap.getAppearanceSpeed(((SignalHead)this._nextSignal).getAppearanceName(appearance));
                log.debug("{} SignalHead {} shows appearance {} which maps to speed {}", new Object[]{this._trainName, ((SignalHead)this._nextSignal).getDisplayName(), appearance, speed});
            } else {
                String aspect = ((SignalMast)this._nextSignal).getAspect();
                speed = this._speedMap.getAspectSpeed(aspect == null ? "" : aspect, ((SignalMast)this._nextSignal).getSignalSystem());
                log.debug("{} SignalMast {} shows aspect {} which maps to speed {}", new Object[]{this._trainName, ((SignalMast)this._nextSignal).getDisplayName(), aspect, speed});
            }
            float speed_f = (float)((double)this._speedMap.getSpeed(speed) / 125.0);
            if ((this.approchingDestination() || this.inStartBlock()) && speed_f > 0.4f) {
                speed_f = 0.4f;
            }
            this._throttle.setSpeedSetting(this.speedFactor * speed_f);
        }
    }

    protected void allocateBlocksAndSetTurnouts(int startIndex) {
        log.debug("{} allocateBlocksAndSetTurnouts startIndex={} _orders.size()={}", new Object[]{this._trainName, startIndex, this.getBlockOrders().size()});
        for (int i = startIndex; i < this.getBlockOrders().size(); ++i) {
            log.debug("{} allocateBlocksAndSetTurnouts for loop #{}", (Object)this._trainName, (Object)i);
            BlockOrder bo = this.getBlockOrderAt(i);
            OBlock block = bo.getBlock();
            String pathAlreadySet = block.isPathSet(bo.getPathName());
            if (pathAlreadySet == null) {
                String message = null;
                if ((block.getState() & 2) != 0) {
                    log.info("{} block allocation failed {} not allocated, but Occupied.", (Object)this._trainName, (Object)block.getDisplayName());
                    message = " block allocation failed ";
                }
                if (message == null && (message = block.allocate(this)) != null) {
                    log.info("{} block allocation failed {}", (Object)this._trainName, (Object)message);
                }
                if (message == null) {
                    message = bo.setPath(this);
                }
                if (message == null) continue;
                log.debug("{} path setting failed for {} at block {} {}", new Object[]{this._trainName, this.getDisplayName(), block.getDisplayName(), message});
                if (this._stoppingBlock != null) {
                    this._stoppingBlock.removePropertyChangeListener(this);
                }
                this._stoppingBlock = block;
                this._stoppingBlock.addPropertyChangeListener(this);
                return;
            }
            if (pathAlreadySet.equals(this.getDisplayName())) {
                log.debug("{} Path {} already set (and thereby block allocated) for {}", new Object[]{this._trainName, bo.getPathName(), pathAlreadySet});
                continue;
            }
            log.info("{} Block allocation failed: Path {} already set (and thereby block allocated) for {}", new Object[]{this._trainName, bo.getPathName(), pathAlreadySet});
            return;
        }
    }

    @Override
    public String setRunMode(int mode, DccLocoAddress address, LearnThrottleFrame student, List<ThrottleSetting> commands, boolean runBlind) {
        if (log.isDebugEnabled()) {
            log.debug("{}: SCWarrant::setRunMode({}) ({}) called with _runMode= {}.", new Object[]{this.getDisplayName(), mode, MODES[mode], MODES[this._runMode]});
        }
        this._message = null;
        if (this._runMode != 0) {
            this._message = this.getRunModeMessage();
            log.debug("setRunMode called, but SCWarrant is already running");
            return this._message;
        }
        if (mode != 2) {
            this.deAllocate();
            return this._message;
        }
        this._runMode = mode;
        this.getBlockAt((int)0)._entryTime = System.currentTimeMillis();
        this._message = this.acquireThrottle();
        return this._message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="NotifyAll call triggers recomputation")
    protected void goingActive(OBlock block) {
        log.debug("{} **Block \"{}\" goingActive.  - warrant= {} _runMode = {} _throttle==null: {}", new Object[]{this._trainName, block.getDisplayName(), this.getDisplayName(), this._runMode, this._throttle == null});
        if (this._runMode != 2) {
            log.debug("_runMode != MODE_RUN - ignored");
            return;
        }
        if (this._throttle == null || this._throttle.getSpeedSetting() == 0.0f) {
            log.debug("Train is not running - ignored");
            return;
        }
        int activeIdx = this.getIndexOfBlockAfter(block, this.getCurrentOrderIndex());
        log.debug("{} **Block \"{}\" goingActive. activeIdx= {}, getCurrentOrderIndex()= {} - warrant= {} _runMode = {} _throttle==null: {}", new Object[]{this._trainName, block.getDisplayName(), activeIdx, this.getCurrentOrderIndex(), this.getDisplayName(), this._runMode, this._throttle == null});
        if (activeIdx <= 0) {
            log.debug("{} Block going active is not part of this trains route forward", (Object)this._trainName);
        } else if (activeIdx == this.getCurrentOrderIndex()) {
            log.debug("{} Current block becoming active - ignored", (Object)this._trainName);
        } else {
            if (activeIdx == this.getCurrentOrderIndex() + 1) {
                this.incrementCurrentOrderIndex();
                block.setValue(this._trainName);
                block.setState(block.getState() | 0x20);
                this.firePropertyChange("blockChange", this.getBlockAt(this.getCurrentOrderIndex() - 1), this.getBlockAt(this.getCurrentOrderIndex()));
                SCWarrant sCWarrant = this;
                synchronized (sCWarrant) {
                    this.notifyAll();
                }
            }
            log.debug("{} Rogue occupation of block.", (Object)this._trainName);
            SCWarrant sCWarrant = this;
            synchronized (sCWarrant) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="See comment above notify call")
    protected void goingInactive(OBlock block) {
        int idx = this.getIndexOfBlockAfter(block, 0);
        log.debug("{} Block \"{}\" goingInactive. idx= {}, getCurrentOrderIndex()= {} - warrant= {}", new Object[]{this._trainName, block.getDisplayName(), idx, this.getCurrentOrderIndex(), this.getDisplayName()});
        if (this._runMode != 2) {
            return;
        }
        if (idx >= this.getCurrentOrderIndex() && idx == this.getCurrentOrderIndex()) {
            log.debug("{} LOST TRAIN firePropertyChange(\"blockChange\", {}, null) - warrant= {}", new Object[]{this._trainName, block.getDisplayName(), this.getDisplayName()});
        }
        SCWarrant sCWarrant = this;
        synchronized (sCWarrant) {
            this.notifyAll();
        }
    }

    protected void deallocateUpToBlock(int idx) {
        for (int i = 0; i <= idx; ++i) {
            OBlock block_j;
            OBlock block_i = this.getBlockOrderAt(i).getBlock();
            if (!block_i.isAllocatedTo(this)) continue;
            if ((block_i.getState() & 4) != 4) {
                log.debug("{} Block {} occupied. Not de-allocating any further", (Object)this._trainName, (Object)block_i.getDisplayName());
                return;
            }
            boolean deAllocate = true;
            for (int j = this.getCurrentOrderIndex(); j < this.getBlockOrders().size() && (block_j = this.getBlockOrderAt(j).getBlock()).isAllocatedTo(this); ++j) {
                if (block_i != block_j) continue;
                deAllocate = false;
                break;
            }
            if (!deAllocate) continue;
            log.debug("{} De-allocating block {}", (Object)this._trainName, (Object)block_i.getDisplayName());
            block_i.deAllocate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "NN_NAKED_NOTIFY"}, justification="Unconditional wait is give the warrant that now has _stoppingBlock allocated a little time to deallocate it.  This occurs after this method sets _stoppingBlock to null. NotifyAll passing event, not state.")
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof NamedBean)) {
            log.debug("{} propertyChange \"{}\" old= {} new= {}", new Object[]{this._trainName, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            return;
        }
        String property = evt.getPropertyName();
        log.debug("{} propertyChange \"{}\" new= {} source= {} - warrant= {}", new Object[]{this._trainName, property, evt.getNewValue(), ((NamedBean)evt.getSource()).getDisplayName(), this.getDisplayName()});
        if (this._nextSignal != null && this._nextSignal == evt.getSource() && (property.equals("Aspect") || property.equals("Appearance"))) {
            SCWarrant sCWarrant = this;
            synchronized (sCWarrant) {
                this.notifyAll();
            }
            return;
        }
        SCWarrant sCWarrant = this;
        synchronized (sCWarrant) {
            if (this._stoppingBlock != null) {
                log.debug("{} CHECKING STOPPINGBLOCKEVENT ((NamedBean) evt.getSource()).getDisplayName() = '{}' evt.getPropertyName() = '{}' evt.getNewValue() = {} _throttle==null: {}", new Object[]{this._trainName, ((NamedBean)evt.getSource()).getDisplayName(), evt.getPropertyName(), evt.getNewValue(), this._throttle == null});
                if (((NamedBean)evt.getSource()).getDisplayName().equals(this._stoppingBlock.getDisplayName()) && evt.getPropertyName().equals("state") && (((Number)evt.getNewValue()).intValue() & 4) == 4) {
                    log.debug("{} being aware that Block {} has become free", (Object)this._trainName, (Object)((NamedBean)evt.getSource()).getDisplayName());
                    this._stoppingBlock.removePropertyChangeListener(this);
                    this._stoppingBlock = null;
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        log.debug(WAIT_UNEXPECTED_EXCEPTION, new Object[]{this._trainName, e, e});
                    }
                    this.notifyAll();
                    return;
                }
                if (((NamedBean)evt.getSource()).getDisplayName().equals(this.getBlockOrderAt(0).getBlock().getDisplayName()) && evt.getPropertyName().equals("state") && (((Number)evt.getOldValue()).intValue() & 4) == 4 && (((Number)evt.getNewValue()).intValue() & 4) != 4 && this._throttle == null && this._runMode == 2) {
                    log.debug("{} has arrived at starting block", (Object)this._trainName);
                    String msg = null;
                    msg = this.acquireThrottle();
                    if (msg != null) {
                        log.warn("propertyChange of \"{}\" has message: {}", (Object)property, (Object)msg);
                        this._message = msg;
                        this.abortWarrant(msg);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void stopWarrant(boolean abort, boolean turnOffFunctions) {
        if (this._nextSignal != null) {
            this._nextSignal.removePropertyChangeListener(this);
            this._nextSignal = null;
        }
        super.stopWarrant(abort, false);
        this._message = null;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private class SCTrainRunner
    implements Runnable {
        private static final String INTERRUPTED_EXCEPTION = "{} InterruptedException {}";
        SCWarrant _warrant = null;

        SCTrainRunner(SCWarrant warrant) {
            this._warrant = warrant;
        }

        boolean isItOurTurn() {
            for (SCWarrant e : waitToRunQ) {
                try {
                    log.debug("{} isItOurTurn is checking {}", (Object)SCWarrant.this._trainName, (Object)e.getDisplayName());
                    if (e.isRouteFree()) {
                        if (e == this._warrant) {
                            log.debug("{} isItOurTurn: We are first in line", (Object)SCWarrant.this._trainName);
                            return true;
                        }
                        log.debug("{} isItOurTurn: An other warrant is before us", (Object)SCWarrant.this._trainName);
                        return false;
                    }
                    if (e != this._warrant) continue;
                    log.debug("{} isItOurTurn: our route is not free - keep waiting", (Object)SCWarrant.this._trainName);
                    return false;
                }
                catch (Exception ex) {
                    log.debug("{} isItOurTurn exception ignored: {}", new Object[]{SCWarrant.this._trainName, ex, ex});
                }
            }
            log.debug("{} isItOurTurn: No warrant with a free route is waiting. Let us try our luck, so that we are not all waiting for each other.", (Object)SCWarrant.this._trainName);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SCWarrant sCWarrant = this._warrant;
            synchronized (sCWarrant) {
                SCWarrant.this.waitForStartblockToGetOccupied();
                boolean AllocationDone = false;
                log.debug("{} ENTERING QUEUE ", (Object)SCWarrant.this._trainName);
                try {
                    waitToRunQ.put(this._warrant);
                }
                catch (InterruptedException ie) {
                    log.debug("{} waitToRunQ.put InterruptedException {}", new Object[]{SCWarrant.this._trainName, ie, ie});
                }
                while (!AllocationDone) {
                    log.debug("{} Route is not allocated yet..... ", (Object)SCWarrant.this._trainName);
                    while (!this.isItOurTurn()) {
                        SCWarrant.this.deAllocate();
                        log.debug("{} Waiting for route to become free ....", (Object)SCWarrant.this._trainName);
                        try {
                            this._warrant.wait(2500L + Math.round(1000.0 * Math.random()));
                        }
                        catch (InterruptedException ie) {
                            log.debug("{} _warrant.wait InterruptedException {}", new Object[]{SCWarrant.this._trainName, ie, ie});
                        }
                        catch (Exception e) {
                            log.debug("{} _warrant.wait unexpected exception {}", new Object[]{SCWarrant.this._trainName, e, e});
                        }
                    }
                    SCWarrant.this.allocateStartBlock();
                    SCWarrant.this.allocateBlocksAndSetTurnouts(1);
                    AllocationDone = SCWarrant.this.isRouteAllocated();
                    if (AllocationDone) continue;
                    SCWarrant.this.deAllocate();
                    try {
                        this._warrant.wait(10000L + Math.round(1000.0 * Math.random()));
                    }
                    catch (InterruptedException ie) {
                        log.debug("{} _warrant.wait !AllocationDone InterruptedException {}", new Object[]{SCWarrant.this._trainName, ie, ie});
                    }
                    catch (Exception e) {
                        log.debug("{} _warrant.wait !AllocationDone unexpected exception {}", new Object[]{SCWarrant.this._trainName, e, e});
                    }
                }
                log.debug("{} LEAVING QUEUE ", (Object)SCWarrant.this._trainName);
                waitToRunQ.remove(this._warrant);
                while (!SCWarrant.this.allTurnoutsSet()) {
                    log.debug("{} Waiting for turnouts to settle ....", (Object)SCWarrant.this._trainName);
                    try {
                        this._warrant.wait(2500L);
                    }
                    catch (InterruptedException ie) {
                        log.debug("{} _warrant.wait InterruptedException {}", new Object[]{SCWarrant.this._trainName, ie, ie});
                    }
                    catch (Exception e) {
                        log.debug("{} _warrant.wait unexpected exception {}", new Object[]{SCWarrant.this._trainName, e, e});
                    }
                }
                try {
                    this._warrant.wait(3000L);
                }
                catch (InterruptedException ie) {
                    log.debug(INTERRUPTED_EXCEPTION, new Object[]{SCWarrant.this._trainName, ie, ie});
                }
                catch (Exception e) {
                    log.debug(SCWarrant.WAIT_UNEXPECTED_EXCEPTION, new Object[]{SCWarrant.this._trainName, e, e});
                }
                List<BlockOrder> orders = SCWarrant.this.getBlockOrders();
                while (this._warrant.getCurrentOrderIndex() < orders.size() - 1 && SCWarrant.this._runMode == 2) {
                    log.debug("{} runSignalControlledTrain entering while loop. getCurrentOrderIndex()={} _orders.size()={}", new Object[]{this._warrant._trainName, SCWarrant.this.getCurrentOrderIndex(), orders.size()});
                    if (SCWarrant.this._throttle == null) {
                        this.emergencyStop();
                    }
                    if (SCWarrant.this.isNextBlockFreeAndAllocated()) {
                        SCWarrant.this.getAndGetNotifiedFromNextSignal();
                        SCWarrant.this.setSpeedFromNextSignal();
                    } else {
                        try {
                            SCWarrant.this._throttle.setSpeedSetting(0.0f);
                            SCWarrant.this.getBlockOrderAt(SCWarrant.this.getCurrentOrderIndex() + 1).getBlock().addPropertyChangeListener(this._warrant);
                            log.debug("{} runSignalControlledTrain stops train due to block not free: {}", (Object)this._warrant._trainName, (Object)SCWarrant.this.getBlockOrderAt(SCWarrant.this.getCurrentOrderIndex() + 1).getBlock().getDisplayName());
                        }
                        catch (Exception e) {
                            this.emergencyStop();
                            log.debug("{} exception trying to stop train due to block not free: {}", new Object[]{this._warrant._trainName, e, e});
                        }
                    }
                    log.debug("{} {} before wait {} getCurrentOrderIndex(): {} orders.size(): {}", new Object[]{this._warrant._trainName, this._warrant.getDisplayName(), this._warrant.getRunningMessage(), this._warrant.getCurrentOrderIndex(), orders.size()});
                    try {
                        this._warrant.wait(2000L);
                    }
                    catch (InterruptedException ie) {
                        log.debug(INTERRUPTED_EXCEPTION, new Object[]{this._warrant._trainName, ie, ie});
                    }
                    catch (Exception e) {
                        log.debug(SCWarrant.WAIT_UNEXPECTED_EXCEPTION, new Object[]{SCWarrant.this._trainName, e, e});
                    }
                    log.debug("{} {} after wait {} getCurrentOrderIndex(): {} orders.size(): {}", new Object[]{this._warrant._trainName, this._warrant.getDisplayName(), this._warrant.getRunningMessage(), this._warrant.getCurrentOrderIndex(), orders.size()});
                }
                log.debug("{} runSignalControlledTrain out of while loop, i.e. train entered stop block getCurrentOrderIndex()={} orders.size()={} waiting for train to clear block {}", new Object[]{this._warrant._trainName, SCWarrant.this.getCurrentOrderIndex(), orders.size(), SCWarrant.this.getBlockAt(orders.size() - 2).getDisplayName()});
                if (SCWarrant.this._throttle == null) {
                    this.emergencyStop();
                    log.debug("Throttle lost at stop block");
                } else {
                    SCWarrant.this._throttle.setSpeedSetting(SCWarrant.this.speedFactor * 0.2f);
                }
                while ((SCWarrant.this.getBlockAt(orders.size() - 2).getState() & 2) == 2 && SCWarrant.this.getBlockAt(orders.size() - 2).isAllocatedTo(this._warrant)) {
                    log.debug(" runSignalControlledTrain {} entering wait. Block {}   free: {}   allocated to this warrant: {}", new Object[]{this._warrant._trainName, SCWarrant.this.getBlockAt(orders.size() - 2).getDisplayName(), SCWarrant.this.getBlockAt(orders.size() - 2).isFree(), SCWarrant.this.getBlockAt(orders.size() - 2).isAllocatedTo(this._warrant)});
                    try {
                        this._warrant.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        log.debug(INTERRUPTED_EXCEPTION, new Object[]{this._warrant._trainName, ie, ie});
                    }
                    catch (Exception e) {
                        log.debug(SCWarrant.WAIT_UNEXPECTED_EXCEPTION, new Object[]{SCWarrant.this._trainName, e, e});
                    }
                    log.debug("{} runSignalControlledTrain woken after last wait.... _orders.size()={}", (Object)this._warrant._trainName, (Object)orders.size());
                }
                if (SCWarrant.this.timeToPlatform > 100L) {
                    long remaining;
                    log.debug("{} runSignalControlledTrain is now fully into the stopping block. Proceeding for {} miliseconds", (Object)this._warrant._trainName, (Object)SCWarrant.this.timeToPlatform);
                    long timeWhenDone = System.currentTimeMillis() + SCWarrant.this.timeToPlatform;
                    while ((remaining = timeWhenDone - System.currentTimeMillis()) > 0L) {
                        try {
                            log.debug("{} running slowly to platform for {} miliseconds", (Object)this._warrant._trainName, (Object)remaining);
                            this._warrant.wait(remaining);
                        }
                        catch (InterruptedException e) {
                            log.debug(INTERRUPTED_EXCEPTION, new Object[]{this._warrant._trainName, e, e});
                        }
                    }
                }
                log.debug("{} runSignalControlledTrain STOPPING TRAIN IN STOP BLOCK", (Object)this._warrant._trainName);
                if (SCWarrant.this._throttle == null) {
                    this.emergencyStop();
                    log.debug("Throttle lost after stop block");
                } else {
                    SCWarrant.this._throttle.setSpeedSetting(0.0f);
                }
                SCWarrant.this.stopWarrant(false, false);
            }
        }

        private void emergencyStop() {
            PowerManager manager = InstanceManager.getNullableDefault(PowerManager.class);
            if (manager == null) {
                log.debug("{} EMERGENCY STOP IMPOSSIBLE: NO POWER MANAGER", (Object)SCWarrant.this._trainName);
                return;
            }
            try {
                manager.setPower(4);
            }
            catch (Exception e) {
                log.debug("{} EMERGENCY STOP FAILED WITH EXCEPTION: {}", new Object[]{SCWarrant.this._trainName, e, e});
            }
            log.debug("{} EMERGENCY STOP", (Object)SCWarrant.this._trainName);
        }
    }
}

