/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.XmlFile;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.BlockSpeedInfo;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedUtil {
    private DccLocoAddress _dccAddress;
    private String _rosterId;
    private RosterEntry _rosterEntry;
    private DccThrottle _throttle;
    private boolean _isForward = true;
    private float _rampThrottleIncrement;
    private int _rampTimeIncrement;
    private RosterSpeedProfile _sessionProfile;
    private final SignalSpeedMap _signalSpeedMap = InstanceManager.getDefault(SignalSpeedMap.class);
    private int _ma;
    private int _md;
    private ArrayList<BlockSpeedInfo> _speedInfo;
    public static final float SCALE_FACTOR = 44.704f;
    public static final float MAX_TGV_SPEED = 88889.0f;
    private long _timeAtSpeed = 0L;
    private float _intStartSpeed = 0.0f;
    private float _intEndSpeed = 0.0f;
    private float _distanceTravelled = 0.0f;
    private float _settingsTravelled = 0.0f;
    private long _prevChangeTime = -1L;
    private int _numchanges = 0;
    private long _entertime = 0L;
    private boolean _cantMeasure = false;
    private static final Logger log = LoggerFactory.getLogger(SpeedUtil.class);

    protected SpeedUtil() {
    }

    @CheckForNull
    public RosterEntry getRosterEntry() {
        return this._rosterEntry;
    }

    public String getRosterId() {
        return this._rosterId;
    }

    public boolean setRosterId(String id) {
        log.trace("setRosterId({}) old={}", (Object)id, (Object)this._rosterId);
        if (id == null || id.isEmpty()) {
            this._rosterEntry = null;
            this._sessionProfile = null;
            return false;
        }
        if (id.equals(this._rosterId)) {
            return true;
        }
        this._sessionProfile = null;
        RosterEntry re = Roster.getDefault().getEntryForId(id);
        if (re != null) {
            this._rosterEntry = re;
            this._dccAddress = re.getDccLocoAddress();
            this._rosterId = id;
            return true;
        }
        return false;
    }

    public DccLocoAddress getDccAddress() {
        if (this._dccAddress == null && this._rosterEntry != null) {
            this._dccAddress = this._rosterEntry.getDccLocoAddress();
        }
        return this._dccAddress;
    }

    @CheckForNull
    protected String getAddress() {
        if (this._dccAddress == null) {
            this._dccAddress = this.getDccAddress();
        }
        if (this._dccAddress != null) {
            return this._dccAddress.toString();
        }
        return null;
    }

    protected void setDccAddress(DccLocoAddress dccAddr) {
        log.trace("setDccAddress(DccLocoAddress) _dccAddress= {}", (Object)this._dccAddress);
        if (dccAddr == null) {
            this._sessionProfile = null;
            this._rosterId = null;
            this._rosterEntry = null;
            this._dccAddress = null;
            return;
        }
        if (!dccAddr.equals(this._dccAddress)) {
            this._sessionProfile = null;
            this._dccAddress = dccAddr;
        }
    }

    public boolean setDccAddress(int number, String type) {
        LocoAddress.Protocol protocol;
        log.trace("setDccAddress({}, {})", (Object)number, (Object)type);
        switch (type) {
            case "L": 
            case "l": {
                protocol = LocoAddress.Protocol.DCC_LONG;
                break;
            }
            case "S": 
            case "s": {
                protocol = LocoAddress.Protocol.DCC_SHORT;
                break;
            }
            default: {
                try {
                    protocol = LocoAddress.Protocol.getByPeopleName(type);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    try {
                        protocol = LocoAddress.Protocol.getByShortName(type.toLowerCase());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        this._dccAddress = null;
                        return false;
                    }
                }
            }
        }
        DccLocoAddress addr = new DccLocoAddress(number, protocol);
        if (this._rosterEntry != null && addr.equals(this._rosterEntry.getDccLocoAddress())) {
            return true;
        }
        this._dccAddress = addr;
        String numStr = String.valueOf(number);
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, numStr, null, null, null, null);
        if (!l.isEmpty()) {
            int size = l.size();
            if (size != 1) {
                log.info("{} entries for address {}, {}", new Object[]{l.size(), number, type});
            }
            this._rosterEntry = l.get(size - 1);
            this.setRosterId(this._rosterEntry.getId());
        } else {
            this._rosterId = "$" + this._dccAddress.toString() + "$";
            this.makeRosterEntry(this._rosterId);
            this._sessionProfile = null;
        }
        return true;
    }

    protected RosterEntry makeRosterEntry(String id) {
        RosterEntry rosterEntry = new RosterEntry();
        rosterEntry.setId(id);
        DccLocoAddress dccAddr = this.getDccAddress();
        if (dccAddr == null) {
            return null;
        }
        rosterEntry.setDccAddress(String.valueOf(dccAddr.getNumber()));
        rosterEntry.setProtocol(dccAddr.getProtocol());
        rosterEntry.ensureFilenameExists();
        return rosterEntry;
    }

    public boolean setAddress(String id) {
        int num;
        String type;
        String numId;
        log.trace("setDccAddress: id= {}, _rosterId= {}", (Object)id, (Object)this._rosterId);
        if (id == null || id.isEmpty()) {
            return false;
        }
        if (this.setRosterId(id)) {
            return true;
        }
        int index = -1;
        for (int i = 0; i < id.length(); ++i) {
            if (Character.isDigit(id.charAt(i))) continue;
            index = i;
            break;
        }
        if (index == -1) {
            numId = id;
            type = null;
        } else {
            int beginIdx = id.charAt(index) == '(' ? index + 1 : index;
            int endIdx = id.charAt(id.length() - 1) == ')' ? id.length() - 1 : id.length();
            numId = id.substring(0, index);
            type = id.substring(beginIdx, endIdx);
        }
        try {
            num = Integer.parseInt(numId);
        }
        catch (NumberFormatException e) {
            num = 0;
        }
        if (type == null) {
            type = num > 128 ? "L" : "S";
        }
        if (!this.setDccAddress(num, type)) {
            log.error("setDccAddress failed for ID= {} number={} type={}", new Object[]{id, num, type});
            return false;
        }
        if (log.isTraceEnabled()) {
            log.debug("setDccAddress({}): _rosterId= {}, _dccAddress= {}", new Object[]{id, this._rosterId, this._dccAddress.toString()});
        }
        return true;
    }

    protected float getRampThrottleIncrement() {
        if (this._rampThrottleIncrement <= 0.0f) {
            this._rampThrottleIncrement = WarrantPreferences.getDefault().getThrottleIncrement();
        }
        return this._rampThrottleIncrement;
    }

    protected void setRampThrottleIncrement(float incr) {
        this._rampThrottleIncrement = incr;
    }

    protected int getRampTimeIncrement() {
        if (this._rampTimeIncrement < 500) {
            this._rampTimeIncrement = WarrantPreferences.getDefault().getTimeIncrement();
            if (this._rampTimeIncrement <= 500) {
                this._rampTimeIncrement = 500;
            }
        }
        return this._rampTimeIncrement;
    }

    protected void setRampTimeIncrement(int incr) {
        this._rampTimeIncrement = incr;
    }

    protected float getMomentumTime(float fromSpeed, float toSpeed) {
        float time;
        float delta;
        float incr = this.getThrottleSpeedStepIncrement();
        if (fromSpeed < toSpeed) {
            delta = toSpeed - fromSpeed;
            time = (float)this._ma * delta / incr;
        } else {
            delta = fromSpeed - toSpeed;
            time = (float)this._md * delta / incr;
        }
        if (time < 2.0f * delta / incr) {
            time = 2.0f * delta / incr;
        }
        if (log.isTraceEnabled()) {
            log.debug("getMomentumTime for {}, addr={}. fromSpeed={}, toSpeed= {}, time= {}ms for {} steps", new Object[]{this._rosterId, this.getAddress(), Float.valueOf(fromSpeed), Float.valueOf(toSpeed), Float.valueOf(time), Float.valueOf(delta / incr)});
        }
        return time;
    }

    protected float getThrottleSpeedStepIncrement() {
        if (this._throttle != null) {
            return this._throttle.getSpeedIncrement();
        }
        return 0.007936508f;
    }

    protected synchronized RosterSpeedProfile getMergeProfile() {
        if (this._sessionProfile == null) {
            this.makeSpeedTree();
            this.makeRampParameters();
        }
        return this._sessionProfile;
    }

    private synchronized void makeSpeedTree() {
        log.trace("makeSpeedTree for {}.", (Object)this._rosterId);
        WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
        this._sessionProfile = manager.getMergeProfile(this._rosterId);
        if (this._sessionProfile == null) {
            RosterSpeedProfile profile;
            this._rosterEntry = Roster.getDefault().getEntryForId(this._rosterId);
            if (this._rosterEntry == null) {
                this._rosterEntry = this.makeRosterEntry(this._rosterId);
                profile = new RosterSpeedProfile(this._rosterEntry);
            } else {
                profile = this._rosterEntry.getSpeedProfile();
                if (profile == null) {
                    profile = new RosterSpeedProfile(this._rosterEntry);
                    this._rosterEntry.setSpeedProfile(profile);
                }
            }
            this._sessionProfile = manager.makeProfileCopy(profile, this._rosterEntry);
            manager.setMergeProfile(this._rosterId, this._sessionProfile);
        }
        if (log.isTraceEnabled()) {
            log.debug("SignalSpeedMap: throttle factor= {}, layout scale= {} convesion to mm/s= {}", new Object[]{Float.valueOf(this._signalSpeedMap.getDefaultThrottleFactor()), Float.valueOf(this._signalSpeedMap.getLayoutScale()), Float.valueOf(this._signalSpeedMap.getDefaultThrottleFactor() * this._signalSpeedMap.getLayoutScale() / 44.704f)});
        }
    }

    private void makeRampParameters() {
        this._rampTimeIncrement = this.getRampTimeIncrement();
        this._rampThrottleIncrement = this.getRampThrottleIncrement();
        this._ma = 0;
        this._md = 0;
        if (this._rosterEntry != null) {
            Element elem;
            String fileName = Roster.getDefault().getRosterFilesLocation() + this._rosterEntry.getFileName();
            XmlFile xmlFile = new XmlFile(){};
            try {
                elem = xmlFile.rootFromFile(new File(fileName));
            }
            catch (FileNotFoundException npe) {
                elem = null;
            }
            catch (IOException | JDOMException eb) {
                log.error("Exception while loading warrant preferences", eb);
                elem = null;
            }
            if (elem != null) {
                elem = elem.getChild("locomotive");
            }
            if (elem != null) {
                elem = elem.getChild("values");
            }
            if (elem != null) {
                List list = elem.getChildren("CVvalue");
                int count = 0;
                for (Element cv : list) {
                    Attribute attr = cv.getAttribute("name");
                    if (attr != null) {
                        if (attr.getValue().equals("3")) {
                            this._ma += this.getMomentumFactor(cv);
                            ++count;
                        } else if (attr.getValue().equals("4")) {
                            this._md += this.getMomentumFactor(cv);
                            ++count;
                        } else if (attr.getValue().equals("23")) {
                            this._ma += this.getMomentumAdustment(cv);
                            ++count;
                        } else if (attr.getValue().equals("24")) {
                            this._md += this.getMomentumAdustment(cv);
                            ++count;
                        }
                    }
                    if (count <= 3) continue;
                    break;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("makeRampParameters for {}, addr={}. _ma= {}ms/step, _md= {}ms/step. rampThrottleIncr= {} rampTimeIncr= {} throttleStep= {}", new Object[]{this._rosterId, this.getAddress(), this._ma, this._md, Float.valueOf(this._rampThrottleIncrement), this._rampTimeIncrement, Float.valueOf(this.getThrottleSpeedStepIncrement())});
        }
    }

    private int getMomentumFactor(Element cv) {
        Attribute attr = cv.getAttribute("value");
        int num = 0;
        if (attr != null) {
            try {
                num = Integer.parseInt(attr.getValue());
                num = Math.round((float)(num * 896) * this.getThrottleSpeedStepIncrement());
            }
            catch (NumberFormatException nfe) {
                num = 0;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("getMomentumFactor for cv {} {}, num= {}", new Object[]{cv.getAttribute("name"), attr, num});
        }
        return num;
    }

    private int getMomentumAdustment(Element cv) {
        Attribute attr = cv.getAttribute("value");
        int num = 0;
        if (attr != null) {
            try {
                int val = Integer.parseInt(attr.getValue());
                num = val & 0x3F;
                if ((val & 0x40) != 0) {
                    num = -num;
                }
            }
            catch (NumberFormatException nfe) {
                num = 0;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("getMomentumAdustment for cv {} {},  num= {}", new Object[]{cv.getAttribute("name"), attr, num});
        }
        return num;
    }

    protected boolean profileHasSpeedInfo() {
        RosterSpeedProfile speedProfile = this.getMergeProfile();
        if (speedProfile == null) {
            return false;
        }
        return speedProfile.hasForwardSpeeds() || speedProfile.hasReverseSpeeds();
    }

    protected void setIsForward(boolean direction) {
        this._isForward = direction;
        if (this._throttle != null) {
            this._throttle.setIsForward(direction);
        }
    }

    protected boolean getIsForward() {
        if (this._throttle != null) {
            this._isForward = this._throttle.getIsForward();
        }
        return this._isForward;
    }

    protected void setThrottle(DccThrottle throttle) {
        this._throttle = throttle;
        this.getMergeProfile();
        float stepIncrement = this._throttle.getSpeedIncrement();
        this._rampThrottleIncrement = stepIncrement * (float)Math.round(this.getRampThrottleIncrement() / stepIncrement);
        if (log.isDebugEnabled()) {
            log.debug("User's Ramp increment modified to {} ({} speed steps)", (Object)Float.valueOf(this._rampThrottleIncrement), (Object)Math.round(this._rampThrottleIncrement / stepIncrement));
        }
    }

    protected DccThrottle getThrottle() {
        return this._throttle;
    }

    protected boolean secondGreaterThanFirst(String speed1, String speed2) {
        float s2;
        if (speed2 == null) {
            return false;
        }
        if (speed1 == null) {
            return true;
        }
        if (speed1.equals(speed2)) {
            return false;
        }
        float s1 = this._signalSpeedMap.getSpeed(speed1);
        return s1 < (s2 = this._signalSpeedMap.getSpeed(speed2));
    }

    protected float modifySpeed(float tSpeed, String sType) {
        log.trace("modifySpeed speed= {} for SpeedType= \"{}\"", (Object)Float.valueOf(tSpeed), (Object)sType);
        if (sType.equals(Warrant.Stop)) {
            return 0.0f;
        }
        if (sType.equals(Warrant.EStop)) {
            return -1.0f;
        }
        float throttleSpeed = tSpeed;
        if (sType.equals("Normal")) {
            return throttleSpeed;
        }
        float signalSpeed = this._signalSpeedMap.getSpeed(sType);
        switch (this._signalSpeedMap.getInterpretation()) {
            case 1: {
                throttleSpeed *= signalSpeed / 100.0f;
                break;
            }
            case 2: {
                signalSpeed /= 100.0f;
                if (!(signalSpeed < throttleSpeed)) break;
                throttleSpeed = signalSpeed;
                break;
            }
            case 3: {
                signalSpeed /= this._signalSpeedMap.getLayoutScale();
                signalSpeed /= 2.2369363f;
                float trackSpeed = this.getTrackSpeed(throttleSpeed);
                if (!(signalSpeed < trackSpeed)) break;
                throttleSpeed = this.getThrottleSettingForSpeed(signalSpeed);
                break;
            }
            case 4: {
                signalSpeed /= this._signalSpeedMap.getLayoutScale();
                signalSpeed /= 3.6f;
                float trackSpeed = this.getTrackSpeed(throttleSpeed);
                if (!(signalSpeed < trackSpeed)) break;
                throttleSpeed = this.getThrottleSettingForSpeed(signalSpeed);
                break;
            }
            default: {
                log.error("Unknown speed interpretation {}", (Object)this._signalSpeedMap.getInterpretation());
                throw new IllegalArgumentException("Unknown speed interpretation " + this._signalSpeedMap.getInterpretation());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("modifySpeed: from {}, to {}, signalSpeed= {}. interpretation= {}", new Object[]{Float.valueOf(tSpeed), Float.valueOf(throttleSpeed), Float.valueOf(signalSpeed), this._signalSpeedMap.getInterpretation()});
        }
        return throttleSpeed;
    }

    protected static long modifyTime(float speed, long time, float modifiedSpeed) {
        if (Math.abs(speed - modifiedSpeed) > 1.0E-4f) {
            return (long)(speed / modifiedSpeed * (float)time);
        }
        return time;
    }

    protected float getTrackSpeed(float throttleSetting) {
        boolean isForward;
        if (throttleSetting <= 0.0f) {
            return 0.0f;
        }
        if (this._dccAddress == null) {
            return this.factorSpeed(throttleSetting);
        }
        RosterSpeedProfile sessionProfile = this.getMergeProfile();
        float speed = sessionProfile.getSpeed(throttleSetting, isForward = this.getIsForward()) / 1000.0f;
        if (speed <= 0.0f) {
            speed = sessionProfile.getSpeed(throttleSetting, !isForward) / 1000.0f;
        }
        if (speed <= 0.0f) {
            return this.factorSpeed(throttleSetting);
        }
        return speed;
    }

    private float factorSpeed(float throttleSetting) {
        float factor = this._signalSpeedMap.getDefaultThrottleFactor() * 44.704f / this._signalSpeedMap.getLayoutScale();
        return throttleSetting * factor;
    }

    protected float getThrottleSettingForSpeed(float trackSpeed) {
        RosterSpeedProfile speedProfile = this.getMergeProfile();
        float throttleSpeed = speedProfile != null ? speedProfile.getThrottleSetting(trackSpeed * 1000.0f, this.getIsForward()) : 0.0f;
        if (throttleSpeed <= 0.0f) {
            throttleSpeed = trackSpeed * this._signalSpeedMap.getLayoutScale() / (44.704f * this._signalSpeedMap.getDefaultThrottleFactor());
        }
        return throttleSpeed;
    }

    protected float getDistanceTraveled(float speedSetting, String speedtype, float time) {
        if (time <= 0.0f) {
            return 0.0f;
        }
        float throttleSetting = this.modifySpeed(speedSetting, speedtype);
        return this.getTrackSpeed(throttleSetting) * time;
    }

    protected int getTimeForDistance(float throttleSetting, float distance) {
        float speed = this.getTrackSpeed(throttleSetting);
        if (distance <= 0.0f || speed <= 0.0f) {
            return 0;
        }
        return Math.round(distance / speed);
    }

    protected void getBlockSpeedTimes(List<ThrottleSetting> commands, List<BlockOrder> orders) {
        this._speedInfo = new ArrayList();
        float firstSpeed = 0.0f;
        float speed = 0.0f;
        float intStartSpeed = 0.0f;
        float intEndSpeed = 0.0f;
        long blkTime = 0L;
        float pathDist = 0.0f;
        float calcDist = 0.0f;
        int firstIdx = 0;
        int blkOrderIdx = 0;
        ThrottleSetting ts = commands.get(0);
        OBlock blk = (OBlock)ts.getNamedBeanHandle().getBean();
        String blkName = blk.getDisplayName();
        for (int i = 0; i < commands.size(); ++i) {
            ts = commands.get(i);
            ThrottleSetting.Command command = ts.getCommand();
            ThrottleSetting.CommandValue cmdVal = ts.getValue();
            if (command.equals((Object)ThrottleSetting.Command.FORWARD)) {
                ThrottleSetting.ValueType val = cmdVal.getType();
                this.setIsForward(val.equals((Object)ThrottleSetting.ValueType.VAL_TRUE));
            }
            long time = ts.getTime();
            blkTime += time;
            if (time > 0L) {
                calcDist += this.getDistanceOfSpeedChange(intStartSpeed, intEndSpeed, time);
            }
            if (command.equals((Object)ThrottleSetting.Command.SPEED)) {
                speed = cmdVal.getFloat();
                if (speed < 0.0f) {
                    speed = 0.0f;
                }
                intStartSpeed = intEndSpeed;
                intEndSpeed = speed;
            }
            if (!command.equals((Object)ThrottleSetting.Command.NOOP)) continue;
            if (time > 0L) {
                calcDist += this.getDistanceOfSpeedChange(intStartSpeed, intEndSpeed, time);
            }
            float ratio = 1.0f;
            if (calcDist > 0.0f && blkOrderIdx > 0 && blkOrderIdx < commands.size() - 1) {
                pathDist = orders.get(blkOrderIdx).getPathLength();
                ratio = pathDist / calcDist;
            } else {
                pathDist = orders.get(blkOrderIdx).getPathLength() / 2.0f;
            }
            this._speedInfo.add(new BlockSpeedInfo(blkName, firstSpeed, speed, blkTime, pathDist, calcDist, firstIdx, i));
            if ((Warrant._trace || log.isDebugEnabled()) && (calcDist <= 0.0f || Math.abs(ratio) > 2.0f || Math.abs(ratio) < 0.5f)) {
                log.debug("\"{}\" Speeds: enter= {}, exit= {}. time= {}ms, pathDist= {}, calcDist= {}. index {} to {}", new Object[]{blkName, Float.valueOf(firstSpeed), Float.valueOf(speed), blkTime, Float.valueOf(pathDist), Float.valueOf(calcDist), firstIdx, i});
            }
            ++blkOrderIdx;
            blk = (OBlock)ts.getNamedBeanHandle().getBean();
            blkName = blk.getDisplayName();
            blkTime = 0L;
            calcDist = 0.0f;
            intStartSpeed = intEndSpeed;
            firstSpeed = speed;
            firstIdx = i + 1;
        }
        this._speedInfo.add(new BlockSpeedInfo(blkName, firstSpeed, speed, blkTime, pathDist, calcDist, firstIdx, commands.size() - 1));
        if (log.isDebugEnabled()) {
            log.debug("block: {} speeds: entrance= {}, exit= {}. time= {}ms pathDist= {}, calcDist= {}. index {} to {}", new Object[]{blkName, Float.valueOf(firstSpeed), Float.valueOf(speed), blkTime, Float.valueOf(pathDist), Float.valueOf(calcDist), firstIdx, commands.size() - 1});
        }
        this.clearStats(-1L);
        this._intStartSpeed = 0.0f;
        this._intEndSpeed = 0.0f;
    }

    protected BlockSpeedInfo getBlockSpeedInfo(int idxBlockOrder) {
        return this._speedInfo.get(idxBlockOrder);
    }

    protected RampData getRampForSpeedChange(float fromSpeed, float toSpeed) {
        return new RampData(this, this.getRampThrottleIncrement(), this.getRampTimeIncrement(), fromSpeed, toSpeed);
    }

    protected float getRampLengthForEntry(float fromSpeed, float toSpeed) {
        RampData ramp = this.getRampForSpeedChange(fromSpeed, toSpeed);
        float enterLen = ramp.getRampLength();
        if (log.isTraceEnabled()) {
            log.debug("getRampLengthForEntry: from speed={} to speed={}. rampLen={}", new Object[]{Float.valueOf(fromSpeed), Float.valueOf(toSpeed), Float.valueOf(enterLen)});
        }
        return enterLen;
    }

    protected float getDistanceOfSpeedChange(float fromSpeed, float toSpeed, long speedTime) {
        float dist;
        float momentumTime;
        if (toSpeed < 0.0f) {
            toSpeed = 0.0f;
        }
        if (fromSpeed < 0.0f) {
            fromSpeed = 0.0f;
        }
        if ((float)speedTime <= (momentumTime = this.getMomentumTime(fromSpeed, toSpeed))) {
            dist = this.getTrackSpeed((fromSpeed + toSpeed) / 2.0f) * (float)speedTime;
        } else {
            dist = this.getTrackSpeed((fromSpeed + toSpeed) / 2.0f) * momentumTime;
            if ((float)speedTime > momentumTime) {
                dist += this.getTrackSpeed(toSpeed) * ((float)speedTime - momentumTime);
            }
        }
        return dist;
    }

    protected void leavingBlock(int blkIdx) {
        float distRatio;
        float measuredSpeed;
        long exitTime = System.currentTimeMillis();
        BlockSpeedInfo blkInfo = this.getBlockSpeedInfo(blkIdx);
        log.debug("BlockInfo: {}", (Object)blkInfo);
        if (this._cantMeasure) {
            this.clearStats(exitTime);
            this._entertime = exitTime;
            log.debug("Skip speed measurement");
            return;
        }
        boolean isForward = this.getIsForward();
        float throttle = this._throttle.getSpeedSetting();
        float length = blkInfo.getPathLen();
        long elapsedTime = exitTime - this._prevChangeTime;
        if (this._numchanges == 0) {
            this._distanceTravelled = this.getTrackSpeed(throttle) * (float)elapsedTime;
            this._settingsTravelled = throttle * (float)elapsedTime;
            this._timeAtSpeed = elapsedTime;
        } else {
            float dist = this.getDistanceOfSpeedChange(this._intStartSpeed, this._intEndSpeed, elapsedTime);
            if (this._intStartSpeed > 0.0f || this._intEndSpeed > 0.0f) {
                this._timeAtSpeed += elapsedTime;
            }
            if (log.isDebugEnabled()) {
                log.debug("speedChange to {}: dist={} in {}ms from speed {} to {}.", new Object[]{Float.valueOf(throttle), Float.valueOf(dist), elapsedTime, Float.valueOf(this._intStartSpeed), Float.valueOf(this._intEndSpeed)});
            }
            this._distanceTravelled += dist;
            this._settingsTravelled += throttle * (float)elapsedTime;
        }
        if (length <= 0.0f) {
            measuredSpeed = this._distanceTravelled / (float)this._timeAtSpeed;
            distRatio = 2.0f;
        } else {
            measuredSpeed = length / (float)this._timeAtSpeed;
            distRatio = blkInfo.getCalcLen() / this._distanceTravelled;
        }
        measuredSpeed *= 1000.0f;
        float aveSettings = this._settingsTravelled / (float)this._timeAtSpeed;
        if (log.isDebugEnabled()) {
            float timeRatio = (float)(exitTime - this._entertime) / (float)this._timeAtSpeed;
            log.debug("distRatio= {}, timeRatio= {}, aveSpeed= {}, length= {}, calcLength= {}, elapsedTime= {}", new Object[]{Float.valueOf(distRatio), Float.valueOf(timeRatio), Float.valueOf(measuredSpeed), Float.valueOf(length), Float.valueOf(this._distanceTravelled), exitTime - this._entertime});
        }
        if ((double)aveSettings > 1.0 || measuredSpeed > 88889.0f * aveSettings / this._signalSpeedMap.getLayoutScale() || distRatio > 1.15f || distRatio < 0.87f) {
            if (log.isDebugEnabled()) {
                log.info("Bad speed measurements data for block {}. aveThrottle= {},  measuredSpeed= {},(TGVmax= {}), distTravelled= {}, pathLen= {}", new Object[]{blkInfo.getBlockDisplayName(), Float.valueOf(aveSettings), Float.valueOf(measuredSpeed), Float.valueOf(88889.0f * aveSettings / this._signalSpeedMap.getLayoutScale()), Float.valueOf(this._distanceTravelled), Float.valueOf(length)});
            }
        } else if (this._numchanges < 3) {
            this.setSpeedProfile(this._sessionProfile, aveSettings, measuredSpeed, isForward);
        }
        if (log.isDebugEnabled()) {
            log.debug("{} changes in block '{}\". measuredDist={}, pathLen={},  measuredThrottle={},  measuredTrkSpd={}, profileTrkSpd={} curThrottle={}.", new Object[]{this._numchanges, blkInfo.getBlockDisplayName(), Math.round(this._distanceTravelled), Float.valueOf(length), Float.valueOf(aveSettings), Float.valueOf(measuredSpeed), Float.valueOf(this.getTrackSpeed(aveSettings) * 1000.0f), Float.valueOf(throttle)});
        }
        this.clearStats(exitTime);
        this._entertime = exitTime;
    }

    private void setSpeedProfile(RosterSpeedProfile profile, float throttle, float measuredSpeed, boolean isForward) {
        int key;
        int keyIncrement = Math.round(this.getThrottleSpeedStepIncrement() * 1000.0f);
        TreeMap<Integer, RosterSpeedProfile.SpeedStep> speeds = profile.getProfileSpeeds();
        Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = speeds.floorEntry(key = Math.round(throttle * 1000.0f));
        if (entry != null && this.mergeEntry(key, measuredSpeed, entry, keyIncrement, isForward)) {
            return;
        }
        entry = speeds.ceilingEntry(key);
        if (entry != null && this.mergeEntry(key, measuredSpeed, entry, keyIncrement, isForward)) {
            return;
        }
        float speed = profile.getSpeed(throttle, isForward);
        if (speed > 0.0f) {
            measuredSpeed = (measuredSpeed + speed) / 2.0f;
        }
        if (isForward) {
            profile.setForwardSpeed(throttle, measuredSpeed, this._throttle.getSpeedIncrement());
        } else {
            profile.setReverseSpeed(throttle, measuredSpeed, this._throttle.getSpeedIncrement());
        }
        log.debug("Put measuredThrottle={} and measuredTrkSpd={} for isForward= {} curThrottle={}.", new Object[]{Float.valueOf(throttle), Float.valueOf(measuredSpeed), isForward, Float.valueOf(throttle)});
    }

    private boolean mergeEntry(int key, float measuredSpeed, Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry, int keyIncrement, boolean isForward) {
        Integer sKey = entry.getKey();
        if (Math.abs(sKey - key) < keyIncrement) {
            RosterSpeedProfile.SpeedStep sStep = entry.getValue();
            if (isForward) {
                float sTrackSpeed = sStep.getForwardSpeed();
                if (sTrackSpeed > 0.0f) {
                    sTrackSpeed = sTrackSpeed > 0.0f ? (sTrackSpeed + measuredSpeed) / 2.0f : measuredSpeed;
                    sStep.setForwardSpeed(sTrackSpeed);
                }
            } else {
                float sTrackSpeed = sStep.getReverseSpeed();
                if (sTrackSpeed > 0.0f) {
                    sTrackSpeed = sTrackSpeed > 0.0f ? (sTrackSpeed + measuredSpeed) / 2.0f : measuredSpeed;
                    sStep.setReverseSpeed(sTrackSpeed);
                }
            }
        }
        return false;
    }

    private void clearStats(long exitTime) {
        this._timeAtSpeed = 0L;
        this._distanceTravelled = 0.0f;
        this._settingsTravelled = 0.0f;
        this._numchanges = 0;
        this._prevChangeTime = exitTime;
        this._cantMeasure = false;
    }

    protected synchronized void speedChange(float throttleSetting) {
        if (Math.abs(this._intEndSpeed - throttleSetting) < 1.0E-5f) {
            this._cantMeasure = true;
            return;
        }
        ++this._numchanges;
        long time = System.currentTimeMillis();
        if (throttleSetting <= 0.0f) {
            throttleSetting = 0.0f;
        }
        if (this._prevChangeTime > 0L) {
            long elapsedTime = time - this._prevChangeTime;
            float dist = this.getDistanceOfSpeedChange(this._intStartSpeed, this._intEndSpeed, elapsedTime);
            if (dist > 0.0f) {
                this._timeAtSpeed += elapsedTime;
            }
            if (log.isTraceEnabled()) {
                log.debug("speedChange to {}: dist={} in {}ms from speed {} to {}.", new Object[]{Float.valueOf(throttleSetting), Float.valueOf(dist), elapsedTime, Float.valueOf(this._intStartSpeed), Float.valueOf(this._intEndSpeed)});
            }
            this._distanceTravelled += dist;
            this._settingsTravelled += throttleSetting * (float)elapsedTime;
        }
        if (this._entertime <= 0L) {
            this._entertime = time;
        }
        this._prevChangeTime = time;
        this._intStartSpeed = this._intEndSpeed;
        this._intEndSpeed = throttleSetting;
    }
}

