/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.JmriException;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.TrackerTableAction;
import jmri.jmrit.logix.Warrant;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracker {
    private static final String TRACKER_NO_CURRENT_BLOCK = "TrackerNoCurrentBlock";
    private final TrackerTableAction _parent;
    private final String _trainName;
    private ArrayList<OBlock> _headRange;
    private ArrayList<OBlock> _tailRange;
    private final ArrayList<OBlock> _lostRange = new ArrayList();
    private final LinkedList<OBlock> _occupies = new LinkedList();
    final long _startTime;
    String _statusMessage;
    private final Color _markerForeground;
    private final Color _markerBackground;
    private final Font _markerFont;
    private OBlock _darkBlock = null;
    private static final Logger log = LoggerFactory.getLogger(Tracker.class);

    Tracker(OBlock block, String name, LocoIcon marker, TrackerTableAction tta) {
        this._trainName = name;
        this._parent = tta;
        this._markerForeground = block.getMarkerForeground();
        this._markerBackground = block.getMarkerBackground();
        this._markerFont = block.getMarkerFont();
        block.setState(block.getState() & 0xFFFFFFDF);
        this.addtoOccupies(block, true);
        block._entryTime = this._startTime = System.currentTimeMillis();
        List<OBlock> occupy = this.initialRange(this._parent);
        if (!occupy.isEmpty()) {
            new ChooseStartBlock(block, occupy, this, this._parent);
        } else {
            this._parent.addTracker(this);
        }
        if (marker != null) {
            marker.dock();
        }
    }

    private List<OBlock> initialRange(TrackerTableAction parent) {
        this.makeRange();
        if (this.getHeadBlock().equals(this.getTailBlock())) {
            return this.makeChoiceList(this._headRange, parent);
        }
        return this.makeChoiceList(this._tailRange, parent);
    }

    private List<OBlock> makeChoiceList(List<OBlock> range, TrackerTableAction parent) {
        ArrayList<OBlock> occupy = new ArrayList<OBlock>();
        for (OBlock b : range) {
            if (this._occupies.contains(b) || (b.getState() & 2) == 0 && (b.getState() & 0x100) == 0 || !parent.checkBlock(b)) continue;
            occupy.add(b);
        }
        return occupy;
    }

    private void showBlockValue(OBlock block) {
        block.setValue(this._trainName);
        block.setMarkerBackground(this._markerBackground);
        block.setMarkerForeground(this._markerForeground);
        block.setMarkerFont(this._markerFont);
        block.setState(block.getState() | 0x20);
    }

    protected String getTrainName() {
        return this._trainName;
    }

    protected final OBlock getHeadBlock() {
        return this._occupies.peekFirst();
    }

    protected final OBlock getTailBlock() {
        return this._occupies.peekLast();
    }

    protected String getStatus() {
        long et = 0L;
        OBlock block = null;
        for (OBlock b : this._occupies) {
            long t = System.currentTimeMillis() - b._entryTime;
            if (t < et) continue;
            et = t;
            block = b;
        }
        if (block == null) {
            return Bundle.getMessage("TrackerLocationLost", this._trainName);
        }
        return Bundle.getMessage("TrackerStatus", this._trainName, block.getDisplayName(), (et /= 1000L) / 60L, et % 60L);
    }

    private PathSet hasPathBetween(@Nonnull OBlock blkA, @Nonnull OBlock blkB, boolean recurse) throws JmriException {
        PathSet pathset = PathSet.NOTSET;
        boolean hasExitA = false;
        boolean hasEnterB = false;
        boolean adjacentBlock = false;
        ArrayList<OBlock> darkBlocks = new ArrayList<OBlock>();
        for (Portal portal : blkA.getPortals()) {
            OBlock block = portal.getOpposingBlock(blkA);
            if (blkB.equals(block)) {
                adjacentBlock = true;
                if (!this.getPathsSet(blkA, portal).isEmpty()) {
                    hasExitA = true;
                    if (this.getPathsSet(blkB, portal).isEmpty()) continue;
                    pathset = PathSet.SET;
                    break;
                }
                if (this.getPathsSet(blkB, portal).isEmpty()) continue;
                hasEnterB = true;
                continue;
            }
            if ((block.getState() & 0x100) == 0) continue;
            darkBlocks.add(block);
        }
        if (pathset != PathSet.SET && (hasExitA || hasEnterB)) {
            pathset = PathSet.PARTIAL;
        }
        if (adjacentBlock || !recurse) {
            return pathset;
        }
        if (darkBlocks.isEmpty()) {
            return PathSet.NOWAY;
        }
        for (OBlock block : darkBlocks) {
            PathSet darkPathSet = this.hasDarkBlockPathBetween(blkA, block, blkB);
            if (darkPathSet == PathSet.SET) {
                this._darkBlock = block;
                pathset = PathSet.SET;
                break;
            }
            if (darkPathSet != PathSet.PARTIAL) continue;
            this._darkBlock = block;
            pathset = PathSet.PARTIAL;
        }
        if (this._darkBlock == null) {
            this._darkBlock = (OBlock)darkBlocks.get(0);
        }
        return pathset;
    }

    private PathSet hasDarkBlockPathBetween(OBlock blkA, OBlock block, OBlock blkB) throws JmriException {
        PathSet pathset = PathSet.NOTSET;
        PathSet setA = this.hasPathBetween(blkA, block, false);
        PathSet setB = this.hasPathBetween(block, blkB, false);
        if (setA == PathSet.SET && setB == PathSet.SET) {
            pathset = PathSet.SET;
        } else if (setA != PathSet.NOTSET && setB != PathSet.NOTSET) {
            pathset = PathSet.PARTIAL;
        }
        return pathset;
    }

    protected PathSet hasPathInto(OBlock block) throws JmriException {
        PathSet pathSet;
        this._darkBlock = null;
        OBlock blk = this.getHeadBlock();
        if (blk != null && (pathSet = this.hasPathBetween(blk, block, true)) != PathSet.NOWAY) {
            return pathSet;
        }
        blk = this.getTailBlock();
        if (blk == null) {
            throw new JmriException("No tail block!");
        }
        return this.hasPathBetween(blk, block, true);
    }

    private List<OPath> getPathsSet(OBlock block, @Nonnull Portal portal) {
        List<OPath> paths = portal.getPathsWithinBlock(block);
        ArrayList<OPath> setPaths = new ArrayList<OPath>();
        for (OPath path : paths) {
            if (!path.checkPathSet()) continue;
            setPaths.add(path);
        }
        return setPaths;
    }

    private boolean areDisjoint(OBlock b) {
        return !this._headRange.contains(b) && !this._occupies.contains(b) && !this._tailRange.contains(b);
    }

    private void addtoHeadRange(@CheckForNull OBlock b) {
        if (b != null && this.areDisjoint(b)) {
            this._headRange.add(b);
        }
    }

    private void addtoTailRange(@CheckForNull OBlock b) {
        if (b != null && this.areDisjoint(b)) {
            this._tailRange.add(b);
        }
    }

    private void addtoOccupies(OBlock b, boolean atHead) {
        if (!this._occupies.contains(b)) {
            if (atHead) {
                this._occupies.addFirst(b);
            } else {
                this._occupies.addLast(b);
            }
            this.showBlockValue(b);
            this._lostRange.remove(b);
        }
    }

    private void removeFromOccupies(OBlock b) {
        if (b != null) {
            this._occupies.remove(b);
            this._lostRange.remove(b);
        }
    }

    protected List<OBlock> makeRange() {
        OBlock blk;
        OBlock block;
        this._headRange = new ArrayList();
        this._tailRange = new ArrayList();
        OBlock headBlock = this.getHeadBlock();
        OBlock tailBlock = this.getTailBlock();
        if (headBlock != null) {
            for (Portal portal : headBlock.getPortals()) {
                block = portal.getOpposingBlock(headBlock);
                if (block == null) continue;
                if ((block.getState() & 0x100) != 0) {
                    for (Portal p : block.getPortals()) {
                        blk = p.getOpposingBlock(block);
                        if (blk.equals(headBlock)) continue;
                        this.addtoHeadRange(blk);
                    }
                    continue;
                }
                this.addtoHeadRange(block);
            }
        }
        if (tailBlock != null && !tailBlock.equals(headBlock)) {
            for (Portal portal : tailBlock.getPortals()) {
                block = portal.getOpposingBlock(tailBlock);
                if (block == null) continue;
                if ((block.getState() & 0x100) != 0) {
                    for (Portal p : block.getPortals()) {
                        blk = p.getOpposingBlock(block);
                        if (blk.equals(tailBlock)) continue;
                        this.addtoTailRange(blk);
                    }
                    continue;
                }
                this.addtoTailRange(block);
            }
        }
        return this.buildRange();
    }

    private List<OBlock> buildRange() {
        ArrayList<OBlock> range = new ArrayList<OBlock>();
        if (this._occupies.isEmpty()) {
            log.warn("{} does not occupy any blocks!", (Object)this._trainName);
        }
        range.addAll(this._occupies);
        range.addAll(this._headRange);
        range.addAll(this._tailRange);
        return range;
    }

    protected List<OBlock> getBlocksOccupied() {
        return this._occupies;
    }

    protected void stop() {
        for (OBlock b : this._occupies) {
            if ((b.getState() & 0x100) == 0) continue;
            this.removeName(b);
        }
    }

    private void removeBlock(@Nonnull OBlock block) {
        int size = this._occupies.size();
        int index = this._occupies.indexOf(block);
        if (index > 0 && index < size - 1) {
            log.warn("Tracker {} lost occupancy mid train at block \"{}\"!", (Object)this._trainName, (Object)block.getDisplayName());
            this._statusMessage = Bundle.getMessage("trackerLostBlock", this._trainName, block.getDisplayName());
            return;
        }
        this.removeFromOccupies(block);
        for (Portal p : block.getPortals()) {
            OBlock b = p.getOpposingBlock(block);
            if ((b.getState() & 0x104) == 0) continue;
            this.removeFromOccupies(b);
            this.removeName(b);
        }
        this.removeName(block);
    }

    private void removeName(OBlock block) {
        if (this._trainName.equals(block.getValue())) {
            block.setValue(null);
            block.setState(block.getState() & 0xFFFFFFDF);
        }
    }

    protected boolean move(OBlock block, int state) {
        this._statusMessage = null;
        if ((state & 2) != 0) {
            if (this._occupies.contains(block)) {
                if (block.getValue() == null) {
                    block.setValue(this._trainName);
                    this.showBlockValue(block);
                    this._parent.setStatus(Bundle.getMessage("TrackerReentry", this._trainName, block.getDisplayName()));
                    this._lostRange.remove(block);
                } else if (!block.getValue().equals(this._trainName)) {
                    log.error("Block \"{}\" occupied by \"{}\", but block.getValue()= {}!", new Object[]{block.getDisplayName(), this._trainName, block.getValue()});
                }
            } else {
                this._lostRange.remove(block);
            }
            Warrant w = block.getWarrant();
            if (w != null) {
                String msg = Bundle.getMessage("AllocatedToWarrant", w.getDisplayName(), block.getDisplayName(), w.getTrainName());
                int idx = w.getCurrentOrderIndex();
                if (Math.abs(w.getIndexOfBlockAfter(block, 0) - idx) < 2) {
                    this._statusMessage = msg;
                    return true;
                }
            }
            if (this._headRange.contains(block)) {
                if (this._darkBlock != null) {
                    this.addtoOccupies(this._darkBlock, true);
                }
                this.addtoOccupies(block, true);
            } else if (this._tailRange.contains(block)) {
                if (this._darkBlock != null) {
                    this.addtoOccupies(this._darkBlock, false);
                }
                this.addtoOccupies(block, false);
            } else if (!this._occupies.contains(block)) {
                log.warn("Block \"{}\" is not within range of  \"{}\"!", (Object)block.getDisplayName(), (Object)this._trainName);
            }
            this.makeRange();
            return true;
        }
        if ((state & 4) != 0) {
            this.removeBlock(block);
            int size = this._occupies.size();
            if (size == 0) {
                this.recover(block);
            } else {
                this.makeRange();
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return this._trainName;
    }

    private void recover(OBlock block) {
        ArrayList<OBlock> list = new ArrayList<OBlock>();
        list.addAll(this._lostRange);
        list.addAll(this._headRange);
        list.addAll(this._tailRange);
        list.add(block);
        Toolkit.getDefaultToolkit().beep();
        new ChooseRecoverBlock(block, list, this, this._parent);
        this._statusMessage = Bundle.getMessage(TRACKER_NO_CURRENT_BLOCK, this._trainName, block.getDisplayName()) + "\n" + Bundle.getMessage("TrackingStopped");
    }

    private abstract class ChooseBlock
    extends JDialog
    implements ListSelectionListener {
        OBlock block;
        TrackerTableAction parent;
        List<OBlock> list;
        JList<OBlock> _jList;
        Tracker tracker;

        ChooseBlock(OBlock b, List<OBlock> l, Tracker t, TrackerTableAction tta) {
            super(tta._frame);
            this.setTitle(Bundle.getMessage("TrackerTitle"));
            this.block = b;
            this.list = l;
            this.tracker = t;
            this.parent = tta;
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            contentPanel.add(Box.createVerticalStrut(10));
            JPanel p = new JPanel();
            p.add(this.makeBlurb());
            contentPanel.add(p);
            p = new JPanel();
            p.add(this.makeListPanel());
            contentPanel.add(p);
            contentPanel.add(Box.createVerticalStrut(10));
            contentPanel.add(this.makeButtonPanel());
            this.setContentPane(contentPanel);
            this.pack();
            this.setLocation(this.parent._frame.getLocation());
            this.setAlwaysOnTop(true);
            this.setVisible(true);
        }

        abstract JPanel makeBlurb();

        abstract JPanel makeButtonPanel();

        abstract void doAction();

        protected JPanel makeListPanel() {
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            this._jList = new JList();
            this._jList.setModel(new BlockListModel(this.list));
            this._jList.setSelectionMode(0);
            this._jList.addListSelectionListener(this);
            this._jList.setCellRenderer(new BlockCellRenderer());
            panel.add(this._jList);
            return panel;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            OBlock b = this._jList.getSelectedValue();
            if (b != null) {
                b.setState(b.getState() & 0xFFFFFFDF);
                Tracker.this.addtoOccupies(b, false);
                b._entryTime = System.currentTimeMillis();
                this._jList.removeListSelectionListener(this);
                List<OBlock> blockList = Tracker.this.initialRange(this.parent);
                if (blockList.isEmpty()) {
                    this.doAction();
                    this.dispose();
                }
                this._jList.setModel(new BlockListModel(blockList));
                this._jList.addListSelectionListener(this);
            }
        }

        class BlockListModel
        extends AbstractListModel<OBlock> {
            List<OBlock> blockList;

            BlockListModel(List<OBlock> bl) {
                this.blockList = bl;
            }

            @Override
            public int getSize() {
                return this.blockList.size();
            }

            @Override
            public OBlock getElementAt(int index) {
                return this.blockList.get(index);
            }
        }

        class BlockCellRenderer
        extends JLabel
        implements ListCellRenderer<Object> {
            BlockCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String s = ((OBlock)value).getDisplayName();
                this.setText(s);
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setOpaque(true);
                return this;
            }
        }
    }

    private class ChooseRecoverBlock
    extends ChooseBlock {
        ChooseRecoverBlock(OBlock block, List<OBlock> list, Tracker t, TrackerTableAction tta) {
            super(block, list, t, tta);
            Tracker.this._occupies.clear();
            tta.removeBlockListeners(t);
        }

        @Override
        JPanel makeBlurb() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel(Bundle.getMessage(Tracker.TRACKER_NO_CURRENT_BLOCK, Tracker.this._trainName, this.block.getDisplayName())));
            panel.add(new JLabel(Bundle.getMessage("PossibleLocation", Tracker.this._trainName)));
            return panel;
        }

        @Override
        JPanel makeButtonPanel() {
            JPanel panel = new JPanel();
            JButton recoverButton = new JButton(Bundle.getMessage("ButtonRecover"));
            recoverButton.addActionListener(a -> {
                if (Tracker.this._occupies.isEmpty()) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("RecoverOrExit", Tracker.this._trainName, Bundle.getMessage("ButtonStop")), Bundle.getMessage("WarningTitle"), 1);
                } else {
                    this.doAction();
                }
            });
            panel.add(recoverButton);
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonStop"));
            cancelButton.addActionListener(a -> this.doStopAction());
            panel.add(cancelButton);
            return panel;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            OBlock blk = (OBlock)this._jList.getSelectedValue();
            if (blk != null) {
                String msg = null;
                if ((blk.getState() & 2) == 0) {
                    msg = Bundle.getMessage("blockUnoccupied", blk.getDisplayName());
                } else {
                    Tracker t = this.parent.findTrackerIn(blk);
                    if (t != null && !this.tracker.getTrainName().equals(blk.getValue())) {
                        msg = Bundle.getMessage("blockInUse", t.getTrainName(), blk.getDisplayName());
                    }
                }
                if (msg != null) {
                    JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
                    this._jList.removeListSelectionListener(this);
                    this.list.remove(blk);
                    if (this.list.isEmpty()) {
                        if (!Tracker.this._occupies.isEmpty()) {
                            this.doAction();
                            this.dispose();
                        } else {
                            this.doStopAction();
                        }
                    }
                    this._jList.setModel(new ChooseBlock.BlockListModel(this.list));
                    this._jList.addListSelectionListener(this);
                } else {
                    super.valueChanged(e);
                }
            }
        }

        @Override
        void doAction() {
            this.parent.addBlockListeners(this.tracker);
            this.parent.setStatus(Bundle.getMessage("restartTracker", this.tracker.getTrainName(), this.tracker.getHeadBlock().getDisplayName()));
            this.dispose();
        }

        void doStopAction() {
            this.parent.stopTracker(this.tracker, this.block);
            this.parent.setStatus(Bundle.getMessage(Tracker.TRACKER_NO_CURRENT_BLOCK, Tracker.this._trainName, this.block.getDisplayName()) + "\n" + Bundle.getMessage("TrackingStopped"));
            this.dispose();
        }

        @Override
        public void dispose() {
            this.parent.updateStatus();
            super.dispose();
        }
    }

    class ChooseStartBlock
    extends ChooseBlock {
        ChooseStartBlock(OBlock b, List<OBlock> l, Tracker t, TrackerTableAction tta) {
            super(b, l, t, tta);
        }

        @Override
        JPanel makeBlurb() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel(Bundle.getMessage("MultipleStartBlocks1", Tracker.this.getHeadBlock().getDisplayName(), Tracker.this._trainName)));
            panel.add(new JLabel(Bundle.getMessage("MultipleStartBlocks2")));
            panel.add(new JLabel(Bundle.getMessage("MultipleStartBlocks3", Tracker.this._trainName)));
            panel.add(new JLabel(Bundle.getMessage("MultipleStartBlocks4", Bundle.getMessage("ButtonStart"))));
            return panel;
        }

        @Override
        JPanel makeButtonPanel() {
            JPanel panel = new JPanel();
            JButton startButton = new JButton(Bundle.getMessage("ButtonStart"));
            startButton.addActionListener(a -> {
                Tracker.this._parent.addTracker(this.tracker);
                this.dispose();
            });
            panel.add(startButton);
            return panel;
        }

        @Override
        void doAction() {
            this.parent.addTracker(this.tracker);
        }
    }

    static enum PathSet {
        NOWAY,
        NOTSET,
        PARTIAL,
        SET;

    }
}

