/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jmri.Block;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.InvokeOnLayoutThread;
import jmri.LocoAddress;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.BlockSpeedInfo;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.Engineer;
import jmri.jmrit.logix.LearnThrottleFrame;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.SCWarrant;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Tracker;
import jmri.jmrit.logix.TrackerTableAction;
import jmri.jmrit.logix.TrainOrder;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Warrant
extends AbstractNamedBean
implements ThrottleListener,
PropertyChangeListener {
    public static final String Stop = InstanceManager.getDefault(SignalSpeedMap.class).getNamedSpeed(0.0f);
    public static final String EStop = Bundle.getMessage("EStop");
    public static final String Normal = "Normal";
    public static final String PROPERTY_WARRANT_START = "WarrantStart";
    public static final String PROPERTY_STOP_WARRANT = "StopWarrant";
    public static final String PROPERTY_THROTTLE_FAIL = "throttleFail";
    public static final String PROPERTY_ABORT_LEARN = "abortLearn";
    public static final String PROPERTY_CONTROL_CHANGE = "controlChange";
    public static final String PROPERTY_CONTROL_FAILED = "controlFailed";
    public static final String PROPERTY_READY_TO_RUN = "ReadyToRun";
    public static final String PROPERTY_CANNOT_RUN = "cannotRun";
    public static final String PROPERTY_BLOCK_CHANGE = "blockChange";
    public static final String PROPERTY_SIGNAL_OVERRUN = "SignalOverrun";
    public static final String PROPERTY_WARRANT_OVERRUN = "WarrantOverrun";
    public static final String PROPERTY_OCCUPY_OVERRUN = "OccupyOverrun";
    private List<BlockOrder> _orders;
    private BlockOrder _viaOrder;
    private BlockOrder _avoidOrder;
    private List<ThrottleSetting> _commands = new ArrayList<ThrottleSetting>();
    protected String _trainName;
    private SpeedUtil _speedUtil;
    private boolean _runBlind = false;
    private boolean _shareRoute;
    private boolean _addTracker;
    private boolean _haltStart;
    private boolean _noRamp;
    private boolean _nxWarrant = false;
    private LearnThrottleFrame _student;
    private boolean _tempRunBlind;
    private boolean _delayStart;
    private boolean _lost;
    private boolean _overrun;
    private boolean _rampBlkOccupied;
    private int _idxCurrentOrder = -1;
    protected int _runMode = 0;
    private Engineer _engineer;
    @GuardedBy(value="this")
    private CommandDelay _delayCommand;
    private boolean _allocated;
    private boolean _totalAllocated;
    private boolean _routeSet;
    protected OBlock _stoppingBlock;
    private int _idxStoppingBlock;
    private NamedBean _protectSignal;
    private int _idxProtectSignal = -1;
    private boolean _waitForSignal;
    private boolean _waitForBlock;
    private boolean _waitForWarrant;
    private String _curSignalAspect;
    protected String _message;
    private final ThrottleManager tm;
    public static final int MODE_NONE = 0;
    public static final int MODE_LEARN = 1;
    public static final int MODE_RUN = 2;
    public static final int MODE_MANUAL = 3;
    static final String[] MODES = new String[]{"none", "LearnMode", "RunAuto", "RunManual", "Abort"};
    public static final int MODE_ABORT = 4;
    public static final int STOP = 0;
    public static final int HALT = 1;
    public static final int RESUME = 2;
    public static final int ABORT = 3;
    public static final int RETRY_FWD = 4;
    public static final int ESTOP = 5;
    protected static final int RAMP_HALT = 6;
    public static final int SPEED_UP = 7;
    public static final int RETRY_BKWD = 8;
    public static final int DEBUG = 9;
    static final String[] CNTRL_CMDS = new String[]{"Stop", "Halt", "Resume", "Abort", "MoveToNext", "EStop", "ramp", "SpeedUp", "MoveToPrevious", "Debug"};
    protected static final int RUNNING = 7;
    protected static final int SPEED_RESTRICTED = 8;
    protected static final int WAIT_FOR_CLEAR = 9;
    protected static final int WAIT_FOR_SENSOR = 10;
    protected static final int WAIT_FOR_TRAIN = 11;
    protected static final int WAIT_FOR_DELAYED_START = 12;
    protected static final int LEARNING = 13;
    protected static final int STOP_PENDING = 14;
    static final String[] RUN_STATE = new String[]{"HaltStart", "atHalt", "Resumed", "Aborts", "Retried", "EStop", "HaltPending", "Running", "changeSpeed", "WaitingForClear", "WaitingForSensor", "RunningLate", "WaitingForStart", "RecordingScript", "StopPending"};
    static final float BUFFER_DISTANCE = 15240.0f / WarrantPreferences.getDefault().getLayoutScale();
    protected static boolean _trace = WarrantPreferences.getDefault().getTrace();
    static final int AT_SPEED = 1;
    static final int RAMP_DOWN = 2;
    static final int RAMP_UP = 3;
    private static final Logger log = LoggerFactory.getLogger(Warrant.class);

    public Warrant(String sName, String uName) {
        super(sName, uName);
        this._orders = new ArrayList<BlockOrder>();
        this._speedUtil = new SpeedUtil();
        this.tm = InstanceManager.getNullableDefault(ThrottleManager.class);
    }

    protected void setNXWarrant(boolean set) {
        this._nxWarrant = set;
    }

    protected boolean isNXWarrant() {
        return this._nxWarrant;
    }

    @Override
    public int getState() {
        if (this._engineer != null) {
            return this._engineer.getRunState();
        }
        if (this._delayStart) {
            return 12;
        }
        if (this._runMode == 1) {
            return 13;
        }
        if (this._runMode != 0) {
            return 7;
        }
        return -1;
    }

    @Override
    public void setState(int state) {
    }

    public SpeedUtil getSpeedUtil() {
        return this._speedUtil;
    }

    public void setSpeedUtil(SpeedUtil su) {
        this._speedUtil = su;
    }

    public List<BlockOrder> getBlockOrders() {
        return this._orders;
    }

    public void addBlockOrder(BlockOrder order) {
        this._orders.add(order);
    }

    public void setBlockOrders(List<BlockOrder> orders) {
        this._orders = orders;
    }

    public BlockOrder getfirstOrder() {
        if (this._orders.isEmpty()) {
            return null;
        }
        return new BlockOrder(this._orders.get(0));
    }

    public BlockOrder getLastOrder() {
        int size = this._orders.size();
        if (size < 2) {
            return null;
        }
        return new BlockOrder(this._orders.get(size - 1));
    }

    public BlockOrder getViaOrder() {
        if (this._viaOrder == null) {
            return null;
        }
        return new BlockOrder(this._viaOrder);
    }

    public void setViaOrder(BlockOrder order) {
        this._viaOrder = order;
    }

    public BlockOrder getAvoidOrder() {
        if (this._avoidOrder == null) {
            return null;
        }
        return new BlockOrder(this._avoidOrder);
    }

    public void setAvoidOrder(BlockOrder order) {
        this._avoidOrder = order;
    }

    public final BlockOrder getCurrentBlockOrder() {
        return this.getBlockOrderAt(this._idxCurrentOrder);
    }

    public final int getCurrentOrderIndex() {
        return this._idxCurrentOrder;
    }

    protected int getNumOrders() {
        return this._orders.size();
    }

    protected void incrementCurrentOrderIndex() {
        ++this._idxCurrentOrder;
    }

    protected int getIndexOfBlockAfter(OBlock block, int idx) {
        for (int i = idx; i < this._orders.size(); ++i) {
            if (!this._orders.get(i).getBlock().equals(block)) continue;
            return i;
        }
        return -1;
    }

    protected int getIndexOfBlockBefore(int idx, OBlock block) {
        for (int i = idx; i >= 0; --i) {
            if (!this._orders.get(i).getBlock().equals(block)) continue;
            return i;
        }
        return -1;
    }

    protected BlockOrder getBlockOrderAt(int index) {
        if (index >= 0 && index < this._orders.size()) {
            return this._orders.get(index);
        }
        return null;
    }

    protected OBlock getBlockAt(int idx) {
        BlockOrder bo = this.getBlockOrderAt(idx);
        if (bo != null) {
            return bo.getBlock();
        }
        return null;
    }

    public String getCurrentBlockName() {
        OBlock block = this.getBlockAt(this._idxCurrentOrder);
        if (block == null || !block.isOccupied()) {
            return Bundle.getMessage("Unknown");
        }
        return block.getDisplayName();
    }

    public List<ThrottleSetting> getThrottleCommands() {
        return this._commands;
    }

    public void setThrottleCommands(List<ThrottleSetting> list) {
        this._commands = list;
    }

    public void addThrottleCommand(ThrottleSetting ts) {
        if (ts == null) {
            log.error("warrant {} cannot add null ThrottleSetting", (Object)this.getDisplayName());
        } else {
            this._commands.add(ts);
        }
    }

    public void setTrackSpeeds() {
        float speed = 0.0f;
        for (ThrottleSetting ts : this._commands) {
            ThrottleSetting.CommandValue cmdVal = ts.getValue();
            ThrottleSetting.ValueType valType = cmdVal.getType();
            switch (valType) {
                case VAL_FLOAT: {
                    speed = this._speedUtil.getTrackSpeed(cmdVal.getFloat());
                    break;
                }
                case VAL_TRUE: {
                    this._speedUtil.setIsForward(true);
                    break;
                }
                case VAL_FALSE: {
                    this._speedUtil.setIsForward(false);
                    break;
                }
            }
            ts.setTrackSpeed(speed);
        }
    }

    public void setNoRamp(boolean set) {
        this._noRamp = set;
    }

    public void setShareRoute(boolean set) {
        this._shareRoute = set;
    }

    public void setAddTracker(boolean set) {
        this._addTracker = set;
    }

    public void setHaltStart(boolean set) {
        this._haltStart = set;
    }

    public boolean getNoRamp() {
        return this._noRamp;
    }

    public boolean getShareRoute() {
        return this._shareRoute;
    }

    public boolean getAddTracker() {
        return this._addTracker;
    }

    public boolean getHaltStart() {
        return this._haltStart;
    }

    public String getTrainName() {
        return this._trainName;
    }

    public void setTrainName(String name) {
        if (this._runMode == 0) {
            this._trainName = name;
        }
    }

    public boolean getRunBlind() {
        return this._runBlind;
    }

    public void setRunBlind(boolean runBlind) {
        this._runBlind = runBlind;
    }

    protected void fireRunStatus(String property, Object old, Object status) {
        ThreadingUtil.runOnGUIEventually(() -> this.firePropertyChange(property, old, status));
    }

    public boolean isAllocated() {
        return this._allocated;
    }

    public boolean isTotalAllocated() {
        return this._totalAllocated;
    }

    public boolean hasRouteSet() {
        return this._routeSet;
    }

    public boolean routeIsFree() {
        for (int i = 0; i < this._orders.size(); ++i) {
            OBlock block = this._orders.get(i).getBlock();
            if (block.isFree()) continue;
            return false;
        }
        return true;
    }

    public boolean routeIsOccupied() {
        for (int i = 1; i < this._orders.size(); ++i) {
            OBlock block = this._orders.get(i).getBlock();
            if ((block.getState() & 2) == 0) continue;
            return true;
        }
        return false;
    }

    public String getMessage() {
        return this._message;
    }

    protected boolean isWaitingForSignal() {
        return this._waitForSignal;
    }

    protected boolean isWaitingForBlock() {
        return this._waitForBlock;
    }

    protected boolean isWaitingForWarrant() {
        return this._waitForWarrant;
    }

    protected Warrant getBlockingWarrant() {
        if (this._stoppingBlock != null && !this.equals(this._stoppingBlock.getWarrant())) {
            return this._stoppingBlock.getWarrant();
        }
        return null;
    }

    public int getRunMode() {
        return this._runMode;
    }

    protected String getRunModeMessage() {
        String modeDesc = null;
        switch (this._runMode) {
            case 0: {
                return Bundle.getMessage("NotRunning", this.getDisplayName());
            }
            case 1: {
                modeDesc = Bundle.getMessage("Recording");
                break;
            }
            case 2: {
                modeDesc = Bundle.getMessage("AutoRun");
                break;
            }
            case 3: {
                modeDesc = Bundle.getMessage("ManualRun");
                break;
            }
        }
        return Bundle.getMessage("WarrantInUse", modeDesc, this.getDisplayName());
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    protected synchronized String getRunningMessage() {
        if (this._delayStart) {
            return Bundle.getMessage("waitForDelayStart", this._trainName, this.getBlockAt(0).getDisplayName());
        }
        switch (this._runMode) {
            case 0: {
                this._message = null;
            }
            case 4: {
                if (this.getBlockOrders().isEmpty()) {
                    return Bundle.getMessage("BlankWarrant");
                }
                if (this._speedUtil.getAddress() == null) {
                    return Bundle.getMessage("NoLoco");
                }
                if (!(this instanceof SCWarrant) && this._commands.size() <= this._orders.size()) {
                    return Bundle.getMessage("NoCommands", this.getDisplayName());
                }
                if (this._message != null) {
                    if (this._lost) {
                        return Bundle.getMessage("locationUnknown", this._trainName, this.getCurrentBlockName()) + this._message;
                    }
                    return Bundle.getMessage("Idle", this._message);
                }
                return Bundle.getMessage("Idle");
            }
            case 1: {
                return Bundle.getMessage("Learning", this.getCurrentBlockName());
            }
            case 2: {
                if (this._engineer == null) {
                    return Bundle.getMessage("engineerGone", this.getCurrentBlockName());
                }
                String speedMsg = this.getSpeedMessage(this._engineer.getSpeedType(true));
                int runState = this._engineer.getRunState();
                int cmdIdx = this._engineer.getCurrentCommandIndex();
                if (cmdIdx >= this._commands.size()) {
                    cmdIdx = this._commands.size() - 1;
                }
                ++cmdIdx;
                OBlock block = this.getBlockAt(this._idxCurrentOrder);
                if ((block.getState() & 0x102) == 0) {
                    return Bundle.getMessage("TrackerNoCurrentBlock", this._trainName, block.getDisplayName());
                }
                String blockName = block.getDisplayName();
                switch (runState) {
                    case 3: {
                        if (cmdIdx == this._commands.size() - 1) {
                            return Bundle.getMessage("endOfScript", this._trainName);
                        }
                        return Bundle.getMessage("Aborted", blockName, cmdIdx);
                    }
                    case 1: {
                        return Bundle.getMessage("RampHalt", this.getTrainName(), blockName);
                    }
                    case 9: {
                        SpeedState ss = this._engineer.getSpeedState();
                        if (ss.equals((Object)SpeedState.STEADY_SPEED)) {
                            return this.makeWaitMessage(blockName, cmdIdx);
                        }
                        return Bundle.getMessage("Ramping", ss.toString(), speedMsg, blockName);
                    }
                    case 11: {
                        if (this._engineer.getSpeedSetting() <= 0.0f) {
                            return this.makeWaitMessage(blockName, cmdIdx);
                        }
                        return Bundle.getMessage("WaitForTrain", cmdIdx, this._engineer.getSynchBlock().getDisplayName(), speedMsg);
                    }
                    case 10: {
                        return Bundle.getMessage("WaitForSensor", cmdIdx, this._engineer.getWaitSensor().getDisplayName(), blockName, speedMsg);
                    }
                    case 7: {
                        return Bundle.getMessage("WhereRunning", blockName, cmdIdx, speedMsg);
                    }
                    case 8: {
                        return Bundle.getMessage("changeSpeed", blockName, cmdIdx, speedMsg);
                    }
                    case 6: {
                        return Bundle.getMessage("HaltPending", speedMsg, blockName);
                    }
                    case 14: {
                        return Bundle.getMessage("StopPending", speedMsg, blockName, this._waitForSignal ? Bundle.getMessage("Signal") : (this._waitForWarrant ? Bundle.getMessage("Warrant") : Bundle.getMessage("Occupancy")));
                    }
                }
                return this._message;
            }
            case 3: {
                BlockOrder bo = this.getCurrentBlockOrder();
                if (bo != null) {
                    return Bundle.getMessage("ManualRunning", bo.getBlock().getDisplayName());
                }
                return Bundle.getMessage("ManualRun");
            }
        }
        return "ERROR mode= " + MODES[this._runMode];
    }

    private String getSpeedMessage(String speedType) {
        String units;
        float speed = 0.0f;
        SignalSpeedMap speedMap = InstanceManager.getDefault(SignalSpeedMap.class);
        switch (speedMap.getInterpretation()) {
            case 1: {
                speed = this._engineer.getSpeedSetting() * 100.0f;
                float scriptSpeed = this._engineer.getScriptSpeed();
                scriptSpeed = scriptSpeed > 0.0f ? speed / scriptSpeed : 0.0f;
                units = Bundle.getMessage("percentNormalScript", Math.round(scriptSpeed));
                break;
            }
            case 2: {
                units = Bundle.getMessage("percentThrottle");
                speed = this._engineer.getSpeedSetting() * 100.0f;
                break;
            }
            case 3: {
                units = Bundle.getMessage("mph");
                speed = this._speedUtil.getTrackSpeed(this._engineer.getSpeedSetting()) * speedMap.getLayoutScale();
                speed *= 2.2369363f;
                break;
            }
            case 4: {
                units = Bundle.getMessage("kph");
                speed = this._speedUtil.getTrackSpeed(this._engineer.getSpeedSetting()) * speedMap.getLayoutScale();
                speed *= 3.6f;
                break;
            }
            default: {
                log.error("{} Unknown speed interpretation {}", (Object)this.getDisplayName(), (Object)speedMap.getInterpretation());
                throw new IllegalArgumentException("Unknown speed interpretation " + speedMap.getInterpretation());
            }
        }
        return Bundle.getMessage("atSpeed", speedType, Math.round(speed), units);
    }

    private String makeWaitMessage(String blockName, int cmdIdx) {
        String which = null;
        String where = null;
        if (this._waitForSignal) {
            which = Bundle.getMessage("Signal");
            OBlock protectedBlock = this.getBlockAt(this._idxProtectSignal);
            if (protectedBlock != null) {
                where = protectedBlock.getDisplayName();
            }
        } else if (this._waitForWarrant) {
            Warrant w = this.getBlockingWarrant();
            which = Bundle.getMessage("WarrantWait", w == null ? "Unknown" : w.getDisplayName());
            if (this._stoppingBlock != null) {
                where = this._stoppingBlock.getDisplayName();
            }
        } else if (this._waitForBlock) {
            which = Bundle.getMessage("Occupancy");
            if (this._stoppingBlock != null) {
                where = this._stoppingBlock.getDisplayName();
            }
        }
        int runState = this._engineer.getRunState();
        if (which == null && (runState == 1 || runState == 6)) {
            which = Bundle.getMessage("Halt");
            where = blockName;
        }
        if (this._engineer.isRamping() && runState != 6) {
            String speedMsg = this.getSpeedMessage(this._engineer.getSpeedType(true));
            return Bundle.getMessage("changeSpeed", blockName, cmdIdx, speedMsg);
        }
        if (where == null) {
            if (this._message == null) {
                this._message = Bundle.getMessage(RUN_STATE[runState], blockName);
            }
            return Bundle.getMessage("trainWaiting", this.getTrainName(), this._message, blockName);
        }
        return Bundle.getMessage("WaitForClear", blockName, which, where);
    }

    @InvokeOnLayoutThread
    private void startTracker() {
        ThreadingUtil.runOnGUIEventually(() -> new Tracker(this.getCurrentBlockOrder().getBlock(), this._trainName, null, InstanceManager.getDefault(TrackerTableAction.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killEngineer(Engineer engineer, boolean abort, boolean functionFlag) {
        engineer.stopRun(abort, functionFlag);
        engineer.interrupt();
        if (!engineer.getState().equals((Object)Thread.State.TERMINATED)) {
            Thread curThread = Thread.currentThread();
            if (!curThread.equals(this._engineer)) {
                this.kill(engineer, abort, functionFlag, curThread);
            } else {
                Killer killer;
                class Killer
                implements Runnable {
                    Engineer victim;
                    boolean abortFlag;
                    boolean functionFlag;

                    Killer(Engineer v, boolean a, boolean f) {
                        this.victim = v;
                        this.abortFlag = a;
                        this.functionFlag = f;
                    }

                    @Override
                    public void run() {
                        Warrant.this.kill(this.victim, this.abortFlag, this.functionFlag, this.victim);
                    }
                }
                Killer killer2 = killer = new Killer(engineer, abort, functionFlag);
                synchronized (killer2) {
                    Thread hit = ThreadingUtil.newThread(killer, this.getDisplayName() + " Killer");
                    hit.start();
                }
            }
        }
    }

    private void kill(Engineer eng, boolean a, boolean f, Thread monitor) {
        long time;
        for (time = 0L; !eng.getState().equals((Object)Thread.State.TERMINATED) && time < 100L; time += 10L) {
            try {
                eng.stopRun(a, f);
                monitor.join(10L);
                continue;
            }
            catch (InterruptedException ex) {
                log.info("victim.join() interrupted. warrant {}", (Object)this.getDisplayName());
            }
        }
        this._engineer = null;
        log.debug("{}: engineer state {} after {}ms", new Object[]{this.getDisplayName(), eng.getState().toString(), time});
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    public void stopWarrant(boolean abort, boolean turnOffFunctions) {
        String bundleKey;
        String blockName;
        this._delayStart = false;
        this.clearWaitFlags(true);
        if (this._student != null) {
            this._student.dispose();
            this._student = null;
        }
        this._curSignalAspect = null;
        this.cancelDelayRamp();
        if (this._engineer != null) {
            if (!this._engineer.getState().equals((Object)Thread.State.TERMINATED)) {
                this.killEngineer(this._engineer, abort, turnOffFunctions);
            }
            if (_trace || log.isDebugEnabled()) {
                if (abort) {
                    log.info("{} at block {}", (Object)Bundle.getMessage("warrantAbort", this.getTrainName(), this.getDisplayName()), (Object)this.getBlockAt(this._idxCurrentOrder).getDisplayName());
                } else {
                    log.info(Bundle.getMessage("warrantComplete", this.getTrainName(), this.getDisplayName(), this.getBlockAt(this._idxCurrentOrder).getDisplayName()));
                }
            }
        } else {
            this._runMode = 0;
        }
        if (this._addTracker && this._idxCurrentOrder == this._orders.size() - 1) {
            this.startTracker();
        }
        this._addTracker = false;
        ThreadingUtil.runOnGUI(this::deAllocate);
        if (abort) {
            blockName = null;
            bundleKey = this._idxCurrentOrder <= 0 ? "warrantAnnull" : "warrantAbort";
        } else {
            blockName = this.getCurrentBlockName();
            bundleKey = this._idxCurrentOrder == this._orders.size() - 1 ? "warrantComplete" : "warrantEnd";
        }
        this.fireRunStatus(PROPERTY_STOP_WARRANT, blockName, bundleKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setRunMode(int mode, DccLocoAddress address, LearnThrottleFrame student, List<ThrottleSetting> commands, boolean runBlind) {
        if (log.isDebugEnabled()) {
            log.debug("{}: setRunMode({}) ({}) called with _runMode= {}.", new Object[]{this.getDisplayName(), mode, MODES[mode], MODES[this._runMode]});
        }
        this._message = null;
        if (this._runMode != 0) {
            this._message = this.getRunModeMessage();
            log.error("{} called setRunMode when mode= {}. {}", new Object[]{this.getDisplayName(), MODES[this._runMode], this._message});
            return this._message;
        }
        this._delayStart = false;
        this._lost = false;
        this._overrun = false;
        this.clearWaitFlags(true);
        if (address != null) {
            this._speedUtil.setDccAddress(address);
        }
        this._message = this.setPathAt(0);
        if (this._message != null) {
            return this._message;
        }
        if (mode == 1) {
            if (student == null) {
                this._message = Bundle.getMessage("noLearnThrottle", this.getDisplayName());
                log.error("{} called setRunMode for mode= {}. {}", new Object[]{this.getDisplayName(), MODES[mode], this._message});
                return this._message;
            }
            Warrant warrant = this;
            synchronized (warrant) {
                this._student = student;
            }
            this._runMode = mode;
        } else if (mode == 2) {
            if (commands != null && commands.size() > 1) {
                this._commands = commands;
            }
            this._idxCurrentOrder = 0;
            this._runMode = mode;
            OBlock b = this.getBlockAt(0);
            if (b.isDark()) {
                this._haltStart = true;
            } else if (!b.isOccupied()) {
                this._idxCurrentOrder = -1;
                this.setStoppingBlock(0);
                this._delayStart = true;
            }
        } else if (mode == 3) {
            if (commands != null) {
                this._commands = commands;
            }
        } else {
            this.deAllocate();
            return this._message;
        }
        this.getBlockAt((int)0)._entryTime = System.currentTimeMillis();
        this._tempRunBlind = runBlind;
        if (!this._delayStart) {
            if (mode != 3) {
                this._message = this.acquireThrottle();
            } else {
                this.startupWarrant();
            }
        }
        return this._message;
    }

    @CheckForNull
    protected String acquireThrottle() {
        String msg = null;
        DccLocoAddress dccAddress = this._speedUtil.getDccAddress();
        if (log.isDebugEnabled()) {
            log.debug("{}: acquireThrottle request at {}", (Object)this.getDisplayName(), (Object)dccAddress);
        }
        if (dccAddress == null) {
            msg = Bundle.getMessage("NoAddress", this.getDisplayName());
        } else if (this.tm == null) {
            msg = Bundle.getMessage("noThrottle", this._speedUtil.getDccAddress().getNumber());
        } else if (!this.tm.requestThrottle(dccAddress, (ThrottleListener)this, false)) {
            msg = Bundle.getMessage("trainInUse", dccAddress.getNumber());
        }
        if (msg != null) {
            this.fireRunStatus(PROPERTY_THROTTLE_FAIL, null, msg);
            this.abortWarrant(msg);
            return msg;
        }
        return null;
    }

    @Override
    public void notifyThrottleFound(DccThrottle throttle) {
        if (throttle == null) {
            this._message = Bundle.getMessage("noThrottle", this.getDisplayName());
            this.fireRunStatus(PROPERTY_THROTTLE_FAIL, null, this._message);
            this.abortWarrant(this._message);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: notifyThrottleFound for address= {}, class= {},", new Object[]{this.getDisplayName(), throttle.getLocoAddress(), throttle.getClass().getName()});
        }
        this._speedUtil.setThrottle(throttle);
        this.startupWarrant();
        this.runWarrant(throttle);
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        this._message = Bundle.getMessage("noThrottle", reason + " " + (Serializable)(address != null ? Integer.valueOf(address.getNumber()) : this.getDisplayName()));
        this.fireRunStatus(PROPERTY_THROTTLE_FAIL, null, reason);
        this.abortWarrant(this._message);
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    protected void releaseThrottle(DccThrottle throttle) {
        if (throttle != null) {
            if (this.tm != null) {
                this.tm.releaseThrottle(throttle, this);
            } else {
                log.error("{} releaseThrottle. {} on thread {}", new Object[]{this.getDisplayName(), Bundle.getMessage("noThrottle", throttle.getLocoAddress()), Thread.currentThread().getName()});
            }
            this._runMode = 0;
        }
    }

    protected void abortWarrant(String msg) {
        log.error("Abort warrant \"{}\" - {} ", (Object)this.getDisplayName(), (Object)msg);
        this.stopWarrant(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    public boolean controlRunTrain(int idx) {
        if (idx < 0) {
            return false;
        }
        boolean ret = false;
        if (this._engineer == null) {
            if (log.isDebugEnabled()) {
                log.debug("{}: controlRunTrain({})= \"{}\" for train {} runMode= {}", new Object[]{this.getDisplayName(), idx, CNTRL_CMDS[idx], this.getTrainName(), MODES[this._runMode]});
            }
            switch (idx) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 0: 
                case 3: {
                    if (this._runMode == 1) {
                        this.fireRunStatus(PROPERTY_ABORT_LEARN, -1, this._idxCurrentOrder);
                        break;
                    }
                    this.stopWarrant(true, true);
                    break;
                }
                case 9: {
                    this.debugInfo();
                    break;
                }
            }
            return true;
        }
        int runState = this._engineer.getRunState();
        if (_trace || log.isDebugEnabled()) {
            log.info(Bundle.getMessage(PROPERTY_CONTROL_CHANGE, this.getTrainName(), Bundle.getMessage(CNTRL_CMDS[idx]), this.getCurrentBlockName()));
        }
        Warrant warrant = this;
        synchronized (warrant) {
            switch (idx) {
                case 1: {
                    this.rampSpeedTo(Stop, -1);
                    this._engineer.setHalt(true);
                    ret = true;
                    break;
                }
                case 2: {
                    BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder);
                    OBlock block = bo.getBlock();
                    String msg = null;
                    if (this.checkBlockForRunning(this._idxCurrentOrder)) {
                        if (this._waitForSignal || this._waitForBlock || this._waitForWarrant) {
                            msg = this.makeWaitMessage(block.getDisplayName(), this._idxCurrentOrder);
                        } else {
                            String train;
                            if (runState == 9) {
                                TrainOrder to = bo.allocatePaths(this, true);
                                if (to._cause == null) {
                                    this._engineer.setWaitforClear(false);
                                } else {
                                    msg = to._message;
                                }
                            }
                            if ((train = (String)block.getValue()) == null) {
                                train = Bundle.getMessage("unknownTrain");
                            }
                            if (block.isOccupied() && !this._trainName.equals(train)) {
                                msg = Bundle.getMessage("blockInUse", train, block.getDisplayName());
                            }
                        }
                    }
                    if (msg != null) {
                        ret = this.askResumeQuestion(block, msg);
                        if (ret) {
                            ret = this.reStartTrain();
                        }
                    } else {
                        ret = this.reStartTrain();
                    }
                    if (ret || !this._message.equals(Bundle.getMessage("blockUnoccupied", block.getDisplayName())) || !(ret = this.askResumeQuestion(block, this._message))) break;
                    ret = this.reStartTrain();
                    break;
                }
                case 7: {
                    if (!this.checkBlockForRunning(this._idxCurrentOrder)) break;
                    if (this._waitForSignal || this._waitForBlock || this._waitForWarrant || runState != 7 && runState != 8) {
                        String msg;
                        OBlock block = this.getBlockAt(this._idxCurrentOrder);
                        ret = this.askResumeQuestion(block, msg = this.makeWaitMessage(block.getDisplayName(), this._idxCurrentOrder));
                        if (!ret) break;
                        ret = this.bumpSpeed();
                        break;
                    }
                    ret = this.bumpSpeed();
                    break;
                }
                case 4: {
                    if (!this.checkBlockForRunning(this._idxCurrentOrder + 1)) break;
                    BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder + 1);
                    OBlock block = bo.getBlock();
                    if (this._waitForSignal || this._waitForBlock || this._waitForWarrant || runState != 7 && runState != 8) {
                        String msg = this.makeWaitMessage(block.getDisplayName(), this._idxCurrentOrder);
                        ret = this.askResumeQuestion(block, msg);
                        if (!ret) break;
                        ret = this.moveToBlock(bo, this._idxCurrentOrder + 1);
                        break;
                    }
                    ret = this.moveToBlock(bo, this._idxCurrentOrder + 1);
                    break;
                }
                case 8: {
                    if (!this.checkBlockForRunning(this._idxCurrentOrder - 1)) break;
                    BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder - 1);
                    OBlock block = bo.getBlock();
                    if (this._waitForSignal || this._waitForBlock || this._waitForWarrant || runState != 7 && runState != 8) {
                        String msg = this.makeWaitMessage(block.getDisplayName(), this._idxCurrentOrder);
                        ret = this.askResumeQuestion(block, msg);
                        if (!ret) break;
                        ret = this.moveToBlock(bo, this._idxCurrentOrder - 1);
                        break;
                    }
                    ret = this.moveToBlock(bo, this._idxCurrentOrder - 1);
                    break;
                }
                case 3: {
                    this.stopWarrant(true, true);
                    ret = true;
                    break;
                }
                case 0: {
                    this.setSpeedToType(Stop);
                    this._engineer.setHalt(true);
                    ret = true;
                    break;
                }
                case 5: {
                    this.setSpeedToType(EStop);
                    this._engineer.setHalt(true);
                    ret = true;
                    break;
                }
                case 9: {
                    ret = this.debugInfo();
                    break;
                }
            }
        }
        if (ret) {
            this.fireRunStatus(PROPERTY_CONTROL_CHANGE, runState, idx);
        } else {
            if (_trace || log.isDebugEnabled()) {
                log.info(Bundle.getMessage(PROPERTY_CONTROL_FAILED, this.getTrainName(), this._message, Bundle.getMessage(CNTRL_CMDS[idx])));
            }
            this.fireRunStatus(PROPERTY_CONTROL_FAILED, this._message, idx);
        }
        return ret;
    }

    private boolean askResumeQuestion(OBlock block, String reason) {
        String msg = Bundle.getMessage("ResumeQuestion", reason);
        return ThreadingUtil.runOnGUIwithReturn(() -> {
            int result = JmriJOptionPane.showConfirmDialog(WarrantTableFrame.getDefault(), msg, Bundle.getMessage("ResumeTitle"), 0, 3);
            return result == 0;
        });
    }

    private boolean reStartTrain() {
        BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder);
        OBlock block = bo.getBlock();
        if (!block.isOccupied() && !block.isDark()) {
            this._message = Bundle.getMessage("blockUnoccupied", block.getDisplayName());
            return false;
        }
        block.setValue(this._trainName);
        block.setState(block.getState());
        this._engineer.setHalt(false);
        this.clearWaitFlags(false);
        this._overrun = true;
        return this.restoreRunning(this._engineer.getSpeedType(false));
    }

    private boolean checkBlockForRunning(int idxBlockOrder) {
        BlockOrder bo = this.getBlockOrderAt(idxBlockOrder);
        if (bo == null) {
            this._message = Bundle.getMessage("BlockNotInRoute", "?");
            return false;
        }
        OBlock block = bo.getBlock();
        if (!block.isOccupied()) {
            this._message = Bundle.getMessage("blockUnoccupied", block.getDisplayName());
            return false;
        }
        return true;
    }

    private boolean bumpSpeed() {
        this._engineer.setHalt(false);
        this.clearWaitFlags(false);
        float speedSetting = this._engineer.getSpeedSetting();
        if (speedSetting < 0.0f) {
            speedSetting = 0.0f;
        }
        float bumpSpeed = Math.max(WarrantPreferences.getDefault().getSpeedAssistance(), this._speedUtil.getRampThrottleIncrement());
        this._engineer.setSpeed(speedSetting + bumpSpeed);
        return true;
    }

    private boolean moveToBlock(BlockOrder bo, int idx) {
        this._idxCurrentOrder = idx;
        this._message = this.setPathAt(idx);
        if (this._message != null) {
            return false;
        }
        OBlock block = bo.getBlock();
        if (block.equals(this._stoppingBlock)) {
            this.clearStoppingBlock();
            this._engineer.setHalt(false);
        }
        this.goingActive(block);
        return true;
    }

    protected boolean debugInfo() {
        if (!log.isInfoEnabled()) {
            return true;
        }
        StringBuilder info = new StringBuilder("\"");
        info.append(this.getDisplayName());
        info.append("\" Train \"");
        info.append(this.getTrainName());
        info.append("\" - Current Block \"");
        info.append(this.getBlockAt(this._idxCurrentOrder).getDisplayName());
        info.append("\" BlockOrder idx= ");
        info.append(this._idxCurrentOrder);
        info.append("\n\tWait flags: _waitForSignal= ");
        info.append(this._waitForSignal);
        info.append(", _waitForBlock= ");
        info.append(this._waitForBlock);
        info.append(", _waitForWarrant= ");
        info.append(this._waitForWarrant);
        info.append("\n\tStatus flags: _overrun= ");
        info.append(this._overrun);
        info.append(", _rampBlkOccupied= ");
        info.append(this._rampBlkOccupied);
        info.append(", _lost= ");
        info.append(this._lost);
        if (this._protectSignal != null) {
            info.append("\n\tWait for Signal \"");
            info.append(this._protectSignal.getDisplayName());
            info.append("\" protects block ");
            info.append(this.getBlockAt(this._idxProtectSignal).getDisplayName());
            info.append("\" from approch block \"");
            info.append(this.getBlockAt(this._idxProtectSignal - 1).getDisplayName());
            info.append("\". Shows aspect \"");
            info.append(this.getSignalSpeedType(this._protectSignal));
            info.append("\".");
        } else {
            info.append("\n\tNo signals ahead with speed restrictions");
        }
        if (this._stoppingBlock != null) {
            if (this._waitForWarrant) {
                info.append("\n\tWait for Warrant \"");
                Warrant w = this.getBlockingWarrant();
                info.append(w != null ? w.getDisplayName() : "Unknown");
                info.append("\" owns block \"");
                info.append(this._stoppingBlock.getDisplayName());
                info.append("\"");
            } else {
                Object what = this._stoppingBlock.getValue();
                String who = what != null ? what.toString() : "Unknown Train";
                info.append("\n\tWait for \"");
                info.append(who);
                info.append("\" occupying Block \"");
                info.append(this._stoppingBlock.getDisplayName());
                info.append("\"");
            }
        } else {
            info.append("\n\tNo occupied blocks ahead");
        }
        if (this._message != null) {
            info.append("\n\tLast message = ");
            info.append(this._message);
        } else {
            info.append("\n\tNo messages.");
        }
        if (this._engineer != null) {
            info.append("\"");
            info.append("\n\tEngineer Stack trace:");
            for (StackTraceElement elem : this._engineer.getStackTrace()) {
                info.append("\n\t\t");
                info.append(elem.getClassName());
                info.append(".");
                info.append(elem.getMethodName());
                info.append(", line ");
                info.append(elem.getLineNumber());
            }
            info.append(this._engineer.debugInfo());
        } else {
            info.append("No engineer.");
        }
        log.info("\n Warrant: {}", (Object)info.toString());
        return true;
    }

    protected void startupWarrant() {
        this._idxCurrentOrder = 0;
        BlockOrder bo = this.getBlockOrderAt(0);
        OBlock b = bo.getBlock();
        b.setValue(this._trainName);
        b.setState(b.getState() | 0x20);
        this.firePropertyChange(PROPERTY_WARRANT_START, 0, this._runMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWarrant(DccThrottle throttle) {
        if (this._runMode == 1) {
            Warrant warrant = this;
            synchronized (warrant) {
                this._student.notifyThrottleFound(throttle);
            }
        } else {
            if (this._engineer != null) {
                this.killEngineer(this._engineer, true, true);
            }
            this._engineer = new Engineer(this, throttle);
            this._speedUtil.getBlockSpeedTimes(this._commands, this._orders);
            if (this._tempRunBlind) {
                this._engineer.setRunOnET(true);
            }
            if (this._delayStart || this._haltStart) {
                this._engineer.setHalt(true);
                this.fireRunStatus(PROPERTY_READY_TO_RUN, -1, 0);
            }
            this._delayStart = false;
            this._engineer.start();
            int runState = this._engineer.getRunState();
            if (_trace || log.isDebugEnabled()) {
                log.info("Train \"{}\" on warrant \"{}\" launched. runState= {}", new Object[]{this.getTrainName(), this.getDisplayName(), RUN_STATE[runState]});
            }
            if (runState != 1 && runState != 6) {
                this.setMovement();
            }
        }
    }

    private String setPathAt(int idx) {
        BlockOrder bo = this._orders.get(idx);
        OBlock b = bo.getBlock();
        String msg = b.allocate(this);
        if (msg == null) {
            Warrant w;
            OPath path1 = bo.getPath();
            Portal exit = bo.getExitPortal();
            OBlock block = this.getBlockAt(idx + 1);
            if (block != null && ((w = block.getWarrant()) != null && !w.equals(this) || w == null && block.isOccupied()) && (msg = bo.pathsConnect(path1, exit, block)) == null) {
                msg = bo.setPath(this);
            }
            b.showAllocated(this, bo.getPathName());
        }
        return msg;
    }

    public String allocateRoute(boolean show, List<BlockOrder> orders) {
        if (this._totalAllocated && this._runMode != 0 && this._runMode != 4) {
            return null;
        }
        if (orders != null) {
            this._orders = orders;
        }
        this._allocated = false;
        this._message = null;
        int idxSpeedChange = 0;
        block6: do {
            TrainOrder to = this.getBlockOrderAt(idxSpeedChange).allocatePaths(this, true);
            switch (to._cause) {
                case NONE: {
                    break;
                }
                case WARRANT: {
                    this._waitForWarrant = true;
                    if (this._message == null) {
                        this._message = to._message;
                    }
                    if (show || to._idxContrlBlock != 0) continue block6;
                    return this._message;
                }
                case OCCUPY: {
                    this._waitForBlock = true;
                    if (this._message != null) continue block6;
                    this._message = to._message;
                    break;
                }
                case SIGNAL: {
                    if (!Stop.equals(to._speedType)) continue block6;
                    this._waitForSignal = true;
                    if (this._message != null) continue block6;
                    this._message = to._message;
                    break;
                }
                default: {
                    log.error("{}: allocateRoute at block \"{}\" setPath returns: {}", new Object[]{this.getDisplayName(), this.getBlockAt(idxSpeedChange).getDisplayName(), to.toString()});
                    if (this._message != null) continue block6;
                    this._message = to._message;
                }
            }
        } while ((show || this._message == null && (!this._shareRoute || idxSpeedChange <= 1)) && ++idxSpeedChange < this._orders.size());
        if (log.isDebugEnabled()) {
            log.debug("{}: allocateRoute() _shareRoute= {} show= {}. Break at {} of {}. msg= {}", new Object[]{this.getDisplayName(), this._shareRoute, show, idxSpeedChange, this._orders.size(), this._message});
        }
        this._allocated = true;
        if (this._message == null) {
            this._totalAllocated = true;
            if (show && this._shareRoute) {
                this._message = Bundle.getMessage("sharedRoute");
            }
        }
        if (show) {
            return this._message;
        }
        return null;
    }

    public void deAllocate() {
        if (this._runMode == 0 || this._runMode == 4) {
            this._allocated = false;
            this._totalAllocated = false;
            this._routeSet = false;
            for (int i = 0; i < this._orders.size(); ++i) {
                this.deAllocateBlock(this._orders.get(i).getBlock());
            }
        }
    }

    private boolean deAllocateBlock(OBlock block) {
        if (block.isAllocatedTo(this)) {
            block.deAllocate(this);
            if (block.equals(this._stoppingBlock)) {
                this.doStoppingBlockClear();
            }
            return true;
        }
        return false;
    }

    public void runWarrant(int mode) {
        this.setRunMode(mode, null, null, null, false);
    }

    public String setRoute(boolean show, List<BlockOrder> orders) {
        if (this._shareRoute) {
            this.deAllocate();
        }
        this._message = this.allocateRoute(show, orders);
        if (this._message != null) {
            log.debug("{}: setRoute: {}", (Object)this.getDisplayName(), (Object)this._message);
            return this._message;
        }
        this._routeSet = true;
        return null;
    }

    public String checkStartBlock() {
        log.debug("{}: checkStartBlock.", (Object)this.getDisplayName());
        BlockOrder bo = this._orders.get(0);
        OBlock block = bo.getBlock();
        String msg = block.allocate(this);
        if (msg != null) {
            return msg;
        }
        if (block.isDark() || this._tempRunBlind) {
            msg = "BlockDark";
        } else if (!block.isOccupied()) {
            msg = "warnStart";
        }
        return msg;
    }

    protected String checkforTrackers() {
        BlockOrder bo = this._orders.get(0);
        OBlock block = bo.getBlock();
        log.debug("{}: checkforTrackers at block {}", (Object)this.getDisplayName(), (Object)block.getDisplayName());
        Tracker t = InstanceManager.getDefault(TrackerTableAction.class).findTrackerIn(block);
        if (t != null) {
            return Bundle.getMessage("blockInUse", t.getTrainName(), block.getDisplayName());
        }
        return null;
    }

    public String checkRoute() {
        log.debug("{}: checkRoute.", (Object)this.getDisplayName());
        if (this._orders == null || this._orders.isEmpty()) {
            return Bundle.getMessage("noBlockOrders");
        }
        OBlock startBlock = this._orders.get(0).getBlock();
        for (int i = 1; i < this._orders.size(); ++i) {
            OBlock block = this._orders.get(i).getBlock();
            if (block.isOccupied() && !startBlock.equals(block)) {
                return Bundle.getMessage("BlockRougeOccupied", block.getDisplayName());
            }
            Warrant w = block.getWarrant();
            if (w == null || this.equals(w)) continue;
            return Bundle.getMessage("AllocatedToWarrant", w.getDisplayName(), block.getDisplayName(), w.getTrainName());
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof NamedBean)) {
            return;
        }
        String property = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug("{}: propertyChange \"{}\" new= {} source= {}", new Object[]{this.getDisplayName(), property, evt.getNewValue(), ((NamedBean)evt.getSource()).getDisplayName()});
        }
        if (this._protectSignal != null && this._protectSignal == evt.getSource()) {
            if (property.equals("Aspect") || property.equals("Appearance")) {
                this.readStoppingSignal();
            }
        } else if (property.equals("state") && this._stoppingBlock != null && this._stoppingBlock.equals(evt.getSource())) {
            int newState = ((Number)evt.getNewValue()).intValue();
            if ((newState & 2) != 0) {
                if (this._delayStart) {
                    this.clearStoppingBlock();
                    OBlock block = this.getBlockAt(0);
                    this._idxCurrentOrder = 0;
                    if (this._runMode == 2 && this._engineer == null) {
                        this._message = this.acquireThrottle();
                    } else if (this._runMode == 3) {
                        this.fireRunStatus(PROPERTY_READY_TO_RUN, -1, 0);
                        this._delayStart = false;
                    }
                    block._entryTime = System.currentTimeMillis();
                    block.setValue(this._trainName);
                    block.setState(block.getState() | 0x20);
                } else if ((((Number)evt.getNewValue()).intValue() & 0x10) == 0) {
                    this.clearStoppingBlock();
                    log.debug("\"{}\" cleared its wait. but block \"{}\" remains occupied", (Object)this.getDisplayName(), (Object)((Block)evt.getSource()).getDisplayName());
                }
            } else if ((((Number)evt.getNewValue()).intValue() & 4) != 0) {
                this.clearStoppingBlock();
            }
        }
    }

    private String getSignalSpeedType(@Nonnull NamedBean signal) {
        String speedType;
        if (signal instanceof SignalHead) {
            SignalHead head = (SignalHead)signal;
            int appearance = head.getAppearance();
            speedType = InstanceManager.getDefault(SignalSpeedMap.class).getAppearanceSpeed(head.getAppearanceName(appearance));
            if (log.isDebugEnabled()) {
                log.debug("{}: SignalHead {} sets appearance speed to {}", new Object[]{this.getDisplayName(), signal.getDisplayName(), speedType});
            }
        } else {
            SignalMast mast;
            String aspect;
            speedType = InstanceManager.getDefault(SignalSpeedMap.class).getAspectSpeed((aspect = (mast = (SignalMast)signal).getAspect()) == null ? "" : aspect, mast.getSignalSystem());
            if (log.isDebugEnabled()) {
                log.debug("{}: SignalMast {} sets aspect speed to {}", new Object[]{this.getDisplayName(), signal.getDisplayName(), speedType});
            }
        }
        return speedType;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    private void readStoppingSignal() {
        if (this._idxProtectSignal < this._idxCurrentOrder) {
            this.changeSignalListener(null, this._idxCurrentOrder);
            return;
        }
        if (this._idxProtectSignal == this._idxCurrentOrder && !this._waitForSignal) {
            this.changeSignalListener(null, this._idxCurrentOrder);
            return;
        }
        String speedType = this.getSignalSpeedType(this._protectSignal);
        String curSpeedType = this._waitForSignal ? Stop : this._engineer.getSpeedType(true);
        if (log.isDebugEnabled()) {
            log.debug("{}: Signal \"{}\" changed to aspect \"{}\" {} blocks ahead. curSpeedType= {}", new Object[]{this.getDisplayName(), this._protectSignal.getDisplayName(), speedType, this._idxProtectSignal - this._idxCurrentOrder, curSpeedType});
        }
        if (curSpeedType.equals(speedType)) {
            return;
        }
        if (this._idxProtectSignal > this._idxCurrentOrder && this._speedUtil.secondGreaterThanFirst(speedType, curSpeedType)) {
            float availDist = this.getAvailableDistance(this._idxProtectSignal);
            float changeDist = this.getChangeSpeedDistance(this._idxProtectSignal, speedType);
            if (changeDist > availDist) {
                int cmdStartIdx;
                availDist += this.getAvailableDistanceAt(this._idxCurrentOrder);
                if (speedType.equals(Stop)) {
                    this._waitForSignal = true;
                }
                if (!this.doDelayRamp(availDist, changeDist, this._idxProtectSignal, speedType, cmdStartIdx = this._engineer.getCurrentCommandIndex())) {
                    log.info("No room for train {} to ramp to \"{}\" from \"{}\" for signal \"{}\"!. availDist={}, changeDist={} on warrant {}", new Object[]{this.getTrainName(), speedType, curSpeedType, this._protectSignal.getDisplayName(), Float.valueOf(availDist), Float.valueOf(changeDist), this.getDisplayName()});
                }
            }
            return;
        }
        if (!speedType.equals(Stop) && this._waitForSignal) {
            this._curSignalAspect = speedType;
            this._waitForSignal = false;
            if (_trace || log.isDebugEnabled()) {
                log.info(Bundle.getMessage("SignalCleared", this._protectSignal.getDisplayName(), speedType, this._trainName));
            }
            ThreadingUtil.runOnGUIDelayed(() -> this.restoreRunning(speedType), 2000);
        }
    }

    private float getAvailableDistance(int idxChange) {
        float availDist = 0.0f;
        int idxBlockOrder = this._idxCurrentOrder + 1;
        if (idxBlockOrder < this._orders.size() - 1) {
            while (idxBlockOrder < idxChange) {
                availDist += this.getAvailableDistanceAt(idxBlockOrder++);
            }
        }
        return availDist;
    }

    private float getChangeSpeedDistance(int idxBlockOrder, String speedType) {
        float enterSpeed;
        float speedSetting = this._engineer.getSpeedSetting();
        if (speedSetting > 0.1f && this._idxCurrentOrder == idxBlockOrder - 1) {
            enterSpeed = speedSetting;
        } else {
            String currentSpeedType = this._engineer.getSpeedType(false);
            float scriptSpeed = this._speedUtil.getBlockSpeedInfo(idxBlockOrder - 1).getEntranceSpeed();
            enterSpeed = this._speedUtil.modifySpeed(scriptSpeed, currentSpeedType);
        }
        float scriptSpeed = this._speedUtil.getBlockSpeedInfo(idxBlockOrder).getEntranceSpeed();
        float endSpeed = this._speedUtil.modifySpeed(scriptSpeed, speedType);
        float enterLen = this._speedUtil.getRampLengthForEntry(enterSpeed, endSpeed);
        float bufDist = this.getEntranceBufferDist(idxBlockOrder);
        return enterLen + bufDist;
    }

    private void doStoppingBlockClear() {
        if (this._stoppingBlock == null) {
            return;
        }
        this._stoppingBlock.removePropertyChangeListener(this);
        this._stoppingBlock = null;
        this._idxStoppingBlock = -1;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    private synchronized void clearStoppingBlock() {
        if (this._stoppingBlock == null) {
            return;
        }
        String name = this._stoppingBlock.getDisplayName();
        this.doStoppingBlockClear();
        if (this._delayStart) {
            return;
        }
        if (_trace || log.isDebugEnabled()) {
            String reason = this._waitForBlock ? Bundle.getMessage("Occupancy") : Bundle.getMessage("Warrant");
            log.info(Bundle.getMessage("StopBlockCleared", this.getTrainName(), this.getDisplayName(), reason, name));
        }
        this.cancelDelayRamp();
        int time = 1000;
        if (this._waitForBlock) {
            this._waitForBlock = false;
            time = 4000;
        }
        if (this._waitForWarrant) {
            this._waitForWarrant = false;
            time = 3000;
        }
        String speedType = this._curSignalAspect != null ? this._curSignalAspect : this._engineer.getSpeedType(false);
        ThreadingUtil.runOnGUIDelayed(() -> this.restoreRunning(speedType), time);
    }

    private String okToRun() {
        int runState;
        boolean cannot = false;
        StringBuilder sb = new StringBuilder();
        if (this._waitForSignal) {
            sb.append(Bundle.getMessage("Signal"));
            cannot = true;
        }
        if (this._waitForWarrant) {
            if (cannot) {
                sb.append(", ");
            } else {
                cannot = true;
            }
            Warrant w = this.getBlockingWarrant();
            if (w != null) {
                sb.append(Bundle.getMessage("WarrantWait", w.getDisplayName()));
            } else {
                sb.append(Bundle.getMessage("WarrantWait", "Unknown"));
            }
        }
        if (this._waitForBlock) {
            if (cannot) {
                sb.append(", ");
            } else {
                cannot = true;
            }
            sb.append(Bundle.getMessage("Occupancy"));
        }
        if (this._engineer != null && ((runState = this._engineer.getRunState()) == 1 || runState == 6)) {
            if (cannot) {
                sb.append(", ");
            } else {
                cannot = true;
            }
            sb.append(Bundle.getMessage("userHalt"));
        }
        if (cannot) {
            return sb.toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    private boolean restoreRunning(String speedType) {
        boolean returnOK;
        this._message = this.okToRun();
        if (this._message == null) {
            BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder);
            TrainOrder to = bo.allocatePaths(this, true);
            OBlock block = bo.getBlock();
            if (log.isDebugEnabled()) {
                log.debug("{}: restoreRunning {}", (Object)this.getDisplayName(), (Object)to.toString());
            }
            switch (to._cause) {
                case NONE: {
                    returnOK = this.doRestoreRunning(block, speedType);
                    break;
                }
                case WARRANT: {
                    this._waitForWarrant = true;
                    this._message = to._message;
                    this.setStoppingBlock(to._idxContrlBlock);
                    returnOK = false;
                    break;
                }
                case OCCUPY: {
                    if (this._overrun || this._lost) {
                        this._message = this.setPathAt(this._idxCurrentOrder);
                        returnOK = this._message == null ? this.doRestoreRunning(block, speedType) : false;
                        if (!this._lost || !returnOK) break;
                        this._lost = false;
                        break;
                    }
                    returnOK = false;
                    this._waitForBlock = true;
                    this._message = to._message;
                    this.setStoppingBlock(to._idxContrlBlock);
                    break;
                }
                case SIGNAL: {
                    returnOK = to._idxContrlBlock == this._idxCurrentOrder ? this.doRestoreRunning(block, speedType) : false;
                    if (returnOK && Stop.equals(to._speedType)) {
                        this._waitForSignal = true;
                        this._message = to._message;
                        this.setProtectingSignal(to._idxContrlBlock);
                        returnOK = false;
                        break;
                    }
                    speedType = to._speedType;
                    returnOK = this.doRestoreRunning(block, speedType);
                    break;
                }
                default: {
                    log.error("restoreRunning TrainOrder {}", (Object)to.toString());
                    this._message = to._message;
                    returnOK = false;
                    break;
                }
            }
        } else {
            returnOK = false;
        }
        if (!returnOK) {
            String blockName = this.getBlockAt(this._idxCurrentOrder).getDisplayName();
            if (_trace || log.isDebugEnabled()) {
                log.info(Bundle.getMessage("trainWaiting", this.getTrainName(), this._message, blockName));
            }
            this.fireRunStatus(PROPERTY_CANNOT_RUN, blockName, this._message);
        }
        return returnOK;
    }

    private boolean doRestoreRunning(OBlock block, String speedType) {
        this._overrun = false;
        this._curSignalAspect = null;
        this.setPathAt(this._idxCurrentOrder);
        BlockOrder bo = this.getBlockOrderAt(this._idxCurrentOrder + 1);
        if (bo != null) {
            TrainOrder to = bo.allocatePaths(this, true);
            if (Stop.equals(to._speedType)) {
                this._message = to._message;
                switch (to._cause) {
                    case NONE: {
                        break;
                    }
                    case WARRANT: {
                        this._waitForWarrant = true;
                        this.setStoppingBlock(to._idxContrlBlock);
                        break;
                    }
                    case OCCUPY: {
                        this._waitForBlock = true;
                        this.setStoppingBlock(to._idxContrlBlock);
                        break;
                    }
                    case SIGNAL: {
                        this._waitForSignal = true;
                        this.setProtectingSignal(to._idxContrlBlock);
                        break;
                    }
                }
                return false;
            }
        }
        this._engineer.clearWaitForSync(block);
        if (log.isDebugEnabled()) {
            log.debug("{}: restoreRunning(): rampSpeedTo to \"{}\"", (Object)this.getDisplayName(), (Object)speedType);
        }
        this.rampSpeedTo(speedType, -1);
        if (!this._overrun && this._idxCurrentOrder < this._orders.size() - 1) {
            this.lookAheadforSpeedChange(speedType, speedType);
        }
        return true;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    private void setStoppingBlock(int idxBlock) {
        OBlock block = this.getBlockAt(idxBlock);
        if (block == null) {
            return;
        }
        if (idxBlock < 0 || this._idxCurrentOrder == idxBlock && !this._lost) {
            return;
        }
        OBlock prevBlk = this._stoppingBlock;
        if (this._stoppingBlock != null) {
            if (this._stoppingBlock.equals(block)) {
                return;
            }
            int idxStop = this.getIndexOfBlockAfter(this._stoppingBlock, this._idxCurrentOrder);
            if (idxBlock < idxStop || idxStop < 0) {
                prevBlk.removePropertyChangeListener(this);
            } else {
                if (idxStop < this._idxCurrentOrder) {
                    log.error("{}: _stoppingBlock \"{}\" index {} < _idxCurrentOrder {}", new Object[]{this.getDisplayName(), this._stoppingBlock.getDisplayName(), idxStop, this._idxCurrentOrder});
                }
                return;
            }
        }
        this._stoppingBlock = block;
        this._idxStoppingBlock = idxBlock;
        this._stoppingBlock.addPropertyChangeListener(this);
        if ((_trace || log.isDebugEnabled()) && (this._waitForBlock || this._waitForWarrant)) {
            String cause;
            String reason;
            if (this._waitForWarrant) {
                reason = Bundle.getMessage("Warrant");
                Warrant w = block.getWarrant();
                cause = w != null ? w.getDisplayName() : Bundle.getMessage("Unknown");
            } else if (this._waitForBlock) {
                reason = Bundle.getMessage("Occupancy");
                cause = (String)block.getValue();
                if (cause == null) {
                    cause = Bundle.getMessage("unknownTrain");
                }
            } else if (this._lost) {
                reason = Bundle.getMessage("Lost");
                cause = Bundle.getMessage("Occupancy");
            } else {
                reason = Bundle.getMessage("Start");
                cause = "";
            }
            log.info(Bundle.getMessage("StopBlockSet", this._stoppingBlock.getDisplayName(), this.getTrainName(), reason, cause));
        }
    }

    private boolean setProtectingSignal(int idx) {
        if (this._idxProtectSignal == idx) {
            return true;
        }
        BlockOrder blkOrder = this.getBlockOrderAt(idx);
        NamedBean signal = blkOrder.getSignal();
        if (this._protectSignal != null && this._protectSignal.equals(signal)) {
            if (this._idxProtectSignal < idx && idx >= 0) {
                this._idxProtectSignal = idx;
            }
            return true;
        }
        if (this._protectSignal != null && idx > this._idxProtectSignal && this._idxProtectSignal > this._idxCurrentOrder) {
            return true;
        }
        return this.changeSignalListener(signal, idx);
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    private boolean changeSignalListener(NamedBean signal, int signalIndex) {
        if (signalIndex == this._idxProtectSignal) {
            return true;
        }
        if (this._protectSignal != null) {
            this._protectSignal.removePropertyChangeListener(this);
            this._protectSignal = null;
            this._idxProtectSignal = -1;
        }
        boolean ret = false;
        if (signal != null) {
            this._protectSignal = signal;
            this._idxProtectSignal = signalIndex;
            this._protectSignal.addPropertyChangeListener(this);
            if (_trace || log.isDebugEnabled()) {
                log.info(Bundle.getMessage("ProtectSignalSet", this.getTrainName(), this._protectSignal.getDisplayName(), this.getBlockAt(this._idxProtectSignal).getDisplayName()));
            }
            ret = true;
        }
        return ret;
    }

    @InvokeOnLayoutThread
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    protected void goingActive(OBlock block) {
        Warrant w;
        if (log.isDebugEnabled() && !ThreadingUtil.isLayoutThread()) {
            log.error("{} invoked on wrong thread", (Object)this.getDisplayName(), (Object)new Exception("traceback"));
            this.stopWarrant(true, true);
            return;
        }
        if (this._runMode == 0) {
            return;
        }
        int activeIdx = this.getIndexOfBlockAfter(block, this._idxCurrentOrder);
        if (log.isDebugEnabled()) {
            log.debug("{}: **Block \"{}\" goingActive. activeIdx= {}, _idxCurrentOrder= {}.", new Object[]{this.getDisplayName(), block.getDisplayName(), activeIdx, this._idxCurrentOrder});
        }
        if ((w = block.getWarrant()) == null || !this.equals(w)) {
            if (log.isDebugEnabled()) {
                log.debug("{}: **Block \"{}\" owned by {}!", new Object[]{this.getDisplayName(), block.getDisplayName(), w == null ? "NO One" : w.getDisplayName()});
            }
            return;
        }
        if (this._lost && !this.getBlockAt(this._idxCurrentOrder).isOccupied()) {
            this._idxCurrentOrder = activeIdx;
            log.info("Train \"{}\" found at block \"{}\" of warrant {}.", new Object[]{this.getTrainName(), block.getDisplayName(), this.getDisplayName()});
            this._lost = false;
            this.rampSpeedTo(this._engineer.getSpeedType(false), -1);
            this.setMovement();
            return;
        }
        if (activeIdx <= 0) {
            return;
        }
        if (activeIdx == this._idxCurrentOrder) {
            if (_trace || log.isDebugEnabled()) {
                log.info(Bundle.getMessage("RegainDetection", this.getTrainName(), block.getDisplayName()));
            }
        } else if (activeIdx == this._idxCurrentOrder + 1) {
            if (this._delayStart) {
                log.warn("{}: Rogue entered Block \"{}\" ahead of {}.", new Object[]{this.getDisplayName(), block.getDisplayName(), this.getTrainName()});
                this._message = Bundle.getMessage("BlockRougeOccupied", block.getDisplayName());
                return;
            }
            this._idxCurrentOrder = activeIdx;
        } else if (activeIdx > this._idxCurrentOrder + 1) {
            for (int idx = this._idxCurrentOrder + 1; idx < activeIdx; ++idx) {
                OBlock preBlock = this.getBlockAt(idx);
                if (!preBlock.isDark()) {
                    if (log.isDebugEnabled()) {
                        OBlock curBlock = this.getBlockAt(this._idxCurrentOrder);
                        log.debug("Rogue train entered block \"{}\" ahead of train {} currently in block \"{}\"!", new Object[]{block.getDisplayName(), this._trainName, curBlock.getDisplayName()});
                    }
                    return;
                }
                this._idxCurrentOrder = activeIdx;
            }
            OBlock prevBlock = this.getBlockAt(activeIdx - 1);
            prevBlock._entryTime = System.currentTimeMillis() - 5000L;
            prevBlock.setValue(this._trainName);
            prevBlock.setState(prevBlock.getState() | 0x20);
            if (log.isDebugEnabled()) {
                log.debug("{}: Train moving from UNDETECTED block \"{}\" now entering block\"{}\"", new Object[]{this.getDisplayName(), prevBlock.getDisplayName(), block.getDisplayName()});
            }
        } else if (this._idxCurrentOrder > activeIdx) {
            log.info("Tail of Train {} regained detection behind Block= {} at block= {}", new Object[]{this.getTrainName(), block.getDisplayName(), this.getBlockAt(activeIdx).getDisplayName()});
            return;
        }
        this.setHeadOfTrain(block);
        if (this._engineer != null) {
            this._engineer.clearWaitForSync(block);
        }
        if (_trace) {
            log.info(Bundle.getMessage("TrackerBlockEnter", this.getTrainName(), block.getDisplayName()));
        }
        this.fireRunStatus(PROPERTY_BLOCK_CHANGE, this.getBlockAt(activeIdx - 1), block);
        if (this._runMode == 1) {
            return;
        }
        if (this._idxCurrentOrder < this._orders.size() - 1 && this._engineer != null) {
            BlockOrder bo = this._orders.get(this._idxCurrentOrder + 1);
            if (bo.getBlock().isDark()) {
                this._engineer.setRunOnET(true);
            } else if (!this._tempRunBlind) {
                this._engineer.setRunOnET(false);
            }
        }
        if (log.isTraceEnabled()) {
            log.debug("{}: end of goingActive. leaving \"{}\" entered \"{}\"", new Object[]{this.getDisplayName(), this.getBlockAt(activeIdx - 1).getDisplayName(), block.getDisplayName()});
        }
        this.setMovement();
    }

    private void setHeadOfTrain(OBlock block) {
        block.setValue(this._trainName);
        block.setState(block.getState() | 0x20);
        if (this._runMode == 2 && this._idxCurrentOrder > 0 && this._idxCurrentOrder < this._orders.size()) {
            this._speedUtil.leavingBlock(this._idxCurrentOrder - 1);
        }
    }

    @InvokeOnLayoutThread
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    protected void goingInactive(OBlock block) {
        if (log.isDebugEnabled() && !ThreadingUtil.isLayoutThread()) {
            log.error("{} invoked on wrong thread", (Object)this.getDisplayName(), (Object)new Exception("traceback"));
        }
        if (this._runMode == 0) {
            return;
        }
        int idx = this.getIndexOfBlockBefore(this._idxCurrentOrder, block);
        if (log.isDebugEnabled()) {
            log.debug("{}: *Block \"{}\" goingInactive. idx= {}, _idxCurrentOrder= {}.", new Object[]{this.getDisplayName(), block.getDisplayName(), idx, this._idxCurrentOrder});
        }
        if (idx > this._idxCurrentOrder) {
            return;
        }
        this.releaseBlock(block, idx);
        block.setValue(null);
        if (idx == this._idxCurrentOrder) {
            if (this._idxCurrentOrder + 1 < this._orders.size()) {
                OBlock nextBlock = this.getBlockAt(this._idxCurrentOrder + 1);
                if (nextBlock.isDark()) {
                    this.goingActive(nextBlock);
                    return;
                }
                if (this.checkForOverrun(nextBlock)) {
                    return;
                }
            }
            this._lost = true;
            if (this._engineer != null) {
                this.setSpeedToType(Stop);
                this.setStoppingBlock(this._idxCurrentOrder);
            }
            if (_trace) {
                log.info(Bundle.getMessage("ChangedRoute", this._trainName, block.getDisplayName(), this.getDisplayName()));
            }
            this.fireRunStatus(PROPERTY_BLOCK_CHANGE, block, null);
        }
    }

    private void releaseBlock(OBlock block, int idx) {
        for (int i = idx; i > -1; --i) {
            boolean neededLater = false;
            OBlock curBlock = this.getBlockAt(i);
            for (int j = i + 1; j < this._orders.size(); ++j) {
                if (!curBlock.equals(this.getBlockAt(j))) continue;
                neededLater = true;
            }
            if (!neededLater) {
                if (!this.deAllocateBlock(curBlock)) continue;
                curBlock.setValue(null);
                this._totalAllocated = false;
                continue;
            }
            if (curBlock.isAllocatedTo(this)) {
                if (this._idxCurrentOrder != idx + 1) {
                    curBlock.setValue(null);
                }
                if (curBlock.equals(this._stoppingBlock)) {
                    this.doStoppingBlockClear();
                }
            }
            if (!this._shareRoute) continue;
            for (int k = Math.min(3, this._orders.size()); k > this._idxCurrentOrder; --k) {
                if (curBlock.equals(this.getBlockAt(k)) || !this.deAllocateBlock(curBlock)) continue;
                curBlock.setValue(null);
                this._totalAllocated = false;
            }
        }
    }

    private boolean checkForOverrun(OBlock block) {
        if (block.isOccupied() && System.currentTimeMillis() - block._entryTime < 5000L) {
            this._overrun = true;
            this._message = this.setPathAt(this._idxCurrentOrder + 1);
            if (this._message == null) {
                ++this._idxCurrentOrder;
                ThreadingUtil.runOnGUI(() -> this.goingActive(block));
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this._runMode != 0) {
            this.stopWarrant(true, true);
        }
        super.dispose();
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameWarrant");
    }

    private synchronized void cancelDelayRamp() {
        if (this._delayCommand != null) {
            log.debug("{}: cancelDelayRamp() called. _speedType= {}", (Object)this.getDisplayName(), (Object)this._delayCommand._speedType);
            this._delayCommand.quit = true;
            this._delayCommand.interrupt();
            this._delayCommand = null;
        }
    }

    private synchronized void endDelayCommand() {
        this._delayCommand = null;
    }

    private void rampSpeedTo(String speedType, int idx) {
        this.cancelDelayRamp();
        if (this._noRamp) {
            this._engineer.setSpeedToType(speedType);
            this._engineer.setWaitforClear(speedType.equals(Stop) || speedType.equals(EStop));
            if (log.isDebugEnabled()) {
                log.debug("{}: No Ramp to \"{}\" from block \"{}\"", new Object[]{this.getDisplayName(), speedType, this.getCurrentBlockName()});
            }
            return;
        }
        if (log.isDebugEnabled()) {
            if (idx < 0) {
                log.debug("{}: Ramp up to \"{}\" from block \"{}\"", new Object[]{this.getDisplayName(), speedType, this.getCurrentBlockName()});
            } else {
                log.debug("{}: Ramp down to \"{}\" before block \"{}\"", new Object[]{this.getDisplayName(), speedType, this.getBlockAt(idx).getDisplayName()});
            }
        }
        if (this._engineer != null) {
            this._engineer.rampSpeedTo(speedType, idx);
        } else {
            log.error("{}: No Engineer!", (Object)this.getDisplayName());
        }
    }

    private void setSpeedToType(String speedType) {
        this.cancelDelayRamp();
        this._engineer.setSpeedToType(speedType);
    }

    private void clearWaitFlags(boolean removeListeners) {
        if (log.isTraceEnabled()) {
            log.trace("{}: Flags cleared {}.", (Object)this.getDisplayName(), (Object)(removeListeners ? "and removed Listeners" : "only"));
        }
        this._waitForBlock = false;
        this._waitForSignal = false;
        this._waitForWarrant = false;
        if (removeListeners) {
            if (this._protectSignal != null) {
                this._protectSignal.removePropertyChangeListener(this);
                this._protectSignal = null;
                this._idxProtectSignal = -1;
            }
            if (this._stoppingBlock != null) {
                this._stoppingBlock.removePropertyChangeListener(this);
                this._stoppingBlock = null;
                this._idxStoppingBlock = -1;
            }
        }
    }

    private float getAvailableDistanceAt(int idxBlockOrder) {
        BlockOrder blkOrder = this.getBlockOrderAt(idxBlockOrder);
        float pathLength = blkOrder.getPathLength();
        if (idxBlockOrder == 0 || pathLength <= 20.0f) {
            float blkDist = this._speedUtil.getBlockSpeedInfo(idxBlockOrder).getCalcLen();
            if (log.isDebugEnabled()) {
                log.debug("{}: getAvailableDistanceAt: block \"{}\" using calculated blkDist= {}, pathLength= {}", new Object[]{this.getDisplayName(), blkOrder.getBlock().getDisplayName(), Float.valueOf(blkDist), Float.valueOf(pathLength)});
            }
            return blkDist;
        }
        return pathLength;
    }

    private float getEntranceBufferDist(int idxBlockOrder) {
        float bufDist = BUFFER_DISTANCE;
        if (this._waitForSignal) {
            bufDist += this.getBlockOrderAt(idxBlockOrder).getEntranceSpace();
        }
        return bufDist;
    }

    private void setMovement() {
        BlockOrder curBlkOrder = this.getBlockOrderAt(this._idxCurrentOrder);
        OBlock curBlock = curBlkOrder.getBlock();
        String currentSpeedType = this._engineer.getSpeedType(false);
        String entrySpeedType = BlockOrder.getPermissibleSpeedAt(curBlkOrder);
        if (entrySpeedType == null) {
            entrySpeedType = currentSpeedType;
        }
        curBlkOrder.setPath(this);
        if (log.isDebugEnabled()) {
            SpeedState speedState = this._engineer.getSpeedState();
            int runState = this._engineer.getRunState();
            log.debug("{}: SET MOVEMENT Block \"{}\" runState= {}, speedState= {} for currentSpeedType= {}. entrySpeedType= {}.", new Object[]{this.getDisplayName(), curBlock.getDisplayName(), RUN_STATE[runState], speedState.toString(), currentSpeedType, entrySpeedType});
            log.debug("{}: Flags: _waitForBlock={}, _waitForSignal={}, _waitForWarrant={} curThrottle= {}.", new Object[]{this.getDisplayName(), this._waitForBlock, this._waitForSignal, this._waitForWarrant, Float.valueOf(this._engineer.getSpeedSetting())});
            if (this._message != null) {
                log.debug("{}: _message ({}) ", (Object)this.getDisplayName(), (Object)this._message);
            }
        }
        if (this._idxCurrentOrder > 0) {
            if (this._waitForSignal && this._idxProtectSignal == this._idxCurrentOrder) {
                this.makeOverrunMessage(curBlkOrder);
                this.setSpeedToType(Stop);
                return;
            }
            if (this._idxStoppingBlock == this._idxCurrentOrder && (this._waitForBlock || this._waitForWarrant)) {
                this.makeOverrunMessage(curBlkOrder);
                this.setSpeedToType(Stop);
                return;
            }
            if (this._speedUtil.secondGreaterThanFirst(entrySpeedType, currentSpeedType)) {
                NamedBean signal = curBlkOrder.getSignal();
                if (signal != null) {
                    log.info("Train {} moved past required {} speed for signal \"{}\" at block \"{}\" on warrant {}!", new Object[]{this.getTrainName(), entrySpeedType, signal.getDisplayName(), curBlock.getDisplayName(), this.getDisplayName()});
                } else {
                    log.info("Train {} moved past required \"{}\" speed at block \"{}\" on warrant {}!", new Object[]{this.getTrainName(), entrySpeedType, curBlock.getDisplayName(), this.getDisplayName()});
                }
                this.fireRunStatus(PROPERTY_SIGNAL_OVERRUN, signal != null ? signal.getDisplayName() : curBlock.getDisplayName(), entrySpeedType);
                this.setSpeedToType(entrySpeedType);
                currentSpeedType = entrySpeedType;
            }
        } else if (Stop.equals(currentSpeedType)) {
            currentSpeedType = Normal;
        }
        if (this._idxCurrentOrder < this._orders.size() - 1) {
            this.lookAheadforSpeedChange(currentSpeedType, entrySpeedType);
        }
    }

    private void lookAheadforSpeedChange(String currentSpeedType, String entrySpeedType) {
        int cmdStartIdx;
        TrainOrder to;
        this.clearWaitFlags(false);
        String speedType = currentSpeedType;
        int idx = this._idxCurrentOrder + 1;
        int idxSpeedChange = -1;
        int idxContrlBlock = -1;
        int limit = this._shareRoute ? Math.min(this._orders.size(), this._idxCurrentOrder + 3) : this._orders.size();
        boolean allocate = true;
        int numAllocated = 0;
        do {
            to = this.getBlockOrderAt(idx).allocatePaths(this, allocate);
            if (log.isDebugEnabled()) {
                log.debug("{}: lookAheadforSpeedChange {}", (Object)this.getDisplayName(), (Object)to.toString());
            }
            switch (to._cause) {
                case NONE: {
                    break;
                }
                case WARRANT: {
                    this._waitForWarrant = true;
                    this._message = to._message;
                    idxContrlBlock = to._idxContrlBlock;
                    idxSpeedChange = to._idxEnterBlock;
                    speedType = Stop;
                    break;
                }
                case OCCUPY: {
                    this._waitForBlock = true;
                    this._message = to._message;
                    idxContrlBlock = to._idxContrlBlock;
                    idxSpeedChange = to._idxEnterBlock;
                    speedType = Stop;
                    break;
                }
                case SIGNAL: {
                    speedType = to._speedType;
                    if (Stop.equals(speedType)) {
                        this._waitForSignal = true;
                    }
                    idxContrlBlock = to._idxContrlBlock;
                    idxSpeedChange = to._idxEnterBlock;
                    this._message = to._message;
                    break;
                }
                default: {
                    log.error("{}: lookAheadforSpeedChange at block \"{}\" setPath returns: {}", new Object[]{this.getDisplayName(), this.getBlockAt(this._idxCurrentOrder).getDisplayName(), to.toString()});
                    this._message = to._message;
                    this.setSpeedToType(Stop);
                    return;
                }
            }
            ++numAllocated;
            if (Stop.equals(speedType)) break;
            if (!this._shareRoute || numAllocated <= 1) continue;
            allocate = false;
        } while (idxSpeedChange < 0 && ++idx < limit && !this._speedUtil.secondGreaterThanFirst(speedType, currentSpeedType));
        if (!Stop.equals(speedType)) {
            while (idx < limit) {
                to = this.getBlockOrderAt(idx).allocatePaths(this, false);
                if (Stop.equals(to._speedType)) break;
                ++idx;
            }
        }
        if (idxSpeedChange < 0) {
            idxSpeedChange = this._orders.size() - 1;
        }
        float availDist = this.getAvailableDistance(idxSpeedChange);
        float changeDist = this.getChangeSpeedDistance(idxSpeedChange, speedType);
        if (this._speedUtil.secondGreaterThanFirst(currentSpeedType, speedType)) {
            this.rampSpeedTo(speedType, -1);
            return;
        }
        if (!currentSpeedType.equals(entrySpeedType)) {
            this.rampSpeedTo(entrySpeedType, -1);
        }
        for (int i = this._idxCurrentOrder + 1; i < this._orders.size() && !this.setProtectingSignal(i); ++i) {
        }
        OBlock block = this.getBlockAt(idxSpeedChange);
        if (log.isDebugEnabled()) {
            log.debug("{}: Speed \"{}\" at block \"{}\" until speed \"{}\" at block \"{}\", availDist={}, changeDist={}", new Object[]{this.getDisplayName(), currentSpeedType, this.getBlockAt(this._idxCurrentOrder).getDisplayName(), speedType, block.getDisplayName(), Float.valueOf(availDist), Float.valueOf(changeDist)});
        }
        if (changeDist <= availDist) {
            this.cancelDelayRamp();
            this.clearWaitFlags(false);
            return;
        }
        if (this._waitForBlock) {
            if (!this.getBlockAt(this._idxCurrentOrder).equals(block)) {
                this.setStoppingBlock(idxContrlBlock);
            }
        } else if (this._waitForWarrant && this._stoppingBlock == null) {
            this.setStoppingBlock(idxContrlBlock);
        }
        if (this._waitForSignal) {
            this.setProtectingSignal(idxContrlBlock);
        }
        if (!this._speedUtil.secondGreaterThanFirst(speedType, currentSpeedType)) {
            return;
        }
        if (!this.doDelayRamp(availDist += this.getAvailableDistanceAt(this._idxCurrentOrder), changeDist, idxSpeedChange, speedType, cmdStartIdx = this._speedUtil.getBlockSpeedInfo(this._idxCurrentOrder).getFirstIndex())) {
            log.warn("No room for train {} to ramp to \"{}\" from \"{}\" in block \"{}\"!. availDist={}, changeDist={} on warrant {}", new Object[]{this.getTrainName(), speedType, currentSpeedType, this.getBlockAt(this._idxCurrentOrder).getDisplayName(), Float.valueOf(availDist), Float.valueOf(changeDist), this.getDisplayName()});
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="Write unexpected error and fall through")
    private synchronized boolean doDelayRamp(float availDist, float changeDist, int idxSpeedChange, String speedType, int cmdStartIdx) {
        String pendingSpeedType = this._engineer.getSpeedType(true);
        if (pendingSpeedType.equals(speedType)) {
            return true;
        }
        if (availDist < 10.0f) {
            this.setSpeedToType(speedType);
            return false;
        }
        SpeedState speedState = this._engineer.getSpeedState();
        switch (speedState) {
            case RAMPING_UP: {
                this.makeRampWait(availDist, idxSpeedChange, speedType);
                break;
            }
            case RAMPING_DOWN: {
                log.error("Already ramping to \"{}\" making ramp for \"{}\".", (Object)this._engineer.getSpeedType(true), (Object)speedType);
            }
            default: {
                this.makeScriptWait(availDist, changeDist, idxSpeedChange, speedType, cmdStartIdx);
            }
        }
        return true;
    }

    private void makeRampWait(float availDist, int idxSpeedChange, @Nonnull String speedType) {
        float curTrackSpeed;
        BlockSpeedInfo info = this._speedUtil.getBlockSpeedInfo(idxSpeedChange - 1);
        float speedSetting = info.getExitSpeed();
        float endSpeed = this._speedUtil.modifySpeed(speedSetting, speedType);
        float prevSetting = speedSetting = this._engineer.getSpeedSetting();
        String currentSpeedType = this._engineer.getSpeedType(false);
        float changeDist = 0.0f;
        if (log.isDebugEnabled()) {
            log.debug("{}: makeRampWait for speed change \"{}\" to \"{}\". Throttle from={}, to={}, availDist={}", new Object[]{this.getDisplayName(), currentSpeedType, speedType, Float.valueOf(speedSetting), Float.valueOf(endSpeed), Float.valueOf(availDist)});
        }
        float bufDist = this.getEntranceBufferDist(idxSpeedChange);
        float accumTime = 0.0f;
        float accumDist = 0.0f;
        RampData ramp = this._speedUtil.getRampForSpeedChange(speedSetting, 1.0f);
        int time = ramp.getRampTimeIncrement();
        ListIterator<Float> iter = ramp.speedIterator(true);
        while (iter.hasNext()) {
            changeDist = this._speedUtil.getRampLengthForEntry(speedSetting, endSpeed) + bufDist;
            accumDist += this._speedUtil.getDistanceOfSpeedChange(prevSetting, speedSetting, time);
            accumTime += (float)time;
            prevSetting = speedSetting;
            speedSetting = iter.next().floatValue();
            if (!(changeDist + accumDist >= availDist)) continue;
            curTrackSpeed = this._speedUtil.getTrackSpeed(speedSetting);
            float remDist = changeDist + accumDist - availDist;
            if (curTrackSpeed > 0.0f) {
                accumTime -= remDist / curTrackSpeed;
                break;
            }
            log.warn("{}: Cannot compute wait time for \"{}\" ramp to block \"{}\". trackSpeed= {}", new Object[]{this.getDisplayName(), speedType, this.getBlockAt(idxSpeedChange).getDisplayName(), Float.valueOf(curTrackSpeed)});
            break;
        }
        if (changeDist < accumDist) {
            curTrackSpeed = this._speedUtil.getTrackSpeed(speedSetting);
            if (curTrackSpeed > 0.0f) {
                accumTime += (availDist - changeDist) / curTrackSpeed;
            } else {
                log.warn("{}: Cannot compute wait time for \"{}\" ramp to block \"{}\". trackSpeed= {}", new Object[]{this.getDisplayName(), speedType, this.getBlockAt(idxSpeedChange).getDisplayName(), Float.valueOf(curTrackSpeed)});
            }
        }
        int waitTime = Math.round(accumTime);
        if (log.isDebugEnabled()) {
            log.debug("{}: RAMP: Wait {}ms and travel {}mm until {}mm before entering block \"{}\" at throttle= {}. availDist={}mm", new Object[]{this.getDisplayName(), waitTime, Math.round(accumDist), Math.round(changeDist), this.getBlockAt(idxSpeedChange).getDisplayName(), Float.valueOf(speedSetting), Math.round(availDist)});
        }
        this.rampSpeedDelay(waitTime, speedType, speedSetting, idxSpeedChange);
    }

    private void makeScriptWait(float availDist, float changeDist, int idxSpeedChange, @Nonnull String speedType, int cmdStartIdx) {
        float beginTrackSpeed;
        BlockSpeedInfo info = this._speedUtil.getBlockSpeedInfo(idxSpeedChange - 1);
        int cmdEndIdx = info.getLastIndex();
        float scriptSpeed = info.getExitSpeed();
        float endSpeed = this._speedUtil.modifySpeed(scriptSpeed, speedType);
        scriptSpeed = this._engineer.getScriptSpeed();
        float speedSetting = this._engineer.getSpeedSetting();
        String currentSpeedType = this._engineer.getSpeedType(false);
        float modSetting = speedSetting;
        float curTrackSpeed = beginTrackSpeed = this._speedUtil.getTrackSpeed(modSetting);
        float prevTrackSpeed = beginTrackSpeed;
        if (this._idxCurrentOrder == 0 && availDist > BUFFER_DISTANCE) {
            changeDist = 0.0f;
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: makespeedChange cmdIdx #{} to #{} at speedType \"{}\" to \"{}\". speedSetting={}, changeDist={}, availDist={}", new Object[]{this.getDisplayName(), cmdStartIdx + 1, cmdEndIdx + 1, currentSpeedType, speedType, Float.valueOf(speedSetting), Float.valueOf(changeDist), Float.valueOf(availDist)});
        }
        float accumTime = 0.0f;
        float accumDist = 0.0f;
        ThrottleSetting.Command cmd = this._commands.get(cmdStartIdx).getCommand();
        if (cmd.equals((Object)ThrottleSetting.Command.NOOP) && beginTrackSpeed > 0.0f) {
            accumTime = (availDist - changeDist) / beginTrackSpeed;
        } else {
            float timeRatio = curTrackSpeed > this._speedUtil.getRampThrottleIncrement() ? this._speedUtil.getTrackSpeed(scriptSpeed) / curTrackSpeed : 1.0f;
            float bufDist = this.getEntranceBufferDist(idxSpeedChange);
            for (int i = cmdStartIdx; i <= cmdEndIdx; ++i) {
                ThrottleSetting ts = this._commands.get(i);
                long time = ts.getTime();
                accumDist += this._speedUtil.getDistanceOfSpeedChange(prevTrackSpeed, curTrackSpeed, (int)((float)time * timeRatio));
                accumTime += (float)time * timeRatio;
                cmd = ts.getCommand();
                if (cmd.equals((Object)ThrottleSetting.Command.SPEED)) {
                    prevTrackSpeed = curTrackSpeed;
                    ThrottleSetting.CommandValue cmdVal = ts.getValue();
                    scriptSpeed = cmdVal.getFloat();
                    modSetting = this._speedUtil.modifySpeed(scriptSpeed, currentSpeedType);
                    curTrackSpeed = this._speedUtil.getTrackSpeed(modSetting);
                    changeDist = this._speedUtil.getRampLengthForEntry(modSetting, endSpeed) + bufDist;
                    timeRatio = this._speedUtil.getTrackSpeed(scriptSpeed) / curTrackSpeed;
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}: cmd#{} accumTime= {} accumDist= {} changeDist= {}, throttle= {}", new Object[]{this.getDisplayName(), i + 1, Float.valueOf(accumTime), Float.valueOf(accumDist), Float.valueOf(changeDist), Float.valueOf(modSetting)});
                }
                if (changeDist + accumDist >= availDist) {
                    float remDist = changeDist + accumDist - availDist;
                    if (curTrackSpeed > 0.0f) {
                        accumTime -= remDist / curTrackSpeed;
                        break;
                    }
                    log.warn("{}: script unfit cmd#{}. Cannot compute wait time for \"{}\" ramp to block \"{}\". trackSpeed= {}", new Object[]{this.getDisplayName(), i + 1, speedType, this.getBlockAt(idxSpeedChange).getDisplayName(), Float.valueOf(curTrackSpeed)});
                    if (!(prevTrackSpeed > 0.0f)) break;
                    accumTime -= remDist / prevTrackSpeed;
                    break;
                }
                if (!cmd.equals((Object)ThrottleSetting.Command.NOOP)) continue;
                float remDist = availDist - changeDist - accumDist;
                log.warn("{}: script unfit cmd#{}. Cannot compute wait time for \"{}\" ramp to block \"{}\". remDist= {}", new Object[]{this.getDisplayName(), i + 1, speedType, this.getBlockAt(idxSpeedChange).getDisplayName(), Float.valueOf(remDist)});
                accumTime -= (float)this._speedUtil.getTimeForDistance(modSetting, bufDist);
                break;
            }
        }
        int waitTime = Math.round(accumTime);
        if (log.isDebugEnabled()) {
            log.debug("{}: RAMP: Wait {}ms and travel {}mm until {}mm before entering block \"{}\" at throttle= {}. availDist={}mm", new Object[]{this.getDisplayName(), waitTime, Math.round(accumDist), Math.round(changeDist), this.getBlockAt(idxSpeedChange).getDisplayName(), Float.valueOf(modSetting), Math.round(availDist)});
        }
        this.rampSpeedDelay(waitTime, speedType, modSetting, idxSpeedChange);
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    private synchronized void rampSpeedDelay(long waitTime, String speedType, float waitSpeed, int idxSpeedChange) {
        int endBlockIdx = idxSpeedChange - 1;
        if ((waitTime -= 50L) < 0L) {
            this.rampSpeedTo(speedType, endBlockIdx);
            return;
        }
        String reason = this._waitForSignal ? Bundle.getMessage("Signal") : (this._waitForWarrant ? Bundle.getMessage("Warrant") : (this._waitForBlock ? Bundle.getMessage("Occupancy") : Bundle.getMessage("Signal")));
        if ((_trace || log.isDebugEnabled()) && log.isDebugEnabled()) {
            log.info("Train \"{}\" needs speed decrease to \"{}\" from \"{}\" for {} before entering block \"{}\"", new Object[]{this.getTrainName(), speedType, this._engineer.getSpeedType(true), reason, this.getBlockAt(idxSpeedChange).getDisplayName()});
        }
        if (this._delayCommand != null) {
            if (this._delayCommand.isDuplicate(speedType, waitTime, endBlockIdx)) {
                return;
            }
            this.cancelDelayRamp();
        }
        this._delayCommand = new CommandDelay(speedType, waitTime, waitSpeed, endBlockIdx);
        this._delayCommand.start();
        if (log.isDebugEnabled()) {
            log.debug("{}: CommandDelay: will wait {}ms, then Ramp to {} in block {}.", new Object[]{this.getDisplayName(), waitTime, speedType, this.getBlockAt(endBlockIdx).getDisplayName()});
        }
        String blkName = this.getBlockAt(endBlockIdx).getDisplayName();
        if (_trace || log.isDebugEnabled()) {
            log.info(Bundle.getMessage("RampBegin", this.getTrainName(), reason, blkName, speedType, waitTime));
        }
    }

    protected void downRampBegun(int endBlockIdx) {
        OBlock block = this.getBlockAt(endBlockIdx + 1);
        this._rampBlkOccupied = block != null ? block.isOccupied() : true;
    }

    protected void downRampDone(boolean stop, boolean halted, String speedType, int endBlockIdx) {
        BlockOrder bo;
        OBlock block;
        if (this._idxCurrentOrder < endBlockIdx) {
            return;
        }
        int nextIdx = endBlockIdx + 1;
        if (nextIdx > 0 && nextIdx < this._orders.size() && (block = (bo = this.getBlockOrderAt(nextIdx)).getBlock()).isOccupied() && !this._rampBlkOccupied) {
            if (!this.checkForOverrun(block)) {
                Warrant w = block.getWarrant();
                this._overrun = true;
                if (w != null && !w.equals(this)) {
                    this._waitForWarrant = true;
                    this.setStoppingBlock(nextIdx);
                } else if (Stop.equals(BlockOrder.getPermissibleSpeedAt(bo))) {
                    this._waitForSignal = true;
                    this.setProtectingSignal(nextIdx);
                } else {
                    this._waitForBlock = true;
                }
            }
            this.makeOverrunMessage(bo);
        }
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="False assumption")
    private void makeOverrunMessage(BlockOrder curBlkOrder) {
        OBlock curBlock = curBlkOrder.getBlock();
        String name = null;
        if (this._waitForSignal) {
            NamedBean signal = curBlkOrder.getSignal();
            name = signal != null ? signal.getDisplayName() : curBlock.getDisplayName();
            this._overrun = true;
            String entrySpeedType = BlockOrder.getPermissibleSpeedAt(curBlkOrder);
            log.info(Bundle.getMessage(PROPERTY_SIGNAL_OVERRUN, this.getTrainName(), entrySpeedType, name));
            this.fireRunStatus(PROPERTY_SIGNAL_OVERRUN, name, entrySpeedType);
            return;
        }
        String bundleKey = null;
        if (this._waitForWarrant) {
            bundleKey = PROPERTY_WARRANT_OVERRUN;
            Warrant w = curBlock.getWarrant();
            if (w != null) {
                name = w.getDisplayName();
            }
        } else if (this._waitForBlock) {
            bundleKey = PROPERTY_OCCUPY_OVERRUN;
            name = (String)curBlock.getValue();
        }
        if (name == null) {
            name = Bundle.getMessage("unknownTrain");
        }
        if (bundleKey != null) {
            this._overrun = true;
            log.info(Bundle.getMessage(bundleKey, this.getTrainName(), curBlock.getDisplayName(), name));
            this.fireRunStatus(bundleKey, curBlock.getDisplayName(), name);
        } else {
            log.error("Train \"{}\" entered stopping block \"{}\" for unknown reason on warrant {}!", new Object[]{this.getTrainName(), curBlock.getDisplayName(), this.getDisplayName()});
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Warrant) {
            Warrant b = (Warrant)obj;
            DccLocoAddress addr = this._speedUtil.getDccAddress();
            if (addr == null) {
                if (b._speedUtil.getDccAddress() != null) {
                    return false;
                }
                return this.getSystemName().equals(b.getSystemName());
            }
            return this.getSystemName().equals(b.getSystemName()) && addr.equals(b._speedUtil.getDccAddress());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getSystemName().concat(this._speedUtil.getDccAddress().toString()).hashCode();
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getBlockingWarrant())) {
                report.add(new NamedBeanUsageReport("WarrantBlocking"));
            }
            this.getBlockOrders().forEach(blockOrder -> {
                if (bean.equals(blockOrder.getBlock())) {
                    report.add(new NamedBeanUsageReport("WarrantBlock"));
                }
                if (bean.equals(blockOrder.getSignal())) {
                    report.add(new NamedBeanUsageReport("WarrantSignal"));
                }
            });
        }
        return report;
    }

    private class CommandDelay
    extends Thread {
        String _speedType;
        long _waitTime = 0L;
        float _waitSpeed;
        boolean quit = false;
        int _endBlockIdx;

        CommandDelay(String speedType, long startWait, float waitSpeed, int endBlockIdx) {
            this._speedType = speedType;
            this._waitTime = startWait;
            this._waitSpeed = waitSpeed;
            this._endBlockIdx = endBlockIdx;
            this.setName("CommandDelay(" + Warrant.this.getTrainName() + "-" + speedType + ")");
        }

        boolean isDuplicate(String speedType, long startWait, int endBlockIdx) {
            return endBlockIdx == this._endBlockIdx && speedType.equals(this._speedType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"}, justification="notify never called on this thread")
        public void run() {
            CommandDelay commandDelay = this;
            synchronized (commandDelay) {
                block12: {
                    boolean ramping = Warrant.this._engineer.isRamping();
                    if (!ramping) {
                        try {
                            this.wait(this._waitTime);
                        }
                        catch (InterruptedException ie) {
                            if (!log.isDebugEnabled() || !this.quit) break block12;
                            log.debug("CommandDelay interrupt.  Ramp to {} not done. warrant {}", (Object)this._speedType, (Object)Warrant.this.getDisplayName());
                        }
                    } else {
                        for (long time = 0L; time <= this._waitTime && !(Warrant.this._engineer.getSpeedSetting() >= this._waitSpeed); time += 50L) {
                            try {
                                this.wait(100L);
                                continue;
                            }
                            catch (InterruptedException ie) {
                                if (!log.isDebugEnabled() || !this.quit) continue;
                                log.debug("CommandDelay interrupt. Ramp to {} not done. warrant {}", (Object)this._speedType, (Object)Warrant.this.getDisplayName());
                            }
                        }
                    }
                }
                if (!this.quit && Warrant.this._engineer != null) {
                    if (Warrant.this._noRamp) {
                        Warrant.this.setSpeedToType(this._speedType);
                    } else {
                        Warrant.this._engineer.rampSpeedTo(this._speedType, this._endBlockIdx);
                    }
                }
            }
            Warrant.this.endDelayCommand();
        }
    }

    public static enum SpeedState {
        STEADY_SPEED(1, "SteadySpeed"),
        RAMPING_DOWN(2, "RampingDown"),
        RAMPING_UP(3, "RampingUp");

        int _speedStateId;
        String _bundleKey;

        private SpeedState(int id, String bundleName) {
            this._speedStateId = id;
            this._bundleKey = bundleName;
        }

        public int getIntId() {
            return this._speedStateId;
        }

        public String toString() {
            return Bundle.getMessage(this._bundleKey);
        }
    }
}

