/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.SpeedStepMode;
import jmri.configurexml.StoreMenu;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.LearnThrottleFrame;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.RampData;
import jmri.jmrit.logix.SCWarrant;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantRoute;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.jmrit.logix.WarrantTableModel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantFrame
extends WarrantRoute {
    private int _rowHeight;
    private Warrant _warrant;
    private Warrant _saveWarrant;
    private ThrottleTableModel _commandModel;
    private JTable _commandTable;
    private JScrollPane _throttlePane;
    private Dimension _viewPortDim;
    private ArrayList<ThrottleSetting> _throttleCommands = new ArrayList();
    private long _startTime;
    private float _speedFactor;
    private float _speed;
    private long _TTP = 0L;
    private boolean _forward = true;
    private LearnThrottleFrame _learnThrottle = null;
    private static Color myGreen = new Color(0, 100, 0);
    private JTextField _sysNameBox;
    private JTextField _userNameBox;
    private JTabbedPane _tabbedPane;
    private JPanel _routePanel;
    private JPanel _commandPanel;
    private JPanel _parameterPanel;
    private final JRadioButton _isSCWarrant = new JRadioButton(Bundle.getMessage("SmallLayoutTrainAutomater"), false);
    private final JRadioButton _isWarrant = new JRadioButton(Bundle.getMessage("NormalWarrant"), true);
    private WarrantRoute.DisplayButton _speedUnits;
    private JLabel _unitsLabel;
    private float _speedConversion;
    private final JCheckBox _runForward = new JCheckBox(Bundle.getMessage("Forward"));
    private final JFormattedTextField _speedFactorTextField = new JFormattedTextField();
    private final JFormattedTextField _TTPtextField = new JFormattedTextField();
    private final JCheckBox _noRampBox = new JCheckBox();
    private final JCheckBox _shareRouteBox = new JCheckBox();
    private final JCheckBox _addTracker = new JCheckBox();
    private final JCheckBox _haltStartBox = new JCheckBox();
    private final JCheckBox _runETOnlyBox = new JCheckBox();
    private final JRadioButton _invisible = new JRadioButton();
    private final JTextField _statusBox = new JTextField(90);
    private final JRadioButton _showRoute = new JRadioButton(Bundle.getMessage("showRoute"), false);
    private final JRadioButton _showScript = new JRadioButton(Bundle.getMessage("showScript"), false);
    private final JTextField _searchStatus = new JTextField();
    private boolean _dirty = false;
    private long lastClicktime;
    static final String[] TRUE_FALSE = new String[]{ThrottleSetting.ValueType.VAL_TRUE.toString(), ThrottleSetting.ValueType.VAL_FALSE.toString()};
    static final String[] ON_OFF = new String[]{ThrottleSetting.ValueType.VAL_ON.toString(), ThrottleSetting.ValueType.VAL_OFF.toString()};
    static final String[] SENSOR_STATES = new String[]{ThrottleSetting.ValueType.VAL_ACTIVE.toString(), ThrottleSetting.ValueType.VAL_INACTIVE.toString()};
    private Point cellPt;
    private static DecimalFormat twoDigit = new DecimalFormat("0.00");
    private static final Logger log = LoggerFactory.getLogger(WarrantFrame.class);

    protected WarrantFrame(@Nonnull Warrant w) {
        this._saveWarrant = w;
        this._warrant = new Warrant(w.getSystemName(), w.getUserName());
        this.setup(this._saveWarrant, false);
        this.init();
        if (this._saveWarrant instanceof SCWarrant) {
            this._isSCWarrant.setSelected(true);
            this._showRoute.setSelected(true);
            this.showCommands(false);
        }
    }

    protected WarrantFrame(@CheckForNull Warrant startW, @CheckForNull Warrant endW) {
        WarrantManager mgr = InstanceManager.getDefault(WarrantManager.class);
        String sName = mgr.getAutoSystemName();
        while (mgr.getBySystemName(sName) != null) {
            mgr.updateAutoNumber(sName);
            sName = mgr.getAutoSystemName();
        }
        this._warrant = new Warrant(sName, null);
        if (startW != null) {
            if (endW != null) {
                WarrantTableFrame tf = WarrantTableFrame.getDefault();
                tf.setVisible(true);
                boolean includeAllCmds = tf.askStopQuestion(startW.getLastOrder().getBlock().getDisplayName());
                float entranceSpeed = this.setup(startW, !includeAllCmds);
                List<BlockOrder> orders = endW.getBlockOrders();
                BlockOrder bo = orders.get(0);
                bo.setExitName(endW.getfirstOrder().getExitName());
                for (int i = 1; i < orders.size(); ++i) {
                    this._orders.add(new BlockOrder(orders.get(i)));
                }
                this._destination.setOrder(endW.getLastOrder());
                if (this._via.getOrder() == null) {
                    this._via.setOrder(endW.getViaOrder());
                }
                if (this._avoid.getOrder() == null) {
                    this._avoid.setOrder(endW.getAvoidOrder());
                }
                float exitSpeed = 0.0f;
                OBlock bean = bo.getBlock();
                for (ThrottleSetting ts : endW.getThrottleCommands()) {
                    float speedSetting;
                    ListIterator<Float> iter;
                    if (includeAllCmds) {
                        this._throttleCommands.add(new ThrottleSetting(ts));
                        continue;
                    }
                    ThrottleSetting.Command cmd = ts.getCommand();
                    if (cmd.equals((Object)ThrottleSetting.Command.SPEED)) {
                        exitSpeed = ts.getValue().getFloat();
                        continue;
                    }
                    if (!cmd.equals((Object)ThrottleSetting.Command.NOOP) || ts.getBean().equals(bean)) continue;
                    includeAllCmds = true;
                    long et = this._speedUtil.getTimeForDistance(entranceSpeed, bo.getPathLength()) / 2;
                    RampData ramp = this._speedUtil.getRampForSpeedChange(entranceSpeed, exitSpeed);
                    String blockName = bean.getDisplayName();
                    if (ramp.isUpRamp()) {
                        iter = ramp.speedIterator(true);
                        while (iter.hasNext()) {
                            speedSetting = iter.next().floatValue();
                            this._throttleCommands.add(new ThrottleSetting(et, ThrottleSetting.Command.SPEED, -1, ThrottleSetting.ValueType.VAL_FLOAT, SpeedStepMode.UNKNOWN, speedSetting, "", blockName, this._speedUtil.getTrackSpeed(speedSetting)));
                            et = ramp.getRampTimeIncrement();
                        }
                    } else {
                        iter = ramp.speedIterator(false);
                        while (iter.hasPrevious()) {
                            speedSetting = iter.previous().floatValue();
                            this._throttleCommands.add(new ThrottleSetting(et, ThrottleSetting.Command.SPEED, -1, ThrottleSetting.ValueType.VAL_FLOAT, SpeedStepMode.UNKNOWN, speedSetting, "", blockName, this._speedUtil.getTrackSpeed(speedSetting)));
                            et = ramp.getRampTimeIncrement();
                        }
                    }
                    this._throttleCommands.add(new ThrottleSetting(ts));
                }
            } else {
                this.setup(startW, false);
            }
        }
        this.init();
    }

    private float setup(@Nonnull Warrant warrant, boolean omitLastBlockCmds) {
        this._origin.setOrder(warrant.getfirstOrder());
        this._destination.setOrder(warrant.getLastOrder());
        this._via.setOrder(warrant.getViaOrder());
        this._avoid.setOrder(warrant.getAvoidOrder());
        List<BlockOrder> list = warrant.getBlockOrders();
        this._orders = new ArrayList(list.size());
        for (BlockOrder blockOrder : list) {
            this._orders.add(new BlockOrder(blockOrder));
        }
        if (warrant instanceof SCWarrant) {
            this._speedFactor = ((SCWarrant)warrant).getSpeedFactor();
            this._TTP = ((SCWarrant)warrant).getTimeToPlatform();
            this._forward = ((SCWarrant)warrant).getForward();
        }
        float entranceSpeed = 0.0f;
        for (ThrottleSetting ts : warrant.getThrottleCommands()) {
            if (omitLastBlockCmds && !list.isEmpty()) {
                OBlock bean = list.get(list.size() - 1).getBlock();
                ThrottleSetting.Command cmd = ts.getCommand();
                if (cmd.equals((Object)ThrottleSetting.Command.SPEED)) {
                    entranceSpeed = ts.getValue().getFloat();
                }
                this._throttleCommands.add(new ThrottleSetting(ts));
                if (!cmd.equals((Object)ThrottleSetting.Command.NOOP) || !ts.getBean().equals(bean)) continue;
                break;
            }
            this._throttleCommands.add(new ThrottleSetting(ts));
        }
        this._shareRouteBox.setSelected(warrant.getShareRoute());
        this._warrant.setShareRoute(warrant.getShareRoute());
        this._addTracker.setSelected(warrant.getAddTracker());
        this._warrant.setAddTracker(warrant.getAddTracker());
        this._haltStartBox.setSelected(warrant.getHaltStart());
        this._warrant.setHaltStart(warrant.getHaltStart());
        this._noRampBox.setSelected(warrant.getNoRamp());
        this._warrant.setNoRamp(warrant.getNoRamp());
        this._runETOnlyBox.setSelected(warrant.getRunBlind());
        this._warrant.setRunBlind(warrant.getRunBlind());
        this.setTrainName(warrant.getTrainName());
        this._warrant.setTrainName(warrant.getTrainName());
        SpeedUtil speedUtil = warrant.getSpeedUtil();
        this.setSpeedUtil(this._warrant.getSpeedUtil());
        this._speedUtil.setDccAddress(speedUtil.getDccAddress());
        this._speedUtil.setRosterId(speedUtil.getRosterId());
        if (this._speedUtil.getDccAddress() != null) {
            this.setTrainInfo(warrant.getTrainName());
        } else {
            this.setTrainName(warrant.getTrainName());
        }
        return entranceSpeed;
    }

    private void init() {
        this._commandModel = new ThrottleTableModel();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.add((Component)this.makeTopPanel(), "North");
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addTab(Bundle.getMessage("MakeRoute"), this.makeFindRouteTabPanel());
        this._tabbedPane.addTab(Bundle.getMessage("RecordPlay"), this.makeSetPowerTabPanel());
        contentPane.add((Component)this._tabbedPane, "Center");
        contentPane.add((Component)this.makeEditableButtonPanel(), "South");
        if (this._orders != null && !this._orders.isEmpty()) {
            this._tabbedPane.setSelectedIndex(1);
        }
        if (!this._throttleCommands.isEmpty()) {
            this._showScript.setSelected(true);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (WarrantFrame.this.askClose()) {
                    WarrantTableAction.getDefault().closeWarrantFrame();
                }
            }
        });
        this.makeMenus();
        this.setTitle(Bundle.getMessage("editing", this._warrant.getDisplayName()));
        this.setContentPane(contentPane);
        this.setVisible(true);
        this._parameterPanel.setMaximumSize(this._parameterPanel.getPreferredSize());
        this._dirty = false;
        this.pack();
        this.getContentPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = (Component)e.getSource();
                int height = c.getHeight();
                WarrantFrame.this._viewPortDim.height = WarrantFrame.this._rowHeight * 10 + height - 541;
                WarrantFrame.this._throttlePane.getViewport().setPreferredSize(WarrantFrame.this._viewPortDim);
                WarrantFrame.this._throttlePane.invalidate();
                WarrantFrame.this._commandTable.invalidate();
            }
        });
        this.speedUnitsAction();
    }

    public boolean askClose() {
        if (this._dirty && JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("saveOrClose", this._warrant.getDisplayName()), Bundle.getMessage("QuestionTitle"), 0, 3) == 0 && !this.isRunning()) {
            this.save();
        }
        this._dirty = false;
        return true;
    }

    private JPanel makeTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(2 * STRUT_SIZE));
        JLabel sysNameLabel = new JLabel(Bundle.getMessage("LabelSystemName"));
        panel.add(sysNameLabel);
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        if (this._saveWarrant != null) {
            this._sysNameBox = new JTextField(this._saveWarrant.getSystemName());
            this._sysNameBox.setEditable(false);
            this._userNameBox = new JTextField(this._saveWarrant.getUserName());
        } else {
            this._sysNameBox = new JTextField(this._warrant.getSystemName());
            this._userNameBox = new JTextField(this._warrant.getUserName());
        }
        sysNameLabel.setLabelFor(this._sysNameBox);
        this._sysNameBox.setBackground(Color.white);
        panel.add(this._sysNameBox);
        panel.add(Box.createHorizontalStrut(2 * STRUT_SIZE));
        JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName"));
        userNameLabel.setLabelFor(this._userNameBox);
        panel.add(userNameLabel);
        panel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(this._userNameBox);
        panel.add(Box.createHorizontalStrut(2 * STRUT_SIZE));
        topPanel.add(panel);
        topPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        return topPanel;
    }

    private JPanel makeFindRouteTabPanel() {
        JPanel tab1 = new JPanel();
        tab1.setLayout(new BoxLayout(tab1, 2));
        tab1.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel topLeft = new JPanel();
        topLeft.setLayout(new BoxLayout(topLeft, 3));
        topLeft.add(this.makeBlockPanels(false));
        topLeft.add(Box.createVerticalStrut(2 * STRUT_SIZE));
        tab1.add(topLeft);
        tab1.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel topRight = new JPanel();
        topRight.setLayout(new BoxLayout(topRight, 2));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(Box.createVerticalStrut(2 * STRUT_SIZE));
        panel.add(this.calculatePanel(true));
        panel.add(Box.createVerticalStrut(2 * STRUT_SIZE));
        panel.add(this.searchDepthPanel(true));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.add(WarrantFrame.makeTextBoxPanel(true, this._searchStatus, "SearchRoute", null));
        this._searchStatus.setEditable(false);
        p.add(Box.createVerticalGlue());
        panel.add(p);
        this._searchStatus.setBackground(Color.white);
        this._searchStatus.setEditable(false);
        panel.add(Box.createRigidArea(new Dimension(10, topLeft.getPreferredSize().height - panel.getPreferredSize().height)));
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel.add(Box.createVerticalGlue());
        topRight.add(panel);
        topRight.add(Box.createHorizontalStrut(STRUT_SIZE));
        PickListModel<OBlock> pickListModel = PickListModel.oBlockPickModelInstance();
        topRight.add(new JScrollPane(pickListModel.makePickTable()));
        Dimension dim = topRight.getPreferredSize();
        topRight.setMinimumSize(dim);
        tab1.add(topRight);
        tab1.add(Box.createHorizontalStrut(STRUT_SIZE));
        return tab1;
    }

    private JPanel makeSetPowerTabPanel() {
        JPanel tab2 = new JPanel();
        tab2.setLayout(new BoxLayout(tab2, 3));
        tab2.add(this.makeTabMidPanel());
        this._parameterPanel = new JPanel();
        this._parameterPanel.setLayout(new BoxLayout(this._parameterPanel, 2));
        this._parameterPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        this._parameterPanel.add(this.makeBorderedTrainPanel());
        this._parameterPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel typePanel = this.makeTypePanel();
        JPanel edge = new JPanel();
        edge.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("SelectType"), 2, 2));
        edge.add(typePanel);
        this._parameterPanel.add(edge);
        this._parameterPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel scParamPanel = this.makeSCParamPanel();
        edge = new JPanel();
        edge.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("SetSCParameters"), 2, 2));
        edge.add(scParamPanel);
        this._parameterPanel.add(edge);
        this._parameterPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel learnPanel = this.makeRecordPanel();
        edge = new JPanel();
        edge.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("LearnMode"), 2, 2));
        edge.add(learnPanel);
        this._parameterPanel.add(edge);
        this._parameterPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel paramsPanel = this.makeRunParmsPanel();
        edge = new JPanel();
        edge.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("RunParameters"), 2, 2));
        edge.add(paramsPanel);
        this._parameterPanel.add(edge);
        this._parameterPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel runPanel = this.makePlaybackPanel();
        edge = new JPanel();
        edge.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("RunTrain"), 2, 2));
        edge.add(runPanel);
        this._parameterPanel.add(edge);
        this._parameterPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        this._parameterPanel.setPreferredSize(this._parameterPanel.getPreferredSize());
        tab2.add(this._parameterPanel);
        this._isSCWarrant.addActionListener(e -> {
            this.setPanelEnabled(scParamPanel, true);
            this.setPanelEnabled(learnPanel, false);
            this.setPanelEnabled(paramsPanel, false);
            this.setPanelEnabled(runPanel, false);
        });
        if (this._saveWarrant instanceof SCWarrant) {
            this.setPanelEnabled(scParamPanel, true);
            this.setPanelEnabled(learnPanel, false);
            this.setPanelEnabled(paramsPanel, false);
            this.setPanelEnabled(runPanel, false);
            this._isSCWarrant.setVisible(true);
        }
        this._isWarrant.addActionListener(e -> {
            this.setPanelEnabled(scParamPanel, false);
            this.setPanelEnabled(learnPanel, true);
            this.setPanelEnabled(paramsPanel, true);
            this.setPanelEnabled(runPanel, true);
        });
        JPanel panel = new JPanel();
        panel.add(WarrantFrame.makeTextBoxPanel(false, this._statusBox, "Status", null));
        this._statusBox.setEditable(false);
        this._statusBox.setMinimumSize(new Dimension(300, this._statusBox.getPreferredSize().height));
        this._statusBox.setMaximumSize(new Dimension(900, this._statusBox.getPreferredSize().height));
        panel.add(this._statusBox);
        tab2.add(panel);
        return tab2;
    }

    private void setPanelEnabled(@Nonnull JPanel panel, Boolean isEnabled) {
        Component[] components;
        panel.setEnabled(isEnabled);
        for (Component component : components = panel.getComponents()) {
            if (component == null) continue;
            if (component instanceof JPanel) {
                this.setPanelEnabled((JPanel)component, isEnabled);
            }
            component.setEnabled(isEnabled);
        }
    }

    private JPanel makeBorderedTrainPanel() {
        JPanel trainPanel = this.makeTrainIdPanel(null);
        JPanel edge = new JPanel();
        edge.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("SetPower"), 2, 2));
        edge.add(trainPanel);
        return edge;
    }

    private JPanel makeTypePanel() {
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 2));
        typePanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel wTypePanel = new JPanel();
        wTypePanel.setLayout(new BoxLayout(wTypePanel, 3));
        wTypePanel.add(Box.createVerticalStrut(STRUT_SIZE));
        ButtonGroup group = new ButtonGroup();
        group.add(this._isSCWarrant);
        group.add(this._isWarrant);
        this._isSCWarrant.setToolTipText(Bundle.getMessage("SCW_Tooltip"));
        this._isWarrant.setToolTipText(Bundle.getMessage("W_Tooltip"));
        wTypePanel.add(this._isSCWarrant);
        wTypePanel.add(this._isWarrant);
        typePanel.add(wTypePanel);
        return typePanel;
    }

    private void addSpeeds() {
        float speed = 0.0f;
        for (ThrottleSetting ts : this._throttleCommands) {
            ThrottleSetting.CommandValue cmdVal = ts.getValue();
            ThrottleSetting.ValueType valType = cmdVal.getType();
            switch (valType) {
                case VAL_FLOAT: {
                    speed = this._speedUtil.getTrackSpeed(cmdVal.getFloat());
                    break;
                }
                case VAL_TRUE: {
                    this._speedUtil.setIsForward(true);
                    break;
                }
                case VAL_FALSE: {
                    this._speedUtil.setIsForward(false);
                    break;
                }
            }
            ts.setTrackSpeed(speed);
        }
        this._commandModel.fireTableDataChanged();
        this.showCommands(true);
    }

    private JPanel makeSCParamPanel() {
        JPanel scParamPanel = new JPanel();
        scParamPanel.setLayout(new BoxLayout(scParamPanel, 3));
        scParamPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        scParamPanel.add(this._runForward);
        this._runForward.setSelected(this._forward);
        JPanel ttpPanel = new JPanel();
        ttpPanel.setLayout(new BoxLayout(ttpPanel, 2));
        JLabel ttp_l = new JLabel(Bundle.getMessage("TTP"));
        this._TTPtextField.setValue(this._TTP);
        this._TTPtextField.setColumns(6);
        ttp_l.setAlignmentX(0.0f);
        this._TTPtextField.setAlignmentX(1.0f);
        ttpPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        ttpPanel.add(ttp_l);
        ttpPanel.add(this._TTPtextField);
        ttpPanel.setToolTipText(Bundle.getMessage("TTPtoolTip"));
        scParamPanel.add(ttpPanel);
        JPanel sfPanel = new JPanel();
        sfPanel.setLayout(new BoxLayout(sfPanel, 2));
        JLabel sf_l = new JLabel(Bundle.getMessage("SF"));
        this._speedFactorTextField.setValue((long)(100.0f * this._speedFactor));
        this._speedFactorTextField.setColumns(3);
        sf_l.setAlignmentX(0.0f);
        this._speedFactorTextField.setAlignmentX(1.0f);
        sfPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        sfPanel.add(sf_l);
        sfPanel.add(this._speedFactorTextField);
        sfPanel.setToolTipText(Bundle.getMessage("sfToolTip"));
        scParamPanel.add(sfPanel);
        if (this._isWarrant.isSelected()) {
            this.setPanelEnabled(scParamPanel, false);
        }
        return scParamPanel;
    }

    private JPanel makeRecordPanel() {
        JPanel learnPanel = new JPanel();
        learnPanel.setLayout(new BoxLayout(learnPanel, 2));
        learnPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel startStopPanel = new JPanel();
        startStopPanel.setLayout(new BoxLayout(startStopPanel, 3));
        startStopPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        JButton startButton = new JButton(Bundle.getMessage("Start"));
        startButton.addActionListener(e -> {
            this.clearTempWarrant();
            this._tabbedPane.setSelectedIndex(1);
            this.showCommands(true);
            this.runLearnModeTrain();
        });
        JButton stopButton = new JButton(Bundle.getMessage("Stop"));
        stopButton.addActionListener(e -> this.stopRunTrain(false));
        startButton.setAlignmentX(0.5f);
        stopButton.setAlignmentX(0.5f);
        startStopPanel.add(startButton);
        startStopPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        startStopPanel.add(stopButton);
        startStopPanel.add(Box.createRigidArea(new Dimension(30 + stopButton.getPreferredSize().width, 10)));
        learnPanel.add(startStopPanel);
        return learnPanel;
    }

    private JPanel makeRunParmsPanel() {
        JPanel paramsPanel = new JPanel();
        paramsPanel.setLayout(new BoxLayout(paramsPanel, 2));
        paramsPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel.add(WarrantFrame.makeTextBoxPanel(this._shareRouteBox, "ShareRoute", "ToolTipShareRoute"));
        panel.add(WarrantFrame.makeTextBoxPanel(this._addTracker, "AddTracker", "ToolTipAddTracker"));
        panel.add(WarrantFrame.makeTextBoxPanel(this._noRampBox, "NoRamping", "ToolTipNoRamping"));
        panel.add(WarrantFrame.makeTextBoxPanel(this._haltStartBox, "HaltAtStart", null));
        panel.add(WarrantFrame.makeTextBoxPanel(this._runETOnlyBox, "RunETOnly", "ToolTipRunETOnly"));
        paramsPanel.add(panel);
        return paramsPanel;
    }

    private JPanel makePlaybackPanel() {
        JPanel runPanel = new JPanel();
        runPanel.setLayout(new BoxLayout(runPanel, 2));
        runPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        runPanel.add(panel);
        runPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JRadioButton run = new JRadioButton(Bundle.getMessage("ARun"), false);
        JRadioButton halt = new JRadioButton(Bundle.getMessage("Stop"), false);
        JRadioButton resume = new JRadioButton(Bundle.getMessage("Resume"), false);
        JRadioButton eStop = new JRadioButton(Bundle.getMessage("EStop"), false);
        JRadioButton abort = new JRadioButton(Bundle.getMessage("Abort"), false);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        ButtonGroup group = new ButtonGroup();
        group.add(run);
        group.add(halt);
        group.add(resume);
        group.add(eStop);
        group.add(abort);
        group.add(this._invisible);
        panel.add(run);
        panel.add(halt);
        panel.add(resume);
        panel.add(eStop);
        panel.add(abort);
        runPanel.add(panel);
        run.addActionListener(e -> this.runTrain());
        halt.addActionListener(e -> this.doControlCommand(1));
        resume.addActionListener(e -> this.doControlCommand(2));
        eStop.addActionListener(e -> this.doControlCommand(5));
        abort.addActionListener(e -> this.doControlCommand(3));
        runPanel.add(panel);
        return runPanel;
    }

    private JPanel makeTabMidPanel() {
        JPanel midPanel = new JPanel();
        midPanel.setLayout(new BoxLayout(midPanel, 3));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 2));
        tablePanel.add(Box.createHorizontalStrut(5));
        this._routePanel = this.makeRouteTablePanel();
        tablePanel.add(this._routePanel);
        tablePanel.add(this.makeThrottleTablePanel());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        ButtonGroup group = new ButtonGroup();
        group.add(this._showRoute);
        group.add(this._showScript);
        buttonPanel.add(this._showRoute);
        buttonPanel.add(this._showScript);
        boolean show = !this._throttleCommands.isEmpty();
        this.showCommands(show);
        this._showScript.setSelected(show);
        this._showRoute.addActionListener(e -> this.showCommands(false));
        this._showScript.addActionListener(e -> this.showCommands(true));
        if (this._saveWarrant != null && this._saveWarrant instanceof SCWarrant) {
            this._showRoute.setSelected(true);
            this.showCommands(false);
            this.setPanelEnabled(buttonPanel, false);
        }
        this._isSCWarrant.addActionListener(e -> {
            this._showRoute.setSelected(true);
            this.showCommands(false);
            this.setPanelEnabled(buttonPanel, false);
        });
        this._isWarrant.addActionListener(e -> this.setPanelEnabled(buttonPanel, true));
        midPanel.add(buttonPanel);
        midPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        midPanel.add(tablePanel);
        midPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        return midPanel;
    }

    private void showCommands(boolean setCmds) {
        this._routePanel.setVisible(!setCmds);
        this._commandPanel.setVisible(setCmds);
    }

    private void speedUnitsAction() {
        switch (this._displayPref) {
            case MPH: {
                this._displayPref = WarrantRoute.Display.KPH;
                this._speedConversion = this._scale * 3.6f;
                this.setFormatter("kph");
                break;
            }
            case KPH: {
                this._displayPref = WarrantRoute.Display.MMPS;
                this._speedConversion = 1000.0f;
                this._unitsLabel.setText(Bundle.getMessage("trackSpeed"));
                this.setFormatter("mmps");
                break;
            }
            case MMPS: {
                this._displayPref = WarrantRoute.Display.INPS;
                this._speedConversion = 39.37f;
                this.setFormatter("inps");
                break;
            }
            default: {
                this._displayPref = WarrantRoute.Display.MPH;
                this._speedConversion = 2.23694f * this._scale;
                this._unitsLabel.setText(Bundle.getMessage("scaleSpeed"));
                this.setFormatter("mph");
            }
        }
        this._speedUnits.setDisplayPref(this._displayPref);
        this.addSpeeds();
    }

    private void setFormatter(String title) {
        JTableHeader header = this._commandTable.getTableHeader();
        TableColumnModel colMod = header.getColumnModel();
        TableColumn tabCol = colMod.getColumn(5);
        tabCol.setHeaderValue(Bundle.getMessage(title));
        header.repaint();
    }

    private JPanel makeThrottleTablePanel() {
        this._commandTable = new JTable(this._commandModel);
        DefaultCellEditor ed = (DefaultCellEditor)this._commandTable.getDefaultEditor(String.class);
        ed.setClickCountToStart(1);
        TableColumnModel columnModel = this._commandTable.getColumnModel();
        for (int i = 0; i < this._commandModel.getColumnCount(); ++i) {
            int width = this._commandModel.getPreferredWidth(i);
            columnModel.getColumn(i).setPreferredWidth(width);
        }
        TableColumn cmdColumn = columnModel.getColumn(2);
        cmdColumn.setCellEditor(new CommandCellEditor(new JComboBox<ThrottleSetting.Command>()));
        cmdColumn.setCellRenderer(new CommandCellRenderer());
        cmdColumn.setMinWidth(40);
        TableColumn valueColumn = columnModel.getColumn(3);
        valueColumn.setCellEditor(new ValueCellEditor(new JTextField()));
        this._throttlePane = new JScrollPane(this._commandTable);
        this._viewPortDim = this._commandTable.getPreferredSize();
        this._rowHeight = this._commandTable.getRowHeight();
        this._viewPortDim.height = this._rowHeight * 10;
        this._throttlePane.getViewport().setPreferredSize(this._viewPortDim);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.add(Box.createVerticalStrut(2 * STRUT_SIZE));
        JButton insertButton = new JButton(Bundle.getMessage("buttonInsertRow"));
        insertButton.addActionListener(e -> this.insertRow());
        buttonPanel.add(insertButton);
        buttonPanel.add(Box.createVerticalStrut(2 * STRUT_SIZE));
        JButton deleteButton = new JButton(Bundle.getMessage("buttonDeleteRow"));
        deleteButton.addActionListener(e -> this.deleteRow());
        buttonPanel.add(deleteButton);
        buttonPanel.add(Box.createVerticalStrut(2 * STRUT_SIZE));
        this._unitsLabel = this._displayPref.equals((Object)WarrantRoute.Display.MMPS) || this._displayPref.equals((Object)WarrantRoute.Display.INPS) ? new JLabel(Bundle.getMessage("trackSpeed")) : new JLabel(Bundle.getMessage("scaleSpeed"));
        this._unitsLabel.setHorizontalAlignment(0);
        this._speedUnits = new WarrantRoute.DisplayButton(this._displayPref);
        FontMetrics fm = this._speedUnits.getFontMetrics(this._speedUnits.getFont());
        int width = Math.max(fm.stringWidth(WarrantRoute.Display.KPH.toString()), Math.max(fm.stringWidth(WarrantRoute.Display.MPH.toString()), fm.stringWidth(WarrantRoute.Display.MMPS.toString())));
        Dimension d = this._speedUnits.getPreferredSize();
        d.width = width + 40;
        this._speedUnits.setMaximumSize(d);
        this._speedUnits.setMinimumSize(d);
        this._speedUnits.setPreferredSize(d);
        this._speedUnits.addActionListener(evt -> this.speedUnitsAction());
        buttonPanel.add(this._unitsLabel);
        buttonPanel.add(this._speedUnits);
        this._commandPanel = new JPanel();
        this._commandPanel.setLayout(new BoxLayout(this._commandPanel, 3));
        JLabel title = new JLabel(Bundle.getMessage("CommandTableTitle"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        JPanel p = new JPanel();
        p.add(this._throttlePane);
        panel.add(p);
        buttonPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        panel.add(buttonPanel);
        buttonPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        this._commandPanel.add(title);
        this._commandPanel.add(panel);
        this._commandPanel.add(Box.createGlue());
        this._displayPref = WarrantRoute.Display.KPH;
        return this._commandPanel;
    }

    private void insertRow() {
        int row = this._commandTable.getSelectedRow();
        if (row < 0) {
            this.showWarning(Bundle.getMessage("selectRow"));
            return;
        }
        this._throttleCommands.add(++row, new ThrottleSetting());
        this._commandModel.fireTableDataChanged();
        this._commandTable.setRowSelectionInterval(row, row);
    }

    private void deleteRow() {
        int row = this._commandTable.getSelectedRow();
        if (row < 0) {
            this.showWarning(Bundle.getMessage("selectRow"));
            return;
        }
        ThrottleSetting cmd = this._throttleCommands.get(row);
        if (cmd != null && cmd.getCommand() != null) {
            if (cmd.getCommand().equals((Object)ThrottleSetting.Command.NOOP)) {
                this.showWarning(Bundle.getMessage("cannotDeleteNoop"));
                return;
            }
            long time = cmd.getTime();
            if (row + 1 < this._throttleCommands.size()) {
                this._throttleCommands.get(row + 1).setTime(time += this._throttleCommands.get(row + 1).getTime());
            }
        }
        this._throttleCommands.remove(row);
        this._dirty = true;
        this._commandModel.fireTableDataChanged();
    }

    private JPanel makeEditableButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(Box.createHorizontalStrut(10 * STRUT_SIZE));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        saveButton.addActionListener(e -> {
            if (this.save()) {
                WarrantTableAction.getDefault().closeWarrantFrame();
            }
        });
        panel.add(saveButton);
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        buttonPanel.add(panel);
        buttonPanel.add(Box.createHorizontalStrut(3 * STRUT_SIZE));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JButton copyButton = new JButton(Bundle.getMessage("ButtonCopy"));
        copyButton.addActionListener(e -> WarrantTableAction.getDefault().makeWarrantFrame(this._saveWarrant, null));
        panel.add(copyButton);
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        buttonPanel.add(panel);
        buttonPanel.add(Box.createHorizontalStrut(3 * STRUT_SIZE));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(e -> this.close());
        panel.add(cancelButton);
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        buttonPanel.add(panel);
        buttonPanel.add(Box.createHorizontalStrut(3 * STRUT_SIZE));
        buttonPanel.add(Box.createHorizontalGlue());
        return buttonPanel;
    }

    private void doControlCommand(int cmd) {
        int runMode;
        if (log.isDebugEnabled()) {
            log.debug("actionPerformed on doControlCommand  cmd= {}", (Object)cmd);
        }
        if ((runMode = this._warrant.getRunMode()) == 0) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NotRunning", this._warrant.getDisplayName()), Bundle.getMessage("WarningTitle"), 2);
        } else if (runMode == 1 && cmd != 3) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LearnInvalidControl", this._warrant.getDisplayName()), Bundle.getMessage("WarningTitle"), 2);
        } else {
            this._warrant.controlRunTrain(cmd);
        }
        this._invisible.setSelected(true);
    }

    private void makeMenus() {
        this.setTitle(Bundle.getMessage("TitleWarrant", this._warrant.getDisplayName()));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        fileMenu.add(new StoreMenu());
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.logix.CreateEditWarrant", true);
    }

    private void clearCommands() {
        this._throttleCommands = new ArrayList();
        this._commandModel.fireTableDataChanged();
        this._searchStatus.setText("");
    }

    @Override
    protected void selectedRoute(ArrayList<BlockOrder> orders) {
        this.clearCommands();
        this._tabbedPane.setSelectedIndex(1);
    }

    private String checkTrainId() {
        String msg = this.setAddress();
        if (msg == null) {
            msg = this.routeIsValid();
        }
        if (msg == null) {
            this._warrant.setBlockOrders(this.getOrders());
            msg = this._warrant.checkforTrackers();
        }
        if (msg == null) {
            msg = this.checkLocoAddress();
        }
        return msg;
    }

    private String checkThrottleCommands() {
        if (this._throttleCommands.size() <= this.getOrders().size() + 1) {
            return Bundle.getMessage("NoCommands", this._warrant.getDisplayName());
        }
        float lastSpeed = 0.0f;
        block10: for (int i = 0; i < this._throttleCommands.size(); ++i) {
            ThrottleSetting ts = this._throttleCommands.get(i);
            ThrottleSetting.Command cmd = ts.getCommand();
            ThrottleSetting.CommandValue val = ts.getValue();
            if (val == null || cmd == null) {
                return Bundle.getMessage("BadThrottleSetting", i + 1);
            }
            ThrottleSetting.ValueType valType = val.getType();
            if (valType == null) {
                return Bundle.getMessage("BadThrottleSetting", i + 1);
            }
            switch (cmd) {
                case SPEED: {
                    OBlock blk;
                    if (valType != ThrottleSetting.ValueType.VAL_FLOAT) {
                        return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                    }
                    lastSpeed = ts.getValue().getFloat();
                    if (lastSpeed > 1.0f) {
                        return Bundle.getMessage("badSpeed", Float.valueOf(lastSpeed));
                    }
                    if (!(lastSpeed < 0.0f) || (blk = this.getOrders().get(this.getOrders().size() - 1).getBlock()).getSystemName().equals(ts.getBeanSystemName())) continue block10;
                    return Bundle.getMessage("badSpeed", Float.valueOf(lastSpeed));
                }
                case NOOP: {
                    if (valType == ThrottleSetting.ValueType.VAL_NOOP) continue block10;
                    return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                }
                case FORWARD: {
                    if (valType == ThrottleSetting.ValueType.VAL_TRUE || valType == ThrottleSetting.ValueType.VAL_FALSE) continue block10;
                    return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                }
                case FKEY: 
                case LATCHF: {
                    if (valType == ThrottleSetting.ValueType.VAL_ON || valType == ThrottleSetting.ValueType.VAL_OFF) continue block10;
                    return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                }
                case SET_SENSOR: 
                case WAIT_SENSOR: {
                    if (valType != ThrottleSetting.ValueType.VAL_ACTIVE && valType != ThrottleSetting.ValueType.VAL_INACTIVE) {
                        return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                    }
                    String msg = ts.getBeanDisplayName();
                    if (msg == null) {
                        return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                    }
                    msg = WarrantFrame.checkBeanName(cmd, ts.getBeanDisplayName());
                    if (msg == null) continue block10;
                    return msg + "\n" + Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                }
                case RUN_WARRANT: {
                    if (valType != ThrottleSetting.ValueType.VAL_INT) {
                        return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                    }
                    String msg = ts.getBeanDisplayName();
                    if (msg == null) {
                        return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                    }
                    msg = WarrantFrame.checkBeanName(cmd, ts.getBeanDisplayName());
                    if (msg == null) continue block10;
                    return msg + "\n" + Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                }
                case SPEEDSTEP: {
                    if (valType == ThrottleSetting.ValueType.VAL_STEP) continue block10;
                    return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                }
                case SET_MEMORY: {
                    if (valType != ThrottleSetting.ValueType.VAL_TEXT) {
                        return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                    }
                    String msg = ts.getBeanDisplayName();
                    if (msg == null) {
                        return Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                    }
                    msg = WarrantFrame.checkBeanName(cmd, ts.getBeanDisplayName());
                    if (msg == null) continue block10;
                    return msg + "\n" + Bundle.getMessage("badThrottleCommand", i + 1, cmd.toString(), valType.toString());
                }
                default: {
                    return Bundle.getMessage("BadThrottleSetting", i + 1);
                }
            }
        }
        if (lastSpeed > 0.0f) {
            return Bundle.getMessage("BadLastSpeed", Float.valueOf(lastSpeed));
        }
        return null;
    }

    static String checkBeanName(ThrottleSetting.Command command, String beanName) {
        switch (command) {
            case SET_SENSOR: 
            case WAIT_SENSOR: {
                if (InstanceManager.sensorManagerInstance().getSensor(beanName) != null) break;
                return Bundle.getMessage("BadSensor", beanName);
            }
            case RUN_WARRANT: {
                if (InstanceManager.getDefault(WarrantManager.class).getWarrant(beanName) != null) break;
                return Bundle.getMessage("BadWarrant", beanName);
            }
            case SET_MEMORY: {
                if (InstanceManager.getDefault(MemoryManager.class).getMemory(beanName) != null) break;
                return Bundle.getMessage("BadMemory", beanName);
            }
            default: {
                if (InstanceManager.getDefault(OBlockManager.class).getOBlock(beanName) != null) break;
                return Bundle.getMessage("BlockNotFound", beanName);
            }
        }
        return null;
    }

    private void runLearnModeTrain() {
        this._warrant.setSpeedUtil(this._speedUtil);
        String msg = null;
        if (this.isRunning()) {
            msg = Bundle.getMessage("CannotRun", this._warrant.getDisplayName(), Bundle.getMessage("TrainRunning", this._warrant.getTrainName()));
        }
        if (msg == null) {
            this._warrant.setBlockOrders(this.getOrders());
            msg = this.checkTrainId();
        }
        if (msg == null) {
            msg = this._warrant.checkRoute();
        }
        if (msg == null) {
            msg = WarrantTableFrame.getDefault().getModel().checkAddressInUse(this._warrant);
        }
        if (msg == null) {
            msg = this._warrant.allocateRoute(false, this.getOrders());
        }
        this.toFront();
        if (msg != null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LearnError", msg), Bundle.getMessage("WarningTitle"), 2);
            this._warrant.deAllocate();
            this.setStatus(msg, Color.red);
            return;
        }
        if (!this._throttleCommands.isEmpty()) {
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("deleteCommand"), Bundle.getMessage("QuestionTitle"), 0, 3) != 0) {
                return;
            }
            this._throttleCommands = new ArrayList();
            this._commandModel.fireTableDataChanged();
        }
        if ((msg = this._warrant.checkStartBlock()) != null) {
            if (msg.equals("warnStart")) {
                msg = Bundle.getMessage("warnStart", this.getTrainName(), this._warrant.getCurrentBlockName());
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
                this.setStatus(msg, Color.red);
                return;
            }
            if (msg.equals("BlockDark")) {
                msg = Bundle.getMessage("BlockDark", this._warrant.getCurrentBlockName(), this.getTrainName());
                if (0 != JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("OkToRun", msg), Bundle.getMessage("QuestionTitle"), 0, 2)) {
                    this.stopRunTrain(true);
                    this.setStatus(msg, Color.red);
                    return;
                }
            }
            this.setStatus(msg, Color.black);
        }
        if (this._learnThrottle == null) {
            this._learnThrottle = new LearnThrottleFrame(this);
        } else {
            this._learnThrottle.setVisible(true);
        }
        this._warrant.setTrainName(this.getTrainName());
        this._startTime = System.currentTimeMillis();
        this._speed = 0.0f;
        this._warrant.addPropertyChangeListener(this);
        msg = this._warrant.setRunMode(1, this._speedUtil.getDccAddress(), this._learnThrottle, this._throttleCommands, this._runETOnlyBox.isSelected());
        if (msg != null) {
            this.stopRunTrain(true);
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
            this.setStatus(msg, Color.red);
        }
    }

    protected void runTrain() {
        long time = System.currentTimeMillis();
        if (time - this.lastClicktime < 1000L) {
            return;
        }
        this.lastClicktime = time;
        this._warrant.setSpeedUtil(this._speedUtil);
        String msg = null;
        if (this.isRunning()) {
            msg = Bundle.getMessage("CannotRun", this._warrant.getDisplayName(), Bundle.getMessage("TrainRunning", this._warrant.getTrainName()));
        }
        if (msg == null) {
            this._warrant.setTrainName(this.getTrainName());
            this._warrant.setShareRoute(this._shareRouteBox.isSelected());
            this._warrant.setAddTracker(this._addTracker.isSelected());
            this._warrant.setHaltStart(this._haltStartBox.isSelected());
            this._warrant.setNoRamp(this._noRampBox.isSelected());
        }
        if (msg == null) {
            msg = this.checkTrainId();
        }
        if (msg == null && (msg = this.checkThrottleCommands()) == null && !this._warrant.hasRouteSet() && this._runETOnlyBox.isSelected()) {
            msg = Bundle.getMessage("BlindRouteNotSet", this._warrant.getDisplayName());
        }
        if (msg == null) {
            WarrantTableModel model = WarrantTableFrame.getDefault().getModel();
            msg = model.checkAddressInUse(this._warrant);
        }
        if (msg != null) {
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
            this.setStatus(msg, Color.black);
            return;
        }
        if (this._warrant.getRunMode() != 0) {
            return;
        }
        this._warrant.addPropertyChangeListener(this);
        msg = this._warrant.setRunMode(2, this._speedUtil.getDccAddress(), null, this._throttleCommands, this._runETOnlyBox.isSelected());
        if (msg != null) {
            this.clearWarrant();
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
            this.setStatus(msg, Color.red);
            return;
        }
        msg = this._warrant.checkStartBlock();
        if (msg != null) {
            if (msg.equals("warnStart")) {
                msg = Bundle.getMessage("warnStart", this._warrant.getTrainName(), this._warrant.getCurrentBlockName());
            } else if (msg.equals("BlockDark")) {
                msg = Bundle.getMessage("BlockDark", this._warrant.getCurrentBlockName(), this._warrant.getTrainName());
            }
            if (0 != JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("OkToRun", msg), Bundle.getMessage("QuestionTitle"), 0, 2)) {
                this.clearWarrant();
                this.setStatus(msg, Color.red);
            } else {
                this.setStatus(this._warrant.getRunningMessage(), myGreen);
            }
        }
    }

    private void stopRunTrain(boolean aborted) {
        BlockOrder bo;
        List<BlockOrder> orders;
        if (this._learnThrottle != null) {
            this._learnThrottle.dispose();
            this._learnThrottle = null;
        }
        if (this._warrant == null) {
            return;
        }
        if (this._warrant.getRunMode() == 1 && (orders = this.getOrders()) != null && orders.size() > 1 && (bo = this._warrant.getCurrentBlockOrder()) != null) {
            OBlock currentBlock;
            OBlock lastBlock = orders.get(orders.size() - 1).getBlock();
            if (!lastBlock.equals(currentBlock = bo.getBlock())) {
                if ((lastBlock.getState() & 0x100) != 0 && currentBlock.equals(orders.get(orders.size() - 2).getBlock())) {
                    this.setThrottleCommand("NoOp", Bundle.getMessage("Mark"), lastBlock.getDisplayName());
                    this.setStatus(Bundle.getMessage("LearningStop"), myGreen);
                } else if (!aborted) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("IncompleteScript", lastBlock), Bundle.getMessage("WarningTitle"), 2);
                }
            } else {
                this.setStatus(Bundle.getMessage("LearningStop"), myGreen);
            }
        }
        this.clearWarrant();
    }

    private void clearWarrant() {
        if (this._warrant != null) {
            this._warrant.stopWarrant(false, true);
            this._warrant.removePropertyChangeListener(this);
        }
    }

    protected Warrant getWarrant() {
        return this._warrant;
    }

    private void setStatus(String msg, Color c) {
        ThreadingUtil.runOnGUIEventually(() -> {
            this._statusBox.setForeground(c);
            this._statusBox.setText(msg);
        });
    }

    @Override
    protected void maxThrottleEventAction() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (property.equals("DnDrop")) {
            this.doAction(e.getSource());
        } else if (e.getSource() instanceof Warrant && this._warrant.equals(e.getSource())) {
            if (log.isDebugEnabled()) {
                log.debug("propertyChange \"{}\" old= {} new= {} source= {}", new Object[]{property, e.getOldValue(), e.getNewValue(), e.getSource().getClass().getName()});
            }
            String msg = null;
            Color color = myGreen;
            block0 : switch (this._warrant.getRunMode()) {
                case 0: {
                    this._warrant.removePropertyChangeListener(this);
                    if (!property.equals("StopWarrant")) break;
                    String blkName = (String)e.getOldValue();
                    String bundleKey = (String)e.getNewValue();
                    if (blkName == null) {
                        msg = Bundle.getMessage(bundleKey, this._warrant.getTrainName(), this._warrant.getDisplayName());
                        color = Color.red;
                        break;
                    }
                    msg = Bundle.getMessage(bundleKey, this._warrant.getTrainName(), this._warrant.getDisplayName(), blkName);
                    color = myGreen;
                    break;
                }
                case 1: {
                    switch (property) {
                        case "blockChange": {
                            OBlock oldBlock = (OBlock)e.getOldValue();
                            OBlock newBlock = (OBlock)e.getNewValue();
                            if (newBlock == null) {
                                this.stopRunTrain(true);
                                msg = Bundle.getMessage("ChangedRoute", this._warrant.getTrainName(), oldBlock.getDisplayName(), this._warrant.getDisplayName());
                                color = Color.red;
                                break block0;
                            }
                            this.setThrottleCommand("NoOp", Bundle.getMessage("Mark"), ((OBlock)e.getNewValue()).getDisplayName());
                            msg = Bundle.getMessage("TrackerBlockEnter", this._warrant.getTrainName(), newBlock.getDisplayName());
                            break block0;
                        }
                        case "abortLearn": {
                            this.stopRunTrain(true);
                            int oldIdx = (Integer)e.getOldValue();
                            int newIdx = (Integer)e.getNewValue();
                            if (oldIdx > newIdx) {
                                msg = Bundle.getMessage("LearnAbortOccupied", this._warrant.getBlockAt(oldIdx), this._warrant.getDisplayName());
                                color = Color.red;
                                break block0;
                            }
                            msg = Bundle.getMessage("warrantAbort", this._warrant.getTrainName(), this._warrant.getDisplayName());
                            color = Color.red;
                            break block0;
                        }
                    }
                    msg = Bundle.getMessage("Learning", this._warrant.getCurrentBlockName());
                    color = Color.black;
                    break;
                }
                case 2: 
                case 3: {
                    if (e.getPropertyName().equals("blockChange")) {
                        OBlock oldBlock = (OBlock)e.getOldValue();
                        OBlock newBlock = (OBlock)e.getNewValue();
                        if (newBlock == null) {
                            msg = Bundle.getMessage("ChangedRoute", this._warrant.getTrainName(), oldBlock.getDisplayName(), this._warrant.getDisplayName());
                            color = Color.red;
                            break;
                        }
                        msg = Bundle.getMessage("TrackerBlockEnter", this._warrant.getTrainName(), newBlock.getDisplayName());
                        break;
                    }
                    if (e.getPropertyName().equals("ReadyToRun")) {
                        msg = this._warrant.getRunningMessage();
                        break;
                    }
                    if (e.getPropertyName().equals("SpeedChange")) {
                        msg = this._warrant.getRunningMessage();
                        color = Color.black;
                        break;
                    }
                    if (property.equals("SignalOverrun")) {
                        String name = (String)e.getOldValue();
                        String speed = (String)e.getNewValue();
                        msg = Bundle.getMessage("SignalOverrun", this._warrant.getTrainName(), speed, name);
                        color = Color.red;
                        break;
                    }
                    if (property.equals("OccupyOverrun")) {
                        String blockName = (String)e.getOldValue();
                        OBlock occuppier = (OBlock)e.getNewValue();
                        msg = Bundle.getMessage("OccupyOverrun", this._warrant.getTrainName(), blockName, occuppier);
                        color = Color.red;
                        break;
                    }
                    if (property.equals("WarrantOverrun")) {
                        String blkName = (String)e.getOldValue();
                        OBlock warName = (OBlock)e.getNewValue();
                        msg = Bundle.getMessage("WarrantOverrun", this._warrant.getTrainName(), blkName, warName);
                        color = Color.red;
                        break;
                    }
                    if (e.getPropertyName().equals("WarrantStart")) {
                        msg = Bundle.getMessage("warrantStart", this._warrant.getTrainName(), this._warrant.getDisplayName(), this._warrant.getCurrentBlockName());
                        if (this._warrant.getState() != 1) break;
                        JmriJOptionPane.showMessageDialog(this, this._warrant.getRunningMessage(), Bundle.getMessage("WarningTitle"), 2);
                        break;
                    }
                    if (e.getPropertyName().equals("controlChange")) {
                        int newCntrl = (Integer)e.getNewValue();
                        msg = Bundle.getMessage("controlChange", this._warrant.getTrainName(), Bundle.getMessage(Warrant.CNTRL_CMDS[newCntrl]), this._warrant.getCurrentBlockName());
                        color = Color.black;
                        break;
                    }
                    if (e.getPropertyName().equals("throttleFail")) {
                        msg = Bundle.getMessage("ThrottleFail", this._warrant.getTrainName(), e.getNewValue());
                        color = Color.red;
                        break;
                    }
                    return;
                }
            }
            this.setStatus(msg, color);
        }
        this.invalidate();
    }

    protected void setThrottleCommand(String cmd, String value) {
        String bName = Bundle.getMessage("NoBlock");
        BlockOrder bo = this._warrant.getCurrentBlockOrder();
        if (bo != null) {
            bName = bo.getBlock().getDisplayName();
        }
        this.setThrottleCommand(cmd, value, bName);
    }

    protected void setSpeedCommand(float speed) {
        this._speed = this._warrant.getSpeedUtil().profileHasSpeedInfo() ? this._warrant.getSpeedUtil().getTrackSpeed(speed) : 0.0f;
        this.setThrottleCommand("speed", Float.toString(speed));
    }

    private void setThrottleCommand(String cmd, String value, String bName) {
        long endTime = System.currentTimeMillis();
        long time = endTime - this._startTime;
        this._startTime = endTime;
        ThrottleSetting ts = new ThrottleSetting(time, cmd, value, bName, this._speed);
        log.debug("setThrottleCommand= {}", (Object)ts);
        this._throttleCommands.add(ts);
        this._commandModel.fireTableDataChanged();
        this.scrollCommandTable(this._commandModel.getRowCount());
    }

    private void scrollCommandTable(int row) {
        JScrollBar bar = this._throttlePane.getVerticalScrollBar();
        bar.setValue(row * this._rowHeight);
        bar.invalidate();
    }

    protected boolean isRunning() {
        return this._warrant._runMode != 0 || this._saveWarrant != null && this._saveWarrant._runMode != 0;
    }

    private boolean save() {
        boolean fatal = false;
        String msg = null;
        if (this.isRunning()) {
            msg = Bundle.getMessage("CannotEdit", this._warrant.getDisplayName());
        }
        if (msg == null) {
            msg = this.routeIsValid();
        }
        if (msg != null) {
            msg = Bundle.getMessage("SaveError", msg);
            fatal = true;
        }
        if (msg == null) {
            msg = this.checkLocoAddress();
        }
        if (msg == null && !this._isSCWarrant.isSelected() && (msg = this.checkThrottleCommands()) != null) {
            msg = Bundle.getMessage("BadData", msg);
            fatal = true;
        }
        WarrantManager mgr = InstanceManager.getDefault(WarrantManager.class);
        if (msg == null) {
            if (this._saveWarrant != null) {
                if (this._saveWarrant instanceof SCWarrant && !this._isSCWarrant.isSelected() || !(this._saveWarrant instanceof SCWarrant) && this._isSCWarrant.isSelected()) {
                    mgr.deregister(this._saveWarrant);
                    this._warrant = mgr.createNewWarrant(this._sysNameBox.getText(), this._userNameBox.getText(), this._isSCWarrant.isSelected(), (Long)this._TTPtextField.getValue());
                } else {
                    String uName = this._userNameBox.getText();
                    if (uName.length() > 0 && !uName.equals(this._saveWarrant.getUserName()) && mgr.getWarrant(uName) != null) {
                        fatal = true;
                        msg = Bundle.getMessage("WarrantExists", this._userNameBox.getText());
                    } else {
                        this._warrant = this._saveWarrant;
                    }
                }
            } else if (this._warrant == null) {
                this._warrant = mgr.createNewWarrant(this._sysNameBox.getText(), this._userNameBox.getText(), this._isSCWarrant.isSelected(), (Long)this._TTPtextField.getValue());
            }
        }
        if (this._warrant == null) {
            msg = this._userNameBox.getText().length() > 0 && mgr.getByUserName(this._userNameBox.getText()) != null ? Bundle.getMessage("WarrantExists", this._userNameBox.getText()) : (mgr.getBySystemName(this._sysNameBox.getText()) != null ? Bundle.getMessage("WarrantExists", this._sysNameBox.getText()) : Bundle.getMessage("IWSystemName", this._sysNameBox.getText()));
            fatal = true;
        }
        if (msg == null && this._userNameBox.getText().length() == 0) {
            msg = Bundle.getMessage("NoUserName", this._sysNameBox.getText());
        }
        if (msg != null) {
            if (fatal) {
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
            int result = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("SaveQuestion", msg), Bundle.getMessage("QuestionTitle"), 0, 3);
            if (result != 0) {
                if (this._warrant != null) {
                    mgr.deregister(this._warrant);
                }
                return false;
            }
        }
        if (this._saveWarrant != null) {
            this._warrant = this._saveWarrant;
            if (this._saveWarrant instanceof SCWarrant && !this._isSCWarrant.isSelected() || !(this._saveWarrant instanceof SCWarrant) && this._isSCWarrant.isSelected()) {
                InstanceManager.getDefault(WarrantManager.class).deregister(this._saveWarrant);
                this._warrant = InstanceManager.getDefault(WarrantManager.class).createNewWarrant(this._sysNameBox.getText(), this._userNameBox.getText(), this._isSCWarrant.isSelected(), (Long)this._TTPtextField.getValue());
            }
        } else {
            this._warrant = InstanceManager.getDefault(WarrantManager.class).createNewWarrant(this._sysNameBox.getText(), this._userNameBox.getText(), this._isSCWarrant.isSelected(), (Long)this._TTPtextField.getValue());
        }
        if (this._isSCWarrant.isSelected()) {
            ((SCWarrant)this._warrant).setForward(this._runForward.isSelected());
            ((SCWarrant)this._warrant).setTimeToPlatform((Long)this._TTPtextField.getValue());
            long sf = (Long)this._speedFactorTextField.getValue();
            float sf_float = sf;
            ((SCWarrant)this._warrant).setSpeedFactor(sf_float / 100.0f);
        }
        this._warrant.setTrainName(this.getTrainName());
        this._warrant.setRunBlind(this._runETOnlyBox.isSelected());
        this._warrant.setShareRoute(this._shareRouteBox.isSelected());
        this._warrant.setAddTracker(this._addTracker.isSelected());
        this._warrant.setNoRamp(this._noRampBox.isSelected());
        this._warrant.setHaltStart(this._haltStartBox.isSelected());
        this._warrant.setUserName(this._userNameBox.getText());
        this._warrant.setViaOrder(this.getViaBlockOrder());
        this._warrant.setAvoidOrder(this.getAvoidBlockOrder());
        this._warrant.setBlockOrders(this.getOrders());
        this._warrant.setThrottleCommands(this._throttleCommands);
        this._warrant.setSpeedUtil(this._speedUtil);
        if (this._saveWarrant == null) {
            try {
                mgr.register(this._warrant);
            }
            catch (NamedBean.DuplicateSystemNameException duplicateSystemNameException) {
                // empty catch block
            }
            this._saveWarrant = this._warrant;
        }
        if (log.isDebugEnabled()) {
            log.debug("warrant {} saved _train {} name= {}", new Object[]{this._warrant.getDisplayName(), this._speedUtil.getRosterId(), this.getTrainName()});
        }
        WarrantTableAction.getDefault().updateWarrantMenu();
        WarrantTableFrame.getDefault().getModel().fireTableDataChanged();
        this._dirty = false;
        return true;
    }

    protected List<ThrottleSetting> getThrottleCommands() {
        return this._throttleCommands;
    }

    protected void close() {
        this._dirty = false;
        this.clearTempWarrant();
        if (this._warrant.getRunMode() != 0) {
            this.stopRunTrain(true);
        }
        this.closeProfileTable();
        this.dispose();
    }

    void makeEditWindow(ThrottleSetting ts, ThrottleSetting.Command cmd) {
        EditDialog dialog = new EditDialog(this, ts, cmd);
        dialog.setLocation(this.cellPt);
        dialog.pack();
        dialog.setVisible(true);
        log.debug("makeEditWindow: pt at ({}, {})", (Object)this.cellPt.x, (Object)this.cellPt.y);
    }

    private class ThrottleTableModel
    extends AbstractTableModel {
        public static final int ROW_NUM = 0;
        public static final int TIME_COLUMN = 1;
        public static final int COMMAND_COLUMN = 2;
        public static final int VALUE_COLUMN = 3;
        public static final int BLOCK_COLUMN = 4;
        public static final int SPEED_COLUMN = 5;
        public static final int NUMCOLS = 6;
        JComboBox<Integer> keyNums = new JComboBox();

        ThrottleTableModel() {
            for (int i = 0; i < 29; ++i) {
                this.keyNums.addItem(i);
            }
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            return WarrantFrame.this._throttleCommands.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return Bundle.getMessage("TimeCol");
                }
                case 2: {
                    return Bundle.getMessage("CommandCol");
                }
                case 3: {
                    return Bundle.getMessage("ValueCol");
                }
                case 4: {
                    return Bundle.getMessage("BlockCol");
                }
                case 5: {
                    return Bundle.getMessage("trackSpeed");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0 && col != 5;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 2) {
                return JComboBox.class;
            }
            return String.class;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)3).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
                case 2: 
                case 3: {
                    return new JTextField((int)18).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)45).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)10).getPreferredSize().width;
                }
            }
            return new JTextField((int)12).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= WarrantFrame.this._throttleCommands.size()) {
                log.debug("row {} is greater than throttle command size {}", (Object)row, (Object)WarrantFrame.this._throttleCommands.size());
                return "";
            }
            ThrottleSetting ts = WarrantFrame.this._throttleCommands.get(row);
            if (ts == null) {
                log.debug("Throttle setting is null!");
                return "";
            }
            switch (col) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ts.getTime();
                }
                case 2: {
                    return ts.getCommand();
                }
                case 3: {
                    ThrottleSetting.CommandValue cmdVal = ts.getValue();
                    if (cmdVal == null) {
                        return "";
                    }
                    return cmdVal.showValue();
                }
                case 4: {
                    return ts.getBeanDisplayName();
                }
                case 5: {
                    return twoDigit.format(ts.getTrackSpeed() * WarrantFrame.this._speedConversion);
                }
            }
            return "";
        }

        @Override
        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="put least likely cases last for efficiency")
        public void setValueAt(Object value, int row, int col) {
            if (row >= WarrantFrame.this._throttleCommands.size()) {
                return;
            }
            ThrottleSetting ts = WarrantFrame.this._throttleCommands.get(row);
            String msg = null;
            block2 : switch (col) {
                case 1: {
                    try {
                        long time = Long.parseLong((String)value);
                        if (time < 0L) {
                            msg = Bundle.getMessage("InvalidTime", (String)value);
                            break;
                        }
                        ts.setTime(time);
                        WarrantFrame.this._dirty = true;
                    }
                    catch (NumberFormatException nfe) {
                        msg = Bundle.getMessage("InvalidTime", (String)value);
                    }
                    break;
                }
                case 2: {
                    ThrottleSetting.Command cmd = (ThrottleSetting.Command)((Object)value);
                    if (cmd == null) break;
                    ThrottleSetting.Command prCmd = ts.getCommand();
                    if (prCmd != null) {
                        if (prCmd.equals((Object)ThrottleSetting.Command.NOOP)) break;
                        if (!cmd.hasBlockName() && prCmd.hasBlockName()) {
                            ts.setNamedBeanHandle(null);
                        }
                    }
                    switch (cmd) {
                        case FKEY: 
                        case LATCHF: {
                            class CellMaker
                            implements Runnable {
                                ThrottleSetting ts;
                                ThrottleSetting.Command cmd;

                                CellMaker(ThrottleSetting t, ThrottleSetting.Command c) {
                                    this.ts = t;
                                    this.cmd = c;
                                }

                                @Override
                                public void run() {
                                    WarrantFrame.this.makeEditWindow(this.ts, this.cmd);
                                }
                            }
                            CellMaker t = new CellMaker(ts, cmd);
                            SwingUtilities.invokeLater(t);
                            break block2;
                        }
                        case NOOP: {
                            msg = Bundle.getMessage("cannotEnterNoop", cmd.toString());
                            break block2;
                        }
                        case SPEED: 
                        case FORWARD: 
                        case SET_SENSOR: 
                        case WAIT_SENSOR: 
                        case RUN_WARRANT: 
                        case SPEEDSTEP: 
                        case SET_MEMORY: {
                            ts.setCommand(cmd);
                            WarrantFrame.this._dirty = true;
                            break block2;
                        }
                    }
                    msg = Bundle.getMessage("badCommand", cmd.toString());
                    break;
                }
                case 3: {
                    if (value == null || ((String)value).length() == 0) break;
                    if (ts == null || ts.getCommand() == null) {
                        msg = Bundle.getMessage("nullValue", Bundle.getMessage("CommandCol"));
                        break;
                    }
                    ThrottleSetting.Command command = ts.getCommand();
                    if (command.equals((Object)ThrottleSetting.Command.NOOP)) break;
                    try {
                        ThrottleSetting.CommandValue val = ThrottleSetting.getValueFromString(command, (String)value);
                        if (!val.equals(ts.getValue())) {
                            WarrantFrame.this._dirty = true;
                            ts.setValue(val);
                        }
                    }
                    catch (JmriException je) {
                        msg = je.getMessage();
                        break;
                    }
                    if (!command.hasBlockName()) break;
                    NamedBeanHandle<? extends NamedBean> bh = this.getPreviousBlockHandle(row);
                    ts.setNamedBeanHandle(bh);
                    break;
                }
                case 4: {
                    String name;
                    if (ts == null || ts.getCommand() == null) {
                        msg = Bundle.getMessage("nullValue", Bundle.getMessage("CommandCol"));
                        break;
                    }
                    ThrottleSetting.Command command = ts.getCommand();
                    if (command == null) break;
                    if (!command.hasBlockName()) {
                        msg = ts.setNamedBean(command, (String)value);
                        break;
                    }
                    if (command.equals((Object)ThrottleSetting.Command.NOOP)) {
                        if (((String)value).equals(ts.getBeanDisplayName())) break;
                        msg = Bundle.getMessage("cannotChangeBlock", (String)value);
                        break;
                    }
                    NamedBeanHandle<? extends NamedBean> bh = this.getPreviousBlockHandle(row);
                    if (bh == null || (name = bh.getBean().getDisplayName()).equals(value)) break;
                    msg = Bundle.getMessage("commandInBlock", name);
                    ts.setNamedBeanHandle(bh);
                    WarrantFrame.this._dirty = true;
                    break;
                }
                case 5: {
                    break;
                }
            }
            if (msg != null) {
                WarrantFrame.this.showWarning(msg);
            } else {
                this.fireTableRowsUpdated(row, row);
            }
        }

        private NamedBeanHandle<? extends NamedBean> getPreviousBlockHandle(int row) {
            for (int i = row; i > 0; --i) {
                NamedBeanHandle<? extends NamedBean> bh = WarrantFrame.this._throttleCommands.get(i - 1).getNamedBeanHandle();
                if (bh == null || !(bh.getBean() instanceof OBlock)) continue;
                return bh;
            }
            return null;
        }
    }

    private static class EditDialog
    extends JDialog {
        SpinnerNumberModel _keyNumModel;
        ThrottleSetting _ts;
        ThrottleSetting.Command _cmd;

        EditDialog(JFrame frame, ThrottleSetting ts, ThrottleSetting.Command cmd) {
            super((Frame)frame, true);
            this._ts = ts;
            this._cmd = cmd;
            int key = ts.getKeyNum();
            if (key < 0) {
                key = 0;
            }
            this._keyNumModel = new SpinnerNumberModel(key, 0, 28, 1);
            JSpinner keyNums = new JSpinner(this._keyNumModel);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel(Bundle.getMessage("editFunctionKey")), "North");
            panel.add((Component)keyNums, "Center");
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
            doneButton.addActionListener(a -> this.done());
            p.add(doneButton);
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            cancelButton.addActionListener(a -> this.dispose());
            p.add(cancelButton);
            panel.add((Component)p, "South");
            this.getContentPane().add(panel);
            this.setUndecorated(true);
        }

        public void done() {
            int i = (Integer)this._keyNumModel.getValue();
            this._ts.setKeyNum(i);
            this._ts.setCommand(this._cmd);
            this.dispose();
        }
    }

    private class CommandCellRenderer
    extends DefaultTableCellRenderer {
        public CommandCellRenderer() {
            log.debug("New JComboBox<String> CommandCellRenderer");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ThrottleSetting.Command cmd = (ThrottleSetting.Command)((Object)value);
            int key = WarrantFrame.this._throttleCommands.get(row).getKeyNum();
            if (null == cmd) {
                this.setText(null);
            } else {
                switch (cmd) {
                    case FKEY: {
                        this.setText(Bundle.getMessage("FKey", key));
                        break;
                    }
                    case LATCHF: {
                        this.setText(Bundle.getMessage("FKeyMomemtary", key));
                        break;
                    }
                    default: {
                        this.setText(cmd.toString());
                    }
                }
            }
            return this;
        }
    }

    private class CommandCellEditor
    extends DefaultCellEditor {
        CommandCellEditor(JComboBox<ThrottleSetting.Command> comboBox) {
            super(comboBox);
            log.debug("New JComboBox<String> CommandCellEditor");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            log.debug("getTableCellEditorComponent: row= {}, column= {} selected = {}", new Object[]{row, column, isSelected});
            JComboBox comboBox = (JComboBox)this.getComponent();
            WarrantFrame.this.cellPt = MouseInfo.getPointerInfo().getLocation();
            comboBox.removeAllItems();
            for (ThrottleSetting.Command cmd : ThrottleSetting.Command.values()) {
                if (cmd.name().equals("NOOP") || cmd.name().equals("SPEEDSTEP")) continue;
                comboBox.addItem(cmd);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class ValueCellEditor
    extends DefaultCellEditor {
        private ComboDialog editorDialog;
        private TextDialog textDialog;
        private String currentText;

        ValueCellEditor(JTextField textField) {
            super(textField);
            this.setClickCountToStart(1);
            log.debug("valueCellEditor Ctor");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            log.debug("getValueCellEditorComponent: row= {}, column= {} selected = {} value= {}", new Object[]{row, col, isSelected, value});
            this.currentText = value.toString();
            this.editorComponent = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, col);
            ThrottleSetting.Command cmd = (ThrottleSetting.Command)((Object)WarrantFrame.this._commandModel.getValueAt(row, 2));
            Rectangle cellRect = table.getCellRect(row, col, false);
            Dimension dim = new Dimension(cellRect.width, cellRect.height);
            if (cmd == null) {
                this.showTextDialog(dim);
            } else {
                switch (cmd) {
                    case FORWARD: {
                        this.showComboDialog(TRUE_FALSE, dim);
                        break;
                    }
                    case FKEY: 
                    case LATCHF: {
                        this.showComboDialog(ON_OFF, dim);
                        break;
                    }
                    case SET_SENSOR: 
                    case WAIT_SENSOR: {
                        this.showComboDialog(SENSOR_STATES, dim);
                        break;
                    }
                    default: {
                        this.showTextDialog(dim);
                    }
                }
            }
            return this.editorComponent;
        }

        void showTextDialog(Dimension dim) {
            log.debug("valueCellEditor.showTextDialog");
            this.textDialog = new TextDialog();
            this.textDialog._textField.setText(this.currentText);
            class CellMaker
            implements Runnable {
                Dimension dim;

                CellMaker(Dimension d) {
                    this.dim = d;
                }

                @Override
                public void run() {
                    log.debug("Run valueCellEditor.TextDialog");
                    Point p = ValueCellEditor.this.editorComponent.getLocationOnScreen();
                    ValueCellEditor.this.textDialog.setLocation(p.x, p.y);
                    ValueCellEditor.this.textDialog.setPreferredSize(this.dim);
                    ValueCellEditor.this.textDialog.pack();
                    ValueCellEditor.this.textDialog.setVisible(true);
                }
            }
            CellMaker t = new CellMaker(dim);
            SwingUtilities.invokeLater(t);
        }

        void showComboDialog(String[] items, Dimension dim) {
            this.editorDialog = new ComboDialog(items);
            log.debug("valueCellEditor.showComboDialog");
            class CellMaker
            implements Runnable {
                Dimension dim;

                CellMaker(Dimension d) {
                    this.dim = d;
                }

                @Override
                public void run() {
                    log.debug("Run valueCellEditor.showDialog");
                    Point p = ValueCellEditor.this.editorComponent.getLocationOnScreen();
                    ValueCellEditor.this.editorDialog.setLocation(p.x, p.y);
                    ValueCellEditor.this.editorDialog.setPreferredSize(this.dim);
                    ValueCellEditor.this.editorDialog.pack();
                    ValueCellEditor.this.editorDialog.setVisible(true);
                }
            }
            CellMaker t = new CellMaker(dim);
            SwingUtilities.invokeLater(t);
        }

        class ComboDialog
        extends JDialog
        implements ItemListener,
        FocusListener {
            JComboBox<String> _comboBox;
            ComboDialog _this;

            ComboDialog(String[] items) {
                super((Frame)null, false);
                this._this = this;
                this._comboBox = new JComboBox();
                this._comboBox.addItemListener(this);
                this._comboBox.addFocusListener(this);
                this._comboBox.setForeground(Color.RED);
                for (String item : items) {
                    this._comboBox.addItem(item);
                }
                this._comboBox.removeItem(ThrottleSetting.Command.NOOP.toString());
                this.getContentPane().add(this._comboBox);
                this.setUndecorated(true);
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                ValueCellEditor.this.currentText = (String)this._comboBox.getSelectedItem();
                ((JTextField)ValueCellEditor.this.editorComponent).setText(ValueCellEditor.this.currentText);
                ValueCellEditor.this.fireEditingStopped();
                this._this.dispose();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ValueCellEditor.this.currentText = (String)this._comboBox.getSelectedItem();
                ((JTextField)ValueCellEditor.this.editorComponent).setText(ValueCellEditor.this.currentText);
                ValueCellEditor.this.fireEditingStopped();
                this._this.dispose();
            }
        }

        class TextDialog
        extends JDialog
        implements FocusListener {
            JTextField _textField;
            TextDialog _this;

            TextDialog() {
                super((Frame)null, false);
                this._this = this;
                this._textField = new JTextField();
                this._textField.addFocusListener(this);
                this._textField.setForeground(Color.RED);
                this.getContentPane().add(this._textField);
                this.setUndecorated(true);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ValueCellEditor.this.currentText = this._textField.getText();
                ((JTextField)ValueCellEditor.this.editorComponent).setText(ValueCellEditor.this.currentText);
                ValueCellEditor.this.fireEditingStopped();
                this._this.dispose();
            }
        }
    }
}

