/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.XmlFile;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.WarrantPreferencesPanel;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantPreferences
extends AbstractPreferencesManager {
    public static final String LAYOUT_PARAMS = "layoutParams";
    public static final String LAYOUT_SCALE = "layoutScale";
    public static final String SEARCH_DEPTH = "searchDepth";
    public static final String SPEED_MAP_PARAMS = "speedMapParams";
    public static final String RAMP_PREFS = "rampPrefs";
    public static final String TIME_INCREMENT = "timeIncrement";
    public static final String THROTTLE_SCALE = "throttleScale";
    public static final String RAMP_INCREMENT = "rampIncrement";
    public static final String STEP_INCREMENTS = "stepIncrements";
    public static final String SPEED_NAME_PREFS = "speedNames";
    public static final String SPEED_NAMES = "speedNames";
    public static final String INTERPRETATION = "interpretation";
    public static final String APPEARANCE_PREFS = "appearancePrefs";
    public static final String APPEARANCES = "appearances";
    public static final String SHUT_DOWN = "shutdown";
    public static final String NO_MERGE = "NO_MERGE";
    public static final String PROMPT = "PROMPT";
    public static final String MERGE_ALL = "MERGE_ALL";
    public static final String TRACE = "Trace";
    public static final String SPEED_ASSISTANCE = "SpeedAssistance";
    private String _fileName;
    private float _scale = 87.1f;
    private int _searchDepth = 20;
    private float _throttleScale = 0.9f;
    private final LinkedHashMap<String, Float> _speedNames = new LinkedHashMap();
    private final LinkedHashMap<String, String> _headAppearances = new LinkedHashMap();
    private int _interpretation = 1;
    private int _msIncrTime = 1000;
    private float _throttleIncr = 0.0238f;
    private Shutdown _shutdown = Shutdown.PROMPT;
    private boolean _trace = false;
    private float _slowSpeedAssistance = 0.02f;
    private static final Logger log = LoggerFactory.getLogger(WarrantPreferences.class);

    public static WarrantPreferences getDefault() {
        return InstanceManager.getOptionalDefault(WarrantPreferences.class).orElseGet(() -> {
            WarrantPreferences preferences = InstanceManager.setDefault(WarrantPreferences.class, new WarrantPreferences());
            try {
                preferences.initialize(ProfileManager.getDefault().getActiveProfile());
            }
            catch (InitializationException ex) {
                log.error("Error initializing default WarrantPreferences", (Throwable)ex);
            }
            return preferences;
        });
    }

    public void openFile(String name) {
        Element root;
        this._fileName = name;
        WarrantPreferencesXml prefsXml = new WarrantPreferencesXml();
        File file = new File(this._fileName);
        try {
            root = prefsXml.rootFromFile(file);
        }
        catch (FileNotFoundException ea) {
            log.debug("Could not find Warrant preferences file.  Normal if preferences have not been saved before.");
            root = null;
        }
        catch (IOException | JDOMException eb) {
            log.error("Exception while loading warrant preferences", eb);
            root = null;
        }
        if (root != null) {
            this.loadLayoutParams(root.getChild(LAYOUT_PARAMS));
            if (!this.loadSpeedMap(root.getChild(SPEED_MAP_PARAMS))) {
                this.loadSpeedMapFromOldXml();
                log.error("Unable to read ramp parameters. Setting to default values.");
            }
        } else {
            this.loadSpeedMapFromOldXml();
        }
    }

    public void loadLayoutParams(Element layoutParm) {
        Element speedAssistance;
        Element trace;
        Element shutdown;
        if (layoutParm == null) {
            return;
        }
        Attribute a = layoutParm.getAttribute(LAYOUT_SCALE);
        if (a != null) {
            try {
                this.setLayoutScale(a.getFloatValue());
            }
            catch (DataConversionException ex) {
                this.setLayoutScale(87.1f);
                log.error("Unable to read layout scale. Setting to default value.", (Throwable)ex);
            }
        }
        if ((a = layoutParm.getAttribute(SEARCH_DEPTH)) != null) {
            try {
                this._searchDepth = a.getIntValue();
            }
            catch (DataConversionException ex) {
                this._searchDepth = 20;
                log.error("Unable to read route search depth. Setting to default value (20).", (Throwable)ex);
            }
        }
        if ((shutdown = layoutParm.getChild(SHUT_DOWN)) != null) {
            String choice = shutdown.getText();
            this._shutdown = MERGE_ALL.equals(choice) ? Shutdown.MERGE_ALL : (NO_MERGE.equals(choice) ? Shutdown.NO_MERGE : Shutdown.PROMPT);
        }
        if ((trace = layoutParm.getChild(TRACE)) != null) {
            this._trace = "true".equals(trace.getText());
        }
        if ((speedAssistance = layoutParm.getChild(SPEED_ASSISTANCE)) != null) {
            this._slowSpeedAssistance = Float.parseFloat(speedAssistance.getText());
        }
    }

    private void loadSpeedMapFromOldXml() {
        SignalSpeedMap map = InstanceManager.getNullableDefault(SignalSpeedMap.class);
        if (map == null) {
            log.error("Cannot find signalSpeeds.xml file.");
            return;
        }
        Iterator<String> it = map.getValidSpeedNames().iterator();
        LinkedHashMap<String, Float> names = new LinkedHashMap<String, Float>();
        while (it.hasNext()) {
            String name = it.next();
            names.put(name, Float.valueOf(map.getSpeed(name)));
        }
        this.setSpeedNames(names);
        Enumeration<String> en = map.getAppearanceIterator();
        LinkedHashMap<String, String> heads = new LinkedHashMap<String, String>();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            heads.put(name, map.getAppearanceSpeed(name));
        }
        this.setAppearances(heads);
        this._msIncrTime = map.getStepDelay();
        this._throttleIncr = map.getStepIncrement();
    }

    private boolean loadSpeedMap(Element child) {
        if (child == null) {
            return false;
        }
        Element rampParms = child.getChild(STEP_INCREMENTS);
        if (rampParms == null) {
            return false;
        }
        Attribute a = rampParms.getAttribute(TIME_INCREMENT);
        if (a != null) {
            try {
                this._msIncrTime = a.getIntValue();
            }
            catch (DataConversionException ex) {
                this._msIncrTime = 500;
                log.error("Unable to read ramp time increment. Setting to default value (500ms).", (Throwable)ex);
            }
        }
        if ((a = rampParms.getAttribute(RAMP_INCREMENT)) != null) {
            try {
                this._throttleIncr = a.getFloatValue();
            }
            catch (DataConversionException ex) {
                this._throttleIncr = 0.03f;
                log.error("Unable to read ramp throttle increment. Setting to default value (0.03).", (Throwable)ex);
            }
        }
        if ((a = rampParms.getAttribute(THROTTLE_SCALE)) != null) {
            try {
                this._throttleScale = a.getFloatValue();
            }
            catch (DataConversionException ex) {
                this._throttleScale = 0.9f;
                log.error("Unable to read throttle scale. Setting to default value (0.90f).", (Throwable)ex);
            }
        }
        if ((rampParms = child.getChild("speedNames")) == null) {
            return false;
        }
        a = rampParms.getAttribute("percentNormal");
        if (a != null) {
            this._interpretation = a.getValue().equals("yes") ? 1 : 2;
        }
        if ((a = rampParms.getAttribute(INTERPRETATION)) != null) {
            try {
                this._interpretation = a.getIntValue();
            }
            catch (DataConversionException ex) {
                this._interpretation = 1;
                log.error("Unable to read interpetation of Speed Map. Setting to default value % normal.", (Throwable)ex);
            }
        }
        LinkedHashMap<String, Float> map = new LinkedHashMap<String, Float>();
        List list = rampParms.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            String name = ((Element)list.get(i)).getName();
            Float speed = Float.valueOf(0.0f);
            try {
                speed = Float.valueOf(((Element)list.get(i)).getText());
            }
            catch (NumberFormatException nfe) {
                log.error("Speed names has invalid content for {} = {}", (Object)name, (Object)((Element)list.get(i)).getText());
            }
            log.debug("Add {}, {} to AspectSpeed Table", (Object)name, (Object)speed);
            map.put(name, speed);
        }
        this.setSpeedNames(map);
        rampParms = child.getChild(APPEARANCE_PREFS);
        if (rampParms == null) {
            return false;
        }
        LinkedHashMap<String, String> heads = new LinkedHashMap<String, String>();
        list = rampParms.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            String name = Bundle.getMessage(((Element)list.get(i)).getName());
            String speed = ((Element)list.get(i)).getText();
            heads.put(name, speed);
        }
        this.setAppearances(heads);
        SignalSpeedMap speedMap = InstanceManager.getDefault(SignalSpeedMap.class);
        speedMap.setRampParams(this._throttleIncr, this._msIncrTime);
        speedMap.setDefaultThrottleFactor(this._throttleScale);
        speedMap.setLayoutScale(this._scale);
        speedMap.setAspects(new HashMap<String, Float>(this._speedNames), this._interpretation);
        speedMap.setAppearances(new HashMap<String, String>(this._headAppearances));
        return true;
    }

    public void save() {
        if (this._fileName == null) {
            log.error("_fileName null. Could not create warrant preferences file.");
            return;
        }
        XmlFile xmlFile = new XmlFile(){};
        xmlFile.makeBackupFile(this._fileName);
        File file = new File(this._fileName);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdir()) {
                log.warn("Could not create parent directory for prefs file :{}", (Object)this._fileName);
                return;
            }
            if (file.createNewFile()) {
                log.debug("Creating new warrant prefs file: {}", (Object)this._fileName);
            }
        }
        catch (IOException ea) {
            log.error("Could not create warrant preferences file at {}.", (Object)this._fileName, (Object)ea);
        }
        try {
            Element root = new Element("warrantPreferences");
            Document doc = XmlFile.newDocument(root);
            if (this.store(root)) {
                xmlFile.writeXML(file, doc);
            }
        }
        catch (IOException eb) {
            log.warn("Exception in storing warrant xml", (Throwable)eb);
        }
    }

    public boolean store(Element root) {
        Element prefs = new Element(LAYOUT_PARAMS);
        try {
            prefs.setAttribute(LAYOUT_SCALE, Float.toString(this.getLayoutScale()));
            prefs.setAttribute(SEARCH_DEPTH, Integer.toString(this.getSearchDepth()));
            Element shutdownPref = new Element(SHUT_DOWN);
            shutdownPref.setText(this._shutdown.toString());
            prefs.addContent((Content)shutdownPref);
            Element tracePref = new Element(TRACE);
            tracePref.setText(this._trace ? "true" : "false");
            prefs.addContent((Content)tracePref);
            Element speedAssistancePref = new Element(SPEED_ASSISTANCE);
            speedAssistancePref.setText(String.valueOf(this._slowSpeedAssistance));
            prefs.addContent((Content)speedAssistancePref);
            root.addContent((Content)prefs);
            prefs = new Element(SPEED_MAP_PARAMS);
            Element rampPrefs = new Element(STEP_INCREMENTS);
            rampPrefs.setAttribute(TIME_INCREMENT, Integer.toString(this.getTimeIncrement()));
            rampPrefs.setAttribute(RAMP_INCREMENT, Float.toString(this.getThrottleIncrement()));
            rampPrefs.setAttribute(THROTTLE_SCALE, Float.toString(this.getThrottleScale()));
            prefs.addContent((Content)rampPrefs);
            rampPrefs = new Element("speedNames");
            rampPrefs.setAttribute(INTERPRETATION, Integer.toString(this.getInterpretation()));
            Iterator<Map.Entry<String, Float>> it = this.getSpeedNameEntryIterator();
            while (it.hasNext()) {
                Map.Entry<String, Float> ent = it.next();
                Element step = new Element(ent.getKey());
                step.setText(ent.getValue().toString());
                rampPrefs.addContent((Content)step);
            }
            prefs.addContent((Content)rampPrefs);
            rampPrefs = new Element(APPEARANCE_PREFS);
            Element step = new Element("SignalHeadStateRed");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateRed")));
            rampPrefs.addContent((Content)step);
            step = new Element("SignalHeadStateFlashingRed");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateFlashingRed")));
            rampPrefs.addContent((Content)step);
            step = new Element("SignalHeadStateGreen");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateGreen")));
            rampPrefs.addContent((Content)step);
            step = new Element("SignalHeadStateFlashingGreen");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateFlashingGreen")));
            rampPrefs.addContent((Content)step);
            step = new Element("SignalHeadStateYellow");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateYellow")));
            rampPrefs.addContent((Content)step);
            step = new Element("SignalHeadStateFlashingYellow");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateFlashingYellow")));
            rampPrefs.addContent((Content)step);
            step = new Element("SignalHeadStateLunar");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateLunar")));
            rampPrefs.addContent((Content)step);
            step = new Element("SignalHeadStateFlashingLunar");
            step.setText(this._headAppearances.get(Bundle.getMessage("SignalHeadStateFlashingLunar")));
            rampPrefs.addContent((Content)step);
            prefs.addContent((Content)rampPrefs);
        }
        catch (RuntimeException ex) {
            log.warn("Exception in storing warrant xml.", (Throwable)ex);
            return false;
        }
        root.addContent((Content)prefs);
        return true;
    }

    public final float getLayoutScale() {
        return this._scale;
    }

    public void setLayoutScale(float scale) {
        float oldScale = this._scale;
        this._scale = scale;
        this.firePropertyChange(LAYOUT_SCALE, Float.valueOf(oldScale), Float.valueOf(scale));
    }

    public float getThrottleScale() {
        return this._throttleScale;
    }

    public void setThrottleScale(float scale) {
        float oldScale = this._throttleScale;
        this._throttleScale = scale;
        this.firePropertyChange(THROTTLE_SCALE, Float.valueOf(oldScale), Float.valueOf(scale));
    }

    int getSearchDepth() {
        return this._searchDepth;
    }

    void setSearchDepth(int depth) {
        int oldDepth = this._searchDepth;
        this._searchDepth = depth;
        this.firePropertyChange(SEARCH_DEPTH, oldDepth, depth);
    }

    boolean getTrace() {
        return this._trace;
    }

    void setTrace(boolean t) {
        this._trace = t;
    }

    float getSpeedAssistance() {
        return this._slowSpeedAssistance;
    }

    void setSpeedAssistance(float f) {
        this._slowSpeedAssistance = f;
    }

    Iterator<Map.Entry<String, Float>> getSpeedNameEntryIterator() {
        ArrayList vec = new ArrayList();
        this._speedNames.entrySet().forEach(entry -> vec.add(new WarrantPreferencesPanel.DataPair<String, Float>((String)entry.getKey(), (Float)entry.getValue())));
        return vec.iterator();
    }

    Float getSpeedNameValue(String key) {
        return this._speedNames.get(key);
    }

    @Nonnull
    @CheckReturnValue
    public HashMap<String, Float> getSpeedNames() {
        return new HashMap<String, Float>(this._speedNames);
    }

    private void setSpeedNames(@Nonnull HashMap<String, Float> map) {
        this._speedNames.clear();
        this._speedNames.putAll(map);
    }

    protected void setSpeedNames(@Nonnull ArrayList<WarrantPreferencesPanel.DataPair<String, Float>> speedNameMap) {
        LinkedHashMap<String, Float> map = new LinkedHashMap<String, Float>();
        for (int i = 0; i < speedNameMap.size(); ++i) {
            WarrantPreferencesPanel.DataPair<String, Float> dp = speedNameMap.get(i);
            map.put(dp.getKey(), dp.getValue());
        }
        LinkedHashMap<String, Float> old = new LinkedHashMap<String, Float>(this._speedNames);
        this.setSpeedNames(map);
        this.firePropertyChange("speedNames", old, new LinkedHashMap<String, Float>(this._speedNames));
    }

    Iterator<Map.Entry<String, String>> getAppearanceEntryIterator() {
        ArrayList vec = new ArrayList();
        this._headAppearances.entrySet().stream().forEach(entry -> vec.add(new WarrantPreferencesPanel.DataPair<String, String>((String)entry.getKey(), (String)entry.getValue())));
        return vec.iterator();
    }

    String getAppearanceValue(String key) {
        return this._headAppearances.get(key);
    }

    @Nonnull
    @CheckReturnValue
    public HashMap<String, String> getAppearances() {
        return new HashMap<String, String>(this._headAppearances);
    }

    private void setAppearances(HashMap<String, String> map) {
        this._headAppearances.clear();
        this._headAppearances.putAll(map);
    }

    protected void setAppearances(ArrayList<WarrantPreferencesPanel.DataPair<String, String>> appearanceMap) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < appearanceMap.size(); ++i) {
            WarrantPreferencesPanel.DataPair<String, String> dp = appearanceMap.get(i);
            map.put(dp.getKey(), dp.getValue());
        }
        LinkedHashMap<String, String> old = new LinkedHashMap<String, String>(this._headAppearances);
        this.setAppearances(map);
        this.firePropertyChange(APPEARANCES, old, new LinkedHashMap<String, String>(this._headAppearances));
    }

    public int getInterpretation() {
        return this._interpretation;
    }

    void setInterpretation(int interp) {
        int oldInterpretation = this._interpretation;
        this._interpretation = interp;
        this.firePropertyChange(INTERPRETATION, oldInterpretation, interp);
    }

    public final int getTimeIncrement() {
        return this._msIncrTime;
    }

    public void setTimeIncrement(int increment) {
        int oldIncrement = this._msIncrTime;
        this._msIncrTime = increment;
        this.firePropertyChange(TIME_INCREMENT, oldIncrement, increment);
    }

    public final float getThrottleIncrement() {
        return this._throttleIncr;
    }

    public void setThrottleIncrement(float increment) {
        float oldIncrement = this._throttleIncr;
        this._throttleIncr = increment;
        this.firePropertyChange(RAMP_INCREMENT, Float.valueOf(oldIncrement), Float.valueOf(increment));
    }

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.isInitialized(profile) && !this.isInitializing(profile)) {
            this.setInitializing(profile, true);
            this.openFile(FileUtil.getUserFilesPath() + "signal" + File.separator + "WarrantPreferences.xml");
            this.setInitialized(profile, true);
        }
    }

    public void setShutdown(Shutdown set) {
        this._shutdown = set;
    }

    public Shutdown getShutdown() {
        return this._shutdown;
    }

    @Override
    public void savePreferences(Profile profile) {
        this.save();
    }

    public static class WarrantPreferencesXml
    extends XmlFile {
    }

    public static enum Shutdown {
        NO_MERGE,
        PROMPT,
        MERGE_ALL;

    }
}

