/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.WarrantFrame;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantRoute;
import jmri.swing.PreferencesPanel;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantPreferencesPanel
extends JPanel
implements PreferencesPanel,
ItemListener {
    static int STRUT_SIZE = 10;
    private boolean _isDirty = false;
    private JComboBox<ScaleData> _layoutScales;
    private JSpinner _searchDepth;
    private JSpinner _timeIncre;
    private JTextField _rampIncre;
    private JTextField _throttleScale;
    private JTextField _speedAssistance;
    private int _interpretation = 1;
    private ArrayList<DataPair<String, Float>> _speedNameMap;
    private SpeedNameTableModel _speedNameModel;
    private JTable _speedNameTable;
    private ArrayList<DataPair<String, String>> _appearanceMap;
    private AppearanceTableModel _appearanceModel;
    private JTable _appearanceTable;
    private ArrayList<DataPair<String, Integer>> _stepIncrementMap;
    private WarrantPreferences.Shutdown _shutdown;
    private boolean _traceWarrants;
    private static final Logger log = LoggerFactory.getLogger(WarrantPreferencesPanel.class);

    public WarrantPreferencesPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        final JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 3));
        leftPanel.add(this.layoutScalePanel());
        leftPanel.add(this.searchDepthPanel(true));
        this._timeIncre = new JSpinner(new SpinnerNumberModel(750, 200, 10000, 1));
        leftPanel.add(WarrantPreferencesPanel.timeIncrementPanel(true, this._timeIncre));
        this._rampIncre = new JTextField(6);
        leftPanel.add(WarrantPreferencesPanel.throttleIncrementPanel(true, this._rampIncre));
        leftPanel.add(this.throttleScalePanel(true));
        leftPanel.add(this.speedRosterPanel(true));
        leftPanel.add(this.tracePanel(true));
        leftPanel.add(this.speedAssistancePanel(true));
        rightPanel.add(this.speedNamesPanel());
        rightPanel.add(Box.createGlue());
        rightPanel.add(this.appearancePanel());
        this._rampIncre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = WarrantPreferencesPanel.this._rampIncre.getText();
                boolean showdialog = false;
                try {
                    float incr = NumberFormat.getNumberInstance().parse(text).floatValue();
                    showdialog = incr < 0.5f || incr > 25.0f;
                }
                catch (ParseException pe) {
                    showdialog = true;
                }
                if (showdialog) {
                    JmriJOptionPane.showMessageDialog(leftPanel, Bundle.getMessage("rampIncrWarning", text), Bundle.getMessage("WarningTitle"), 2);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(leftPanel);
        panel.add(rightPanel);
        this.add(panel);
    }

    private JPanel layoutScalePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this._layoutScales = new JComboBox();
        this._layoutScales.addItem(new ScaleData("G", 22.5f));
        this._layoutScales.addItem(new ScaleData("L", 38.0f));
        this._layoutScales.addItem(new ScaleData("O", 48.0f));
        this._layoutScales.addItem(new ScaleData("O'", 43.0f));
        this._layoutScales.addItem(new ScaleData("S", 64.0f));
        this._layoutScales.addItem(new ScaleData("OO", 76.2f));
        this._layoutScales.addItem(new ScaleData("HO", 87.1f));
        this._layoutScales.addItem(new ScaleData("TT", 120.0f));
        this._layoutScales.addItem(new ScaleData("N", 160.0f));
        this._layoutScales.addItem(new ScaleData("Z", 220.0f));
        this._layoutScales.addItem(new ScaleData("T", 480.0f));
        JComboBoxUtil.setupComboBoxMaxRows(this._layoutScales);
        ScaleData sc = this.makeCustomItem(WarrantPreferences.getDefault().getLayoutScale());
        this._layoutScales.addItem(sc);
        if (this._layoutScales.getSelectedIndex() < 0) {
            this._layoutScales.setSelectedItem(sc);
        }
        Dimension dim = this._layoutScales.getPreferredSize();
        dim.width = 3 * dim.width / 2;
        this._layoutScales.setPreferredSize(dim);
        this._layoutScales.addItemListener(this);
        this._layoutScales.setToolTipText(Bundle.getMessage("ToolTipLayoutScale"));
        JLabel label = new JLabel(Bundle.getMessage("LabelLayoutScale"));
        label.setToolTipText(Bundle.getMessage("ToolTipLayoutScale"));
        panel.add(label);
        JPanel p = new JPanel();
        p.add(this._layoutScales);
        panel.add(p);
        return panel;
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="fixed number of possible values")
    private ScaleData makeCustomItem(float scale) {
        for (int cnt = 0; cnt < this._layoutScales.getItemCount(); ++cnt) {
            if (this._layoutScales.getItemAt((int)cnt).scale != scale) continue;
            this._layoutScales.setSelectedItem(this._layoutScales.getItemAt(cnt));
            return new CustomDialog("custom", 0.0f);
        }
        this._layoutScales.setSelectedIndex(-1);
        return new CustomDialog(Bundle.getMessage("custom"), scale);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        WarrantPreferences preferences = WarrantPreferences.getDefault();
        if (e.getStateChange() == 1) {
            ScaleData sd = (ScaleData)e.getItem();
            if (sd instanceof CustomDialog) {
                boolean ok = false;
                while (!ok) {
                    float scale = 0.0f;
                    String str = JmriJOptionPane.showInputDialog(this, Bundle.getMessage("customInput"), Bundle.getMessage("customTitle"), 3);
                    try {
                        if (str == null) {
                            sd.scale = 0.0f;
                            this.makeCustomItem(preferences.getLayoutScale());
                            ok = true;
                            continue;
                        }
                        scale = Float.parseFloat(str);
                        if (scale <= 1.0f) {
                            throw new NumberFormatException();
                        }
                        sd.scale = scale;
                        preferences.setLayoutScale(scale);
                        this._isDirty = true;
                        ok = true;
                    }
                    catch (NumberFormatException nfe) {
                        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("customError", str), Bundle.getMessage("customTitle"), 0);
                    }
                }
            } else {
                preferences.setLayoutScale(sd.scale);
                this._isDirty = true;
            }
        }
    }

    private JPanel searchDepthPanel(boolean vertical) {
        this._searchDepth = new JSpinner(new SpinnerNumberModel(20, 1, 50, 1));
        int searchDepthPref = WarrantPreferences.getDefault().getSearchDepth();
        if (searchDepthPref >= 1 && searchDepthPref <= 50) {
            this._searchDepth.setValue(searchDepthPref);
        }
        JPanel p = new JPanel();
        p.add(WarrantRoute.makeTextBoxPanel(vertical, this._searchDepth, "SearchDepth", "ToolTipSearchDepth"));
        p.setToolTipText(Bundle.getMessage("ToolTipSearchDepth"));
        return p;
    }

    private JPanel throttleScalePanel(boolean vertical) {
        this._throttleScale = new JTextField(5);
        this._throttleScale.setText(NumberFormat.getNumberInstance().format(WarrantPreferences.getDefault().getThrottleScale()));
        JPanel p = new JPanel();
        p.add(WarrantRoute.makeTextBoxPanel(vertical, this._throttleScale, "ThrottleScale", "ToolTipThrottleScale"));
        this._throttleScale.setColumns(8);
        p.setToolTipText(Bundle.getMessage("ToolTipThrottleScale"));
        return p;
    }

    protected static JPanel timeIncrementPanel(boolean vertical, JSpinner timeIncre) {
        int timeIncrePrefs = WarrantPreferences.getDefault().getTimeIncrement();
        if (timeIncrePrefs >= 200 && timeIncrePrefs <= 10000) {
            timeIncre.setValue(timeIncrePrefs);
        }
        JPanel incrPanel = new JPanel();
        incrPanel.add(timeIncre);
        incrPanel.add(new JLabel(Bundle.getMessage("milliseconds")));
        JPanel p = new JPanel();
        p.add(WarrantFrame.makeTextBoxPanel(vertical, incrPanel, "TimeIncrement", "ToolTipTimeIncrement"));
        p.setToolTipText(Bundle.getMessage("ToolTipTimeIncrement"));
        return p;
    }

    protected static JPanel throttleIncrementPanel(boolean vertical, JTextField rampIncre) {
        rampIncre.setText(NumberFormat.getNumberInstance().format(WarrantPreferences.getDefault().getThrottleIncrement() * 100.0f));
        JPanel incrPanel = new JPanel();
        incrPanel.add(rampIncre);
        incrPanel.add(new JLabel(Bundle.getMessage("percent")));
        JPanel p = new JPanel();
        p.add(WarrantFrame.makeTextBoxPanel(vertical, incrPanel, "RampIncrement", "ToolTipRampIncrement"));
        p.setToolTipText(Bundle.getMessage("ToolTipRampIncrement"));
        return p;
    }

    private JPanel tracePanel(boolean vertical) {
        this._traceWarrants = WarrantPreferences.getDefault().getTrace();
        String text = this._traceWarrants ? "ColumnHeadEnabled" : "Disabled";
        final JButton button = new JButton(Bundle.getMessage(text));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantPreferencesPanel.this._traceWarrants = !WarrantPreferencesPanel.this._traceWarrants;
                String text = WarrantPreferencesPanel.this._traceWarrants ? "ColumnHeadEnabled" : "Disabled";
                button.setText(Bundle.getMessage(text));
                button.setSelected(false);
            }
        });
        JPanel p = new JPanel();
        p.add(WarrantFrame.makeTextBoxPanel(vertical, button, "warrantTrace", "ToolTipTraceWarrant"));
        p.setToolTipText(Bundle.getMessage("ToolTipTimeIncrement"));
        return p;
    }

    private JPanel speedAssistancePanel(boolean vertical) {
        this._speedAssistance = new JTextField(6);
        this._speedAssistance.setText(NumberFormat.getNumberInstance().format(WarrantPreferences.getDefault().getSpeedAssistance() * 100.0f));
        JPanel incrPanel = new JPanel();
        incrPanel.add(this._speedAssistance);
        incrPanel.add(new JLabel(Bundle.getMessage("percent")));
        JPanel p = new JPanel();
        p.add(WarrantFrame.makeTextBoxPanel(vertical, incrPanel, "SpeedAssistance", "ToolTipSpeedAssistance"));
        p.setToolTipText(Bundle.getMessage("ToolTipRampIncrement"));
        return p;
    }

    private JPanel speedRosterPanel(boolean vertical) {
        ButtonGroup bg = new ButtonGroup();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        JRadioButton b1 = new JRadioButton(Bundle.getMessage("NeverMerge"));
        b1.addActionListener(e -> {
            if (b1.isSelected()) {
                this._shutdown = WarrantPreferences.Shutdown.NO_MERGE;
            }
        });
        bg.add(b1);
        p.add(b1);
        JRadioButton b2 = new JRadioButton(Bundle.getMessage("PromptMerges"));
        b2.addActionListener(e -> {
            if (b2.isSelected()) {
                this._shutdown = WarrantPreferences.Shutdown.PROMPT;
            }
        });
        bg.add(b2);
        p.add(b2);
        JRadioButton b3 = new JRadioButton(Bundle.getMessage("AlwaysMerge"));
        b3.addActionListener(e -> {
            if (b3.isSelected()) {
                this._shutdown = WarrantPreferences.Shutdown.MERGE_ALL;
            }
        });
        bg.add(b3);
        p.add(b3);
        this._shutdown = WarrantPreferences.getDefault().getShutdown();
        switch (this._shutdown) {
            case NO_MERGE: {
                b1.setSelected(true);
                break;
            }
            case PROMPT: {
                b2.setSelected(true);
                break;
            }
            case MERGE_ALL: {
                b3.setSelected(true);
                break;
            }
        }
        JPanel panel = new JPanel();
        panel.add(WarrantRoute.makeTextBoxPanel(vertical, p, "MergeRoster", "ToolTipMergeRoster"));
        return panel;
    }

    private JPanel speedNamesPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("LabelSpeedNameTable"), 2, 2));
        panel.setLayout(new BoxLayout(panel, 3));
        this._speedNameMap = new ArrayList();
        Iterator<Map.Entry<String, Float>> it = WarrantPreferences.getDefault().getSpeedNameEntryIterator();
        while (it.hasNext()) {
            Map.Entry<String, Float> ent = it.next();
            this._speedNameMap.add(new DataPair<String, Float>(ent.getKey(), ent.getValue()));
        }
        this._speedNameModel = new SpeedNameTableModel();
        this._speedNameTable = new JTable(this._speedNameModel);
        for (int i = 0; i < this._speedNameModel.getColumnCount(); ++i) {
            int width = this._speedNameModel.getPreferredWidth(i);
            this._speedNameTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        ActionListener insertAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantPreferencesPanel.this.insertSpeedNameRow();
            }
        };
        ActionListener deleteAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantPreferencesPanel.this.deleteSpeedNameRow();
            }
        };
        panel.add(WarrantPreferencesPanel.tablePanel(this._speedNameTable, "ToolTipSpeedNameTable", insertAction, deleteAction));
        panel.add(this.interpretationPanel());
        return panel;
    }

    private JPanel appearancePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Bundle.getMessage("LabelAppearanceTable"), 2, 2));
        panel.setLayout(new BoxLayout(panel, 2));
        this._appearanceMap = new ArrayList();
        Iterator<Map.Entry<String, String>> it = WarrantPreferences.getDefault().getAppearanceEntryIterator();
        while (it.hasNext()) {
            Map.Entry<String, String> ent = it.next();
            this._appearanceMap.add(new DataPair<String, String>(ent.getKey(), ent.getValue()));
        }
        this._appearanceModel = new AppearanceTableModel();
        this._appearanceTable = new JTable(this._appearanceModel);
        for (int i = 0; i < this._appearanceModel.getColumnCount(); ++i) {
            int width = this._appearanceModel.getPreferredWidth(i);
            this._appearanceTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        panel.add(Box.createGlue());
        panel.add(WarrantPreferencesPanel.tablePanel(this._appearanceTable, "ToolTipAppearanceTable", null, null));
        panel.add(Box.createGlue());
        return panel;
    }

    private static JPanel tablePanel(JTable table, String toolTip, ActionListener insertAction, ActionListener removeAction) {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 2));
        JScrollPane scrollPane = new JScrollPane(table);
        int height = table.getRowHeight();
        Dimension dim = table.getPreferredSize();
        dim.height = height * 5;
        scrollPane.getViewport().setPreferredSize(dim);
        table.setToolTipText(Bundle.getMessage(toolTip));
        scrollPane.setToolTipText(Bundle.getMessage(toolTip));
        tablePanel.add(scrollPane);
        tablePanel.add(Box.createVerticalStrut(STRUT_SIZE));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        if (insertAction != null) {
            JButton insertButton = new JButton(Bundle.getMessage("buttonInsertRow"));
            insertButton.addActionListener(insertAction);
            buttonPanel.add(insertButton);
            buttonPanel.add(Box.createVerticalStrut(2 * STRUT_SIZE));
        }
        if (removeAction != null) {
            JButton deleteButton = new JButton(Bundle.getMessage("buttonDeleteRow"));
            deleteButton.addActionListener(removeAction);
            buttonPanel.add(deleteButton);
        }
        tablePanel.add(buttonPanel);
        return tablePanel;
    }

    private void insertSpeedNameRow() {
        int row = this._speedNameTable.getSelectedRow();
        if (row < 0) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("selectRow"), Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        this._speedNameMap.add(row, new DataPair<String, Float>("", Float.valueOf(0.0f)));
        this._speedNameModel.fireTableDataChanged();
    }

    private void deleteSpeedNameRow() {
        int row = this._speedNameTable.getSelectedRow();
        if (row < 0) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("selectRow"), Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        this._speedNameMap.remove(row);
        this._speedNameModel.fireTableDataChanged();
    }

    private JPanel interpretationPanel() {
        this._interpretation = WarrantPreferences.getDefault().getInterpretation();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        ButtonGroup group = new ButtonGroup();
        this.makeButton(buttonPanel, group, "percentNormal", "ToolTipPercentNormal", 1);
        this.makeButton(buttonPanel, group, "percentThrottle", "ToolTipPercentThrottle", 2);
        this.makeButton(buttonPanel, group, "speedMph", "ToolTipSpeedMph", 3);
        this.makeButton(buttonPanel, group, "speedKmph", "ToolTipSpeedKmph", 4);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.add(Box.createGlue());
        JLabel label = new JLabel(Bundle.getMessage("LabelInterpretation", 0));
        label.setToolTipText(Bundle.getMessage("ToolTipInterpretation"));
        p.setToolTipText(Bundle.getMessage("ToolTipInterpretation"));
        p.add(label);
        p.add(Box.createGlue());
        panel.add((Component)p, 0);
        panel.add((Component)buttonPanel, Float.valueOf(0.5f));
        return panel;
    }

    private void makeButton(JPanel panel, ButtonGroup group, String name, String tooltip, int interp) {
        JRadioButton button = new JRadioButton(Bundle.getMessage(name));
        group.add(button);
        panel.add(button);
        button.setToolTipText(Bundle.getMessage(tooltip));
        button.addActionListener(new ActionListener(){
            int value;
            JRadioButton but;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.but.isSelected()) {
                    WarrantPreferencesPanel.this._interpretation = this.value;
                }
            }

            ActionListener init(JRadioButton b, int num) {
                this.but = b;
                this.value = num;
                return this;
            }
        }.init(button, interp));
        if (this._interpretation == interp) {
            button.setSelected(true);
        }
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="fixed number of possible values")
    private void setValues() {
        String name;
        DataPair<String, Object> dp;
        int i;
        WarrantPreferences.Shutdown shutDown;
        WarrantPreferences preferences = WarrantPreferences.getDefault();
        int depth = (Integer)this._searchDepth.getValue();
        if (preferences.getSearchDepth() != depth) {
            preferences.setSearchDepth(depth);
            this._isDirty = true;
        }
        if (preferences.getInterpretation() != this._interpretation) {
            preferences.setInterpretation(this._interpretation);
            this._isDirty = true;
        }
        int time = (Integer)this._timeIncre.getValue();
        if (preferences.getTimeIncrement() != time) {
            preferences.setTimeIncrement(time);
            this._isDirty = true;
        }
        if (preferences.getTrace() != this._traceWarrants) {
            preferences.setTrace(this._traceWarrants);
            this._isDirty = true;
        }
        float scale = preferences.getThrottleIncrement();
        try {
            scale = NumberFormat.getNumberInstance().parse(this._rampIncre.getText()).floatValue();
        }
        catch (ParseException pe) {
            this._rampIncre.setText(NumberFormat.getNumberInstance().format(preferences.getThrottleIncrement() * 100.0f));
        }
        if (scale < 0.5f || scale > 25.0f) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("rampIncrWarning", this._rampIncre.getText()), Bundle.getMessage("WarningTitle"), 2);
            this._rampIncre.setText(NumberFormat.getNumberInstance().format(WarrantPreferences.getDefault().getThrottleIncrement() * 100.0f));
        } else if (preferences.getThrottleIncrement() != (scale /= 100.0f)) {
            preferences.setThrottleIncrement(scale);
            this._isDirty = true;
        }
        scale = preferences.getThrottleScale();
        try {
            scale = NumberFormat.getNumberInstance().parse(this._throttleScale.getText()).floatValue();
        }
        catch (ParseException pe) {
            this._throttleScale.setText(NumberFormat.getNumberInstance().format(preferences.getThrottleScale()));
        }
        if (preferences.getThrottleScale() != scale) {
            preferences.setThrottleScale(scale);
            this._isDirty = true;
        }
        scale = preferences.getSpeedAssistance();
        try {
            scale = NumberFormat.getNumberInstance().parse(this._speedAssistance.getText()).floatValue();
        }
        catch (ParseException pe) {
            this._rampIncre.setText(NumberFormat.getNumberInstance().format(preferences.getSpeedAssistance() * 100.0f));
        }
        if (preferences.getSpeedAssistance() != (scale /= 100.0f)) {
            preferences.setSpeedAssistance(scale);
            this._isDirty = true;
        }
        if ((shutDown = preferences.getShutdown()) != this._shutdown) {
            preferences.setShutdown(this._shutdown);
            this._isDirty = true;
        }
        boolean different = false;
        TableCellEditor tce = this._speedNameTable.getCellEditor();
        if (tce != null) {
            tce.stopCellEditing();
        }
        if (preferences.getSpeedNames().size() != this._speedNameMap.size()) {
            different = true;
        } else {
            for (i = 0; i < this._speedNameMap.size(); ++i) {
                dp = this._speedNameMap.get(i);
                name = dp.getKey();
                if (preferences.getSpeedNameValue(name) != null && preferences.getSpeedNameValue(name).floatValue() == dp.getValue().floatValue()) continue;
                different = true;
                break;
            }
        }
        if (different) {
            preferences.setSpeedNames(this._speedNameMap);
            this._isDirty = true;
        }
        different = false;
        tce = this._appearanceTable.getCellEditor();
        if (tce != null) {
            tce.stopCellEditing();
        }
        if (preferences.getAppearances().size() != this._appearanceMap.size()) {
            different = true;
        } else {
            for (i = 0; i < this._appearanceMap.size(); ++i) {
                dp = this._appearanceMap.get(i);
                name = dp.getKey();
                if (preferences.getAppearanceValue(name) != null && preferences.getAppearanceValue(name).equals(dp.getValue())) continue;
                different = true;
                break;
            }
        }
        if (different) {
            preferences.setAppearances(this._appearanceMap);
            this._isDirty = true;
        }
    }

    @Override
    public String getPreferencesItem() {
        return "WARRANTS";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("TitleWarrantPreferences");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return null;
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return Bundle.getMessage("ToolTipLayoutScale");
    }

    @Override
    public void savePreferences() {
        this.setValues();
        if (this._isDirty) {
            WarrantPreferences.getDefault().save();
            this._isDirty = false;
        }
    }

    @Override
    public boolean isDirty() {
        return this._isDirty;
    }

    @Override
    public boolean isRestartRequired() {
        return false;
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    class StepIncrementTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return WarrantPreferencesPanel.this._stepIncrementMap.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Bundle.getMessage("throttleStepMode");
            }
            return Bundle.getMessage("rampIncrement");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int getPreferredWidth(int col) {
            if (col == 0) {
                return new JTextField((int)15).getPreferredSize().width;
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= WarrantPreferencesPanel.this._stepIncrementMap.size()) {
                log.error("row is greater than throttle step modes size");
                return "";
            }
            DataPair<String, Integer> data = WarrantPreferencesPanel.this._stepIncrementMap.get(row);
            if (data == null) {
                log.error("Throttle step data is null!");
                return "";
            }
            if (col == 0) {
                return data.getKey();
            }
            return data.getValue();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            DataPair<String, Integer> data = WarrantPreferencesPanel.this._stepIncrementMap.get(row);
            String str = (String)value;
            String msg = null;
            if (str == null || data == null) {
                msg = Bundle.getMessage("NoData");
            }
            if (data != null) {
                if (col == 0) {
                    data.setKey((String)value);
                } else {
                    try {
                        Integer f = Integer.parseInt((String)value);
                        if (f < 1) {
                            msg = Bundle.getMessage("InvalidNumber", (String)value);
                        } else {
                            data.setValue(f);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        msg = Bundle.getMessage("InvalidNumber", (String)value);
                    }
                }
                if (msg != null) {
                    JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
                } else {
                    this.fireTableRowsUpdated(row, row);
                }
            }
        }
    }

    class AppearanceTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return WarrantPreferencesPanel.this._appearanceMap.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Bundle.getMessage("appearance");
            }
            return Bundle.getMessage("speedName");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int getPreferredWidth(int col) {
            if (col == 0) {
                return new JTextField((int)15).getPreferredSize().width;
            }
            return new JTextField((int)15).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= WarrantPreferencesPanel.this._appearanceMap.size()) {
                log.error("row is greater than appearance names size");
                return "";
            }
            DataPair<String, String> data = WarrantPreferencesPanel.this._appearanceMap.get(row);
            if (data == null) {
                log.error("Appearance name data is null!");
                return "";
            }
            if (col == 0) {
                return data.getKey();
            }
            return data.getValue();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            DataPair<String, String> data = WarrantPreferencesPanel.this._appearanceMap.get(row);
            String str = (String)value;
            String msg = null;
            if (str == null || data == null) {
                msg = Bundle.getMessage("NoData");
            }
            if (data != null) {
                if (col == 0) {
                    data.setKey((String)value);
                } else {
                    data.setValue((String)value);
                }
                if (msg != null) {
                    JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
                } else {
                    this.fireTableRowsUpdated(row, row);
                }
            }
        }
    }

    class SpeedNameTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return WarrantPreferencesPanel.this._speedNameMap.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Bundle.getMessage("speedName");
            }
            return Bundle.getMessage("speedValue");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int getPreferredWidth(int col) {
            if (col == 0) {
                return new JTextField((int)15).getPreferredSize().width;
            }
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= WarrantPreferencesPanel.this._speedNameMap.size()) {
                log.error("row is greater than aspect speedNames size");
                return "";
            }
            DataPair<String, Float> data = WarrantPreferencesPanel.this._speedNameMap.get(row);
            if (data == null) {
                log.error("Aspect speedName data is null!");
                return "";
            }
            if (col == 0) {
                return data.getKey();
            }
            return data.getValue();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            DataPair<String, Float> data = WarrantPreferencesPanel.this._speedNameMap.get(row);
            String str = (String)value;
            String msg = null;
            if (str == null || data == null) {
                msg = Bundle.getMessage("NoData");
            }
            if (data != null) {
                if (col == 0) {
                    data.setKey((String)value);
                } else {
                    try {
                        float f = Float.parseFloat((String)value);
                        if (f < 0.0f) {
                            msg = Bundle.getMessage("InvalidNumber", (String)value);
                        } else {
                            data.setValue(Float.valueOf(f));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        msg = Bundle.getMessage("MustBeFloat", (String)value);
                    }
                }
                if (msg != null) {
                    JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
                } else {
                    this.fireTableRowsUpdated(row, row);
                }
            }
        }
    }

    static class DataPair<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        DataPair(K k, V v) {
            this.key = k;
            this.value = v;
        }

        DataPair(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        void setKey(K k) {
            this.key = k;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            this.value = v;
            return this.value;
        }
    }

    class CustomDialog
    extends ScaleData {
        CustomDialog(String scaleName, float scale) {
            super(scaleName, scale);
        }

        @Override
        public String toString() {
            if (this.scale < 1.0f) {
                return Bundle.getMessage("custom");
            }
            return super.toString();
        }
    }

    class ScaleData {
        float scale;
        String scaleName;

        ScaleData(String scaleName, float scale) {
            this.scale = scale;
            this.scaleName = scaleName;
        }

        public String toString() {
            return Bundle.getMessage("scaleItem", this.scaleName, Float.toString(this.scale));
        }
    }
}

