/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Path;
import jmri.ShutDownManager;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.NXFrame;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.OpSessionLog;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.TrackerTableAction;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantFrame;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantTableFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantTableAction
extends AbstractAction {
    private JMenu _warrantMenu;
    private boolean _hasErrors = false;
    private JDialog _errorDialog;
    private WarrantFrame _openFrame;
    private Point _warFrameLoc = new Point(20, 20);
    private NXFrame _nxFrame;
    private Point _nxFrameLoc = new Point(40, 40);
    private boolean _logging = false;
    private Runnable _shutDownTask = null;
    private static final Logger log = LoggerFactory.getLogger(WarrantTableAction.class);

    private WarrantTableAction(String menuOption) {
        super(Bundle.getMessage(menuOption));
    }

    public static WarrantTableAction getDefault() {
        return InstanceManager.getOptionalDefault(WarrantTableAction.class).orElseGet(() -> {
            WarrantTableAction wta = new WarrantTableAction("ShowWarrants");
            wta.errorCheck();
            return InstanceManager.setDefault(WarrantTableAction.class, wta);
        });
    }

    @Override
    @InvokeOnGuiThread
    public void actionPerformed(ActionEvent e) {
        WarrantTableFrame.getDefault().setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMenu makeWarrantMenu(boolean edit) {
        if (InstanceManager.getDefault(OBlockManager.class).getNamedBeanSet().size() > 1) {
            WarrantTableAction warrantTableAction = this;
            synchronized (warrantTableAction) {
                this._warrantMenu = new JMenu(Bundle.getMessage("MenuWarrant"));
                this.updateWarrantMenu();
                return this._warrantMenu;
            }
        }
        return null;
    }

    @InvokeOnGuiThread
    protected synchronized void updateWarrantMenu() {
        this._warrantMenu.removeAll();
        this._warrantMenu.add(WarrantTableAction.getDefault());
        JMenu editWarrantMenu = new JMenu(Bundle.getMessage("EditWarrantMenu"));
        this._warrantMenu.add(editWarrantMenu);
        ActionListener editWarrantAction = e -> this.openWarrantFrame(e.getActionCommand());
        WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
        if (manager.getObjectCount() == 0) {
            JMenuItem noWarrants = new JMenuItem(Bundle.getMessage("None"));
            editWarrantMenu.add(noWarrants);
            noWarrants.setEnabled(false);
        } else {
            for (Warrant warrant : manager.getNamedBeanSet()) {
                JMenuItem mi = new JMenuItem(warrant.getDisplayName());
                mi.setActionCommand(warrant.getDisplayName());
                mi.addActionListener(editWarrantAction);
                editWarrantMenu.add(mi);
            }
        }
        this._warrantMenu.add(new AbstractAction(Bundle.getMessage("CreateWarrant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantTableAction.this.makeWarrantFrame(null, null);
            }
        });
        this._warrantMenu.add(InstanceManager.getDefault(TrackerTableAction.class));
        this._warrantMenu.add(new AbstractAction(Bundle.getMessage("CreateNXWarrant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantTableAction.this.makeNXFrame();
            }
        });
        this._warrantMenu.add(this.makeLogMenu());
        log.debug("updateMenu to {} warrants.", (Object)manager.getObjectCount());
    }

    protected JMenuItem makeLogMenu() {
        JMenuItem mi;
        if (!this._logging) {
            mi = new JMenuItem(Bundle.getMessage("startLog"));
            mi.addActionListener(e -> {
                if (!OpSessionLog.makeLogFile(WarrantTableFrame.getDefault())) {
                    return;
                }
                this._logging = true;
                this._shutDownTask = () -> {
                    OpSessionLog.close();
                    this._logging = false;
                };
                InstanceManager.getDefault(ShutDownManager.class).register(this._shutDownTask);
                this.updateWarrantMenu();
            });
        } else {
            mi = new JMenuItem(Bundle.getMessage("flushLog"));
            mi.addActionListener(e -> OpSessionLog.flush());
            this._warrantMenu.add(mi);
            mi = new JMenuItem(Bundle.getMessage("stopLog"));
            mi.addActionListener(e -> {
                OpSessionLog.close();
                InstanceManager.getDefault(ShutDownManager.class).deregister(this._shutDownTask);
                this._shutDownTask = null;
                this._logging = false;
                this.updateWarrantMenu();
            });
        }
        return mi;
    }

    protected synchronized void writetoLog(String text) {
        if (this._logging) {
            OpSessionLog.writeLn(text);
        }
    }

    @InvokeOnGuiThread
    protected void closeNXFrame() {
        if (this._nxFrame != null) {
            this._nxFrame.clearTempWarrant();
            this._nxFrameLoc = this._nxFrame.getLocation();
            this._nxFrame.dispose();
            this._nxFrame = null;
        }
    }

    @InvokeOnGuiThread
    protected void makeNXFrame() {
        this.closeWarrantFrame();
        if (this._nxFrame == null) {
            this._nxFrame = new NXFrame();
        }
        this._nxFrame.setState(0);
        this._nxFrame.setVisible(true);
        this._nxFrameLoc.setLocation(this._nxFrameLoc);
        this._nxFrame.toFront();
    }

    @InvokeOnGuiThread
    protected boolean closeWarrantFrame() {
        if (this._openFrame != null) {
            if (!this._openFrame.askClose()) {
                return false;
            }
            this._warFrameLoc = this._openFrame.getLocation();
            this._openFrame.close();
            this._openFrame = null;
        }
        return true;
    }

    protected void makeWarrantFrame(Warrant startW, Warrant endW) {
        if (!this.closeWarrantFrame()) {
            return;
        }
        this.closeNXFrame();
        this._openFrame = new WarrantFrame(startW, endW);
        this._openFrame.setState(0);
        this._openFrame.toFront();
    }

    protected void editWarrantFrame(Warrant w) {
        if (!this.closeWarrantFrame()) {
            return;
        }
        this.closeNXFrame();
        this._openFrame = new WarrantFrame(w);
        this._openFrame.setState(0);
        this._openFrame.toFront();
        this._openFrame.setLocation(this._warFrameLoc);
    }

    private void openWarrantFrame(String key) {
        Warrant w = InstanceManager.getDefault(WarrantManager.class).getWarrant(key);
        if (w != null) {
            this.editWarrantFrame(w);
        }
    }

    public synchronized void mouseClickedOnBlock(OBlock block) {
        if (block == null) {
            return;
        }
        if (this._openFrame != null) {
            this._openFrame.mouseClickedOnBlock(block);
            return;
        }
        if (this._nxFrame != null && this._nxFrame.isVisible() && this._nxFrame.isRouteSeaching()) {
            this._nxFrame.mouseClickedOnBlock(block);
            return;
        }
        InstanceManager.getDefault(TrackerTableAction.class).mouseClickedOnBlock(block);
    }

    protected WarrantFrame getOpenFrame() {
        return this._openFrame;
    }

    public boolean errorCheck() {
        this._hasErrors = false;
        JTextArea textArea = new JTextArea(10, 50);
        textArea.setEditable(false);
        textArea.setTabSize(4);
        textArea.append(Bundle.getMessage("ErrWarnAreaMsg"));
        textArea.append("\n\n");
        OBlockManager manager = InstanceManager.getDefault(OBlockManager.class);
        for (OBlock block : manager.getNamedBeanSet()) {
            textArea.append(this.checkPathPortals(block));
        }
        return this.showPathPortalErrors(textArea);
    }

    @Nonnull
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    public String checkPathPortals(OBlock b) {
        if (log.isDebugEnabled()) {
            log.debug("checkPathPortals for {}", (Object)b.getDisplayName());
        }
        StringBuilder sb = new StringBuilder();
        List<Path> pathList = b.getPaths();
        if (pathList.isEmpty()) {
            if (b.getPortals().isEmpty()) {
                sb.append(Bundle.getMessage("NoPortals"));
                sb.append(" ");
            }
            sb.append(Bundle.getMessage("NoPaths", b.getDisplayName()));
            sb.append("\n");
            this._hasErrors = true;
            return sb.toString();
        }
        List<Portal> portalList = b.getPortals();
        ArrayList<String> portalNameList = new ArrayList<String>();
        for (Portal portal : portalList) {
            if (portal.getFromPaths().isEmpty()) {
                sb.append(Bundle.getMessage("BlockPortalNoPath", portal.getName(), portal.getFromBlockName()));
                sb.append("\n");
                this._hasErrors = true;
                return sb.toString();
            }
            if (portal.getToPaths().isEmpty()) {
                sb.append(Bundle.getMessage("BlockPortalNoPath", portal.getName(), portal.getToBlockName()));
                sb.append("\n");
                this._hasErrors = true;
                return sb.toString();
            }
            portalNameList.add(portal.getName());
        }
        for (Path value : pathList) {
            Portal toPortal;
            OPath path = (OPath)value;
            OBlock block = (OBlock)path.getBlock();
            if (block == null || !block.equals(b)) {
                sb.append(Bundle.getMessage("PathWithBadBlock", path.getName(), b.getDisplayName()));
                sb.append("\n");
                this._hasErrors = true;
                return sb.toString();
            }
            String msg = null;
            boolean hasPortal = false;
            Portal fromPortal = path.getFromPortal();
            if (fromPortal != null) {
                if (!fromPortal.isValid()) {
                    msg = fromPortal.getName();
                }
                hasPortal = true;
                portalNameList.remove(fromPortal.getName());
            }
            if ((toPortal = path.getToPortal()) != null) {
                if (!toPortal.isValid()) {
                    msg = toPortal.getName();
                }
                hasPortal = true;
                portalNameList.remove(toPortal.getName());
                if (fromPortal != null && fromPortal.equals(toPortal)) {
                    sb.append(Bundle.getMessage("PathWithDuplicatePortal", path.getName(), b.getDisplayName()));
                    sb.append("\n");
                }
            }
            if (msg != null) {
                sb.append(Bundle.getMessage("PortalNeedsBlock", msg));
                sb.append("\n");
                this._hasErrors = true;
            } else if (!hasPortal) {
                sb.append(Bundle.getMessage("PathNeedsPortal", path.getName(), b.getDisplayName()));
                sb.append("\n");
                this._hasErrors = true;
            }
            boolean validPath = toPortal != null ? (fromPortal != null ? toPortal.isValidPath(path) && fromPortal.isValidPath(path) : toPortal.isValidPath(path)) : (fromPortal != null ? fromPortal.isValidPath(path) : false);
            if (validPath) continue;
            sb.append(Bundle.getMessage("PathNotConnectedToPortal", path.getName(), b.getDisplayName()));
            sb.append("\n");
            this._hasErrors = true;
        }
        for (String s : portalNameList) {
            sb.append(Bundle.getMessage("BlockPortalNoPath", s, b.getDisplayName()));
            sb.append("\n");
            this._hasErrors = true;
        }
        return sb.toString();
    }

    public boolean showPathPortalErrors(JTextArea textArea) {
        if (this._errorDialog != null) {
            this._errorDialog.dispose();
        }
        if (!this._hasErrors) {
            return false;
        }
        JScrollPane scrollPane = new JScrollPane(textArea);
        this._errorDialog = new JDialog();
        this._errorDialog.setTitle(Bundle.getMessage("ErrorDialogTitle"));
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        class MyListener
        extends WindowAdapter
        implements ActionListener {
            MyListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantTableAction.this._errorDialog.dispose();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                WarrantTableAction.this._errorDialog.dispose();
            }
        }
        ok.addActionListener(new MyListener());
        ok.setMaximumSize(ok.getPreferredSize());
        Container contentPane = this._errorDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(ok);
        contentPane.add((Component)panel, "South");
        this._errorDialog.addWindowListener(new MyListener());
        this._errorDialog.pack();
        this._errorDialog.setVisible(true);
        return true;
    }
}

