/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.Path;
import jmri.configurexml.StoreMenu;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.TrackerTableAction;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantFrame;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.logix.WarrantTableModel;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.DnDStringImportHandler;
import jmri.util.DnDTableExportHandler;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantTableFrame
extends JmriJFrame
implements JmriMouseListener {
    protected static final String ramp = Bundle.getMessage("SmoothHalt");
    protected static final String stop = Bundle.getMessage("Stop");
    protected static final String estop = Bundle.getMessage("EStop");
    protected static final String resume = Bundle.getMessage("Resume");
    protected static final String speedup = Bundle.getMessage("SpeedUp");
    protected static final String abort = Bundle.getMessage("Abort");
    protected static final String retryfwd = Bundle.getMessage("MoveToNext");
    protected static final String retrybkwd = Bundle.getMessage("MoveToPrevious");
    static final String[] controls = new String[]{" ", ramp, resume, stop, speedup, retryfwd, estop, abort, LoggerFactory.getLogger(WarrantTableFrame.class).isDebugEnabled() ? "Debug" : ""};
    public static int _maxHistorySize = 40;
    private final JTextField _startWarrant = new JTextField(30);
    private final JTextField _endWarrant = new JTextField(30);
    private JDialog _concatDialog;
    private final JTextField _status = new JTextField(90);
    private final ArrayList<String> _statusHistory = new ArrayList();
    private final WarrantTableModel _model;
    private long lastClicktime;
    private static final String BLANK = "                                                                                                 ";
    private static final Logger log = LoggerFactory.getLogger(WarrantTableFrame.class);

    public static WarrantTableFrame getDefault() {
        WarrantTableFrame instance = InstanceManager.getOptionalDefault(WarrantTableFrame.class).orElseGet(() -> {
            WarrantTableFrame newInstance = InstanceManager.setDefault(WarrantTableFrame.class, new WarrantTableFrame());
            try {
                newInstance.initComponents();
            }
            catch (Exception ex) {
                log.error("Unable to initilize Warrant Table Frame", (Throwable)ex);
            }
            return newInstance;
        });
        if (ThreadingUtil.isGUIThread()) {
            instance.setVisible(true);
        }
        return instance;
    }

    protected WarrantTableModel getModel() {
        return this._model;
    }

    private WarrantTableFrame() {
        super(true, true);
        this.setTitle(Bundle.getMessage("WarrantTable"));
        this._model = new WarrantTableModel(this);
        this._model.init();
    }

    @Override
    public void initComponents() {
        log.debug("initComponents");
        final JTable table = new JTable(this._model);
        TableRowSorter<WarrantTableModel> sorter = new TableRowSorter<WarrantTableModel>(this._model);
        table.setRowSorter(sorter);
        XTableColumnModel tcm = new XTableColumnModel();
        table.setColumnModel(tcm);
        table.getTableHeader().setReorderingAllowed(true);
        table.createDefaultColumnsFromModel();
        this._model.addHeaderListener(table);
        JComboBox<String> cbox = new JComboBox<String>();
        RouteBoxCellEditor comboEd = new RouteBoxCellEditor(cbox);
        ControlBoxCellEditor controlEd = new ControlBoxCellEditor(new JComboBox<String>(controls));
        table.setDefaultRenderer(Boolean.class, new ButtonRenderer());
        table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        table.setDefaultEditor(JComboBox.class, new ValueEditor());
        table.getColumnModel().getColumn(8).setCellEditor(controlEd);
        table.getColumnModel().getColumn(1).setCellEditor(comboEd);
        table.getColumnModel().getColumn(4).setCellEditor(new ButtonEditor(new JButton()));
        table.getColumnModel().getColumn(4).setCellRenderer(new ButtonRenderer());
        table.getColumnModel().getColumn(5).setCellEditor(new ButtonEditor(new JButton()));
        table.getColumnModel().getColumn(5).setCellRenderer(new ButtonRenderer());
        table.getColumnModel().getColumn(6).setCellEditor(new ButtonEditor(new JButton()));
        table.getColumnModel().getColumn(6).setCellRenderer(new ButtonRenderer());
        table.getColumnModel().getColumn(7).setCellEditor(new ButtonEditor(new JButton()));
        table.getColumnModel().getColumn(7).setCellRenderer(new ButtonRenderer());
        table.getColumnModel().getColumn(9).setCellEditor(new ButtonEditor(new JButton()));
        table.getColumnModel().getColumn(9).setCellRenderer(new ButtonRenderer());
        table.getColumnModel().getColumn(10).setCellEditor(new ButtonEditor(new JButton()));
        table.getColumnModel().getColumn(10).setCellRenderer(new ButtonRenderer());
        for (int i = 0; i < this._model.getColumnCount(); ++i) {
            int width = this._model.getPreferredWidth(i);
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        tcm.setColumnVisible(tcm.getColumnByModelIndex(7), false);
        int rowHeight = comboEd.getComponent().getPreferredSize().height;
        table.setRowHeight(rowHeight);
        table.setDragEnabled(true);
        table.setTransferHandler(new DnDTableExportHandler());
        table.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int lastIndex = table.getRowCount() - 1;
                table.changeSelection(lastIndex, 0, false, false);
            }
        });
        JScrollPane tablePane = new JScrollPane(table);
        JLabel title = new JLabel(Bundle.getMessage("ShowWarrants"));
        title.setHorizontalAlignment(0);
        JLabel statusLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("status")));
        this._status.addMouseListener(JmriMouseListener.adapt(this));
        this._status.setBackground(Color.white);
        this._status.setFont(this._status.getFont().deriveFont(1));
        this._status.setEditable(false);
        this._status.setText(BLANK.substring(0, 90));
        JButton nxButton = new JButton(Bundle.getMessage("CreateNXWarrant"));
        nxButton.addActionListener(e -> WarrantTableAction.getDefault().makeNXFrame());
        JButton haltAllButton = new JButton(Bundle.getMessage("HaltAllTrains"));
        haltAllButton.addActionListener(e -> this.haltAllAction());
        haltAllButton.setForeground(Color.RED);
        JPanel footerLeft = new JPanel();
        footerLeft.setLayout(new BorderLayout());
        footerLeft.add((Component)nxButton, "Before");
        footerLeft.add((Component)statusLabel, "After");
        JPanel footer = new JPanel();
        footer.setLayout(new BorderLayout());
        footer.add((Component)footerLeft, "Before");
        footer.add((Component)this._status, "Center");
        footer.add((Component)haltAllButton, "After");
        Container pane = this.getContentPane();
        pane.add((Component)title, "First");
        pane.add((Component)tablePane, "Center");
        pane.add((Component)footer, "Last");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (WarrantTableFrame.this._concatDialog != null) {
                    WarrantTableFrame.this._concatDialog.dispose();
                }
                WarrantTableFrame.this._model.dispose();
                WarrantTableFrame.this.dispose();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        fileMenu.add(new StoreMenu());
        JMenu warrantMenu = new JMenu(Bundle.getMessage("MenuWarrant"));
        warrantMenu.add(new AbstractAction(Bundle.getMessage("ConcatWarrants")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantTableFrame.this.concatMenuAction();
            }
        });
        warrantMenu.add(new AbstractAction(Bundle.getMessage("CreateWarrant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantTableAction.getDefault().makeWarrantFrame(null, null);
            }
        });
        warrantMenu.add(InstanceManager.getDefault(TrackerTableAction.class));
        warrantMenu.add(new AbstractAction(Bundle.getMessage("CreateNXWarrant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarrantTableAction.getDefault().makeNXFrame();
            }
        });
        warrantMenu.add(WarrantTableAction.getDefault().makeLogMenu());
        menuBar.add(warrantMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.logix.WarrantTable", true);
        this.pack();
    }

    private void haltAllAction() {
        this._model.haltAllTrains();
    }

    private void concatMenuAction() {
        this._concatDialog = new JDialog(this, Bundle.getMessage("ConcatWarrants"), false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel pp = new JPanel();
        pp.setLayout(new FlowLayout());
        pp.add(new JLabel("A:"));
        pp.add(this._startWarrant);
        this._startWarrant.setDragEnabled(true);
        this._startWarrant.setTransferHandler(new DnDStringImportHandler());
        panel.add(pp);
        pp = new JPanel();
        pp.setLayout(new FlowLayout());
        pp.add(new JLabel("B:"));
        pp.add(this._endWarrant);
        this._endWarrant.setDragEnabled(true);
        this._endWarrant.setTransferHandler(new DnDStringImportHandler());
        panel.add(pp);
        JButton concatButton = new JButton(Bundle.getMessage("Concatenate"));
        concatButton.addActionListener(e -> this.concatenate(this._startWarrant.getText(), this._endWarrant.getText()));
        panel.add((Component)concatButton, Float.valueOf(0.5f));
        mainPanel.add(panel);
        this._concatDialog.getContentPane().add(mainPanel);
        this._concatDialog.setLocation(this.getLocation().x + 200, this.getLocation().y + 200);
        this._concatDialog.pack();
        this._concatDialog.setVisible(true);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="OPath extends Path")
    private void concatenate(String startName, String endName) {
        WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
        Warrant startW = manager.getWarrant(startName.trim());
        Warrant endW = manager.getWarrant(endName.trim());
        if (startW == null || endW == null) {
            this.showWarning("BadWarrantNames");
            return;
        }
        BlockOrder last = startW.getLastOrder();
        BlockOrder next = endW.getfirstOrder();
        if (last == null || next == null) {
            this.showWarning("EmptyRoutes");
            return;
        }
        if (!last.getBlock().equals(next.getBlock())) {
            this.showWarning("BlocksDontMatch");
            return;
        }
        if (!last.getPathName().equals(next.getPathName())) {
            boolean foundPath = false;
            String entryName = last.getEntryName();
            String exitName = next.getExitName();
            Iterator<Path> iter = last.getBlock().getPaths().iterator();
            while (iter.hasNext()) {
                String pathName = ((OPath)iter.next()).getName();
                if (!pathName.equals(entryName) || !pathName.equals(exitName)) continue;
                last.setPathName(pathName);
                foundPath = true;
                break;
            }
            if (!foundPath) {
                this.showWarning("RoutesDontMatch");
                return;
            }
        }
        WarrantTableAction.getDefault().makeWarrantFrame(startW, endW);
        this._concatDialog.dispose();
    }

    protected boolean askStopQuestion(String blockName) {
        boolean includeAllCmds = false;
        if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("stopAtBlock", blockName), Bundle.getMessage("QuestionTitle"), 0, 3) == 0) {
            includeAllCmds = true;
        }
        return includeAllCmds;
    }

    public void showWarning(String msg) {
        this.setVisible(true);
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage(msg, this._startWarrant.getText(), this._endWarrant.getText()), Bundle.getMessage("WarningTitle"), 2);
    }

    public String runTrain(Warrant w, int mode) {
        Warrant warrant;
        long time = System.currentTimeMillis();
        if (time - this.lastClicktime < 1000L) {
            return null;
        }
        this.lastClicktime = time;
        String msg = null;
        WarrantFrame frame = WarrantTableAction.getDefault().getOpenFrame();
        if (frame != null && (warrant = frame.getWarrant()) != null && w.equals(warrant) && frame.isRunning()) {
            msg = Bundle.getMessage("CannotRun", w.getDisplayName(), Bundle.getMessage("TrainRunning", warrant.getTrainName()));
        }
        if (msg == null) {
            msg = this._model.checkAddressInUse(w);
        }
        if (msg == null) {
            msg = w.checkforTrackers();
        }
        if (msg == null && (msg = w.setRunMode(mode, null, null, null, w.getRunBlind())) != null) {
            w.deAllocate();
        }
        if (msg != null) {
            return Bundle.getMessage("CannotRun", w.getDisplayName(), msg);
        }
        return null;
    }

    @Override
    public void mouseClicked(JmriMouseEvent event) {
        int clicks = event.getClickCount();
        if (clicks > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = this._statusHistory.size() - 1; i >= 0; --i) {
                sb.append(this._statusHistory.get(i));
                sb.append('\n');
            }
            StringSelection transferable = new StringSelection(sb.toString());
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(transferable, null);
        } else {
            JPopupMenu popup = new JPopupMenu();
            for (int i = this._statusHistory.size() - 1; i >= 0; --i) {
                popup.add(this._statusHistory.get(i));
            }
            popup.show(this._status, 0, 0);
        }
    }

    @Override
    public void mousePressed(JmriMouseEvent event) {
    }

    @Override
    public void mouseEntered(JmriMouseEvent event) {
    }

    @Override
    public void mouseExited(JmriMouseEvent event) {
    }

    @Override
    public void mouseReleased(JmriMouseEvent event) {
    }

    void setStatusText(String msg, Color c, boolean save) {
        this._status.setForeground(c);
        this._status.setText(msg);
        if (save && msg != null && msg.length() > 0) {
            this._statusHistory.add(msg);
            WarrantTableAction.getDefault().writetoLog(msg);
            while (this._statusHistory.size() > _maxHistorySize) {
                this._statusHistory.remove(0);
            }
        }
    }

    protected String getStatus() {
        return this._status.getText();
    }

    private static class ControlBoxCellEditor
    extends DefaultCellEditor {
        ControlBoxCellEditor(JComboBox<String> comboBox) {
            super(comboBox);
            comboBox.setFont(new Font(null, 0, 12));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int column) {
            Component component = this.getComponent();
            if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                comboBox.removeItemAt(0);
                comboBox.insertItemAt((String)value, 0);
                comboBox.setSelectedIndex(0);
                if (log.isDebugEnabled()) {
                    int row = r;
                    if (table.getRowSorter() != null) {
                        row = table.convertRowIndexToModel(row);
                    }
                    WarrantTableModel model = (WarrantTableModel)table.getModel();
                    Warrant warrant = model.getWarrantAt(row);
                    log.debug("getTableCellEditorComponent warrant= {}, selection= {}", (Object)warrant.getDisplayName(), comboBox.getSelectedItem());
                }
            } else {
                log.error("Unexpected editor component: {}", (Object)component);
            }
            return component;
        }
    }

    private static class RouteBoxCellEditor
    extends DefaultCellEditor {
        RouteBoxCellEditor(JComboBox<String> comboBox) {
            super(comboBox);
            comboBox.setFont(new Font(null, 0, 12));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int column) {
            TableModel m = table.getModel();
            WarrantTableModel model = null;
            if (m instanceof WarrantTableModel) {
                model = (WarrantTableModel)m;
            }
            if (model == null) {
                log.error("Unexpected table model: {}", (Object)m);
            }
            int row = r;
            if (table.getRowSorter() != null) {
                row = table.convertRowIndexToModel(row);
            }
            Warrant warrant = null;
            if (model != null) {
                warrant = model.getWarrantAt(row);
            }
            if (warrant == null) {
                log.warn("getWarrantAt row= {}, Warrant is null!", (Object)row);
                return this.getComponent();
            }
            Component component = this.getComponent();
            if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                comboBox.removeAllItems();
                List<BlockOrder> orders = warrant.getBlockOrders();
                for (int i = 0; i < orders.size(); ++i) {
                    BlockOrder order = orders.get(i);
                    comboBox.addItem(order.getBlock().getDisplayName() + ": - " + order.getPath().getName());
                }
            } else {
                log.error("Unexpected editor component: {}", (Object)component);
            }
            return component;
        }
    }
}

