/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jmri.jmrit.logixng.Bundle;
import jmri.util.SystemType;

public abstract class Category
implements Comparable<Category> {
    public static final Item ITEM = new Item();
    public static final Common COMMON = new Common();
    public static final FlowControl FLOW_CONTROL = new FlowControl();
    public static final Other OTHER = new Other();
    public static final Linux LINUX = new Linux();
    private static final List<Category> _categories = new CopyOnWriteArrayList<Category>();
    private final String _name;
    private final String _description;
    private final int _order;

    public static List<Category> values() {
        return Collections.unmodifiableList(_categories);
    }

    public static void registerCategory(Category category) {
        _categories.add(category);
    }

    protected Category(String name, String description, int order) {
        this._name = name;
        this._description = description;
        this._order = order;
    }

    public String name() {
        return this._name;
    }

    public final String toString() {
        return this._description;
    }

    public int order() {
        return this._order;
    }

    public boolean equals(Object o) {
        if (o instanceof Category) {
            Category c = (Category)o;
            return this._description.equals(c._description) && this._name.equals(c._name);
        }
        return false;
    }

    public int hashCode() {
        return this._description.hashCode();
    }

    @Override
    public int compareTo(Category c) {
        if (this._order < c.order()) {
            return -1;
        }
        if (this._order > c.order()) {
            return 1;
        }
        return 0;
    }

    static {
        Category.registerCategory(ITEM);
        Category.registerCategory(COMMON);
        Category.registerCategory(FLOW_CONTROL);
        Category.registerCategory(OTHER);
        if (SystemType.isLinux()) {
            Category.registerCategory(LINUX);
        }
    }

    public static final class Other
    extends Category {
        public Other() {
            super("OTHER", Bundle.getMessage("CategoryOther"), Integer.MAX_VALUE);
        }
    }

    public static final class Linux
    extends Category {
        public Linux() {
            super("LINUX", Bundle.getMessage("CategoryLinux"), 2000);
        }
    }

    public static final class FlowControl
    extends Category {
        public FlowControl() {
            super("FLOW_CONTROL", Bundle.getMessage("CategoryFlowControl"), 210);
        }
    }

    public static final class Common
    extends Category {
        public Common() {
            super("COMMON", Bundle.getMessage("CategoryCommon"), 200);
        }
    }

    public static final class Item
    extends Category {
        public Item() {
            super("ITEM", Bundle.getMessage("CategoryItem"), 100);
        }
    }
}

