/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.Reference;
import jmri.jmrit.logixng.Bundle;
import jmri.jmrit.logixng.LogixNG_ScriptBindings;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.Stack;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.LocalVariableExpressionVariable;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.script.JmriScriptEngineManager;
import jmri.util.FileUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SymbolTable {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"}, justification="Interfaces cannot have private fields")
    public static final Logger log = LoggerFactory.getLogger(SymbolTable.class);

    public Map<String, Symbol> getSymbols();

    public Map<String, Object> getSymbolValues();

    public Object getValue(String var1);

    public Stack.ValueAndType getValueAndType(String var1);

    public boolean hasValue(String var1);

    public void setValue(String var1, Object var2);

    public void createSymbols(Collection<? extends VariableData> var1) throws JmriException;

    public void createSymbols(SymbolTable var1, Collection<? extends VariableData> var2) throws JmriException;

    public void removeSymbols(Collection<? extends VariableData> var1) throws JmriException;

    public void printSymbolTable(PrintWriter var1);

    public static boolean validateName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    public Stack getStack();

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="The code prints a complex variable, like a map, to the log")
    public static void printVariable(Logger log, String pad, String name, Object value, boolean expandArraysAndMaps, boolean showClassName, String headerName, String headerValue) {
        if (expandArraysAndMaps && value instanceof Map) {
            log.warn("{}{}: {},", new Object[]{pad, headerName, name});
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                String className = showClassName && entry.getValue() != null ? ", " + entry.getValue().getClass().getName() : "";
                log.warn("{}{}{} -> {}{},", new Object[]{pad, pad, entry.getKey(), entry.getValue(), className});
            }
        } else if (expandArraysAndMaps && value instanceof List) {
            log.warn("{}{}: {},", new Object[]{pad, headerName, name});
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                Object val = list.get(i);
                String className = showClassName && val != null ? ", " + val.getClass().getName() : "";
                log.warn("{}{}{}: {}{},", new Object[]{pad, pad, i, val, className});
            }
        } else {
            String className;
            String string = className = showClassName && value != null ? ", " + value.getClass().getName() : "";
            if (value instanceof NamedBean) {
                value = ((NamedBean)value).getDisplayName();
            }
            log.warn("{}{}: {}, {}: {}{}", new Object[]{pad, headerName, name, headerValue, value, className});
        }
    }

    private static Object runScriptExpression(SymbolTable symbolTable, String initialData) {
        String script = "import jmri\nvariable.set(" + initialData + ")";
        JmriScriptEngineManager scriptEngineManager = JmriScriptEngineManager.getDefault();
        SimpleBindings bindings = new SimpleBindings();
        LogixNG_ScriptBindings.addScriptBindings(bindings);
        Reference variable = new Reference();
        bindings.put("variable", (Object)variable);
        bindings.put("symbolTable", (Object)symbolTable);
        try {
            String theScript = String.format("import jmri%n", new Object[0]) + script;
            scriptEngineManager.getEngineByName("jython").eval(theScript, (Bindings)bindings);
        }
        catch (ScriptException e) {
            log.warn("cannot execute script", (Throwable)e);
            return null;
        }
        return variable.get();
    }

    private static Object runScriptFile(SymbolTable symbolTable, String initialData) {
        JmriScriptEngineManager scriptEngineManager = JmriScriptEngineManager.getDefault();
        SimpleBindings bindings = new SimpleBindings();
        LogixNG_ScriptBindings.addScriptBindings(bindings);
        Reference variable = new Reference();
        bindings.put("variable", (Object)variable);
        bindings.put("symbolTable", (Object)symbolTable);
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FileUtil.getExternalFilename(initialData)), StandardCharsets.UTF_8);){
            scriptEngineManager.getEngineByName("jython").eval((Reader)reader, (Bindings)bindings);
        }
        catch (IOException | ScriptException e) {
            log.warn("cannot execute script \"{}\"", (Object)initialData, (Object)e);
            return null;
        }
        return variable.get();
    }

    private static Object copyLogixNG_Table(String initialData) {
        NamedTable myTable = InstanceManager.getDefault(NamedTableManager.class).getNamedTable(initialData);
        ConcurrentHashMap myMap = new ConcurrentHashMap();
        for (int row = 1; row <= myTable.numRows(); ++row) {
            Object rowKey = myTable.getCell(row, 0);
            ConcurrentHashMap<Object, Object> rowMap = new ConcurrentHashMap<Object, Object>();
            for (int col = 1; col <= myTable.numColumns(); ++col) {
                Object columnKey = myTable.getCell(0, col);
                Object cellValue = myTable.getCell(row, col);
                rowMap.put(columnKey, cellValue);
            }
            myMap.put(rowKey, rowMap);
        }
        return myMap;
    }

    private static void validateValue(Type type, String name, String initialData, String descr) {
        if (initialData == null) {
            throw new IllegalArgumentException(String.format("Initial data is null for %s \"%s\". Can't set value %s.", type._descr, name, descr));
        }
        if (initialData.isBlank()) {
            throw new IllegalArgumentException(String.format("Initial data is empty string for %s \"%s\". Can't set value %s.", type._descr, name, descr));
        }
    }

    public static Object getInitialValue(Type type, String name, InitialValueType initialType, String initialData, SymbolTable symbolTable, Map<String, Symbol> symbols) throws ParserException, JmriException {
        switch (initialType) {
            case None: {
                return null;
            }
            case Boolean: {
                SymbolTable.validateValue(type, name, initialData, "to boolean");
                return TypeConversionUtil.convertToBoolean(initialData, true);
            }
            case Integer: {
                SymbolTable.validateValue(type, name, initialData, "to integer");
                return Long.valueOf(initialData);
            }
            case FloatingNumber: {
                SymbolTable.validateValue(type, name, initialData, "to floating number");
                return Double.valueOf(initialData);
            }
            case String: {
                return initialData;
            }
            case Array: {
                ArrayList<Object> array;
                ArrayList<Object> initialValue = array = new ArrayList<Object>();
                String initialValueData = initialData;
                if (initialValueData != null && !initialValueData.isEmpty()) {
                    Object data = "";
                    String[] parts = initialValueData.split(":", 2);
                    if (parts.length > 1) {
                        initialValueData = parts[0];
                        if (Character.isDigit(parts[1].charAt(0))) {
                            try {
                                data = Long.valueOf(parts[1]);
                            }
                            catch (NumberFormatException e) {
                                try {
                                    data = Double.valueOf(parts[1]);
                                }
                                catch (NumberFormatException e2) {
                                    throw new IllegalArgumentException("Data is not a number", e2);
                                }
                            }
                        } else {
                            data = parts[1].charAt(0) == '\"' && parts[1].charAt(parts[1].length() - 1) == '\"' ? parts[1].substring(1, parts[1].length() - 1) : symbolTable.getValue(parts[1]).toString();
                        }
                    }
                    try {
                        int count = Character.isDigit(initialValueData.charAt(0)) ? Integer.parseInt(initialValueData) : Integer.parseInt(symbolTable.getValue(initialValueData).toString());
                        for (int i = 0; i < count; ++i) {
                            array.add(data);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Initial capacity is not an integer", e);
                    }
                }
                return initialValue;
            }
            case Map: {
                return new HashMap();
            }
            case LocalVariable: {
                SymbolTable.validateValue(type, name, initialData, "from local variable");
                return symbolTable.getValue(initialData);
            }
            case Memory: {
                SymbolTable.validateValue(type, name, initialData, "from memory");
                Memory m = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(initialData);
                if (m != null) {
                    return m.getValue();
                }
                return null;
            }
            case Reference: {
                SymbolTable.validateValue(type, name, initialData, "from reference");
                if (ReferenceUtil.isReference(initialData)) {
                    return ReferenceUtil.getReference(symbolTable, initialData);
                }
                log.error("\"{}\" is not a reference", (Object)initialData);
                return null;
            }
            case Formula: {
                SymbolTable.validateValue(type, name, initialData, "from formula");
                RecursiveDescentParser parser = SymbolTable.createParser(symbols);
                ExpressionNode expressionNode = parser.parseExpression(initialData);
                return expressionNode.calculate(symbolTable);
            }
            case ScriptExpression: {
                SymbolTable.validateValue(type, name, initialData, "from script expression");
                return SymbolTable.runScriptExpression(symbolTable, initialData);
            }
            case ScriptFile: {
                SymbolTable.validateValue(type, name, initialData, "from script file");
                return SymbolTable.runScriptFile(symbolTable, initialData);
            }
            case LogixNG_Table: {
                SymbolTable.validateValue(type, name, initialData, "from logixng table");
                return SymbolTable.copyLogixNG_Table(initialData);
            }
        }
        log.error("definition._initialValueType has invalid value: {}", (Object)initialType.name());
        throw new IllegalArgumentException("definition._initialValueType has invalid value: " + initialType.name());
    }

    private static RecursiveDescentParser createParser(Map<String, Symbol> symbols) throws ParserException {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (Symbol symbol : Collections.unmodifiableMap(symbols).values()) {
            variables.put(symbol.getName(), new LocalVariableExpressionVariable(symbol.getName()));
        }
        return new RecursiveDescentParser(variables);
    }

    public static Object validateStrictTyping(InitialValueType type, Object oldValue, Object newValue) throws NumberFormatException {
        switch (type) {
            case None: {
                return newValue;
            }
            case Boolean: {
                return TypeConversionUtil.convertToBoolean(newValue, true);
            }
            case Integer: {
                return TypeConversionUtil.convertToLong(newValue, true, true);
            }
            case FloatingNumber: {
                return TypeConversionUtil.convertToDouble(newValue, false, true, true);
            }
            case String: {
                if (newValue == null) {
                    return null;
                }
                return newValue.toString();
            }
        }
        if (oldValue == null) {
            return newValue;
        }
        throw new IllegalArgumentException(String.format("A variable of type %s cannot change its value", type._descr));
    }

    public static class SymbolNotFound
    extends IllegalArgumentException {
        public SymbolNotFound(String message) {
            super(message);
        }
    }

    public static enum Type {
        Global("global variable"),
        Local("local variable"),
        Parameter("parameter");

        private final String _descr;

        private Type(String descr) {
            this._descr = descr;
        }
    }

    public static class VariableData {
        public String _name;
        public InitialValueType _initialValueType = InitialValueType.None;
        public String _initialValueData;

        public VariableData(String name, InitialValueType initialValueType, String initialValueData) {
            this._name = name;
            if (initialValueType != null) {
                this._initialValueType = initialValueType;
            }
            this._initialValueData = initialValueData;
        }

        public VariableData(VariableData variableData) {
            this._name = variableData._name;
            this._initialValueType = variableData._initialValueType;
            this._initialValueData = variableData._initialValueData;
        }

        public String getName() {
            return this._name;
        }

        public InitialValueType getInitialValueType() {
            return this._initialValueType;
        }

        public String getInitialValueData() {
            return this._initialValueData;
        }
    }

    public static interface Symbol {
        public String getName();

        public int getIndex();
    }

    public static enum InitialValueType {
        None(Bundle.getMessage("InitialValueType_None"), true),
        Boolean(Bundle.getMessage("InitialValueType_Boolean"), true),
        Integer(Bundle.getMessage("InitialValueType_Integer"), true),
        FloatingNumber(Bundle.getMessage("InitialValueType_FloatingNumber"), true),
        String(Bundle.getMessage("InitialValueType_String"), true),
        Array(Bundle.getMessage("InitialValueType_Array"), false),
        Map(Bundle.getMessage("InitialValueType_Map"), false),
        LocalVariable(Bundle.getMessage("InitialValueType_LocalVariable"), true),
        Memory(Bundle.getMessage("InitialValueType_Memory"), true),
        Reference(Bundle.getMessage("InitialValueType_Reference"), true),
        Formula(Bundle.getMessage("InitialValueType_Formula"), true),
        ScriptExpression(Bundle.getMessage("InitialValueType_ScriptExpression"), true),
        ScriptFile(Bundle.getMessage("InitialValueType_ScriptFile"), true),
        LogixNG_Table(Bundle.getMessage("InitialValueType_LogixNGTable"), true);

        private final String _descr;
        private final boolean _isValidAsParameter;

        private InitialValueType(String descr, boolean isValidAsParameter) {
            this._descr = descr;
            this._isValidAsParameter = isValidAsParameter;
        }

        public String toString() {
            return this._descr;
        }

        public boolean isValidAsParameter() {
            return this._isValidAsParameter;
        }
    }
}

