/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;

public class ActionAudio
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Audio> _selectNamedBean = new LogixNG_SelectNamedBean<Audio>(this, Audio.class, InstanceManager.getDefault(AudioManager.class), this);
    private final LogixNG_SelectEnum<Operation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])Operation.values(), (Enum)Operation.Play, (PropertyChangeListener)this);

    public ActionAudio(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionAudio copy = new ActionAudio(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Audio> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<Operation> getSelectEnum() {
        return this._selectEnum;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        Audio audio = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (audio == null) {
            return;
        }
        Operation operation = this._selectEnum.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            if (audio.getSubType() == 'S') {
                AudioSource audioSource = (AudioSource)audio;
                switch (operation) {
                    case Play: {
                        audioSource.play();
                        break;
                    }
                    case Stop: {
                        audioSource.stop();
                        break;
                    }
                    case PlayToggle: {
                        audioSource.togglePlay();
                        break;
                    }
                    case Pause: {
                        audioSource.pause();
                        break;
                    }
                    case Resume: {
                        audioSource.resume();
                        break;
                    }
                    case PauseToggle: {
                        audioSource.togglePause();
                        break;
                    }
                    case Rewind: {
                        audioSource.rewind();
                        break;
                    }
                    case FadeIn: {
                        audioSource.fadeIn();
                        break;
                    }
                    case FadeOut: {
                        audioSource.fadeOut();
                        break;
                    }
                    case ResetPosition: {
                        audioSource.resetCurrentPosition();
                        break;
                    }
                }
            } else if (audio.getSubType() == 'L') {
                AudioListener audioListener = (AudioListener)audio;
                switch (operation) {
                    case ResetPosition: {
                        audioListener.resetCurrentPosition();
                        break;
                    }
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionAudio_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String operation = this._selectEnum.getDescription(locale);
        return Bundle.getMessage(locale, "ActionAudio_Long", operation, namedBean);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum Operation {
        Play(Bundle.getMessage("ActionAudio_Operation_Play")),
        PlayToggle(Bundle.getMessage("ActionAudio_Operation_PlayToggle")),
        Pause(Bundle.getMessage("ActionAudio_Operation_Pause")),
        PauseToggle(Bundle.getMessage("ActionAudio_Operation_PauseToggle")),
        Resume(Bundle.getMessage("ActionAudio_Operation_Resume")),
        Stop(Bundle.getMessage("ActionAudio_Operation_Stop")),
        FadeIn(Bundle.getMessage("ActionAudio_Operation_FadeIn")),
        FadeOut(Bundle.getMessage("ActionAudio_Operation_FadeOut")),
        Rewind(Bundle.getMessage("ActionAudio_Operation_Rewind")),
        ResetPosition(Bundle.getMessage("ActionAudio_Operation_ResetPosition"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

