/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Sensor;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionBlock
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Block> _selectNamedBean = new LogixNG_SelectNamedBean<Block>(this, Block.class, InstanceManager.getDefault(BlockManager.class), this);
    private final LogixNG_SelectEnum<DirectOperation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])DirectOperation.values(), (Enum)DirectOperation.SetOccupied, (PropertyChangeListener)this);
    private final LogixNG_SelectString _selectBlockValue = new LogixNG_SelectString(this, this);
    private static final Logger log = LoggerFactory.getLogger(ActionBlock.class);

    public ActionBlock(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionBlock copy = new ActionBlock(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        this._selectBlockValue.copy(copy._selectBlockValue);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Block> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<DirectOperation> getSelectEnum() {
        return this._selectEnum;
    }

    public LogixNG_SelectString getSelectBlockValue() {
        return this._selectBlockValue;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        DirectOperation oper;
        ConditionalNG conditionalNG = this.getConditionalNG();
        Block block = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (block == null) {
            return;
        }
        DirectOperation theOper = oper = this._selectEnum.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theOper) {
                case SetOccupied: {
                    Sensor sensor = block.getSensor();
                    if (sensor != null) {
                        try {
                            sensor.setKnownState(2);
                        }
                        catch (JmriException ex) {
                            log.debug("Exception setting sensor active");
                        }
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorSensor", block.getDisplayName()));
                }
                case SetNotOccupied: {
                    Sensor sensor = block.getSensor();
                    if (sensor != null) {
                        try {
                            sensor.setKnownState(4);
                        }
                        catch (JmriException ex) {
                            log.debug("Exception setting sensor inactive");
                        }
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorSensor", block.getDisplayName()));
                }
                case SetAltColorOn: {
                    LayoutBlock lblk = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(block);
                    if (lblk != null) {
                        lblk.setUseExtraColor(true);
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorLayoutBlock", block.getDisplayName()));
                }
                case SetAltColorOff: {
                    LayoutBlock lblk = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(block);
                    if (lblk != null) {
                        lblk.setUseExtraColor(false);
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorLayoutBlock", block.getDisplayName()));
                }
                case SetNullValue: {
                    block.setValue(null);
                    break;
                }
                case SetValue: {
                    block.setValue(this._selectBlockValue.evaluateValue(conditionalNG));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid oper state: " + theOper.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionBlock_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String state = this._selectEnum.getDescription(locale);
        if (this._selectEnum.isDirectAddressing() && this._selectEnum.getEnum() == DirectOperation.SetValue) {
            String bundleKey = "ActionBlock_Long_Value";
            return Bundle.getMessage(locale, bundleKey, namedBean, this._selectBlockValue.getDescription(locale));
        }
        return Bundle.getMessage(locale, "ActionBlock_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
        this._selectBlockValue.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
        this._selectBlockValue.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum DirectOperation {
        SetOccupied(Bundle.getMessage("ActionBlock_SetOccupied")),
        SetNotOccupied(Bundle.getMessage("ActionBlock_SetNotOccupied")),
        SetAltColorOn(Bundle.getMessage("ActionBlock_SetAltColorOn")),
        SetAltColorOff(Bundle.getMessage("ActionBlock_SetAltColorOff")),
        SetNullValue(Bundle.getMessage("ActionBlock_SetNullValue")),
        SetValue(Bundle.getMessage("ActionBlock_SetValue"));

        private final String _text;

        private DirectOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

