/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Timebase;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectInteger;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;

public class ActionClock
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectEnum<ClockState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])ClockState.values(), (Enum)ClockState.SetClock, (PropertyChangeListener)this);
    private final LogixNG_SelectInteger _selectValue = new LogixNG_SelectInteger(this, this, new TimeFormatterParserValidator());

    public ActionClock(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionClock copy = new ActionClock(sysName, userName);
        copy.setComment(this.getComment());
        this._selectEnum.copy(copy._selectEnum);
        this._selectValue.copy(copy._selectValue);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectEnum<ClockState> getSelectEnum() {
        return this._selectEnum;
    }

    public LogixNG_SelectInteger getSelectTime() {
        return this._selectValue;
    }

    public static String formatTime(int minutes) {
        String hhmm = "00:00";
        if (minutes >= 0 && minutes < 1440) {
            hhmm = String.format("%02d:%02d", minutes / 60, minutes % 60);
        }
        return hhmm;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        ClockState theState = this._selectEnum.evaluateEnum(this.getConditionalNG());
        int theValue = this._selectValue.evaluateValue(this.getConditionalNG());
        Timebase timebase = InstanceManager.getDefault(Timebase.class);
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theState) {
                case SetClock: {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(timebase.getTime());
                    cal.set(11, theValue / 60);
                    cal.set(12, theValue % 60);
                    cal.set(13, 0);
                    timebase.userSetTime(cal.getTime());
                    break;
                }
                case StartClock: {
                    timebase.setRun(true);
                    break;
                }
                case StopClock: {
                    timebase.setRun(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid clock state: " + theState.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionClock_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String value = this._selectValue.isDirectAddressing() ? ActionClock.formatTime(this._selectValue.getValue()) : this._selectValue.getDescription(locale);
        if (this._selectEnum.isDirectAddressing()) {
            if (this._selectEnum.getEnum() == ClockState.SetClock) {
                return Bundle.getMessage(locale, "ActionClock_LongTime", this._selectEnum.getDescription(locale), value);
            }
            return Bundle.getMessage(locale, "ActionClock_Long", this._selectEnum.getDescription(locale), value);
        }
        return Bundle.getMessage(locale, "ActionClock_LongTimeIndirect", this._selectEnum.getDescription(locale), value);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectEnum.registerListeners();
        this._selectValue.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectEnum.unregisterListeners();
        this._selectValue.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    private static class TimeFormatterParserValidator
    implements LogixNG_SelectInteger.FormatterParserValidator {
        private TimeFormatterParserValidator() {
        }

        @Override
        public int getInitialValue() {
            return 0;
        }

        @Override
        public String format(int value) {
            return ActionClock.formatTime(value);
        }

        @Override
        public int parse(String str) {
            try {
                int minutes = Integer.parseInt(str);
                if (minutes < 0 || minutes > 1439) {
                    return 0;
                }
                return minutes;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    LocalTime newHHMM = LocalTime.parse(str.trim(), DateTimeFormatter.ofPattern("H:mm"));
                    int minutes = newHHMM.getHour() * 60 + newHHMM.getMinute();
                    if (minutes < 0 || minutes > 1439) {
                        return 0;
                    }
                    return minutes;
                }
                catch (DateTimeParseException ex) {
                    return 0;
                }
            }
        }

        @Override
        public String validate(String str) {
            try {
                int minutes = Integer.parseInt(str);
                if (minutes < 0 || minutes > 1439) {
                    return Bundle.getMessage("ActionClock_RangeError");
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    LocalTime newHHMM = LocalTime.parse(str.trim(), DateTimeFormatter.ofPattern("H:mm"));
                    int minutes = newHHMM.getHour() * 60 + newHHMM.getMinute();
                    if (minutes < 0 || minutes > 1439) {
                        return Bundle.getMessage("ActionClock_RangeError");
                    }
                }
                catch (DateTimeParseException ex) {
                    return Bundle.getMessage("ActionClock_ParseError", ex.getParsedString());
                }
                return null;
            }
        }
    }

    public static enum ClockState {
        SetClock(Bundle.getMessage("ActionClock_SetClock")),
        StartClock(Bundle.getMessage("ActionClock_StartClock")),
        StopClock(Bundle.getMessage("ActionClock_StopClock"));

        private final String _text;

        private ClockState(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

