/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectDouble;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;

public class ActionClockRate
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectEnum<ClockState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])ClockState.values(), (Enum)ClockState.SetClockRate, (PropertyChangeListener)this);
    private final LogixNG_SelectDouble _selectSpeed = new LogixNG_SelectDouble(this, 3, this, new DefaultFormatterParserValidator());

    public ActionClockRate(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionClockRate copy = new ActionClockRate(sysName, userName);
        copy.setComment(this.getComment());
        this._selectEnum.copy(copy._selectEnum);
        this._selectSpeed.copy(copy._selectSpeed);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectEnum<ClockState> getSelectEnum() {
        return this._selectEnum;
    }

    public LogixNG_SelectDouble getSelectSpeed() {
        return this._selectSpeed;
    }

    public static String formatSpeed(Locale locale, double speed) {
        return String.format(locale, "%1.3f", speed);
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        ClockState theState = this._selectEnum.evaluateEnum(this.getConditionalNG());
        double theValue = this._selectSpeed.evaluateValue(this.getConditionalNG());
        Timebase timebase = InstanceManager.getDefault(Timebase.class);
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theState) {
                case SetClockRate: {
                    try {
                        timebase.userSetRate(theValue);
                    }
                    catch (TimebaseRateException timebaseRateException) {}
                    break;
                }
                case IncreaseClockRate: {
                    try {
                        timebase.userSetRate(timebase.userGetRate() + theValue);
                    }
                    catch (TimebaseRateException timebaseRateException) {}
                    break;
                }
                case DecreaseClockRate: {
                    try {
                        timebase.userSetRate(timebase.userGetRate() - theValue);
                    }
                    catch (TimebaseRateException timebaseRateException) {}
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid clock state: " + theState.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionClockRate_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String value = this._selectSpeed.isDirectAddressing() ? ActionClockRate.formatSpeed(locale, this._selectSpeed.getValue()) : this._selectSpeed.getDescription(locale);
        if (this._selectEnum.isDirectAddressing()) {
            if (this._selectEnum.getEnum() == ClockState.SetClockRate) {
                return Bundle.getMessage(locale, "ActionClockRate_LongTo", this._selectEnum.getDescription(locale), value);
            }
            return Bundle.getMessage(locale, "ActionClockRate_LongWith", this._selectEnum.getDescription(locale), value);
        }
        return Bundle.getMessage(locale, "ActionClockRate_LongTo", this._selectEnum.getDescription(locale), value);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectEnum.registerListeners();
        this._selectSpeed.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectEnum.unregisterListeners();
        this._selectSpeed.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    private static class DefaultFormatterParserValidator
    extends LogixNG_SelectDouble.DefaultFormatterParserValidator {
        private DefaultFormatterParserValidator() {
        }

        @Override
        public double getInitialValue() {
            return 1.0;
        }

        @Override
        public double parse(String str) {
            try {
                double value = Double.parseDouble(str);
                if (value < 0.1 || value > 100.0) {
                    return 0.1;
                }
                return value;
            }
            catch (NumberFormatException ex) {
                return 0.1;
            }
        }

        @Override
        public String validate(String str) {
            try {
                double value = Double.parseDouble(str);
                if (value < 0.1 || value > 100.0) {
                    return Bundle.getMessage("ActionClockRate_RangeError", 0.1, 100.0);
                }
                return null;
            }
            catch (NumberFormatException ex) {
                return Bundle.getMessage("ActionClockRate_ParseError", str);
            }
        }
    }

    public static enum ClockState {
        SetClockRate(Bundle.getMessage("ActionClockRate_SetClockRate")),
        IncreaseClockRate(Bundle.getMessage("ActionClockRate_IncreaseClockRate")),
        DecreaseClockRate(Bundle.getMessage("ActionClockRate_DecreaseClockRate"));

        private final String _text;

        private ClockState(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

