/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanType;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.TableRowOrColumn;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionCreateBeansFromTable
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private boolean _onlyCreatableTypes = true;
    private NamedBeanType _namedBeanType = NamedBeanType.Light;
    private final LogixNG_SelectNamedBean<NamedTable> _selectNamedBean = new LogixNG_SelectNamedBean<NamedTable>(this, NamedTable.class, InstanceManager.getDefault(NamedTableManager.class), this);
    private TableRowOrColumn _tableRowOrColumn = TableRowOrColumn.Row;
    private String _rowOrColumnSystemName = "";
    private String _rowOrColumnUserName = "";
    private boolean _includeCellsWithoutHeader = false;
    private final List<Map.Entry<NamedBean, String>> _namedBeansEntries = new ArrayList<Map.Entry<NamedBean, String>>();
    private boolean _moveUserName = false;
    private boolean _updateToUserName = false;
    private boolean _removeOldBean = false;
    private static final Logger log = LoggerFactory.getLogger(ActionCreateBeansFromTable.class);

    public ActionCreateBeansFromTable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._selectNamedBean.setOnlyDirectAddressingAllowed();
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionCreateBeansFromTable copy = new ActionCreateBeansFromTable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setOnlyCreatableTypes(this._onlyCreatableTypes);
        copy.setNamedBeanType(this._namedBeanType);
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.setTableRowOrColumn(this._tableRowOrColumn);
        copy.setRowOrColumnSystemName(this._rowOrColumnSystemName);
        copy.setRowOrColumnUserName(this._rowOrColumnUserName);
        copy.setIncludeCellsWithoutHeader(this._includeCellsWithoutHeader);
        copy.setMoveUserName(this._moveUserName);
        copy.setUpdateToUserName(this._updateToUserName);
        copy.setRemoveOldBean(this._removeOldBean);
        for (Map.Entry<NamedBean, String> entry : this._namedBeansEntries) {
            copy._namedBeansEntries.add(new AbstractMap.SimpleEntry<NamedBean, String>(entry.getKey(), entry.getValue()));
        }
        return manager.registerAction(copy);
    }

    public boolean isOnlyCreatableTypes() {
        return this._onlyCreatableTypes;
    }

    public void setOnlyCreatableTypes(boolean onlyCreatableTypes) {
        this._onlyCreatableTypes = onlyCreatableTypes;
    }

    public NamedBeanType getNamedBeanType() {
        return this._namedBeanType;
    }

    public void setNamedBeanType(@Nonnull NamedBeanType namedBeanType) {
        if (namedBeanType == null) {
            throw new RuntimeException("Daniel");
        }
        this._namedBeanType = namedBeanType;
    }

    public LogixNG_SelectNamedBean<NamedTable> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public TableRowOrColumn getTableRowOrColumn() {
        return this._tableRowOrColumn;
    }

    public void setTableRowOrColumn(@Nonnull TableRowOrColumn tableRowOrColumn) {
        this._tableRowOrColumn = tableRowOrColumn;
    }

    public String getRowOrColumnSystemName() {
        return this._rowOrColumnSystemName;
    }

    public void setRowOrColumnSystemName(@Nonnull String rowOrColumnName) {
        if (rowOrColumnName == null) {
            throw new IllegalArgumentException("Row/column name is null");
        }
        this._rowOrColumnSystemName = rowOrColumnName;
    }

    public String getRowOrColumnUserName() {
        return this._rowOrColumnUserName;
    }

    public void setRowOrColumnUserName(@Nonnull String rowOrColumnName) {
        if (rowOrColumnName == null) {
            throw new IllegalArgumentException("Row/column name is null");
        }
        this._rowOrColumnUserName = rowOrColumnName;
    }

    public boolean isIncludeCellsWithoutHeader() {
        return this._includeCellsWithoutHeader;
    }

    public void setIncludeCellsWithoutHeader(boolean includeCellsWithoutHeader) {
        this._includeCellsWithoutHeader = includeCellsWithoutHeader;
    }

    public boolean isMoveUserName() {
        return this._moveUserName;
    }

    public void setMoveUserName(boolean isMoveUserName) {
        this._moveUserName = isMoveUserName;
    }

    public boolean isUpdateToUserName() {
        return this._updateToUserName;
    }

    public void setUpdateToUserName(boolean updateToUserName) {
        this._updateToUserName = updateToUserName;
    }

    public boolean isRemoveOldBean() {
        return this._removeOldBean;
    }

    public void setRemoveOldBean(boolean removeOldBean) {
        this._removeOldBean = removeOldBean;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    private List<BeanName> getItems() {
        ArrayList<BeanName> items = new ArrayList<BeanName>();
        if (this._selectNamedBean.getNamedBean() == null) {
            log.error("No table name is given");
            return items;
        }
        if (this._rowOrColumnSystemName.isEmpty()) {
            log.error("rowOrColumnSystemName is empty string");
            return items;
        }
        NamedTable table = this._selectNamedBean.getBean();
        if (this._tableRowOrColumn == TableRowOrColumn.Row) {
            int systemNameRow = table.getRowNumber(this._rowOrColumnSystemName);
            int userNameRow = table.getRowNumber(this._rowOrColumnUserName);
            for (int column = 1; column <= table.numColumns(); ++column) {
                Object header = table.getCell(0, column);
                if (!this._includeCellsWithoutHeader && (header == null || header.toString().isEmpty())) continue;
                Object systemNameCell = table.getCell(systemNameRow, column);
                Object userNameCell = table.getCell(userNameRow, column);
                if (systemNameCell == null || systemNameCell.toString().isBlank()) continue;
                if (userNameCell != null && !userNameCell.toString().isBlank()) {
                    items.add(new BeanName(systemNameCell.toString(), userNameCell.toString()));
                    continue;
                }
                items.add(new BeanName(systemNameCell.toString(), null));
            }
        } else {
            int systemNameColumn = table.getColumnNumber(this._rowOrColumnSystemName);
            int userNameColumn = table.getColumnNumber(this._rowOrColumnUserName);
            for (int row = 1; row <= table.numRows(); ++row) {
                Object header = table.getCell(row, 0);
                if (!this._includeCellsWithoutHeader && (header == null || header.toString().isEmpty())) continue;
                Object systemNameCell = table.getCell(row, systemNameColumn);
                Object userNameCell = table.getCell(row, userNameColumn);
                if (systemNameCell == null || systemNameCell.toString().isBlank()) continue;
                if (userNameCell != null && !userNameCell.toString().isBlank()) {
                    items.add(new BeanName(systemNameCell.toString(), userNameCell.toString()));
                    continue;
                }
                items.add(new BeanName(systemNameCell.toString(), null));
            }
        }
        return items;
    }

    private void moveUserName(NamedBean oldNameBean, NamedBean newNameBean, String userName) throws JmriException {
        NamedBeanHandleManager nbMan = InstanceManager.getDefault(NamedBeanHandleManager.class);
        if (nbMan.inUse(oldNameBean.getSystemName(), oldNameBean) && this._updateToUserName) {
            nbMan.updateBeanFromSystemToUser(oldNameBean);
        }
        oldNameBean.setUserName(null);
        newNameBean.setUserName(userName);
        nbMan.moveBean(oldNameBean, newNameBean, userName);
    }

    @Override
    public void execute() throws JmriException {
        List<BeanName> items = this.getItems();
        for (BeanName beanName : items) {
            NamedBean userBean;
            block12: {
                NamedBean sysBean = this._namedBeanType.getManager().getBySystemName(beanName._systemName);
                userBean = null;
                if (beanName._userName != null && !beanName._userName.isBlank()) {
                    userBean = this._namedBeanType.getManager().getByUserName(beanName._userName);
                }
                if (sysBean == null) {
                    if (this._namedBeanType.getCreateBean() == null) {
                        throw new JmriException(Bundle.getMessage("ActionCreateBeansFromTable_Exception_CreateBeanNotSupported", this._namedBeanType.getName(true)));
                    }
                    String userName = userBean != null ? null : beanName._userName;
                    try {
                        sysBean = this._namedBeanType.getCreateBean().createBean(beanName._systemName, userName);
                    }
                    catch (IllegalArgumentException e) {
                        throw new JmriException(Bundle.getMessage("ActionCreateBeansFromTable_Exception_CantCreateBean2", beanName._systemName, e.getLocalizedMessage()));
                    }
                    if (sysBean == null) {
                        throw new JmriException(Bundle.getMessage("ActionCreateBeansFromTable_Exception_CantCreateBean", beanName._systemName));
                    }
                }
                if (userBean == null || sysBean == userBean) continue;
                if (!this._moveUserName) {
                    throw new JmriException(Bundle.getMessage("ActionCreateBeansFromTable_Exception_CantMoveUserName"));
                }
                this.moveUserName(userBean, sysBean, beanName._userName);
                if (!this._removeOldBean) continue;
                try {
                    this._namedBeanType.getDeleteBean().deleteBean(userBean, "CanDelete");
                }
                catch (PropertyVetoException e) {
                    if (!"DoNotDelete".equals(e.getPropertyChangeEvent().getPropertyName())) break block12;
                    throw new JmriException(String.format("Cannot delete bean: %s", e.getPropertyChangeEvent().getOldValue()), e);
                }
            }
            try {
                this._namedBeanType.getDeleteBean().deleteBean(userBean, "DoDelete");
            }
            catch (PropertyVetoException e) {
                throw new JmriException(String.format("Cannot delete bean: %s", e.getPropertyChangeEvent().getOldValue()), e);
            }
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionCreateBeansFromTable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String tableName = this._selectNamedBean.getDescription(locale);
        String includeCellsWithoutHeaderStr = this._includeCellsWithoutHeader ? Bundle.getMessage(locale, "ActionCreateBeansFromTable_FlagStr", Bundle.getMessage(locale, "ActionCreateBeansFromTable_IncludeCellsWithoutHeader")) : "";
        String includeMoveUserNameStr = this._moveUserName ? Bundle.getMessage(locale, "ActionCreateBeansFromTable_FlagStr", Bundle.getMessage(locale, "ActionCreateBeansFromTable_MoveUserName")) : "";
        String updateToUserNameStr = this._updateToUserName ? Bundle.getMessage(locale, "ActionCreateBeansFromTable_FlagStr", Bundle.getMessage(locale, "ActionCreateBeansFromTable_UpdateToUserName")) : "";
        String includeRemoveOldBeanStr = this._removeOldBean ? Bundle.getMessage(locale, "ActionCreateBeansFromTable_FlagStr", Bundle.getMessage(locale, "ActionCreateBeansFromTable_RemoveOldBean")) : "";
        return Bundle.getMessage(locale, "ActionCreateBeansFromTable_Long", this._namedBeanType.getName(true).toLowerCase(), tableName, this._tableRowOrColumn.getOpposite().toStringLowerCase(), this._tableRowOrColumn.toStringLowerCase(), this._rowOrColumnSystemName, this._rowOrColumnUserName, includeCellsWithoutHeaderStr, includeMoveUserNameStr, updateToUserNameStr, includeRemoveOldBeanStr);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (this._listenersAreRegistered) {
            return;
        }
        this._selectNamedBean.registerListeners();
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            return;
        }
        this._selectNamedBean.unregisterListeners();
        this._listenersAreRegistered = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionCreateBeansFromTable: bean = {}, report = {}", (Object)cdl, report);
        if (this._selectNamedBean.getBean() != null && bean.equals(this._selectNamedBean.getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    private static class BeanName {
        final String _systemName;
        final String _userName;

        BeanName(String systemName, String userName) {
            this._systemName = systemName;
            this._userName = userName;
        }
    }
}

