/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.DispatcherActiveTrainManager;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDispatcher
extends AbstractDigitalAction
implements PropertyChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private String _trainInfoFileName = "";
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private final LogixNG_SelectEnum<DirectOperation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])DirectOperation.values(), (Enum)DirectOperation.None, (PropertyChangeListener)this);
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private boolean _resetOption = false;
    private boolean _terminateOption = false;
    private int _trainPriority = 5;
    private final DispatcherActiveTrainManager _atManager = InstanceManager.getDefault(DispatcherActiveTrainManager.class);
    private static final Logger log = LoggerFactory.getLogger(ActionDispatcher.class);

    public ActionDispatcher(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionDispatcher copy = new ActionDispatcher(sysName, userName);
        copy.setComment(this.getComment());
        copy.setAddressing(this._addressing);
        copy.setTrainInfoFileName(this._trainInfoFileName);
        copy.setReference(this._reference);
        copy.setLocalVariable(this._localVariable);
        copy.setFormula(this._formula);
        this._selectEnum.copy(copy._selectEnum);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        copy.setResetOption(this._resetOption);
        copy.setTerminateOption(this._terminateOption);
        copy.setTrainPriority(this._trainPriority);
        return manager.registerAction(copy);
    }

    public void setTrainInfoFileName(@Nonnull String fileName) {
        this._trainInfoFileName = fileName;
    }

    public String getTrainInfoFileName() {
        return this._trainInfoFileName;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public LogixNG_SelectEnum<DirectOperation> getSelectEnum() {
        return this._selectEnum;
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    public void setTrainPriority(int trainPriority) {
        this._trainPriority = trainPriority;
    }

    public int getTrainPriority() {
        return this._trainPriority;
    }

    public void setResetOption(boolean resetOption) {
        this._resetOption = resetOption;
    }

    public boolean getResetOption() {
        return this._resetOption;
    }

    public void setTerminateOption(boolean terminateOption) {
        this._terminateOption = terminateOption;
    }

    public boolean getTerminateOption() {
        return this._terminateOption;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewData(DirectOperation oper) throws JmriException {
        switch (this._dataAddressing) {
            case Direct: {
                switch (oper) {
                    case TrainPriority: {
                        return String.valueOf(this.getTrainPriority());
                    }
                    case ResetWhenDoneOption: {
                        return this.getResetOption() ? "true" : "false";
                    }
                    case TerminateWhenDoneOption: {
                        return this.getTerminateOption() ? "true" : "false";
                    }
                }
                return "";
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._dataReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._dataLocalVariable), false);
            }
            case Formula: {
                return this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : "";
            }
        }
        throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        String trainInfoFileName = "";
        switch (this._addressing) {
            case Direct: {
                trainInfoFileName = this._trainInfoFileName;
                break;
            }
            case Reference: {
                trainInfoFileName = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                trainInfoFileName = TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false);
                break;
            }
            case Formula: {
                trainInfoFileName = this._expressionNode != null ? TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : "";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (trainInfoFileName.isEmpty()) {
            return;
        }
        ActiveTrain activeTrain = this._atManager.getActiveTrain(trainInfoFileName);
        DirectOperation oper = this._selectEnum.evaluateEnum(this.getConditionalNG());
        String newData = this.getNewData(oper);
        switch (oper) {
            case LoadTrainFromFile: {
                if (activeTrain == null) {
                    activeTrain = this._atManager.createActiveTrain(trainInfoFileName);
                    if (activeTrain == null) {
                        log.warn("DispatcherAction: Unable to create an active train");
                    }
                } else {
                    log.warn("DispatcherAction: The active train already exists");
                }
                return;
            }
            case TerminateTrain: {
                this._atManager.terminateActiveTrain(trainInfoFileName);
                return;
            }
            case TrainPriority: {
                if (activeTrain != null) {
                    int newInt = Integer.parseInt(newData);
                    if (newInt < 0) {
                        newInt = 0;
                    }
                    if (newInt > 100) {
                        newInt = 100;
                    }
                    activeTrain.setPriority(newInt);
                }
                return;
            }
            case ResetWhenDoneOption: {
                if (activeTrain != null && (newData.equals("true") || newData.equals("false"))) {
                    boolean reset = newData.equals("true");
                    activeTrain.setResetWhenDone(reset);
                }
                return;
            }
            case TerminateWhenDoneOption: {
                if (activeTrain != null && (newData.equals("true") || newData.equals("false"))) {
                    boolean term = newData.equals("true");
                    activeTrain.setTerminateWhenDone(term);
                }
                return;
            }
        }
        throw new IllegalArgumentException("invalid oper state: " + oper.name());
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionDispatcher_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String fileName;
        String state = this._selectEnum.getDescription(locale);
        switch (this._addressing) {
            case Direct: {
                fileName = Bundle.getMessage(locale, "AddressByDirect", this._trainInfoFileName);
                break;
            }
            case Reference: {
                fileName = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                fileName = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                fileName = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (this._selectEnum.getAddressing() == NamedBeanAddressing.Direct) {
            switch (this._selectEnum.getEnum()) {
                case LoadTrainFromFile: {
                    return Bundle.getMessage("ActionDispatcher_Long_LoadTrain", fileName);
                }
                case TerminateTrain: {
                    return Bundle.getMessage("ActionDispatcher_Long_Terminate", fileName);
                }
                case TrainPriority: {
                    return this.getLongDataDescription(locale, "ActionDispatcher_Long_Priority", fileName, String.valueOf(this.getTrainPriority()));
                }
                case ResetWhenDoneOption: {
                    return this.getLongDataDescription(locale, "ActionDispatcher_Long_ResetOption", fileName, this.getResetOption() ? Bundle.getMessage("ActionDispatcher_Long_Enable") : Bundle.getMessage("ActionDispatcher_Long_Disable"));
                }
                case TerminateWhenDoneOption: {
                    return this.getLongDataDescription(locale, "ActionDispatcher_Long_TerminateOption", fileName, this.getTerminateOption() ? Bundle.getMessage("ActionDispatcher_Long_Enable") : Bundle.getMessage("ActionDispatcher_Long_Disable"));
                }
            }
            throw new IllegalArgumentException("invalid enum: " + this._selectEnum.getEnum().name());
        }
        return Bundle.getMessage(locale, "ActionDispatcher_Long", fileName, state);
    }

    private String getLongDataDescription(Locale locale, String bundleKey, String fileName, String value) {
        switch (this._dataAddressing) {
            case Direct: {
                return Bundle.getMessage(locale, bundleKey, fileName, value);
            }
            case Reference: {
                return Bundle.getMessage(locale, bundleKey, fileName, Bundle.getMessage("AddressByReference", this._dataReference));
            }
            case LocalVariable: {
                return Bundle.getMessage(locale, bundleKey, fileName, Bundle.getMessage("AddressByLocalVariable", this._dataLocalVariable));
            }
            case Formula: {
                return Bundle.getMessage(locale, bundleKey, fileName, Bundle.getMessage("AddressByFormula", this._dataFormula));
            }
        }
        throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum DirectOperation {
        None(""),
        LoadTrainFromFile(Bundle.getMessage("ActionDispatcher_LoadTrainFromFile")),
        TerminateTrain(Bundle.getMessage("ActionDispatcher_TerminateTrain")),
        TrainPriority(Bundle.getMessage("ActionDispatcher_TrainPriority")),
        ResetWhenDoneOption(Bundle.getMessage("ActionDispatcher_ResetWhenDoneOption")),
        TerminateWhenDoneOption(Bundle.getMessage("ActionDispatcher_TerminateWhenDoneOption"));

        private final String _text;

        private DirectOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

